
/*****************************************************************
*
* ruby_hildon_volumebar.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_VOLUMEBAR(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
 /*   RBGTK_INITIALIZE(self,xxxx () );   */
    return Qnil;
}


/* methods */


static VALUE
get_level(self)
    VALUE self;
{
    double ret =    hildon_volumebar_get_level (_SELF ( self ) );
    return rb_float_new( ret );
}

static VALUE
set_level(self, level)
    VALUE self, level;
{
       hildon_volumebar_set_level (_SELF ( self ), NUM2DBL( level ) );
    return self;
}

static VALUE
get_mute(self)
    VALUE self;
{
    gboolean ret =    hildon_volumebar_get_mute (_SELF ( self ) );
    return CBOOL2RVAL( ret );
}

static VALUE
set_mute(self, mute)
    VALUE self, mute;
{
       hildon_volumebar_set_mute (_SELF ( self ), RVAL2CBOOL ( mute ) );
    return self;
}

static VALUE
get_adjustment(self)
    VALUE self;
{
    GtkAdjustment* ret =    hildon_volumebar_get_adjustment (_SELF ( self ) );
    return GOBJ2RVAL ( ret ) ;
}

static VALUE
set_range_insensitive_message(widget, message)
    VALUE widget, message;
{
       hildon_volumebar_set_range_insensitive_message (_SELF ( widget ), RVAL2CSTR( message ) );
    return widget;
}

static VALUE
set_range_insensitive_messagef(widget, format)
    VALUE widget, format;
{
       hildon_volumebar_set_range_insensitive_messagef (_SELF ( widget ), RVAL2CSTR( format ) );
    return widget;
}


/* Class Initialisation */


void 
Init_hildon_volumebar()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_VOLUMEBAR, "Volumebar", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "get_level", get_level, 0);

     rb_define_method(win, "set_level", set_level, 1);

     rb_define_method(win, "get_mute", get_mute, 0);

     rb_define_method(win, "set_mute", set_mute, 1);

     rb_define_method(win, "get_adjustment", get_adjustment, 0);

     rb_define_method(win, "set_range_insensitive_message", set_range_insensitive_message, 1);

     rb_define_method(win, "set_range_insensitive_messagef", set_range_insensitive_messagef, 1);
}


