
/*****************************************************************
*
* ruby_hildon_time_picker.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_TIME_PICKER(RVAL2GOBJ(self)))

static ID id_to_a;
static VALUE str_hours;
static VALUE str_minutes;

/* Initialisation */


static VALUE
initialize ( self, parent)
    VALUE self, parent;
{
    RBGTK_INITIALIZE(self,hildon_time_picker_new ( GTK_WINDOW ( RVAL2GOBJ ( parent ) ) )  );   
    return Qnil;
}


/* methods */


static VALUE
set_time(picker, hours, minutes)
    VALUE picker, hours, minutes;
{
       hildon_time_picker_set_time (_SELF ( picker ), NUM2UINT( hours ), NUM2UINT( minutes ) );
    return picker;
}

static VALUE
get_time(picker )
    VALUE picker;
{
       
    uint hours, minutes;
    hildon_time_picker_get_time (_SELF ( picker ), &hours , &minutes  );
    VALUE hsh = rb_hash_new();
    rb_hash_aset( hsh, str_hours,UINT2NUM( hours ) );
    rb_hash_aset( hsh, str_minutes,UINT2NUM( minutes ) );
    return hsh;
}


/* Class Initialisation */


void 
Init_hildon_time_picker()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_TIME_PICKER, "TimePicker", mHildon);

    id_to_a = rb_intern("to_a"); 
    str_hours = rb_str_new2("hours");
    str_minutes = rb_str_new2("minutes");
    
    rb_define_method(win, "initialize", initialize, 1);

    /* rb_define_method(win, "new", new, 0); */

     rb_define_method(win, "set_time", set_time, 2);

     rb_define_method(win, "get_time", get_time, 0);
}


