
/*****************************************************************
*
* ruby_hildon_time_editor.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_TIME_EDITOR(RVAL2GOBJ(self)))

static ID id_to_a;
static VALUE str_hours;
static VALUE str_minutes;
static VALUE str_seconds;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_time_editor_new () );
    return Qnil;
}


/* methods */
 

static VALUE
set_time(editor, hours, minutes, seconds)
    VALUE editor, hours, minutes, seconds;
{
       hildon_time_editor_set_time (_SELF ( editor ), NUM2UINT( hours ), NUM2UINT( minutes ), NUM2UINT( seconds ) );
    return editor;
}

static VALUE
get_time(editor)
    VALUE editor;
{
      uint hours, minutes, seconds;
	hildon_time_editor_get_time (_SELF ( editor ),  &hours ,  &minutes ,  &seconds  );
	VALUE hsh = rb_hash_new();
    rb_hash_aset( hsh, str_hours,UINT2NUM( hours ) );
    rb_hash_aset( hsh, str_minutes,UINT2NUM( minutes ) );
    rb_hash_aset( hsh, str_seconds,UINT2NUM( seconds ) );
    return hsh;
}

static VALUE
set_duration_range(editor, range)
    VALUE editor, range;
{
       uint min =  NUM2UINT ( range_first(range) );
       uint max=  NUM2UINT ( range_last(range) );
	
	hildon_time_editor_set_duration_range (_SELF ( editor ),  min ,  max  );
    return editor;
}

static VALUE
get_duration_range(editor)
    VALUE editor;
{
        uint min, max;
	hildon_time_editor_get_duration_range (_SELF ( editor ), &min,  &max );
       return 	rb_range_new( UINT2NUM( min ) , UINT2NUM( max), 0 );
}

static VALUE
set_ticks(editor, ticks)
    VALUE editor, ticks;
{
       hildon_time_editor_set_ticks (_SELF ( editor ), NUM2UINT( ticks ) );
    return editor;
}

static VALUE
get_ticks(editor)
    VALUE editor;
{
    guint ret =    hildon_time_editor_get_ticks (_SELF ( editor ) );
    return UINT2NUM( ret );
}

static VALUE
set_show_seconds(editor, show_seconds)
    VALUE editor, show_seconds;
{
       hildon_time_editor_set_show_seconds (_SELF ( editor ), RVAL2CBOOL ( show_seconds ) );
    return editor;
}

static VALUE
get_show_seconds(editor)
    VALUE editor;
{
    gboolean ret =    hildon_time_editor_get_show_seconds (_SELF ( editor ) );
    return CBOOL2RVAL( ret );
}

static VALUE
set_show_hours(editor, show_hours)
    VALUE editor, show_hours;
{
       hildon_time_editor_set_show_hours (_SELF ( editor ), RVAL2CBOOL ( show_hours ) );
    return editor;
}

static VALUE
get_show_hours(editor)
    VALUE editor;
{
    gboolean ret =    hildon_time_editor_get_show_hours (_SELF ( editor ) );
    return CBOOL2RVAL( ret );
}

static VALUE
set_duration_mode(editor, duration_mode)
    VALUE editor, duration_mode;
{
       hildon_time_editor_set_duration_mode (_SELF ( editor ), RVAL2CBOOL ( duration_mode ) );
    return editor;
}

static VALUE
get_duration_mode(editor)
    VALUE editor;
{
    gboolean ret =    hildon_time_editor_get_duration_mode (_SELF ( editor ) );
    return CBOOL2RVAL( ret );
}

static VALUE
set_duration_min(editor, duration_min)
    VALUE editor, duration_min;
{
       hildon_time_editor_set_duration_min (_SELF ( editor ), NUM2UINT( duration_min ) );
    return editor;
}

static VALUE
get_duration_min(editor)
    VALUE editor;
{
    guint ret =    hildon_time_editor_get_duration_min (_SELF ( editor ) );
    return UINT2NUM( ret );
}

static VALUE
set_duration_max(editor, duration_max)
    VALUE editor, duration_max;
{
       hildon_time_editor_set_duration_max (_SELF ( editor ), NUM2UINT( duration_max ) );
    return editor;
}

static VALUE
get_duration_max(editor)
    VALUE editor;
{
    guint ret =    hildon_time_editor_get_duration_max (_SELF ( editor ) );
    return UINT2NUM( ret );
}

static VALUE
get_time_separators(hm_sep_label, ms_sep_label)
    VALUE hm_sep_label, ms_sep_label;
{
       hildon_time_editor_get_time_separators (_SELF ( hm_sep_label ), GTK_LABEL ( RVAL2GOBJ ( ms_sep_label ) ) );
    return hm_sep_label;
}


/* Class Initialisation */


void 
Init_hildon_time_editor()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_TIME_EDITOR, "TimeEditor", mHildon);

    id_to_a = rb_intern("to_a"); 
	
     str_hours = rb_str_new2("hours");
     str_minutes = rb_str_new2("minutes");
     str_seconds = rb_str_new2("seconds");
	
	
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "set_time", set_time, 3);

     rb_define_method(win, "get_time", get_time, 0);

     rb_define_method(win, "set_duration_range", set_duration_range, 1);

     rb_define_method(win, "get_duration_range", get_duration_range, 0);

     rb_define_method(win, "set_ticks", set_ticks, 1);

     rb_define_method(win, "get_ticks", get_ticks, 0);

     rb_define_method(win, "set_show_seconds", set_show_seconds, 1);

     rb_define_method(win, "get_show_seconds", get_show_seconds, 0);

     rb_define_method(win, "set_show_hours", set_show_hours, 1);

     rb_define_method(win, "get_show_hours", get_show_hours, 0);

     rb_define_method(win, "set_duration_mode", set_duration_mode, 1);

     rb_define_method(win, "get_duration_mode", get_duration_mode, 0);

     rb_define_method(win, "set_duration_min", set_duration_min, 1);

     rb_define_method(win, "get_duration_min", get_duration_min, 0);

     rb_define_method(win, "set_duration_max", set_duration_max, 1);

     rb_define_method(win, "get_duration_max", get_duration_max, 0);

     rb_define_method(win, "get_time_separators", get_time_separators, 1);
}


