
/*****************************************************************
*
* ruby_hildon_number_editor.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_NUMBER_EDITOR(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self, min,max )
    VALUE self,min,max;
{
	
/*
	int min =  NUM2INT ( range_first(range) );
        int max=  NUM2INT ( range_last(range) );
	*/
    RBGTK_INITIALIZE(self,hildon_number_editor_new (  NUM2INT ( min ),   NUM2INT (max) )  ); 
    return Qnil;
}


/* methods */


static VALUE
set_range(editor, min,max)
    VALUE editor, min,max;
{
	/*
	int min =  NUM2INT ( range_first(range) );
        int max=  NUM2INT ( range_last(range) );
	*/
       hildon_number_editor_set_range (_SELF ( editor ),  NUM2INT ( min ),  NUM2INT ( max )  );
    return editor;
}

static VALUE
get_value(editor)
    VALUE editor;
{
    gint ret =    hildon_number_editor_get_value (_SELF ( editor ) );
    return INT2NUM( ret );
}

static VALUE
set_value(editor, value)
    VALUE editor, value;
{
       hildon_number_editor_set_value (_SELF ( editor ), NUM2INT( value ) );
    return editor;
}


/* Class Initialisation */


void 
Init_hildon_number_editor()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_NUMBER_EDITOR, "NumberEditor", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 2);

     rb_define_method(win, "set_range", set_range, 2);

     rb_define_method(win, "get_value", get_value, 0);

     rb_define_method(win, "set_value", set_value, 1);
}


