
/*****************************************************************
*
* ruby_hildon_get_password_dialog.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_GET_PASSWORD_DIALOG(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self, parent, get_old, password)
    VALUE self , parent, get_old, password;
{
    if (password == Qnil)
	    RBGTK_INITIALIZE(self,hildon_get_password_dialog_new (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CBOOL ( get_old ) )  );   
    else
	    RBGTK_INITIALIZE(self,hildon_get_password_dialog_new_with_default (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( password ), RVAL2CBOOL ( get_old ) ) );
    return Qnil;
}


/* methods */

/*
static VALUE
new_with_default(parent, password, get_old)
    VALUE parent, password, get_old;
{
    GtkWidget* ret =    hildon_get_password_dialog_new_with_default (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( password ), RVAL2CBOOL ( get_old ) );
    return GOBJ2RVAL ( ret ) ;
}
*/

static VALUE
set_message(dialog, message)
    VALUE dialog, message;
{
       hildon_get_password_dialog_set_message (_SELF ( dialog ), RVAL2CSTR( message ) );
    return dialog;
}

static VALUE
set_caption(dialog, new_caption)
    VALUE dialog, new_caption;
{
       hildon_get_password_dialog_set_caption (_SELF ( dialog ), RVAL2CSTR( new_caption ) );
    return dialog;
}

static VALUE
set_max_characters(dialog, max_characters)
    VALUE dialog, max_characters;
{
       hildon_get_password_dialog_set_max_characters (_SELF ( dialog ), NUM2INT( max_characters ) );
    return dialog;
}


/* Class Initialisation */


void 
Init_hildon_get_password_dialog()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_GET_PASSWORD_DIALOG, "GetPasswordDialog", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize,3);

     /* rb_define_method(win, "new_with_default", new_with_default, 2); */

     rb_define_method(win, "set_message", set_message, 1);

     rb_define_method(win, "set_caption", set_caption, 1);

     rb_define_method(win, "set_max_characters", set_max_characters, 1);
}


