
/*****************************************************************
*
* ruby_hildon_font_selection_dialog.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_FONT_SELECTION_DIALOG(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self, parent, title )
    VALUE self, parent, title ;
{
    RBGTK_INITIALIZE(self, hildon_font_selection_dialog_new ( GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( title ) )  );   
    return Qnil;
}


/* methods */

static VALUE
get_preview_text(fsd)
    VALUE fsd;
{
    gchar* ret =    hildon_font_selection_dialog_get_preview_text (_SELF ( fsd ) );
    return CSTR2RVAL( ret );
}

static VALUE
set_preview_text(fsd, text)
    VALUE fsd, text;
{
       hildon_font_selection_dialog_set_preview_text (_SELF ( fsd ),  RVAL2CSTR( text ) )  ;
    return fsd;
}


/* Class Initialisation */


void 
Init_hildon_font_selection_dialog()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_FONT_SELECTION_DIALOG, "FontSelectionDialog", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 2);

     rb_define_method(win, "get_preview_text", get_preview_text, 0);

     rb_define_method(win, "set_preview_text", set_preview_text, 1);
}


