
/*****************************************************************
*
* ruby_hildon_date_editor.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_DATE_EDITOR(RVAL2GOBJ(self)))

static ID id_to_a;

static VALUE str_year;
static VALUE str_month;
static VALUE str_day;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_date_editor_new () );
    return Qnil;
}


/* methods */


static VALUE
set_date(date, year, month, day)
    VALUE date, year, month, day;
{
       hildon_date_editor_set_date (_SELF ( date ), NUM2UINT( year ), NUM2UINT( month ), NUM2UINT( day ) );
    return date;
}

static VALUE
get_date(date)
    VALUE date;
{
       uint year, month, day;
       hildon_date_editor_get_date (_SELF ( date ), &year ,  &month , &day  );
       VALUE hsh = rb_hash_new();
       rb_hash_aset( hsh, str_year,UINT2NUM( year ) );
       rb_hash_aset( hsh, str_month,UINT2NUM( month ) );
       rb_hash_aset( hsh, str_day,UINT2NUM( day ) );
      return hsh;
}

static VALUE
set_year(editor, year)
    VALUE editor, year;
{
    gboolean ret =    hildon_date_editor_set_year (_SELF ( editor ), NUM2UINT( year ) );
    return CBOOL2RVAL( ret );
}

static VALUE
set_month(editor, month)
    VALUE editor, month;
{
    gboolean ret =    hildon_date_editor_set_month (_SELF ( editor ), NUM2UINT( month ) );
    return CBOOL2RVAL( ret );
}

static VALUE
set_day(editor, day)
    VALUE editor, day;
{
    gboolean ret =    hildon_date_editor_set_day (_SELF ( editor ), NUM2UINT( day ) );
    return CBOOL2RVAL( ret );
}

static VALUE
get_year(editor)
    VALUE editor;
{
    guint ret =    hildon_date_editor_get_year (_SELF ( editor ) );
    return UINT2NUM( ret );
}

static VALUE
get_month(editor)
    VALUE editor;
{
    guint ret =    hildon_date_editor_get_month (_SELF ( editor ) );
    return UINT2NUM( ret );
}

static VALUE
get_day(editor)
    VALUE editor;
{
    guint ret =    hildon_date_editor_get_day (_SELF ( editor ) );
    return UINT2NUM( ret );
}


/* Class Initialisation */


void 
Init_hildon_date_editor()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_DATE_EDITOR, "DateEditor", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    str_year = rb_str_new2("year");
    str_month = rb_str_new2("month");
    str_day = rb_str_new2("day");
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "set_date", set_date, 3);

     rb_define_method(win, "get_date", get_date, 0);

     rb_define_method(win, "set_year", set_year, 1);

     rb_define_method(win, "set_month", set_month, 1);

     rb_define_method(win, "set_day", set_day, 1);

     rb_define_method(win, "get_year", get_year, 0);

     rb_define_method(win, "get_month", get_month, 0);

     rb_define_method(win, "get_day", get_day, 0);
}


