
/*****************************************************************
*
* ruby_hildon_caption.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_CAPTION(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize (  self,group, value, control, icon, flag )
    VALUE self,group, value, control, icon, flag;
{
    RBGTK_INITIALIZE(self, hildon_caption_new ( GTK_SIZE_GROUP(RVAL2GOBJ ( group) ), RVAL2CSTR( value ), GTK_WIDGET ( RVAL2GOBJ ( control ) ), GTK_WIDGET ( RVAL2GOBJ ( icon ) ), NUM2UINT( flag ) )   );  
    return Qnil;
}


/* methods */

static VALUE
get_size_group(caption)
    VALUE caption;
{
    GtkSizeGroup* ret =    hildon_caption_get_size_group (_SELF ( caption ) );
    return GOBJ2RVAL ( ret ) ;
}

static VALUE
set_size_group(caption, new_group)
    VALUE caption, new_group;
{
       hildon_caption_set_size_group (_SELF ( caption ), GTK_SIZE_GROUP ( RVAL2GOBJ ( new_group ) ) );
    return caption;
}

static VALUE
is_mandatory(caption)
    VALUE caption;
{
    gboolean ret =    hildon_caption_is_mandatory (_SELF ( caption ) );
    return CBOOL2RVAL( ret );
}

static VALUE
set_status(caption, flag)
    VALUE caption, flag;
{
       hildon_caption_set_status (_SELF ( caption ), NUM2UINT( flag ) );
    return caption;
}

static VALUE
get_status(caption)
    VALUE caption;
{
    HildonCaptionStatus ret =    hildon_caption_get_status (_SELF ( caption ) );
    return INT2NUM ( ret ) ;
}

static VALUE
set_icon_position(caption, pos)
    VALUE caption, pos;
{
       hildon_caption_set_icon_position (_SELF ( caption ), NUM2UINT( pos ) );
    return caption;
}

static VALUE
get_icon_position(caption)
    VALUE caption;
{
    HildonCaptionIconPosition ret =    hildon_caption_get_icon_position (_SELF ( caption ) );
    return INT2NUM ( ret ) ;
}

static VALUE
set_icon_image(caption, icon)
    VALUE caption, icon;
{
       hildon_caption_set_icon_image (_SELF ( caption ), GTK_WIDGET ( RVAL2GOBJ ( icon ) ) );
    return caption;
}

static VALUE
get_icon_image(caption)
    VALUE caption;
{
    GtkWidget* ret =    hildon_caption_get_icon_image (_SELF ( caption ) );
    return GOBJ2RVAL ( ret ) ;
}

static VALUE
set_label(caption, label)
    VALUE caption, label;
{
       hildon_caption_set_label (_SELF ( caption ), RVAL2CSTR( label ) );
    return caption;
}

static VALUE
get_label(caption)
    VALUE caption;
{
    gchar* ret =    hildon_caption_get_label (_SELF ( caption ) );
    return CSTR2RVAL( ret );
}

static VALUE
set_separator(caption, separator)
    VALUE caption, separator;
{
       hildon_caption_set_separator (_SELF ( caption ), RVAL2CSTR( separator ) );
    return caption;
}

static VALUE
get_separator(caption)
    VALUE caption;
{
    gchar* ret =    hildon_caption_get_separator (_SELF ( caption ) );
    return CSTR2RVAL( ret );
}

static VALUE
set_label_alignment(caption, alignment)
    VALUE caption, alignment;
{
       hildon_caption_set_label_alignment (_SELF ( caption ), NUM2INT( alignment ) );
    return caption;
}

static VALUE
get_label_alignment(caption)
    VALUE caption;
{
    gfloat ret =    hildon_caption_get_label_alignment (_SELF ( caption ) );
    return INT2NUM( ret );
}

static VALUE
set_child_expand(caption, expand)
    VALUE caption, expand;
{
       hildon_caption_set_child_expand (_SELF ( caption ), RVAL2CBOOL ( expand ) );
    return caption;
}

static VALUE
get_child_expand(caption)
    VALUE caption;
{
    gboolean ret =    hildon_caption_get_child_expand (_SELF ( caption ) );
    return CBOOL2RVAL( ret );
}

static VALUE
set_label_markup(caption, markup)
    VALUE caption, markup;
{
       hildon_caption_set_label_markup (_SELF ( caption ), RVAL2CSTR( markup ) );
    return caption;
}


/* Class Initialisation */


void 
Init_hildon_caption()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_CAPTION, "Caption", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 5);

     rb_define_method(win, "get_size_group", get_size_group, 0);

     rb_define_method(win, "set_size_group", set_size_group, 1);

     rb_define_method(win, "is_mandatory", is_mandatory, 0);

     rb_define_method(win, "set_status", set_status, 1);

     rb_define_method(win, "get_status", get_status, 0);

     rb_define_method(win, "set_icon_position", set_icon_position, 1);

     rb_define_method(win, "get_icon_position", get_icon_position, 0);

     rb_define_method(win, "set_icon_image", set_icon_image, 1);

     rb_define_method(win, "get_icon_image", get_icon_image, 0);

     rb_define_method(win, "set_label", set_label, 1);

     rb_define_method(win, "get_label", get_label, 0);

     rb_define_method(win, "set_separator", set_separator, 1);

     rb_define_method(win, "get_separator", get_separator, 0);

     rb_define_method(win, "set_label_alignment", set_label_alignment, 1);

     rb_define_method(win, "get_label_alignment", get_label_alignment, 0);

     rb_define_method(win, "set_child_expand", set_child_expand, 1);

     rb_define_method(win, "get_child_expand", get_child_expand, 0);

     rb_define_method(win, "set_label_markup", set_label_markup, 1);
}


