
/*****************************************************************
*
* ruby_hildon_calendar_popup.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_CALENDAR_POPUP(RVAL2GOBJ(self)))

static ID id_to_a;
static VALUE str_year;
static VALUE str_month;
static VALUE str_day;

/* Initialisation */


static VALUE
initialize ( self, parent, year, month, day )
    VALUE self, parent, year, month, day ;
{
    RBGTK_INITIALIZE(self, hildon_calendar_popup_new (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), NUM2UINT( year ), NUM2UINT( month ), NUM2UINT( day ) ) );   
    return Qnil;
}


/* methods */

static VALUE
set_date(cal, year, month, day)
    VALUE cal, year, month, day;
{
       hildon_calendar_popup_set_date (_SELF ( cal ), NUM2UINT( year ), NUM2UINT( month ), NUM2UINT( day ) );
    return cal;
}

static VALUE
get_date(cal)
    VALUE cal;
{
      uint year, month, day;
	hildon_calendar_popup_get_date (_SELF ( cal ),  &year ,  &month ,  &day );
    VALUE hsh = rb_hash_new();
    rb_hash_aset( hsh, str_year,UINT2NUM( year ) );
    rb_hash_aset( hsh, str_month,UINT2NUM( month ) );
	rb_hash_aset( hsh, str_day,UINT2NUM( day ) );
    return hsh;
}

/* Class Initialisation */


void 
Init_hildon_calendar_popup()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_CALENDAR_POPUP, "CalendarPopup", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    str_year = rb_str_new2("year");
    str_month = rb_str_new2("month");
    str_day = rb_str_new2("day");
    
	
    rb_define_method(win, "initialize", initialize,4);

     rb_define_method(win, "set_date", set_date, 3);

     rb_define_method(win, "get_date", get_date, 0);
}


