
/*****************************************************************
*
* ruby_hildon_calendar.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_CALENDAR(RVAL2GOBJ(self)))

static ID id_to_a;
static VALUE str_year;
static VALUE str_month;
static VALUE str_day;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_calendar_new () );
    return Qnil;
}


/* methods */


static VALUE
select_month(calendar, month, year)
    VALUE calendar, month, year;
{
    gboolean ret =    hildon_calendar_select_month (_SELF ( calendar ), NUM2UINT( month ), NUM2UINT( year ) );
    return CBOOL2RVAL( ret );
}

static VALUE
select_day(calendar, day)
    VALUE calendar, day;
{
       hildon_calendar_select_day (_SELF ( calendar ), NUM2UINT( day ) );
    return calendar;
}

static VALUE
mark_day(calendar, day)
    VALUE calendar, day;
{
    gboolean ret =    hildon_calendar_mark_day (_SELF ( calendar ), NUM2UINT( day ) );
    return CBOOL2RVAL( ret );
}

static VALUE
unmark_day(calendar, day)
    VALUE calendar, day;
{
    gboolean ret =    hildon_calendar_unmark_day (_SELF ( calendar ), NUM2UINT( day ) );
    return CBOOL2RVAL( ret );
}

static VALUE
clear_marks(calendar)
    VALUE calendar;
{
       hildon_calendar_clear_marks (_SELF ( calendar ) );
    return calendar;
}

static VALUE
set_display_options(calendar, flags)
    VALUE calendar, flags;
{
       hildon_calendar_set_display_options (_SELF ( calendar ), NUM2UINT( flags ) );
    return calendar;
}

static VALUE
get_display_options(calendar)
    VALUE calendar;
{
    HildonCalendarDisplayOptions ret =    hildon_calendar_get_display_options (_SELF ( calendar ) );
    return INT2NUM ( ret ) ;
}

static VALUE
get_date(calendar)
    VALUE calendar;
{
	uint year, month, day;
       hildon_calendar_get_date (_SELF ( calendar ),  &year ,  &month ,  &day  );
	VALUE hsh = rb_hash_new();
    rb_hash_aset( hsh, str_year,UINT2NUM( year ) );
    rb_hash_aset( hsh, str_month,UINT2NUM( month ) );
	rb_hash_aset( hsh, str_day,UINT2NUM( day ) );
    return hsh;
}

static VALUE
freeze(calendar)
    VALUE calendar;
{
       hildon_calendar_freeze (_SELF ( calendar ) );
    return calendar;
}

static VALUE
thaw(calendar)
    VALUE calendar;
{
       hildon_calendar_thaw (_SELF ( calendar ) );
    return calendar;
}


/* Class Initialisation */


void 
Init_hildon_calendar()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_CALENDAR, "Calendar", mHildon);

    id_to_a = rb_intern("to_a"); 
	
	str_year = rb_str_new2("year");
    str_month = rb_str_new2("month");
	str_day = rb_str_new2("day");
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "select_month", select_month, 2);

     rb_define_method(win, "select_day", select_day, 1);

     rb_define_method(win, "mark_day", mark_day, 1);

     rb_define_method(win, "unmark_day", unmark_day, 1);

     rb_define_method(win, "clear_marks", clear_marks, 0);

     rb_define_method(win, "set_display_options", set_display_options, 1);

     rb_define_method(win, "get_display_options", get_display_options, 0);

     rb_define_method(win, "get_date", get_date, 0);

     rb_define_method(win, "freeze", freeze, 0);

     rb_define_method(win, "thaw", thaw, 0);
}


