#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>


#include "liqapp.h"
#include "liqcanvas.h"
#include "liqimage.h"
#include "liqfont.h"
#include "liqtile.h"



#include "mk_core.h"

static int runfast=0;

static liqtile *tileroot=NULL;
static liqtile *tilepage=NULL;

// void page_coordchange_scr_to_page(PAGE *self,int scrx,int scry,int scrw,int scrh, int scrdpix,int scrdpiy,int *rx,int *ry)
static PAGE *   page=NULL;
static STROKE * strokecurr;




static int page_drawstroke_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is drawing a stroke on page
	//
	int ox=0;
	int oy=0;
	liqtile_getabsoluteoffset(self,&ox,&oy);
	ox+=self->x;
	oy+=self->y;
	int sx=args->mex - ox;
	int sy=args->mey - oy;
	int ax=0;
	int ay=0;
	
	// i should be boundary checking this
	
//void 		  page_coordchange_scr_to_page(PAGE *self,int scrx,int scry,int scrw,int scrh, int scrdpix,int scrdpiy,int *rx,int *ry);
	
	page_coordchange_scr_to_page(page,
									sx,sy,
									//page->pixelwidth,page->pixelheight,
									self->w,self->h,
									page->dpix,page->dpiy,
									//self->w,self->h,
									//canvas.dpix,canvas.dpiy,
									&ax,&ay);


	//app_log("self:%3i,%3i m:%3i,%3i o:%3i,%3i s:%3i,%3i a:%3i,%3i",self->x,self->y, args->mex,args->mey,  ox,oy,  sx,sy,   ax,ay);
	if(args->mez>0)
	{
		if(args->mcnt==1)
		{
			//app_log("mouse new");
			// new
			// we should insert a stroke into the page
			char py,pu,pv;
			liqstyle_getbackcoloryuv(stylepencolor,&py,&pu,&pv);
			strokecurr = stroke_alloc();
			strokecurr->pen_y=py;
			strokecurr->pen_u=pu;
			strokecurr->pen_v=pv;
			stroke_start(strokecurr,ax,ay,args->mez);
			page_strokeinsert(page,strokecurr);
		}
		else
		{
			// ongoing
			// we should extend the stroke in the page
			// we should render the partial last section of the newest stroke :)
			stroke_extend(strokecurr,ax,ay,args->mez);
			page_strokeupdate(page,strokecurr);
			//stroke_render(strokecurr,0);
		}
	}
	else
	{
			// ending, we could do a full render?
			stroke_extend(strokecurr,ax,ay,strokecurr->pointlast->z);
			page_strokeupdate(page,strokecurr);
			app_log("############ %s",stroke_quadchainbuild(strokecurr));
		
			strokecurr=NULL;
	}
	return 0;
}




static int page_paint(struct liqtile *self,liqtileeventpaint *args)
{
	//cliprect_drawclear(args->cr,0,0,0);
	
	self->handlerpaint=NULL;
	liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
	self->handlerpaint=page_paint;
		
	if(strokecurr && strokecurr->strokekind==0)
	{
		// normal stroke is already done by the respective party :)
		//stroke_render(strokecurr,0);
		cliprect_drawpage(args->cr,page,args->ox+self->x,args->oy+self->y,self->w,self->h,4);		// recent bits only
	}
	else
	{
		
		cliprect_drawpage(args->cr,page,args->ox+self->x,args->oy+self->y,self->w,self->h,4);// 2);		// all in high res
	}
	return 0;
}


int mksketch_run(PAGE *basepage)
{
	runfast=1;//0;
	
	// lets go
	if(mk_style_open() != 0)
	{
		return app_warnandcontinue(-1,"Couldnt open default styles");
	}
	
	
	canvas_clear(0);
	
	page=basepage;//page_alloc();
	//page->pixelwidth =800;
	//page->pixelheight=480;
	//page->dpix=225;
	//page->dpiy=225;
	strokecurr=NULL;
	
	
	
		tileroot=liqtile_createquick("ui",0,0,canvas.pixelwidth,canvas.pixelheight);
		//tileroot->handlermouse=page_drawstroke_mouse;
		//tileroot->handlerpaint=ui_paint;
		tileroot->style=stylenone;	
		
		
			tilepage=liqtile_createquick("page", canvas.pixelwidth*0.05, canvas.pixelheight*0.05,  canvas.pixelwidth * 0.4, canvas.pixelheight * 0.9  );
			tilepage->style=stylegrid;
			tilepage->handlermouse=page_drawstroke_mouse;
			tilepage->handlerpaint=page_paint;
			liqtile_childappend(tileroot,tilepage);
		


			tilepage=liqtile_createquick("page", canvas.pixelwidth*0.55, canvas.pixelheight*0.05,  canvas.pixelwidth * 0.4, canvas.pixelheight * 0.4  );
			tilepage->style=stylegrid;
			tilepage->handlermouse=page_drawstroke_mouse;
			tilepage->handlerpaint=page_paint;
			liqtile_childappend(tileroot,tilepage);

/*
			tilepage=liqtile_createquick("page", canvas.pixelwidth*0.05, canvas.pixelheight*0.55,  canvas.pixelwidth * 0.4, canvas.pixelheight * 0.4  );
			tilepage->style=stylegrid;
			tilepage->handlermouse=page_drawstroke_mouse;
			tilepage->handlerpaint=page_paint;
			liqtile_childappend(tileroot,tilepage);
		


			tilepage=liqtile_createquick("page", canvas.pixelwidth*0.55, canvas.pixelheight*0.55,  canvas.pixelwidth * 0.4, canvas.pixelheight * 0.4  );
			tilepage->style=stylegrid;
			tilepage->handlermouse=page_drawstroke_mouse;
			tilepage->handlerpaint=page_paint;
			liqtile_childappend(tileroot,tilepage);
 */
		
		
		liqtile_easyrun2(tileroot,&runfast);
		
		
		liqtile_close(tileroot);

	//page_free(page);
	
	
	mk_style_close();
	return 0;
}







