#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>


#include "liqapp.h"
#include "liqcanvas.h"
#include "liqimage.h"
#include "liqfont.h"
#include "liqtile.h"



#include "mk_core.h"



int liqbookprogress_startreading_lookupposition(char *bookfilename,int *storedfilelength,int *storedreadupto);


int liqed_run(char *sourcefilename);


char *selectedfile=NULL;



static int xitem_click(struct liqtile *self);



static liqtile *filelist_extend(liqtile *self,char *path)
{
	// this function scans a folder tree and will insert all matching files in sequence into self
	
DIR             *dir;
struct dirent 	*dp;
char 			dpfullname[255];
struct stat     statbuf;
liqtile 		*sub=NULL;
	//app_log("walk %s ",path);
	dir = opendir(path);
	while ((dp = readdir(dir)) != NULL)
	{
		if( dp->d_name[0]=='.' )
			continue;

		// if path has a trailing "/" already
		//sprintf(dpfullname, "%s%s", path, dp->d_name);
		// if path has no trailing "/"
		sprintf(dpfullname, "%s/%s", path, dp->d_name);
		
		if(stat(dpfullname, &statbuf) == -1)
		{
			app_log("stat failed: '%s'",dpfullname);
			continue;
		}
		
		// got the information we need
        if ( S_ISDIR(statbuf.st_mode) )
		{
			//printf(" DIR  ");
			sub=filelist_extend(self,dpfullname);	
        }
		else
		if ( S_ISREG(statbuf.st_mode) )
		{
            //printf(" FILE ");		
			char *ext=strrchr(dp->d_name,'.');
			if(!ext)ext=dp->d_name;
			if(ext)
			{
				if(
				   // documents
				   strcasecmp (ext,".txt")==0 ||
				   //strcasecmp (ext,".rtf")==0 ||
				   //strcasecmp (ext,".pdf")==0 ||
				   0)
				{
					//sub=mkfile(dpfullname,&statbuf);
					//app_log("doc %s making",dpfullname);
					
					int sfl=0;
					int sfu=0;
					char buff[10]="";
					
					
					if(liqbookprogress_startreading_lookupposition(dpfullname,&sfl,&sfu))
					{
						if(sfl)
						{
							snprintf(buff,10,"%i",sfu * 100 / sfl);
						}
					}

					
					
					
					sub=mkgrouph( dpfullname,
//									mklabelw(sfl || sfu ? "*"  : " ",50),
									mklabelw(sfl || sfu ? buff : " ",50),

									mklabelw(ext,0),
									mklabelw(dp->d_name,700),		//360
									mklabelw(path,0) ,
									NULL );
					liqtile_titlechange(sub,dp->d_name);
					sub->handlerclick = xitem_click;
					sub->selected=0;
					sub->style=stylelistback;

					//app_log("doc %s inserting",dpfullname);
					liqtile_childinsertsortedbytitle(self,sub,1);
					//app_log("doc %s done",dpfullname);
				}	
			}
			
        }
	}
 //fin:
	closedir(dir);
	return self;
}






























liqtile * list_children_reselectifpossible(liqtile *self,char *listitemkey)
{
	liqtile *f=self->linkchild;
	liqtile *firstvisible=NULL;
	liqtile *hitsel=NULL;
	while(f)
	{
		if(f->visible)
		{
			// it can be included
			if(!firstvisible) firstvisible=f;
			if(listitemkey && f->key && strcasecmp(f->key,listitemkey)==0)
			{
				// we found it!
				f->selected=1;
				f->style=stylelistbacksel;
				hitsel=f;
			}
			else
			{
				// this is not the file you are looking for
				f->selected=0;
				f->style=stylelistback;
			}
		}
		else
		{
			f->selected=0;
			f->style=stylelistback;			
		}
		f=f->linknext;
	}
	if(!hitsel && firstvisible)
	{
		hitsel=firstvisible;
		hitsel->selected=1;
		hitsel->style=stylelistbacksel;
	}
	return hitsel;
}
























static void folderitem_deepsetstyle(liqtile *root,liqstyle *styletoapply)
{
	// this function will collectively apply a style
	liqtile *f=root->linkchild;
	while(f)
	{
		folderitem_deepsetstyle(f,styletoapply);
		f->style=styletoapply;
		f=f->linknext;
	}
}



static int folderitem_click(struct liqtile *self)
{
	// folder item has been clicked
	// we must walk BACKWARDS until we find our root
	liqtile *root=self;
	while(root)
	{
		if(strncasecmp(root->key,"foldertree",32)==0)
		{
			// found it
			break;
		}
		root=root->linkparent;
	}
	if(root)
	{
		folderitem_deepsetstyle(root,stylefolderitem);
		
		self->style=stylefolderitemsel;
		if(root==self)
		{
			root->style=stylefolderitemsel;
		}
		else
		{
			root->style=stylefolderitem;
		}
		// now, filter the filelist to show solidarity
		liqtile *filelist = (liqtile *)root->data;
		if(filelist)
		{
			
			liqtile *f=filelist->linkchild;
			while(f)
			{
				//app_log("filtering to '%s', '%s'",self->key,f->key);
				if(root==self)
				{
					f->visible = 1;
				}
				else
				{
					char *fk=f->key;
					char *wk=self->key;
					while(*fk && *wk)
					{
						if(*fk != *wk) break;
						fk++;
						wk++;
					}
					// should deal with selection here and set the grid coy to match approx location
					// if no selection is found then we should resect the first
					f->visible = (!*wk);
				}
				f=f->linknext;
			}
			
			
			liqtile *selitem = list_children_reselectifpossible(filelist,selectedfile);
			if(selectedfile)
			{
				free(selectedfile);
				selectedfile=NULL;
			}
			
			if(selitem)
			{
				selectedfile = strdup(selitem->key);
			}
			
			
			
			
			// now ensure its sized correctly (the list view should handle it..)
			liqtile_childarrange_col(filelist);
			
			
			// ensure we are at the top of the list
			if(filelist->linkparent)
			{
				if(selitem)
					filelist->linkparent->coy=selitem->y;
				else
					filelist->linkparent->coy=0;
			}
			grid_contents_recalc(filelist);
		}
	}
	return 0;
}


// now, a function to create a folder tree
// i have to do 2 scans
//

static void weighfoldertree(liqtile *self,int totalheight,int totaltagheight)
{
	liqtile *f=self->linkchild;
	int x=0;
	int y=0;
	while(f)
	{
		weighfoldertree(f,totalheight,totaltagheight);
		f->y=y;
		liqtile_update_boundfrompos(f);
		f->visible = (f->style && f->style->textfont && (f->h >= (f->style->textfont->glyphmaxh*0.6)));
		y+=f->h;
		f=f->linknext;
	}
	self->h = self->tag * totaltagheight / totalheight ;
	liqtile_update_boundfrompos(self);
}

liqtile *buildfoldertree(liqtile *filelist,int w,int h)
{
	// given a filelist, make a treeview showing how to get there
	liqtile *root=mkcell("foldertree",w,h);
	liqtile_titlechange(root,"all");
	root->data=filelist;
	root->handlerclick=folderitem_click;
	root->style=stylefolderitemsel;
	liqtile *f=filelist->linkchild;
	char filefullname[1024];
	while(f)
	{
		snprintf(filefullname,1024,f->key);
		liqtile *par = root;
		liqtile *branch=NULL;		
		int recdep=0;
		// skip the initial "/"
		char *lasttime=filefullname;
		char *pch=strchr(filefullname+1,'/');
		while(pch && recdep<7)
		{
			// 1) fullname == "/media"
			*pch=0;
			//pch++;
			// 1) search for "/media"
			branch = liqtile_childfindkey(par,filefullname);
			if(!branch)
			{
				// 1) did not find "/media", create it
				branch=at( (w/7) ,0, mklabelw(filefullname,(w - ((1+recdep) * (w/7))) - (recdep*2)  ) );
				branch->handlerclick=folderitem_click;
				// now actually give it its proper title (which is just a folder name)
				liqtile_titlechange(branch,lasttime+1);
				branch->style=stylefolderitem;
				//app_log("rd: %i,%i,%i",recdep,w,w - (recdep * (w/16))   );
				liqtile_childinsertsorted(par,branch);
			}
			par=branch;
			recdep++;
			*pch='/';
			lasttime=pch;
			pch++;
			pch=strchr(pch,'/');
		}
		while(branch)
		{
			branch->tag++;
			branch=branch->linkparent;
		}
		f=f->linknext;
	}
	//liqtile_print2(root);
	weighfoldertree(root,filelist->childcount,h);
	//liqtile_print2(root);
	return root;
}













































































static int xitem_click(struct liqtile *self)
{
	// change the selection ?
	if(selectedfile)
	{
		free(selectedfile);
		selectedfile=NULL;
	}
	selectedfile = strdup(self->key);
	
	
	//app_log("1Clicked on book : %s",selectedfile);
	
	list_children_reselectifpossible(self->linkparent,selectedfile);

	//app_log("2Clicked on book : %s",selectedfile);
	
/*	
	liqtile *s=self->linkparent->linkchild;
	while(s)
	{
		if(s==self)
		{
			s->selected=1;
			s->style=stylelistbacksel;
		}
		else
		{
			s->selected=0;
			s->style=stylelistback;
		}
		s=s->linknext;
	}
 */

	return 0;
}


//liqed_run("COPYING");

static int cmd_readbook(struct liqtile *self)
{
	//
	if(selectedfile)
	{
		liqed_run(selectedfile);
	}
	return 0;
}

int liqintroduction_run();

static int cmd_intro(struct liqtile *self)
{
	//
	liqintroduction_run();
	return 0;
}


static int runfast=0;

static liqtile *tileroot=NULL;








static int tileroot_paint(struct liqtile *self,liqtileeventpaint *args)
{
	// ok, the screen is about to be painted.
	// set runfast to 0 - this ensures it does not remain fast unless we need it to be so :)
	runfast=0;
	// now, render as normal
	self->handlerpaint=NULL;
	liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
	self->handlerpaint=tileroot_paint;
	return 0;
}





int mkfileselect_run()
{
	runfast=0;//0;
	
	
	selectedfile=NULL;
	
	// lets go
	if(mk_style_open() != 0)
	{
		return app_warnandcontinue(-1,"Couldnt open default styles");
	}
	
	
	canvas_clear(0);

	//styleback->backmode=2;
	
		tileroot=liqtile_createquick("ui",0,0,canvas.pixelwidth,canvas.pixelheight);
		//tileroot->handlermouse=page_drawstroke_mouse;
		tileroot->handlerpaint=tileroot_paint;
		tileroot->style=styleblack;	


			liqtile_childappend(tileroot,     at(0,0, mklabelw("Select a book to read",800))    );

			
			//liqtile *filelist;
			
			liqtile *filelist;
				filelist = mkcell("test",canvas.pixelwidth,canvas.pixelheight);
				filelist->style=styleblack;
				filelist_extend(filelist,"/home/user");
				filelist_extend(filelist,"/media/mmc2");
				filelist_extend(filelist,"/media/mmc1");
				liqtile_childarrange_col(filelist);
				if(filelist->childcount>0)
				{
					// set the first :)
					filelist->linkchild->selected=1;
					filelist->linkchild->style=stylelistbacksel;
				}
				else
				{
				}
				
				liqtile_childappend(tileroot,     at(300,40, mkgrid(500,400,filelist,0,&runfast))    );

					
					
			// make the folder tree :) this is the recursive thingamajig whatsit
			liqtile *foldertree=buildfoldertree(filelist,300,400);
				liqtile_childappend(tileroot,     at(0,40, foldertree)    );



			liqtile *cmd;

			//cmd=mklabel("view:");
			//	liqtile_childappend(tileroot,     at(tileroot->w*0.0,440, cmd)    );

			cmd=mklabel("all");
				liqtile_childappend(tileroot,     at(tileroot->w*0.0,440, cmd)    );
				
			cmd=mklabel("recent");
				liqtile_childappend(tileroot,     at(tileroot->w*0.2,440, cmd)    );



			cmd=mklabel("intro");
				liqtile_childappend(tileroot,     at(tileroot->w*0.4,440, cmd)    );
				cmd->handlerclick=&cmd_intro;



			cmd=mklabel("Read book");
				liqtile_childappend(tileroot,     at(tileroot->w-cmd->w,440, cmd)    );
				cmd->handlerclick=&cmd_readbook;
			
			//liqtile_neatarrange(tileroot);

		
		liqtile_easyrun2(tileroot,&runfast);
		
		
		liqtile_close(tileroot);



	if(selectedfile)
	{
		free(selectedfile);
		selectedfile=NULL;
	}

	
	mk_style_close();
	
	return 0;
}







