#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>


#include "liqapp.h"
#include "liqcanvas.h"
#include "liqimage.h"
#include "liqfont.h"
#include "liqtile.h"


#include "mk_core.h"

// create a bunch of default styles :)


//liqimage *imgback=NULL;
liqimage *imgknob=NULL;
//liqimage *imground=NULL;


liqimage *imgmenuback;
liqimage *imgmenuitemstd;
liqimage *imgmenuitemdefault;	
liqimage *imgmenuitemsel;

LIQFONT *fontsmall=NULL;
LIQFONT *fontnormal=NULL;
LIQFONT *fontlarge=NULL;
LIQFONT *fontxlarge=NULL;

liqstyle *stylefolderitem=NULL;
liqstyle *stylefolderitemsel=NULL;

liqstyle *stylelistback=NULL;
liqstyle *stylelistbacksel=NULL;

liqstyle *styleblack=NULL;

liqstyle *styleback=NULL;
liqstyle *stylegrid=NULL;
liqstyle *stylenone=NULL;

liqstyle *stylebutton=NULL;
liqstyle *stylebuttonsel=NULL;

liqstyle *styleslide=NULL;
liqstyle *styleknob=NULL;

liqstyle *styletitle=NULL;
liqstyle *styletitlesel=NULL;

liqstyle *stylesubtitle=NULL;
liqstyle *stylesubtitlesel=NULL;

liqstyle *stylelabel=NULL;
liqstyle *stylelabelsel=NULL;

liqstyle *styletext=NULL;
liqstyle *styletextsel=NULL;

liqstyle *stylecolorbright=NULL;
liqstyle *stylecolorpalette=NULL;
liqstyle *stylepencolor=NULL;



liqstyle *stylefileseparator=NULL;
liqstyle *stylefilesketch=NULL;
liqstyle *stylefilesketchsel=NULL;


liqstyle *stylemenuback=NULL;	
liqstyle *stylemenuitemstd=NULL;
liqstyle *stylemenuitemdefault=NULL;
liqstyle *stylemenuitemsel=NULL;


liqstyle *stylekeycap=NULL;
liqstyle *stylekeycapsel=NULL;




static int mk_style_opencount=0;


int mk_style_getopencount()
{
	return mk_style_opencount;
}



int mk_style_open()
{
	mk_style_opencount++;
	if(mk_style_opencount>1)
	{
		app_log("mk_style SKIPPED opening styles");

		return 0;
	}
	
	LIQFONT *f=NULL;
	int fontsize=0;
	
	
	app_log("mk_style open making fonts");
	
	f=liqfont_alloc();
	fontsmall=f;
	fontsize =        canvas.font->size-4;
	if(fontsize<8) fontsize=8;
	if(fontsize>72) fontsize=72;
	if(liqfont_openfile(f,canvas.font->name,fontsize,0,canvas.scalew,canvas.scaleh)!=0)
	{
		return app_warnandcontinue(-1,"Couldnt open font");
	}
	 
	f=liqfont_alloc();
	fontnormal=f;
	fontsize =        canvas.font->size;
	if(fontsize<8) fontsize=8;
	if(fontsize>72) fontsize=72;
	if(liqfont_openfile(f,canvas.font->name,fontsize,0,canvas.scalew,canvas.scaleh)!=0)
	{
		return app_warnandcontinue(-1,"Couldnt open font");
	} 

	f=liqfont_alloc();
	fontlarge=f;
	fontsize =        canvas.font->size+8;
	if(fontsize<8) fontsize=8;
	if(fontsize>72) fontsize=72;
	if(liqfont_openfile(f,canvas.font->name,fontsize,0,canvas.scalew,canvas.scaleh)!=0)
	{
		return app_warnandcontinue(-1,"Couldnt open font");
	}
	
	f=liqfont_alloc();
	fontxlarge=f;
	fontsize =        canvas.font->size+12;
	if(fontsize<8) fontsize=8;
	if(fontsize>72) fontsize=72;
	if(liqfont_openfile(f,canvas.font->name,fontsize,0,canvas.scalew,canvas.scaleh)!=0)
	{
		return app_warnandcontinue(-1,"Couldnt open font");
	}
	
	app_log("mk_style open making images");
	
	
			char buf[FILENAME_MAX+1];
			//snprintf(buf,FILENAME_MAX,"%s/menu_back_400_240.jpg",app.themepath);
			//imgback = liqimage_createfromfilejpeg(buf);


			snprintf(buf,FILENAME_MAX,"%s/sun.png",app.themepath);
	
			imgknob = liqimage_createfromfilepng( buf,1);
			if(!imgknob)
			{
				return app_warnandcontinue(-1,"Couldnt open image:knob");
			}
	//imground= liqimage_createfromfilepng( "rounded.png",1);


			snprintf(buf,FILENAME_MAX,"%s/menu_back_400_240.jpg",app.themepath);
			imgmenuback = liqimage_createfromfilejpeg(buf);
			if(!imgmenuback)
			{
				return app_warnandcontinue(-1,"Couldnt open image:imgmenuback");
			}

			cliprect critem;

			imgmenuitemstd = liqimage_create();
			if(!imgmenuitemstd)
			{
				return app_warnandcontinue(-1,"Couldnt open image:imgmenuitemstd");
			}
			liqimage_pagedefine(imgmenuitemstd,32,32,225,225,0);
			cliprect_initfromimage(&critem,imgmenuitemstd);
			cliprect_drawclear(&critem,10,240,20);

			imgmenuitemdefault = liqimage_create();
			if(!imgmenuitemdefault)
			{
				return app_warnandcontinue(-1,"Couldnt open image:imgmenuitemdefault");
			}
			liqimage_pagedefine(imgmenuitemdefault,32,32,225,225,0);
			cliprect_initfromimage(&critem,imgmenuitemdefault);
			cliprect_drawclear(&critem,10,20,20);
			
			imgmenuitemsel = liqimage_create();
			if(!imgmenuitemsel)
			{
				return app_warnandcontinue(-1,"Couldnt open image:imgmenuitemsel");
			}
			liqimage_pagedefine(imgmenuitemsel,32,32,225,225,0);
			cliprect_initfromimage(&critem,imgmenuitemsel);
			cliprect_drawclear(&critem,20,20,240);

	
	app_log("mk_style open making styles");
	
	stylecolorbright=liqstyle_create_key("colorbright");
	stylecolorbright->backmode=4;
	liqstyle_setbackcoloryuv(stylecolorbright,255,128,128);
	stylecolorbright->borderwidth=0;
	liqstyle_setbordercoloryuv(stylecolorbright,128,128,128);
	//stylecolorbright->textfont=&fontsmall;
	stylecolorbright->textalignx=0;
	
	
	
	
	stylecolorpalette=liqstyle_create_key("colorpalette");
	stylecolorpalette->backmode=3;
	liqstyle_setbackcoloryuv(stylecolorpalette,128,128,128);
	stylecolorpalette->borderwidth=0;
	liqstyle_setbordercoloryuv(stylecolorpalette,128,128,128);
	//stylecolorpalette->textfont=&fontsmall;
	stylecolorpalette->textalignx=0;


	stylepencolor=liqstyle_create_key("pencolor");
	stylepencolor->backmode=1;
	liqstyle_setbackcoloryuv(stylepencolor,255,128,128);
	stylepencolor->borderwidth=0;
	liqstyle_setbordercoloryuv(stylepencolor,0,128,128);
	stylepencolor->textfont=fontsmall;
	stylepencolor->textalignx=0;


	styleslide=liqstyle_create_key("slide");
	styleslide->backmode=1;
	liqstyle_setbackcoloryuv(styleslide,10,128,128);
	styleslide->borderwidth=1;
	liqstyle_setbordercoloryuv(styleslide,128,128,128);
	//styleslide->textfont=fontsmall;
	styleslide->textalignx=0;

	styleknob=liqstyle_create_key("knob");
	styleknob->backmode=1;
	styleknob->backimage=imgknob;
	liqstyle_setbackcoloryuv(styleknob,255,128,128);
	styleknob->borderwidth=0;
	liqstyle_setbordercoloryuv(styleknob,128,90,128);
	//styleknob->textfont=fontsmall;
	styleknob->textalignx=0;


	stylelistback=liqstyle_create_key("listback");
	stylelistback->backmode=1;
	liqstyle_setbackcoloryuv(stylelistback,10,0,0);
	stylelistback->borderwidth=0;
	liqstyle_setbordercoloryuv(stylelistback,128,90,128);
	stylelistback->textfont=NULL;
	stylelistback->textalignx=1;
	
	

	stylelistbacksel=liqstyle_create_key("listbacksel");
	stylelistbacksel->backmode=1;
	liqstyle_setbackcoloryuv(stylelistbacksel,30,180,10);
	stylelistbacksel->borderwidth=1;
	liqstyle_setbordercoloryuv(stylelistbacksel,200,220,255);
	stylelistbacksel->textfont=NULL;
	stylelistbacksel->textalignx=0;
	
	
	stylefolderitem=liqstyle_create_key("folderitem");
	stylefolderitem->backmode=1;
	//stylefolderitem->backimage=imground;
	liqstyle_setbackcoloryuv(stylefolderitem,10,250,30);
	stylefolderitem->borderwidth=1;
	liqstyle_setbordercoloryuv(stylefolderitem,128,128,128);
	stylefolderitem->textfont=fontsmall;
	stylefolderitem->textalignx=0;
	
	

	stylefolderitemsel=liqstyle_create_key("folderitemsel");
	stylefolderitemsel->backmode=1;
	//stylefolderitemsel->backimage=imground;
	liqstyle_setbackcoloryuv(stylefolderitemsel,30,180,10);
	stylefolderitemsel->borderwidth=1;
	liqstyle_setbordercoloryuv(stylefolderitemsel,200,220,255);
	stylefolderitemsel->textfont=fontsmall;
	stylefolderitemsel->textalignx=0;
	
	
	
	
	styletitle=liqstyle_create_key("title");
	styletitle->backmode=0;
	liqstyle_setbackcoloryuv(styletitle,20,128,128);
	styletitle->borderwidth=0;
	liqstyle_setbordercoloryuv(styletitle,128,90,128);
	styletitle->textfont=fontlarge;
	styletitle->textalignx=0;
	
	styletitlesel=liqstyle_create_key("titlesel");
	styletitlesel->backmode=0;
	liqstyle_setbackcoloryuv(styletitlesel,30,180,10);
	styletitlesel->borderwidth=1;
	liqstyle_setbordercoloryuv(styletitlesel,200,220,255);
	styletitlesel->textfont=fontlarge;
	styletitlesel->textalignx=0;
	
	
	
	stylesubtitle=liqstyle_create_key("subtitle");
	stylesubtitle->backmode=0;
	liqstyle_setbackcoloryuv(stylesubtitle,20,128,128);
	stylesubtitle->borderwidth=0;
	liqstyle_setbordercoloryuv(stylesubtitle,128,90,128);
	stylesubtitle->textfont=fontsmall;
	stylesubtitle->textalignx=0;
	
	stylesubtitlesel=liqstyle_create_key("subtitlesel");
	stylesubtitlesel->backmode=0;
	liqstyle_setbackcoloryuv(stylesubtitlesel,30,180,10);
	stylesubtitlesel->borderwidth=1;
	liqstyle_setbordercoloryuv(stylesubtitlesel,200,220,255);
	stylesubtitlesel->textfont=fontsmall;
	stylesubtitlesel->textalignx=0;
	
		
	
	
	


	stylelabel=liqstyle_create_key("label");
	stylelabel->backmode=0;
	liqstyle_setbackcoloryuv(stylelabel,20,128,128);
	stylelabel->borderwidth=0;
	liqstyle_setbordercoloryuv(stylelabel,128,90,128);
	stylelabel->textfont=fontnormal;
	stylelabel->textalignx=0;
	
	

	stylelabelsel=liqstyle_create_key("labelsel");
	stylelabelsel->backmode=0;
	liqstyle_setbackcoloryuv(stylelabelsel,30,180,10);
	stylelabelsel->borderwidth=1;
	liqstyle_setbordercoloryuv(stylelabelsel,200,220,255);
	stylelabelsel->textfont=fontnormal;
	stylelabelsel->textalignx=0;
	





	styletext=liqstyle_create_key("text");
	styletext->backmode=1;
	liqstyle_setbackcoloryuv(styletext,20,128,128);
	styletext->borderwidth=1;
	liqstyle_setbordercoloryuv(styletext,128,90,128);
	styletext->textfont=fontnormal;
	styletext->textalignx=1;
	
	

	styletextsel=liqstyle_create_key("textsel");
	styletextsel->backmode=1;
	liqstyle_setbackcoloryuv(styletextsel,30,180,10);
	styletextsel->borderwidth=1;
	liqstyle_setbordercoloryuv(styletextsel,200,220,255);
	styletextsel->textfont=fontnormal;
	styletextsel->textalignx=1;
	
		
	
	
	
	stylebutton=liqstyle_create_key("button");
	stylebutton->backmode=1;
	stylebutton->backimage=imgknob;
	liqstyle_setbackcoloryuv(stylebutton,20,128,128);
	stylebutton->borderwidth=1;
	liqstyle_setbordercoloryuv(stylebutton,128,90,128);
	stylebutton->textfont=fontnormal;
	stylebutton->textalignx=1;
	
	

	stylebuttonsel=liqstyle_create_key("buttonsel");
	stylebuttonsel->backmode=1;
	
	stylebuttonsel->backimage=imgknob;
	//liqstyle_setbackcoloryuv(stylebuttonsel,40,180,10);
	liqstyle_setbackcoloryuv(stylebuttonsel,80,180,10);
	stylebuttonsel->borderwidth=1;
	liqstyle_setbordercoloryuv(stylebuttonsel,200,220,55);
	stylebuttonsel->textfont=fontlarge;
	stylebuttonsel->textalignx=1;
	
		
	

	stylenone=liqstyle_create_key("none");
	stylenone->backmode=0;
	liqstyle_setbackcoloryuv(stylenone,40,128,128);
	stylenone->borderwidth=0;
	liqstyle_setbordercoloryuv(stylenone,255,90,128);
	stylenone->textfont=NULL;
	stylenone->textalignx=0;



	stylegrid=liqstyle_create_key("grid");
	stylegrid->backmode=2;
	//stylegrid->backpage=page;
	liqstyle_setbackcoloryuv(stylegrid,40,128,128);
	stylegrid->borderwidth=1;
	liqstyle_setbordercoloryuv(stylegrid,255,90,128);
	stylegrid->textfont=NULL;//canvas.font;
	stylegrid->textalignx=1;


	styleblack=liqstyle_create_key("black");
	styleblack->backmode=1;
	//styleblack->backpage=page;
	liqstyle_setbackcoloryuv(styleblack,0,128,128);
	styleblack->borderwidth=0;
	liqstyle_setbordercoloryuv(styleblack,255,90,128);
	styleblack->textfont=NULL;//canvas.font;
	styleblack->textalignx=1;

/*
	styleback=liqstyle_create_key();
	styleback->backmode=1;
	styleback->backimage=imgback;
	liqstyle_setbackcoloryuv(styleback,255,128,128);
	//back->borderwidth=1200;
	styleback->borderwidth=00;
	liqstyle_setbordercoloryuv(styleback,255,128,255);
	styleback->textfont=NULL;//canvas.font;
	styleback->textalignx=1;
	
*/	
	
	
	
	
	
	
	
	app_log("mk_style creating menu styles");
	
	stylemenuback=liqstyle_create_key("menuback");
	stylemenuback->backmode=1;
	stylemenuback->backimage=imgmenuback;
	liqstyle_setbackcoloryuv(stylemenuback,255,128,128);
	stylemenuback->borderwidth=0;
	liqstyle_setbordercoloryuv(stylemenuback,255,255,255);
	stylemenuback->textfont=NULL;
	stylemenuback->textalignx=0;
	
	
	stylemenuitemstd=liqstyle_create_key("menuitemstd");
	stylemenuitemstd->backmode=0;
	//stylemenuitemstd->backmode=1;
	stylemenuitemstd->backimage=imgmenuitemstd;
	liqstyle_setbackcoloryuv(stylemenuitemstd,60,128,128);
	stylemenuitemstd->borderwidth=1;
	liqstyle_setbordercoloryuv(stylemenuitemstd,155,180,30);
	stylemenuitemstd->textfont=fontnormal;
	stylemenuitemstd->textalignx=1;
	
	
	stylemenuitemdefault=liqstyle_create_key("menuitemdefault");
	stylemenuitemdefault->backmode=1;
	stylemenuitemdefault->backimage=imgmenuitemdefault;
	liqstyle_setbackcoloryuv(stylemenuitemdefault,50,10,20);
	stylemenuitemdefault->borderwidth=1;
	liqstyle_setbordercoloryuv(stylemenuitemdefault,255,10,20);
	stylemenuitemdefault->textfont=fontnormal;
	stylemenuitemdefault->textalignx=1;
	
	
	stylemenuitemsel=liqstyle_create_key("menuitemsel");
	stylemenuitemsel->backmode=1;
	stylemenuitemsel->backimage=imgmenuitemsel;
	liqstyle_setbackcoloryuv(stylemenuitemsel,70,25,20);
	stylemenuitemsel->borderwidth=1;
	liqstyle_setbordercoloryuv(stylemenuitemsel,255,180,30);
	stylemenuitemsel->textfont=fontlarge;
	stylemenuitemsel->textalignx=1;




	stylefileseparator=liqstyle_create_key("fileseparator");
	stylefileseparator->backmode=1;
	liqstyle_setbackcoloryuv(stylefileseparator,0,134,212);			// 0,0,0 is not applicable, its green on some screens..	
	stylefileseparator->borderwidth=0;
	liqstyle_setbordercoloryuv(stylefileseparator,255,128,128);
	stylefileseparator->textalignx=0;
	stylefileseparator->textfont=fontnormal;

	
	stylefilesketch=liqstyle_create_key("filesketch");
	stylefilesketch->backmode=0;
	liqstyle_setbackcoloryuv(stylefilesketch,0,128,128);			// 0,0,0 is not applicable, its green on some screens..
	stylefilesketch->borderwidth=0;
	liqstyle_setbordercoloryuv(stylefilesketch,255,128,128);
	stylefilesketch->textfont=NULL;
	
	
		
	stylefilesketchsel=liqstyle_create_key("filesketchsel");
	stylefilesketch->backmode=1;
	liqstyle_setbackcoloryuv(stylefilesketchsel,0,110,110);			// 0,0,0 is not applicable, its green on some screens..
	stylefilesketchsel->borderwidth=1;
	liqstyle_setbordercoloryuv(stylefilesketchsel,30,10,10);
	stylefilesketchsel->textfont=NULL;
		
	
	
	
	
	stylekeycap=liqstyle_create_key("keycap");
	stylekeycap->backmode=1;
	//stylekeycap->backimage=imgknob;
	liqstyle_setbackcoloryuv(stylekeycap,10,100,100);
	stylekeycap->borderwidth=1;
	liqstyle_setbordercoloryuv(stylekeycap,255,128,128);
	stylekeycap->textfont=fontnormal;
	stylekeycap->textalignx=1;

	stylekeycapsel=liqstyle_create_key("keycapsel");
	stylekeycapsel->backmode=1;
	//stylekeycapsel->backimage=imgknob;
	liqstyle_setbackcoloryuv(stylekeycapsel,120,128,128);	
	stylekeycapsel->borderwidth=1;
	liqstyle_setbordercoloryuv(stylekeycapsel,128,90,128);
	stylekeycapsel->textfont=fontxlarge;
	stylekeycapsel->textalignx=1;
		
	
	
	
	
	
	
	app_log("mk_style open complete");
	return 0;
}


void mk_style_close()
{
	if(--mk_style_opencount>0)
	{
		app_log("mk_style SKIPPED closing styles");
		return;
	}
	app_log("mk_style closing styles");
	liqstyle_close(styleslide);
	liqstyle_close(styleknob);
	
	liqstyle_close(stylelistback);
	liqstyle_close(stylelistbacksel);
	
	//liqstyle_close(styleback);
	liqstyle_close(stylegrid);
	liqstyle_close(stylenone);
	
	liqstyle_close(stylefolderitem);
	liqstyle_close(stylefolderitemsel);

	liqstyle_close(styletext);
	liqstyle_close(styletextsel);
	

	liqstyle_close(stylebutton);
	liqstyle_close(stylebuttonsel);
	
	liqstyle_close(styletitle);
	liqstyle_close(styletitlesel);

	liqstyle_close(stylesubtitle);
	liqstyle_close(stylesubtitlesel);
	
	liqstyle_close(stylelabel);
	liqstyle_close(stylelabelsel);
	
	
	liqstyle_close(stylepencolor);
	liqstyle_close(styleblack);
	liqstyle_close(stylecolorbright);
	liqstyle_close(stylecolorpalette);
	
	liqstyle_close(stylemenuback);
	liqstyle_close(stylemenuitemstd);
	liqstyle_close(stylemenuitemdefault);
	liqstyle_close(stylemenuitemsel);


	liqstyle_close(stylefileseparator);
	liqstyle_close(stylefilesketch);
	liqstyle_close(stylefilesketchsel);
	
	
	liqstyle_close(stylekeycap);
	liqstyle_close(stylekeycapsel);
	
	
	
	app_log("mk_style closing fonts");
	liqfont_free(fontsmall);
	liqfont_free(fontnormal);
	liqfont_free(fontlarge);
	liqfont_free(fontxlarge);
	
	app_log("mk_style closing images");
	liqimage_free(imgknob);
	liqimage_free(imgmenuback);
	liqimage_free(imgmenuitemsel);
	liqimage_free(imgmenuitemstd);
	liqimage_free(imgmenuitemdefault);
	//liqimage_free(imground);


}


