/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Header for basic sketch
 *
 */




#ifndef MK_CORE_H
#define MK_CORE_H



#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>



#include "liqtile.h"


//#include "liqapp.h"
//#include "liqcanvas.h"
#include "liqimage.h"
#include "liqfont.h"
//#include "liqtile.h"


liqtile *mkcell(char *key,int w,int h);

//###############################################################################
//############################################################################### Properties
//###############################################################################

liqtile *mktitle(char *key);
liqtile *mkauthor(char *key);
liqtile *mkdescription(char *key);
liqtile *mkversion(char *key);

//###############################################################################
//############################################################################### Single entities
//###############################################################################

liqtile *mkhot(char *key);
liqtile *mkbutton(char *key);
liqtile *mkcolorbutton(char *key,char grey,char u,char v);

liqtile *mklabel(char *key);

liqtile *mklabelw(char *key,int w);
liqtile *mklabelwh(char *key,int w,int h);

liqtile *mkentry(char *key);
liqtile *mkspace(char *key);

//###############################################################################
//############################################################################### Group
//###############################################################################

liqtile *mkgroupa(char *key,liqtile *first,va_list arg);
liqtile *mkgroup(char *key,liqtile *first,...);
liqtile *mkgrouph(char *key,liqtile *first,...);
liqtile *mkgroupv(char *key,liqtile *first,...);

liqtile *mkinfo(char *key,liqtile *first,...);



liqtile *mkgrid(int w,int h,liqtile *contents,int scrollleft,int *runfastonkineticflag);		// runfastonkineticflag will be set to 1 if kinetic is used in painting, otherwise it wont be touched.  this allows the host to know whether high speed rendering is required

liqtile *at(int x,int y,liqtile *what);
liqtile *usingstyle(liqstyle *style,liqtile *what);

int grid_contents_recalc(struct liqtile *gridcontents);



//###############################################################################
//############################################################################### style
//###############################################################################

// create a bunch of default styles :)


//extern liqimage *imgback;
extern liqimage *imgknob;

extern liqimage *imgmenuback;
extern liqimage *imgmenuitemstd;
extern liqimage *imgmenuitemdefault;	
extern liqimage *imgmenuitemsel;


extern LIQFONT *fontsmall;
extern LIQFONT *fontnormal;
extern LIQFONT *fontlarge;


extern liqstyle *stylenone;

//extern liqstyle *styleback;
extern liqstyle *styleblack;


extern liqstyle *stylegrid;

extern liqstyle *styleslide;
extern liqstyle *styleknob;

extern liqstyle *stylebutton;
extern liqstyle *stylebuttonsel;

extern liqstyle *styletitle;
extern liqstyle *styletitlesel;

extern liqstyle *stylesubtitle;
extern liqstyle *stylesubtitlesel;


extern liqstyle *stylelabel;
extern liqstyle *stylelabelsel;

extern liqstyle *styletext;
extern liqstyle *styletextsel;

extern liqstyle *stylefolderitem;
extern liqstyle *stylefolderitemsel;

extern liqstyle *stylelistback;
extern liqstyle *stylelistbacksel;

extern liqstyle *stylecolorbright;
extern liqstyle *stylecolorpalette;

extern liqstyle *stylepencolor;


extern liqstyle *stylemenuback;	
extern liqstyle *stylemenuitemstd;
extern liqstyle *stylemenuitemdefault;
extern liqstyle *stylemenuitemsel;

extern liqstyle *stylefileseparator;
extern liqstyle *stylefilesketch;
extern liqstyle *stylefilesketchsel;

extern liqstyle *stylekeycap;
extern liqstyle *stylekeycapsel;

int mk_style_open();

void mk_style_close();

int mk_style_getopencount();		// used when changing resolution
#endif



