#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>


#include "liqapp.h"
#include "liqcanvas.h"
#include "liqimage.h"
#include "liqfont.h"
#include "liqtile.h"


#include "mk_core.h"



liqtile *mkcell(char *key,int w,int h)
{
	liqtile *self= liqtile_createquick(key,0,0,w,h);
	return self;
}

// String,Int,Float,Cell


//###############################################################################
//############################################################################### Properties
//###############################################################################

liqtile *mktitle(char *key)
{
	liqtile *self= mkcell(key,0,0);
	return self;
}
liqtile *mkauthor(char *key)
{
	liqtile *self= mkcell(key,0,0);
	return self;
}
liqtile *mkdescription(char *key)
{
	liqtile *self= mkcell(key,0,0);
	return self;
}
liqtile *mkversion(char *key)
{
	liqtile *self= mkcell(key,0,0);
	return self;
}

//###############################################################################
//############################################################################### Single entities
//###############################################################################

liqtile *mkhot(char *key)
{
	liqtile *self= mkcell(key,64,40);
	self->style=stylelabel;
	self->visible=0;
	return self;
}

liqtile *mkbutton(char *key)
{
	liqtile *self= mkcell(key,80,80);
	self->style=stylelabel;
	return self;
}

liqtile *mkcolorbutton(char *key,char grey,char u,char v)
{
	liqtile *self= mkbutton(key);
	self->style=stylelabel;
	return self;
}

liqtile *mklabel(char *key)
{
	liqtile *self;
	if(stylelabel->textfont)
		self = mkcell(			key,
								liqfont_textwidth(stylelabel->textfont,key)+2*stylelabel->borderwidth,
								stylelabel->textfont->glyphmaxh+2 *stylelabel->borderwidth
					 );
	else
		self = mkcell(key,128,80);
	
	

	self->style=stylelabel;
	//self->layoutstretchw=100;
	//self->layoutstretchh=100;
	
	return self;
}


liqtile *mklabelw(char *key,int w)
{
	liqtile *self=mklabel(key);
	self->w=w;
	liqtile_update_boundfrompos(self);
	return self;
}
liqtile *mklabelwh(char *key,int w,int h)
{
	liqtile *self=mklabel(key);
	self->w=w;
	self->h=h;
	liqtile_update_boundfrompos(self);
	return self;
}


liqtile *mkentry(char *key)
{
	liqtile *self= mkcell(key,80,80);
	self->style=stylegrid;
	//self->visible=0;
	return self;
}

liqtile *mkspace(char *key)
{
	liqtile *self= mkcell(key,640,400);
	self->style=stylegrid;
	//self->layoutstretchw=100;
	//self->layoutstretchh=100;
	return self;
}


//###############################################################################
//############################################################################### Group
//###############################################################################

liqtile *mkgroupa(char *key,liqtile *first,va_list arg)
{
	//app_log("grp %s start",key);
	liqtile *self= mkcell(key,0,0);
	self->visible=1;
	
	// add some special sauce ;)
	//liqtile_childappend(self,mkhot("hot"));
	
	if(first)
	{
		//app_log("grp %s appending first",key);
		liqtile_childappend(self,first);
		//va_list arg;
		//va_start(arg, first);
		while(1)
		{
			liqtile *c = va_arg(arg, liqtile *);
			if(!c)break;
			//app_log("grp %s appending n",key);
			liqtile_childappend(self,c);
		};
		//va_end(arg);
	}
	return self;
}

liqtile *mkgroup(char *key,liqtile *first,...)
{
	va_list arg;
	va_start(arg, first);
	liqtile *self= mkgroupa(key,first,arg);
	self->layoutmode=1;
	va_end(arg);
	return self;
}

liqtile *mkgrouph(char *key,liqtile *first,...)
{
	va_list arg;
	va_start(arg, first);
	//app_log("making %s",key);
	liqtile *self= mkgroupa(key,first,arg);
	//app_log("arranging %s",key);
	liqtile_childarrange_row(self);
	self->layoutmode=1;
	va_end(arg);
	return self;
}
liqtile *mkgroupv(char *key,liqtile *first,...)
{
	va_list arg;
	va_start(arg, first);
	liqtile *self= mkgroupa(key,first,arg);
	liqtile_childarrange_col(self);
	self->layoutmode=2;
	va_end(arg);
	return self;
}


liqtile *mkinfo(char *key,liqtile *first,...)
{
	va_list arg;
	va_start(arg, first);
	liqtile *self= mkgroupa(key,first,arg);
	self->visible=0;
	va_end(arg);
	return self;
}





// ################################################################
// ################################################################
// ################################################################ basic grid stuff
// ################################################################
// ################################################################


//	grid
//		slide
//			knob
//		view
//			contents


static int doscaleconvert(int value,int rangefrom,int rangeto)
{
	int yy = (int) (((float)value/(float)rangefrom)*(float)rangeto);
	return yy;
}		



static int gridslide_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// todo: pray this is correct...  it will blow if not ;)
	
	int isknob=0;
	if(strcmp(self->key,"knob")==0)
	{
		isknob=1;
		self=self->linkparent;
	}
	
	
	//liqtile *grid    =self->linkparent;
	liqtile *view    =self->linkprev;
	//liqtile *contents=view->linkchild;
	liqtile *slide   =self;
	liqtile *knob    =slide->linkchild;
	
	
	//liqtile_print(self,"am i slider?");
	
	
	// aim to adjust y between parent.sy..parent.ey-self->h
	if(isknob)
		knob->y-=args->mdy;
	else
		knob->y = args->mey-(knob->h/2);
	liqtile_update_boundfrompos(knob);
	liqtile_forceinboundparent(knob);
	
	int range = slide->h-knob->h;
	if(range<0) return 0;	// too small to do anything
	
	int off=knob->y-slide->y;
	if(off<0) return 0;
	
	int yy=doscaleconvert(off,range,view->crh-view->cvh);			


	app_log("off %i,  range %i,   yy %i",off,range,yy);


	view->coy=yy;
	
	liqtile_floatensurebounded(view);

	return 0;
}



#define SGN(x) ((x)<0?-1:(x)==0?0:1)


static int gridview_paint(struct liqtile *self,liqtileeventpaint *args)
{
	// ok, the gridview is about to be painted.
		
	//app_log("gridview paint KINETIC: %i,%i",self->kineticx,self->kineticy);
	if(self->kineticx || self->kineticy)
	{

		//liqtile *grid    =self->linkparent;
		liqtile *view    =self;
		liqtile *slide   =self->linknext;
		liqtile *knob    =slide->linkchild;
		//liqtile *contents=view->linkchild;
		
		
		
		if(self->tag)
		{
			// this was specified in the initializer
			*((int *)self->tag) = 1;
		}
		
		// if we have a kinetic component lets use it up
		view->cox+=self->kineticx;
		view->coy+=self->kineticy;
		liqtile_floatensurebounded(self);
		
		// make sure the knob is displayed accordingly		
		int range = slide->h-knob->h;
		if(range<0) return 0;	// too small to do anything		
		int off=view->coy;		
		int yy=doscaleconvert(off,view->crh-view->cvh,range);
		knob->y=yy;
		liqtile_update_boundfrompos(knob);
		liqtile_forceinboundparent(knob);

			self->kineticx-=SGN(self->kineticx);
			self->kineticy-=SGN(self->kineticy);		
	}

	// now, render as normal
	self->handlerpaint=NULL;
	liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
	self->handlerpaint=gridview_paint;
	return 0;
}



static int gridview_mouse(struct liqtile *self,liqtileeventmouse *args)
{
//	app_log("gridview mouse %i,%i",args->mex,args->mey);

	// todo: pray this is correct...  it will blow if not ;)
	//liqtile *grid    =self->linkparent;
	liqtile *view    =self;
	liqtile *slide   =self->linknext;
	liqtile *knob    =slide->linkchild;
	//liqtile *contents=view->linkchild;
	
	
	view->cox+=args->mdx;
	view->coy+=args->mdy;
	liqtile_floatensurebounded(view);
	
	
	
	
	
	int range = slide->h-knob->h;
	if(range<0) return 0;	// too small to do anything
	
	int off=view->coy;
	
	int yy=doscaleconvert(off,view->crh-view->cvh,range);
	
	
	knob->y=yy;
	liqtile_update_boundfrompos(knob);
	liqtile_forceinboundparent(knob);

	return 0;
}
/*
static int gridview_kinetic(struct liqtile *self,liqtileeventmouse *args)
{
	// what does this achieve?
	
}
 */
static int grid_recalc(struct liqtile *self)
{
	// ok, the grid is about to be painted.
	// we have not yet done anything with the contents
	
	
	// todo: pray this is correct...  it will blow if not ;)
	
	//liqtile *grid        = self;
	liqtile *gridview    = self->linkchild;
	//liqtile *gridcontents= gridview->linkchild;
	liqtile *gridslide   = gridview->linknext;
	liqtile *gridknob    = gridslide->linkchild;


	liqtile_floatprepare(gridview);
	
	if(gridview->crh <= gridview->cvh )
	{
		// do not need a knob technically...
		gridknob->h=gridslide->h;
	}
	else
	{
		// need a knob in the correct place
		gridknob->y =  doscaleconvert( gridview->coy, gridview->crh-gridview->cvh, gridslide->h-gridknob->h);
		
		
		
		
		gridknob->h=gridslide->h * gridview->cvh / gridview->crh;
		//if(gridknob->h<(gridslide->h*0.2))gridknob->h=(gridslide->h*0.2);
		if(gridknob->h<(1))gridknob->h=(1);
	}	
	liqtile_update_boundfrompos(gridknob);
	liqtile_forceinboundparent(gridknob);

/*	// now, render as normal
	self->handlerpaint=NULL;
	liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
	self->handlerpaint=grid_paint;

*/
	return 0;
}

int grid_contents_recalc(struct liqtile *gridcontents)
{
	// experimental..  been passed grid contents object (same thing passed in to create)
	grid_recalc(gridcontents->linkparent->linkparent);
	return 0;
}

static int grid_paint(struct liqtile *self,liqtileeventpaint *args)
{
	// ok, the grid is about to be painted.
	// we have not yet done anything with the contents
	
	
	// todo: pray this is correct...  it will blow if not ;)
/*	
	liqtile *grid        = self;
	liqtile *gridview    = self->linkchild;
	liqtile *gridcontents= gridview->linkchild;
	liqtile *gridslide   = gridview->linknext;
	liqtile *gridknob    = gridslide->linkchild;


	liqtile_floatprepare(gridview);
	
	if(gridview->crh <= gridview->cvh )
	{
		// do not need a knob technically...
		gridknob->h=gridslide->h;
	}
	else
	{
		// need a knob in the correct place
		gridknob->y =  doscaleconvert( gridview->coy, gridview->crh-gridview->cvh, gridslide->h-gridknob->h);
		
		
		
		
		gridknob->h=gridslide->h * gridview->cvh / gridview->crh;
		//if(gridknob->h<(gridslide->h*0.2))gridknob->h=(gridslide->h*0.2);
		if(gridknob->h<(1))gridknob->h=(1);
	}	
	liqtile_update_boundfrompos(gridknob);
	liqtile_forceinboundparent(gridknob);
 */
	// now, render as normal
	self->handlerpaint=NULL;
	liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
	self->handlerpaint=grid_paint;
	return 0;
}




liqtile *mkgrid(int w,int h,liqtile *contents,int scrollleft,int *runfast_onkinetic)
{
liqtile *grid      = mkcell("grid",         w,      h       );
liqtile *gridview  = mkcell("view",	 		w*0.9  ,h*1.0   );
liqtile *gridslide = mkcell("slide",   		w*0.1  ,h       );
liqtile *gridknob  = mkcell("knob",			w*0.1  ,h*0.1   );
	if(scrollleft)
	{
		gridslide->x=w*0.0;
		liqtile_update_boundfrompos(gridslide);

		gridview->x=w*0.1;
		liqtile_update_boundfrompos(gridview);
	}
	else
	{
		gridview->x=w*0.0;
		liqtile_update_boundfrompos(gridview);

		gridslide->x=w*0.9;
		liqtile_update_boundfrompos(gridslide);
		
	}
	
	
	gridview->tag=(int)runfast_onkinetic;

	liqtile_childappend(grid,gridview);
	liqtile_childappend(grid,gridslide);
	
	liqtile_childappend(gridslide,gridknob);
	
	liqtile_childappend(gridview,contents);

		// assign the styling information
		grid->style 	=stylenone;
		gridview->style =stylenone;
		gridslide->style=styleslide;
		gridknob->style =styleknob;
		
		// assign the handlers 
		grid->handlerpaint =  &grid_paint;
		gridknob->handlermouse =  &gridslide_mouse;
		gridslide->handlermouse = &gridslide_mouse;
		gridview->handlermouse  = &gridview_mouse;
		gridview->handlerpaint  = &gridview_paint;
		
		
		
	// prepare for floating  (i might just leave this for now..)
	liqtile_floatprepare(gridview);
	if(gridview->crh <= gridview->cvh )
	{
		// do not need a knob technically...
		gridknob->h=gridslide->h;
	}
	else
	{
		// need a knob
		gridknob->h=gridslide->h * gridview->cvh / gridview->crh;
		//if(gridknob->h<(gridslide->h*0.2))gridknob->h=(gridslide->h*0.2);
		if(gridknob->h<(1))gridknob->h=(1);
	}	
	liqtile_update_boundfrompos(gridknob);
	liqtile_forceinboundparent(gridknob);

	return grid;

}




liqtile *at(int x,int y,liqtile *what)
{
	what->x=x;
	what->y=y;
	liqtile_update_boundfrompos(what);
	return what;
	
}




liqtile *usingstyle(liqstyle *style,liqtile *what)
{
	what->style=style;
	return what;
	
}
