

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>








#include "liqapp.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "liqimage.h"
#include "liqtile.h"
#include "liqtextbuffer.h"


//###############################################################################
//############################################################################### style rendering
//###############################################################################


void liqstyle_renderdefault(liqstyle *self,cliprect *cr,int x,int y,int w,int h,liqtile *tile)
{

char cy,cu,cv;
	//app_log("style %s.box(%i,%i,%i,%i)",title,x,y,w,h);
	if(w<=0||h<=0) return;
	switch(self->backmode)
	{
		case 1:
				liqstyle_getbackcoloryuv(self,&cy,&cu,&cv);
				// todo: deal with flat/centred/stretch/tile
				if(self->backimage)
				{
					// use the brightness of the cy to indicate gamma :)
					cliprect_drawimageblendcolor(cr,self->backimage,x,y,w,h,cy);
				}
				else
				{
					cliprect_drawboxfillcolor(cr,x,y,w,h ,cy,cu,cv);
				}
			break;
		case 2:
			// generic grid pattern
			liqstyle_getbackcoloryuv(self,&cy,&cu,&cv);
			cliprect_drawboxfillcolor(cr,x,y,w,h ,cy,cu,cv);
			// invert and rotate the back color
			// may alter soon to just lighten or darken
			//cy=255-cy;
			//{ int t=cu; cu=cv; cv=t; }
			
			if(cy<128)
			{
				cy+=64;
			}
			else
			{
				cy-=64;
			}
			
			int xx=(x>>3)<<3;
			while(xx<x+w)
			{
				cliprect_drawlinecolor(cr,xx,y,xx+0,y+h-1,cy,cu,cv);
				xx+=8;
			}
			int yy=(y>>3)<<3;
			while(yy<y+h)
			{
				cliprect_drawlinecolor(cr,x,yy,x+w-1,yy+0,cy,cu,cv);
				yy+=8;
			}
			break;

		case 3:	// colorcube :)
			
			
			liqstyle_getbackcoloryuv(self,&cy,&cu,&cv);
			
			cliprect_drawcolorcube(cr,x,y,w,h,cy);
			break;
			
		case 4:	// greystrip :)
			{
				int xx;
				int www = w;
				for(xx=0;xx<8;xx++)
				{
					int xxx = x + (xx * w) / 8;
					cliprect_drawboxfillcolor(cr,xxx,y,www/8,h,255-(xx * 32),128,128);
				}
			}

	}

	if(self->backpage)
	{
		cliprect_drawpage(cr,self->backpage,x,y,w,h,0);
	}

	if(tile && tile->linkpage)
	{
		cliprect_drawpage(cr,tile->linkpage,x,y,w,h,0);
		if(tile->selected)
		{
			cliprect_drawpage(cr,tile->linkpage,x-1,y+0,w,h,0);
			cliprect_drawpage(cr,tile->linkpage,x+1,y-0,w,h,0);
			cliprect_drawpage(cr,tile->linkpage,x-0,y+1,w,h,0);
			cliprect_drawpage(cr,tile->linkpage,x+0,y-1,w,h,0);
		}
	}
	else
	{

		if(self->textfont)
		{
			if(tile && tile->title)
			{
				//int tcnt=liqfont_textfitinside(self->textfont,title,w);
				//int tw=liqfont_textwidthn(self->textfont,title,tcnt);
				//app_log("tcnt=%i,  tw=%i,   w=%i   title='%s'",tcnt,tw,w,title);
				cliprect_drawtextinside(cr,self->textfont,x,y,w,h ,tile->title,self->textalignx);
			}
		}
	}
	if(self->borderwidth>0)
	{
		liqstyle_getbordercoloryuv(self,&cy,&cu,&cv);
		cliprect_drawboxlinecolor(cr,x,y,w,h ,cy,cu,cv);
	}
}



//###############################################################################
//############################################################################### easyrun, will be moved soon
//###############################################################################

int 		liqtile_easyrun(liqtile *self)
{
	return liqtile_easyrun2(self,NULL);
}

int liqtile_easyrun2(liqtile *self,int *arg_mode_fastrefresh)
{
	//arg_mode_fastrefresh: if not NULL and set to 1 it will try to render as many frames as possible
	
	
	app_log("liqtile easyrun %s(%i,%i)",self->key,self->w,self->h);
	
	if(self->w==0 || self->h==0)
	{
		app_log("liqtile easyrun cannot continue, tile size must be >0");
		return -1;
	}
liqtile *liqtilehot=NULL;
liqtile *liqtilesel=NULL;

int running=1;

int result=0;

unsigned long tzs=app_GetTicks();
unsigned long tz0=app_GetTicks();
unsigned long tz1=app_GetTicks();


LIQEVENT ev;

int framecount=0;

/*
int mc=0,mx=0,my=0,mp=0;
unsigned	long mt=0;
int mdx=0;
int mdy=0;
unsigned long mdt=0;
*/

int dirty=1;		// ensure we are drawn at least once :)
int wantwait=0;


int hadmouse=0;
int refreshinprogress=0;
unsigned long refreshstarttime=0;		// if we have a refresh in progress 

liqtileeventmouse evmouse;

	evmouse.hand=stroke_alloc();
	
	evmouse.msx=0;
	evmouse.msy=0;
	evmouse.msz=0;
	evmouse.mst=0;
	
	evmouse.mex=0;
	evmouse.mey=0;
	evmouse.mez=0;
	evmouse.met=0;

	evmouse.mdx=0;
	evmouse.mdy=0;
	evmouse.mdz=0;
	evmouse.mdt=0;
	
	evmouse.mcnt=0;
	

int fadein_inprogress=1;
int fadein_offset=canvas.pixelwidth;


	// unselect these to disable fadein
	//fadein_inprogress=0;
	//fadein_offset=0;



	

int mouseterminatorinprogress=0;

	while(running==1)
	{
		hadmouse=0;
		while(canvas_eventcount())// && (liqtilecount>0))
		{
waitevent:
			canvas_nextevent(&ev);
			//todo: upon hearing about a blanking signal, we should automatically switch ourselves to a slow update
			if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65307) )	//ESC
			{
				app_log("Escape Pressed, Cancelling");
				running=0;
				//result=NULL;
				break;
			}
			
			
//			if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65312) )	//Chr
//			{
//				char 		fmtnow[255];
//	 			app_formatnow(fmtnow,255,"yyyymmdd_hhmmss");
//				char buf[FILENAME_MAX+1];
//				snprintf(buf,FILENAME_MAX,"%s/liqbase.pic.%s.png",app.userpath,fmtnow);
//				app_log("Chr Pressed, saving canvas as '%s'",buf);
//				int pngerr =liqimage_pagesavepng(canvas.surface,buf);
//				if(pngerr==0)
//				{
//					// saved ok
//				}
//				else
//				{
//					// failed!
//				}
//				break;
//			}
						
			//keypress 65312==Chr
			
			
			else if(ev.type == LIQEVENT_TYPE_MOUSE)// && ev.mouse.pressure==0)
			{
				
				// todo: when calling out to an event, ensure I clear the refreshinprogress flag - this will ensure i do not get stuck
				
				//######################################### scale the coordinates from screen to tile
				
				ev.mouse.x = ev.mouse.x * self->w / canvas.pixelwidth;
				ev.mouse.y = ev.mouse.y * self->h / canvas.pixelheight;
				
				//app_log("mouse %i,%i",ev.mouse.x,ev.mouse.y);
				
				
				//######################################### prepare the mouse element
mouserestart:

				if( evmouse.mcnt>0 && ((evmouse.met-ev.mouse.ticks)>10000) && mouseterminatorinprogress==0 && (1==0) )
				{
					// point came very late and we should really finish this off and inform the target they are done
					// handle the missing terminator of a stroke now...
					// we should fake up the final stroke (based on the end of the previous) and restart
					mouseterminatorinprogress=1;
					// fake the deltas
					evmouse.mdx=0;
					evmouse.mdy=0;
					evmouse.mdz=0;
					evmouse.mdt=evmouse.met-ev.mouse.ticks;

					// fake the final motion
					evmouse.mex=evmouse.mex;
					evmouse.mey=evmouse.mey;
					evmouse.mez=0;
					evmouse.met=ev.mouse.ticks;
					
					evmouse.mcnt++;
				}
				else
				{
					// normal stroke
					if( evmouse.mcnt==0)
					{
						evmouse.msx=ev.mouse.x;
						evmouse.msy=ev.mouse.y;
						evmouse.msz=ev.mouse.pressure;
						evmouse.mst=ev.mouse.ticks;
	
						evmouse.mex=ev.mouse.x;
						evmouse.mey=ev.mouse.y;
						evmouse.mez=ev.mouse.pressure;
						evmouse.met=ev.mouse.ticks;
	
					}
	
						// this should be delta this time, not delta all time
						evmouse.mdx=evmouse.mex-ev.mouse.x;
						evmouse.mdy=evmouse.mey-ev.mouse.y;
						evmouse.mdz=evmouse.mez-ev.mouse.pressure;
						evmouse.mdt=evmouse.met-ev.mouse.ticks;
	
						// store most recent away now
						evmouse.mex=ev.mouse.x;
						evmouse.mey=ev.mouse.y;
						evmouse.mez=ev.mouse.pressure;
						evmouse.met=ev.mouse.ticks;
						
						evmouse.mcnt++;
				}
					
				//######################################### sort out the stroke now
				if( evmouse.mcnt==1)
				{
					stroke_clear(evmouse.hand);
					stroke_start(evmouse.hand,evmouse.msx,evmouse.msy,evmouse.msz);
				}
				else
				{
					stroke_extend(evmouse.hand,evmouse.mex,evmouse.mey,evmouse.mez);
				}
					evmouse.hand->pointlast->t=evmouse.met;

				//######################################### do a validity check on the stroke
				if(evmouse.mez>0 && evmouse.mdt>1000 && evmouse.mcnt>1)
				{
				//	// point came very late and we should really finish this off and inform the target they are done
				//	// i should really handle this BEFORE appending the new point on, but
				//	
				//	liqtilehot=NULL;
				//	liqtilesel=NULL;
				//	
				//	// once done, rollback
				//	evmouse.mcnt=0;
				//	goto mouseretry;
				}
					
					
					
				//app_log("delta test: %i,%i,%i",evmouse.mcnt,evmouse.mdx,evmouse.mdy);
					

				
				//##################################################### get the hot selection
				if( evmouse.mcnt==1 )
				{
					// because we are starting a stroke, we need to know our target
					liqtilehot=liqtile_findhit(self,ev.mouse.x,ev.mouse.y);
					if(liqtilehot)
					{
						//app_log("mouse down sel hit %s",liqtilehot->key);
					}
					
					liqtilesel=liqtilehot;
					// walk to first actual active region
					while(liqtilehot)
					{
						//app_log("mouse step backwards %s",liqtilehot->key);
						if(liqtilehot->handlermouse) break;
						liqtilehot=liqtilehot->linkparent;
					}
					
					if(liqtilehot)
					{
						//app_log("mouse down sel use %s",liqtilehot->key);
					}
					else
					{
						//app_log("mouse down sel use NONE");
					}
				}
				//##################################################### fire the event

				if(liqtilehot)
				{
					if(liqtilehot->handlermouse)
					{
						liqtilehot->kineticx = 0;
						liqtilehot->kineticy = 0;
						//app_log("handling mouse %s %i,%i",liqtilehot->key,ev.mouse.x,ev.mouse.y);
						
						//refreshinprogress=0;	// clear the inprogress flag before calling out
						liqtilehot->handlermouse(liqtilehot,&evmouse);
					}
				}
				
				//##################################################### finally, free the contents if we are done
				
				if( evmouse.mez==0 )
				{

					// give the opportunity to raise a click event.
					int sl;
					
					// we must identify if we are ina scrolling region or a normal flat area
					liqtile *p=liqtilesel;
					int inscroll=0;
					while(p)
					{
						if(p->crw || p->crh)
						{
							inscroll=1;
							break;
						}
						p=p->linkparent;
					}
					
					if(inscroll)
					{
						// inside scroll region, make the selection a bit tighter
						sl=stroke_totallength(evmouse.hand);
					}
					else
					{
						// not in a scroll user should accept any click inside entire area
						sl=0;
					}
					if(sl<24)
					{
						// small motion, actually a click
						// lets just confirm we are still inside the original selection
						liqtile *final=liqtile_findhit(self,ev.mouse.x,ev.mouse.y);
						if(final && final==liqtilesel)
						{
							//app_log("base Mouse Click hot: %s",liqtilehot->key);
							
							
							liqtile *host = liqtilesel;
							while(host && !host->handlerclick)
							{
								host=host->linkparent;
							}
							
							
							
							if(host && host->handlerclick)
							{
								app_log("base Mouse Click sel: %s, host %s",liqtilesel->key,host->key);
								int res=host->handlerclick(host);
								if(res)
								{
									running=0;
									result=res;
									break;
								}
							}
						}
					}
					else //if( (evmouse.mdx || evmouse.mdy) )
					{
						// apply kinetic to the tile we gave the mouse event to
						if(liqtilehot && liqtilehot->handlermouse && liqtilehot->handlerpaint)
						{
							// rebuild the last known delta (backwards through the stroke)
							int dx=0;
							int dy=0;
							POINT *p = evmouse.hand->pointlast;
							POINT *q;
							if(p)
							{
								q=p->linkprev;
								while(q)
								{
									dx=q->x-p->x;
									dy=q->y-p->y;
									if(dx || dy)break;
									q=q->linkprev;
								}
							}
							if(dx||dy)
							{
								//app_log("setting kinetic: %s,%i,%i",liqtilehot->key,evmouse.mdx,evmouse.mdy);
								liqtilehot->kineticx = dx;
								liqtilehot->kineticy = dy;
							}
						}
					}


					evmouse.mcnt=0;
					liqtilehot=NULL;
					liqtilesel=NULL;
				}
				
				if(mouseterminatorinprogress)
				{
					mouseterminatorinprogress=0;
					evmouse.mcnt=0;
					goto mouserestart;
				}
			
				//#####################################################
				// should a mouse event clear the refreshinprogress thingy?
				// testing now, i should wait really but menus are leaving this 
				//refreshinprogress=0;
				// no, it flickers occasionally.
				// however I must find a solution, perhaps having the refresh expire?
				// stop waiting for it if it has been in effect for X s?
				// should prevent the problem without flickering
				// todo: replace refreshinprogress=1 to the timer value, then check if its expired
				
				
				
				hadmouse=1;
				dirty=1;
			}
			else if(ev.type == LIQEVENT_TYPE_EXPOSE)
			{
				// ok, we want to be exposed
				refreshinprogress=0;
				
				
				wantwait=1;
				dirty=1;
				break;
			}			
			else if(ev.type == LIQEVENT_TYPE_REFRESHED)
			{
				// ok, we have finished the refresh
				refreshinprogress=0;
				
				
				wantwait=1;
				break;
			}
			
			else if(ev.type == LIQEVENT_TYPE_NONE)
			{
				// just move on
				//refreshinprogress=0;
				wantwait=1;
				break;
			}
			else if(ev.type == LIQEVENT_TYPE_UNKNOWN)
			{
				running=0;
				break;
			}
			else
			{
				if(self->handlerevent)
				{
					//
					int res=self->handlerevent(self,&ev);
					if(res)
					{
						running=0;
						result=res;
						break;
					}

					dirty=1;



				}
			}
		}
		if(arg_mode_fastrefresh && *arg_mode_fastrefresh)
		{
			dirty=1;
		}
		
		if(fadein_inprogress)
		{
			// we need to know where we are meant to be
			
			unsigned long now=app_GetTicks();
			float secondssincestart=(float)(now-tzs) / 1000.0;
			
			if(secondssincestart<0) secondssincestart=1;
			
			//if(secondssincestart<=0.1)
			//	fadein_offset=canvas.pixelwidth - (int)(secondssincestart*10 * (float)canvas.pixelwidth);
			
			if(secondssincestart<0.25)
				fadein_offset=canvas.pixelwidth - (int)(secondssincestart*4 * (float)canvas.pixelwidth);
			else
			{
				fadein_offset=0;
				fadein_inprogress=0;
			}
			dirty=1;
			
			//app_log("progress %i %i %2.5f",tzs,now,progress);
			
			//fadein_offset=;
		}
		
		
		//extern void liqtile_print2(liqtile *self);
		if(refreshinprogress==0 && self->visible==0)break;
		
		if(running==0) break;
		if(((dirty==1) && (refreshinprogress==0)))
		{
		
		
				//	app_log("rendering");
			
			if(self->handlerpaint)
			{

				liqtileeventpaint evpaint;
				evpaint.surface=canvas.surface;
				evpaint.cr=canvas.cr;
				evpaint.ox=fadein_offset;
				evpaint.oy=0;
				self->handlerpaint(self,&evpaint);
			}
			else
			{
				//canvas_clear(0);
				liqtile_rendertocanvas(self,fadein_offset,0,NULL);
			}
		/*	if(arg_mode_fastrefresh && *arg_mode_fastrefresh)
			{
				char buff[255];
					snprintf(buff,255,"fc %i   %2.5f,  %2.5f",framecount,app_fps(tz0,tz1,1),app_fps(tzs,tz0,framecount));
					
					int ww=liqfont_textwidth(canvas.font,buff);
					canvas_drawrect(0,0,ww,canvas.font->glyphmaxh,0);
					canvas_drawtext(0,0,buff);
			}
		*/
			
			canvas_refreshdisplay();
			
			framecount++;
			
			refreshinprogress=1;
			refreshstarttime=app_GetTicks();
			
			dirty=0;
			wantwait=1;
			tz0=tz1;
			tz1=app_GetTicks();
		}
		if(refreshinprogress)
		{
			if( (app_GetTicks()-refreshstarttime) > 1000)
			{
				// we have been waiting to refresh for ages now, we should stop trying
				// most likely because we went to another screen and it ate our event
				refreshinprogress=0;
				wantwait=0;
				dirty=1;
			}
		}
		if(wantwait || refreshinprogress)
		{
			

			
			wantwait=0;
			if(arg_mode_fastrefresh && *arg_mode_fastrefresh)
			{
				// we have been passed a fast refresh param, and its set to true
			}
			else
			{
				if(fadein_inprogress)
				{
					//..
				}
				else
				{
					goto waitevent;
				}
			}
		}
	}
	
	
	app_log("liqtile easyrun complete %i",result);
	
	return result;
}

