/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Header for tile routines
 *
 */


#ifndef LIQTILE_H
#define LIQTILE_H

#include "liqcanvas.h"
#include "liqdraw.h"
#include "liqfont.h"
#include "liqimage.h"
#include "liqcliprect.h"

#define mk_fourcc(fourcc_conststr)  (*(unsigned int*)(fourcc_conststr))



typedef struct liqstyle
{
	// standard styling info, may be upgraded
	char           stylekey[20];	//
	//############ style information, should be a pointer...
	int            backmode; // 0=none, 1=solid 2=grid 3=colorcube
	unsigned int   backcolor; //packed yuv
	liqimage *     backimage;
	PAGE          *backpage;

	int            bordermode;
	unsigned int   bordercolor; //packed yuv
	unsigned int   borderwidth;
	
	int            textmode;
	unsigned int   textcolor; //packed yuv - ignored for now
	//char *         textfontname;
	//int            textfontsize;
	int            textalignx;		// -1,0,1
	LIQFONT        *textfont;		// initialize if required first time :)
} liqstyle;


liqstyle *liqstyle_create();
liqstyle *liqstyle_create_key(char *key);
void liqstyle_close(liqstyle *self);

void liqstyle_setbackcoloryuv(liqstyle *self,char y,char u,char v);
void liqstyle_getbackcoloryuv(liqstyle *self,char *y,char *u,char *v);

void liqstyle_setbordercoloryuv(liqstyle *self,char y,char u,char v);
void liqstyle_getbordercoloryuv(liqstyle *self,char *y,char *u,char *v);

typedef struct liqtileeventpaint
{
	// the event context passed to objects per paint event

	STROKE  *hand;
	
	void        *surface;
	cliprect    *cr;
	int         ox;
	int         oy;

}
	liqtileeventpaint;


typedef struct liqtileeventmouse
{
	// the event context passed to objects per stroke
	// privately constructed and managed for you
	// to use in a floating section, just adjust by the deltas
	
	STROKE  *hand;

	int mcnt;		// count of items

	int msx;		// start item
	int msy;
	int msz;
	int mst;
	
	int mex;		// end item
	int mey;
	int mez;
	int met;
	
	int mdx;		// item deltas since last invocation
	int mdy;
	int mdz;
	int mdt;
}
	liqtileeventmouse;



typedef struct liqtileviewport
{
	//############ now define the client viewport requirements.  initialized by layout routines
	//             again, not sure why this couldnt be linked?

	int 		 crw;	// client required size - total required dimensions in client coordinates
	int 		 crh;

	int 		 cvw;	// client view size - how much is visible
	int 		 cvh;
	
	int 		 cox;	// client view offset - offset into the client area
	int 		 coy;
	
	void 		 *data;	// data to actually view inside
}
	liqtileviewport;




typedef struct liqtile 
{
	
	//############ required for tree handling
	
	struct liqtile *linkparent;
	struct liqtile *linkprev;
	struct liqtile *linknext;
	struct liqtile *linkchild;
	int childcount;
	
	struct PAGE *linkpage;		// this is special, it will be automatically be released with _free() afterwards, do not do anything yourself
		
	//############ Cater for the base frame
	
	int 		 sx;		// BOUND actual start/end for the frame, these may be negative and indicate the actual stroke used to create the frame
	int 		 sy;
	int 		 ex;
	int 		 ey;

	int 		 x;		// POS   actual legal positions obtained from the stroke above
	int 		 y;
	int 		 w;
	int 		 h;

	//############ now define the client viewport requirements.  initialized by layout routines
	//             again, not sure why this couldnt be linked?


	//liqtilevp 	 *viewport;		// if null, no sub viewport is in use and the entire tile is expected to fit

	int 		 crw;	// client required size - total required dimensions in client coordinates
	int 		 crh;

	int 		 cvw;	// client view size - how much is visible
	int 		 cvh;
	
	int 		 cox;	// client view offset - offset into the client area
	int 		 coy;
	
	
	short 		 kineticx;		// these will be set by the easyrun system, ONLY if the tile has Mouse and Paint handlers 
	short 		 kineticy;
	
	//############ layout props, not sure if these need to be here, or linked..


	//liqtilelayout *layout;		// if used specifies viable layout ranges for this tile.
	
	//int 		 layoutminw;  		// amount of stretch available for layout purposes.  the control requires its base size
	//int 		 layoutminh;		// however in environments where additional space is available this determines how much
	
	int 		 layoutstretchw;  	// amount of stretch available for layout purposes.  the control requires its base size
	int 		 layoutstretchh;	// however in environments where additional space is available this determines how much
	
	//############ 
	int 		 layoutmode;		// 0 no-op, 1 horiz row, 2 vert column
	int 		 overlapx;  // results of the overlap calculation, if these are none zero then the frame should adjust itself
	int 		 overlapy;
	
	liqstyle *	 style;

	int 		 visible;
	int 		 enabled;
	int 		 selected;
	int          priority;		// importance level of this tile    layout rules note: highest priority information is bigger
	
	
	char *       key;			// key
	char *       title;			// user
	char *       description;	// user
	void *       data;			// instance data special class specific data.  Might be a Page or an Image or another Tile
	unsigned int dataclass4cc;	// class of the data.  0==no special class, anything else requires disposal using the handlerclose
	
	unsigned int tag;			// entirely yours, I will not manage it for you.


	//############ 
	//int (*handlerrefresh)(struct liqtile *self,liqtileeventrefresh *args);
	//int (*handlerlayout)(struct liqtile *self,liqtileeventlayout *args);
	int (*handlermouse)(struct liqtile *self,liqtileeventmouse *args);		// merge this into "event" grab current mouse and keyboard
	//int (*handlerkey)(struct liqtile *self,liqtileeventkey *args);
	int (*handlerpaint)(struct liqtile *self,liqtileeventpaint *args);
	int (*handlerlazyload)(struct liqtile *self);		// this is used to upgrade your data to the next level :)
	int (*handlerclose)(struct liqtile *self);			// this is used to release the data upon closure.

	//int (*handlerkinetic)(struct liqtile *self,liqtileeventmouse *args);			// this is used to start a kinetic fling

	int (*handlerclick)(struct liqtile *self);			// Click!
	
	int (*handlerevent)(struct liqtile *self,LIQEVENT *ev);
	
	//unsigned int class4cc;		// class
	//char *       icon;	        // user

	
	// A tile has dimensions
	
	//   FFFFFFFFFFFFF
	//   FFFFFFFFFFFFF
	//   FFFFFFFFFFFFF
	//   FFFFFFFFFFFFF
	//   FFFFFFFFFFFFF
	//   FFFFFFFFFFFFF
	//   FFFFFFFFFFFFF
	
	// it has a border with an inner area.  note: Make borders out of other Tile objects
	// in reality, there is no border, however this is cleaner to show
	
	//   BBBBBBBBBBBBB
	//   BIIIIIIIIIIIB
	//   BIIIIIIIIIIIB
	//   BIIIIIIIIIIIB
	//   BIIIIIIIIIIIB
	//   BIIIIIIIIIIIB
	//   BBBBBBBBBBBBB
	
	// the inner area may represent content larger than itself
		
	//   CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
	//   CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
	//   CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
	//   CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
	//   CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
	//   CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
	//   CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
	//   CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
	
	
	// The content can be scaled to fit (optionally maintaining aspect ratio)
	
	//   BBBBBBBBBBBBB
	//   B           B
	//   BCCCCCCCCCCCB
	//   BCCCCCCCCCCCB
	//   BCCCCCCCCCCCB
	//   B           B
	//   BBBBBBBBBBBBB	

	
} liqtile;
	
	

//##################################################################

liqtile *	liqtile_create();
//##################################################################
liqtile *	liqtile_createquick(char *key,int x,int y,int w,int h);

//##################################################################

liqtile *	liqtile_lastchild(liqtile *self);

//##################################################################

liqtile* 		liqtile_childinsert(liqtile *self,liqtile *c);
liqtile* 		liqtile_childappend(liqtile *self,liqtile *c);
liqtile* 		liqtile_childinsertsorted(liqtile *self,liqtile * ch);
liqtile* 		liqtile_childinsertsortedbykey(liqtile *self,liqtile * ch,int sortpositive);
liqtile* 		liqtile_childinsertsortedbytitle(liqtile *self,liqtile * ch,int sortpositive);
liqtile*    liqtile_childfindkey(liqtile *self,char *key);
liqtile*    liqtile_childfindorcreatekey(liqtile *self,char *key);
int 		liqtile_childarrange_row(liqtile *self);
int 		liqtile_childarrange_col(liqtile *self);



PAGE * liqtile_pageautoloadbytitle(liqtile *self,char *basepath);



//##################################################################
void 		liqtile_close(liqtile *self);

//##################################################################
int 		liqtile_fullyqualifiedtitle(liqtile *self,char *buffer, int bufferlen);
int 		liqtile_fullyqualifiedkey(liqtile *self,char *buffer, int bufferlen);

//##################################################################
void 		liqtile_titlechange(liqtile *self,char *newtitle);
void 		liqtile_keychange(liqtile *self,char *newkey);


//##################################################################
void 		liqtile_update_posfrombound(liqtile *self);

//##################################################################
void 		liqtile_update_boundfrompos(liqtile *self);

//##################################################################
void 		liqtile_bound_ensurepositive(liqtile *self);
void 		liqtile_print(liqtile *self,char *reason);

//##################################################################
void 		liqtile_editstart(liqtile *self,int x,int y);
void 		liqtile_editexpand(liqtile *self,int x,int y);
void 		liqtile_editcomplete(liqtile *self);

//##################################################################
void 		liqtile_forceinbound(liqtile *self,int bsx,int bsy,int bex,int bey);
void 		liqtile_forceinboundparent(liqtile *self);

void 		liqtile_resizetofitcontent(liqtile *self);
void 		liqtile_resizetofactor(liqtile *self,int fromfw,int fromfh,int tofw,int tofh);
//##################################################################
int 		liqtile_getsurfacearea_p2(liqtile *self);

//##################################################################
void 		liqtile_autoresizecontents(liqtile *self,liqtile *selection);
void 		liqtile_overlapcalc(liqtile *self,liqtile *selection);

int 		liqtile_gethit(liqtile *self,int x,int y,int *hitx,int *hity);

int 		liqtile_floatprepare(liqtile *self);
int 		liqtile_floatensurebounded(liqtile *self);

void 		liqtile_getabsoluteoffset(liqtile *self,int *ox,int *oy);


//##################################################################
//##################################################################
//##################################################################
int 		liqtile_layout(struct liqtile *self,int availw,int availh);
void        liqtile_rendertocanvascr(liqtile *self,int ox,int oy,liqtile *selection,struct cliprect *cr);
void 		liqtile_rendertocanvas(liqtile *self,int ox,int oy,liqtile *selection);
int 		liqtile_neatarrange(liqtile *self);
int         liqtile_neatarrange_autofit(liqtile *self);
int 	 	liqtile_neatarrange_autofit_factor(liqtile *self,float factor);

liqtile * 	liqtile_findhit(liqtile *self,int x,int y);

liqstyle *  liqtile_stylelookup(struct liqtile *self);


void 		liqstyle_renderdefault(liqstyle *self,cliprect *cr,int x,int y,int w,int h,liqtile *tile);
int 		liqtile_easyrun(liqtile *self);
int 		liqtile_easyrun2(liqtile *self,int *arg_mode_fastrefresh);


#endif
