/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

//mon10 tuesda wedne thursd friday saturda sunday

/*
 *
 * tile management
 *
 */




#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <strings.h>

#include "liqapp.h"
#include "liqbook.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "liqdraw.h"

#include "liqtile.h"
#include "liqcliprect.h"

#define ABS(X) ((X)>=0?(X):-(X))

//##################################################################
//################################################################## dimension base
//##################################################################
// dimension isnt really a class, its just a span of Start..End and handling of it
//#####################################################################
static inline void dimension_forceinbound(register int *s,register int *e,register int l,register int r)
{
	register int d=*e-*s;
	register int w=r-l;
	register int isneg=0;
	if(d<0  ){register int t=*s;*s=*e;*e=t;d=-d;isneg=1;}
	if(d>w  ){*e-=d-w;        }
	if(*s<l ){*e+=l-*s;*s=l;  }
	if(*e>=r){*s-=*e-(r);*e=r;  }
	if(isneg){register int t=*s;*s=*e;*e=t;d=-d;}
}

//#####################################################################
static inline int dimension_overlapcalc(register int cs,register int ce,register int ds,register int de,int *overlapres)
{
	// single dimension quick calc
	if(ce < ds) return -2;		//  CCC    DDDDDD
	if(ce == ds) return -1;		//  CCCDDDDDD
	if(de < cs) return 2;		//  DDDDDD    CCC
	if(de == cs) return 1;		//  DDDDDDCCC
	if(cs <= ds)
	{
		// C starts before D starts
		if( ce <= de )	
		{
			// a partial overlap exists
			*overlapres = (ds-ce);
			return 0;
		}
		// D is smaller than us
		// we are wholey engulfing D
		// GET IT OUT OF ME!
		// we take the shortest route out.
		if( (ce-de) < (ds-cs) )
		{
			// D is closer to the right hand side of C
			*overlapres = (ds-ce);
			return 0;
		}
		else
		{
			// D is closer to the left hand side of C
			// this should be negative
			*overlapres = (cs-de);
			return 0;
		}
	}
	else
	{
		// D starts before C starts
		if( de <= ce )	
		{
			// a partial overlap exists
			*overlapres = -(cs-de);
			return 0;
		}
		// D is smaller than us
		// we are wholey engulfing D
		// GET IT OUT OF ME!
		// we take the shortest route out.
		if( (de-ce) < (cs-ds) )
		{
			// D is closer to the right hand side of C
			*overlapres = -(cs-de);
			return 0;
		}
		else
		{
			// D is closer to the left hand side of C
			// this should be negative
			*overlapres = -(ds-ce);
			return 0;
		}
	}
}





//##################################################################
//################################################################## liqstyle base
//##################################################################

//##################################################################

liqstyle *liqstyle_create()
{
	liqstyle *self = (liqstyle *)malloc(sizeof(liqstyle));
	if(self==NULL) {  app_errorandfail(-1, "liqstyle creation failed" ); return NULL; }
	// NULL everything, should do calloc really..
	memset((char *)self,0,sizeof(liqstyle));
	return self;
}

liqstyle *liqstyle_create_key(char *key)
{
	liqstyle *self = liqstyle_create();
	if(self==NULL) {  app_errorandfail(-1, "liqstyle creation failed" ); return NULL; }
	
	if(key && *key)
		strncpy(self->stylekey,key,20);
	self->stylekey[20-1]=0;	
	return self;
}
//##################################################################

void liqstyle_close(liqstyle *self)
{

	//if(self->backimage){ free(self->backimage); self->backimage=NULL; }
	//if(self->textfontname){ free(self->textfontname); self->textfontname=NULL; }
	//if(self->textfont){ liqfont_close(self->textfont); self->textfont=NULL; }

	free((char *)self);
}


//##################################################################


void liqstyle_setbackcoloryuv(liqstyle *self,char y,char u,char v)
{
		char *packyuv = (char *)&self->backcolor;
		packyuv[0]=y;
		packyuv[1]=u;
		packyuv[2]=v;	
}
void liqstyle_getbackcoloryuv(liqstyle *self,char *y,char *u,char *v)
{
		char *packyuv = (char *)&self->backcolor;
		*y=packyuv[0];
		*u=packyuv[1];
		*v=packyuv[2];
}


void liqstyle_setbordercoloryuv(liqstyle *self,char y,char u,char v)
{
		char *packyuv = (char *)&self->bordercolor;
		packyuv[0]=y;
		packyuv[1]=u;
		packyuv[2]=v;	
}
void liqstyle_getbordercoloryuv(liqstyle *self,char *y,char *u,char *v)
{
		char *packyuv = (char *)&self->bordercolor;
		*y=packyuv[0];
		*u=packyuv[1];
		*v=packyuv[2];
}


















//##################################################################
//################################################################## liqtile base
//##################################################################

//##################################################################

liqtile *liqtile_create()
{
	liqtile *self = (liqtile *)malloc(sizeof(liqtile));
	if(self==NULL) {  app_errorandfail(-1, "liqtile creation failed" ); return NULL; }
	// NULL everything
	memset((char *)self,0,sizeof(liqtile));
	self->visible=1;
	self->enabled=1;
	return self;
}
//##################################################################

liqtile *liqtile_lastchild(liqtile *self)
{
	if(self->linkchild==NULL)return NULL;
	liqtile *sa=self->linkchild;
	while(sa)
	{
		if(sa->linknext==NULL) return sa;
		sa=sa->linknext;
	}
	return NULL;
}

//##################################################################

liqtile* liqtile_childinsert(liqtile *self,liqtile *c)
{
	if(!c)return NULL;
	c->linkparent=self;
	c->linkprev=NULL; // we are at the start
	c->linknext=self->linkchild;
	self->linkchild = c;
	self->childcount++;
	return c;
}

liqtile* liqtile_childappend(liqtile *self,liqtile *c)
{
	if(!c)return NULL;
	liqtile *sa=liqtile_lastchild(self);
	if(sa==NULL)
	{
		liqtile_childinsert(self,c);
		return c;
	}
	c->linkparent=self;
	c->linkprev=sa;
	c->linknext=NULL;	// we are at the end
	sa->linknext=c;
	self->childcount++;
	return c;
}

liqtile* liqtile_childinsertsorted(liqtile *self,liqtile * ch)
{
	if(!ch)return NULL;
	// insert sorted
	if(!self->linkchild || !ch->key) // filename)
	{
		// first child or no key to sort on
		liqtile_childappend(self,ch);
		return ch;// ch;
	}
	else
	{
		liqtile *sa=ch;
		liqtile *xx=self->linkchild;
		while(xx)
		{
			if(xx->key && strcmp(sa->key,xx->key)< 0)
			{
				// insert it here...
				if(xx==self->linkchild)
				{
					// first child
					self->linkchild = sa;
					sa->linkparent = self;
					sa->linkprev = xx->linkprev;
					sa->linknext = xx;
					xx->linkprev = sa;
					self->childcount++;
					return sa;// sa;
				}
				else
				{
					// in the middle
					liqtile *yy=xx->linkprev;
					sa->linkparent = self;
					sa->linkprev = yy;
					sa->linknext = xx;
					yy->linknext = sa;
					xx->linkprev = sa;
					self->childcount++;
					return sa;// sa;
				}
			}
			xx=xx->linknext;
		}
		liqtile_childappend(self,ch);
		return ch;// ch;
	}
	return ch;// ch;
}

liqtile* liqtile_childinsertsortedbykey(liqtile *self,liqtile * ch,int sortpositive)
{
	if(!ch)return NULL;
	// insert sorted
	if(!self->linkchild || !ch->key) // filename)
	{
		// first child or no key to sort on
		liqtile_childappend(self,ch);
		return ch;
	}
	else
	{
		liqtile *sa=ch;
		liqtile *xx=self->linkchild;
		while(xx)
		{
			if(xx->key)
			{
				int res=strcmp(sa->key,xx->key);
				if(!sortpositive)res=-res;
				if(res < 0)
				{
					// insert it here...
					if(xx==self->linkchild)
					{
						// first child
						self->linkchild = sa;
						sa->linkparent = self;
						sa->linkprev = xx->linkprev;
						sa->linknext = xx;
						xx->linkprev = sa;
						self->childcount++;
						return sa;
					}
					else
					{
						// in the middle
						liqtile *yy=xx->linkprev;
						sa->linkparent = self;
						sa->linkprev = yy;
						sa->linknext = xx;
						yy->linknext = sa;
						xx->linkprev = sa;
						self->childcount++;
						return sa;
					}
				}
			}
			xx=xx->linknext;
		}
		liqtile_childappend(self,ch);
		return ch;
	}
	return ch;
}

liqtile* liqtile_childinsertsortedbytitle(liqtile *self,liqtile * ch,int sortpositive)
{
	if(!ch)return NULL;
	// insert sorted
	if(!self->linkchild || !ch->title) // filename)
	{
		// first child or no key to sort on
		liqtile_childappend(self,ch);
		return ch;
	}
	else
	{
		liqtile *sa=ch;
		liqtile *xx=self->linkchild;
		while(xx)
		{
			if(xx->title)
			{
				int res=strcmp(sa->title,xx->title);
				if(!sortpositive)res=-res;
				if(res < 0)
				{
					// insert it here...
					if(xx==self->linkchild)
					{
						// first child
						self->linkchild = sa;
						sa->linkparent = self;
						sa->linkprev = xx->linkprev;
						sa->linknext = xx;
						xx->linkprev = sa;
						self->childcount++;
						return sa;
					}
					else
					{
						// in the middle
						liqtile *yy=xx->linkprev;
						sa->linkparent = self;
						sa->linkprev = yy;
						sa->linknext = xx;
						yy->linknext = sa;
						xx->linkprev = sa;
						self->childcount++;
						return sa;
					}
				}
			}
			xx=xx->linknext;
		}			
		liqtile_childappend(self,ch);
		return ch;
	}
	return ch;
}



liqtile* liqtile_childfindkey(liqtile *self,char *key)
{
	if(!self->linkchild || !key)
	{
		// no children or no key to sort on
		return NULL;
	}
	
	char *dot=strchr(key,'.');
	if(dot)
	{
		liqtile *xx=self->linkchild;
		while(xx)
		{
			//strncasecmp
			//strncmp
			
			if(xx->key && (strncasecmp(key,xx->key,dot-key) == 0))
			{
				// we have a PARTIAL match, the operator need never know about this
				// its not worth their time yet (ill add another fn later)
				return liqtile_childfindkey(xx,dot+1);
			}
			xx=xx->linknext;
		}
		return NULL;
	}
	
	

	liqtile *xx=self->linkchild;
	while(xx)
	{
		//strcasecmp
		//strcmp
		
		if(xx->key && (strcasecmp(key,xx->key) == 0))
		{
			return xx;
		}
		xx=xx->linknext;
	}
	return NULL;

}


liqtile* liqtile_childfindorcreatekey(liqtile *self,char *key)
{
	if((!key) || (!*key))
	{
		// no key to sort on
		return NULL;
	}
	
	
	char *dot=strchr(key,'.');
	if(dot)
	{
		*dot=0;
		liqtile *xx=self->linkchild;
		while(xx)
		{
			//strncasecmp
			//strncmp
			
			if(xx->key && (strcasecmp(key,xx->key) == 0))
			{
				// restore the dot
				*dot='.';
				// we have a PARTIAL match from key to dot, the operator need never know about this
				// its not worth their time yet (ill add another fn later)
				return liqtile_childfindorcreatekey(xx,dot+1);
			}
			xx=xx->linknext;
		}
		// key .. dot is the actual key to create
		xx=liqtile_create();		
		liqtile_keychange(xx,key);
		*dot='.';
		liqtile_childinsertsorted(self, xx);
		return liqtile_childfindorcreatekey(xx,dot+1);
	}
	
	

	liqtile *xx=self->linkchild;
	while(xx)
	{
		//strcasecmp
		//strcmp
		
		if(xx->key && (strcasecmp(key,xx->key) == 0))
		{
			return xx;
		}
		xx=xx->linknext;
	}
	// no match just make it
	xx=liqtile_create();		
	liqtile_keychange(xx,key);
	liqtile_childinsertsorted(self, xx);
	return xx;

//	return NULL;

}



int liqtile_childarrange_row(liqtile *self)
{
	int tw=0;								// should we start with self->layout.borderxhead ?
	int mh=0;
	liqtile *sa=self->linkchild;
	while(sa)
	{
		if(sa->visible)
		{
			sa->x=tw;
			sa->y=0;							// should we check sa->layout.float?    0=top  0.5=centre 1=bottom
			liqtile_update_boundfrompos(sa);
			tw+=sa->w;							// should we add self->layout.borderxbetween
			if(sa->h>mh)mh=sa->h;
			sa=sa->linknext;
		}
	}
											// should we add self->layout.borderxtail
	// now fix the size of ch
	self->w=tw;
	self->h=mh;
	liqtile_update_boundfrompos(self);

	return 0;
}

 
int liqtile_childarrange_col(liqtile *self)
{
	int th=0;
	int mw=0;
	liqtile *sa=self->linkchild;
	while(sa)
	{
		if(sa->visible)
		{
			sa->x=0;
			sa->y=th;
			liqtile_update_boundfrompos(sa);
			th+=sa->h;
			if(sa->w>mw)mw=sa->w;
		}
		
		sa=sa->linknext;
	}
	self->w=mw;
	self->h=th+1;
	liqtile_update_boundfrompos(self);
	return 0;

}
//##################################################################

void liqtile_close(liqtile *self)
{
	
	if(self->handlerclose)
	{
		// give the creator a chance to free their private data :)
		self->handlerclose(self);
	}
	
	// unlink from our own chain
	if(self->linkparent)
	{
		if(self == self->linkparent->linkchild)
		{
			self->linkparent->linkchild = self->linknext;
		}
		self->linkparent->childcount--;
	}
	self->linkparent=NULL;
	if(self->linkprev) self->linkprev->linknext = self->linknext;
	if(self->linknext) self->linknext->linkprev = self->linkprev;

	if(self->key){ free(self->key); self->key=NULL; }
	if(self->linkpage){ page_free(self->linkpage); self->linkpage=NULL; }
	if(self->title){ free(self->title); self->title=NULL; }
	if(self->description){ free(self->description); self->description=NULL; }
	//if(self->backimage){ free(self->backimage); self->backimage=NULL; }
	//if(self->textfontname){ free(self->textfontname); self->textfontname=NULL; }
	//if(self->pagefilename) { free(self->pagefilename); self->pagefilename=NULL; }
	//if(self->page){ page_free(self->page); self->page=NULL;}

	// style is closed in its own
	//if(self->style){ liqstyle_close(self->style); self->style=NULL; }


	// destroy our children
	while(self->linkchild)
	{
		liqtile *c = self->linkchild;
		liqtile *n = c->linknext;
		if(n) n->linkprev = NULL;			
		c->linkparent=NULL;
		self->linkchild = n;
		self->childcount--;
		liqtile_close(c);
	}

	free((char *)self);
}











PAGE *page_autoloadbytitle(char *basepath,char *title)
{
	// Initialize the ->page member based upon the title
	// this should not really be used anymore
	// todo: check folder exists
	// todo: check folder contents readable
	if((!title) || (!*title))
	{
		// null or blank, release the page if we have one
		//if(self->pagefilename) { free(self->pagefilename); self->pagefilename=NULL; }
		return NULL; // no title to match
	}
	PAGE *pg=NULL;
	char lookfor[255];
	snprintf(lookfor,255,".page.%s",title);
	//char *dir_name = "/home/user/MyDocs/_apg";
	char *dir_name = basepath;
    DIR           *dir_p;
    struct dirent *dir_entry_p;
    dir_p = opendir(dir_name);
	
	if(!dir_p)
	{
		app_log("opendir failed: '%s'",dir_name);
		return NULL;			// heh thanks kot :)
	}
	
	char filename[1024]="\0";
	while( NULL != (dir_entry_p = readdir(dir_p)))
    {
		// check each file and see if its our pattern
		// yes, shoot me now i need to use "*.page.title" as pattern but im not sure how in linux	
		if(instr(dir_entry_p->d_name, lookfor))
		{
			// now make sure we only select first or the latest one (filenames include datestamp as key),
			// simple to change in future to check actual dates
			if(filename[0]==0 || strcmp(filename,dir_entry_p->d_name)<0)
			{
				strncpy(filename,dir_entry_p->d_name,1024);
			}
		}
    }
    closedir(dir_p);
	//if(self->pagefilename) { free(self->pagefilename); self->pagefilename=NULL; }

	if(filename[0])
	{
		// we matched the suffix
		// obtain the full name including path
		char fn[1024];
		snprintf(fn,1024,"%s/%s", dir_name,filename);
		pg=page_alloc();
		if(pg)
		{
			if(page_fileload(pg,fn)==0)
			{
				// we have a valid page for this title
				// lets store the information and continue
				//self->pagefilename = strdup(fn);
				return pg;
			}
			page_free(pg);
			pg=NULL;
			return NULL;	// filename found, but it was invalid
		}
		
		return NULL;	// hmmm page failed
	}
	
	return NULL; // no match
}



PAGE * liqtile_pageautoloadbytitle(liqtile *self,char *basepath)
{
	if(self->linkpage){ page_free(self->linkpage); self->linkpage=NULL; }
	if(self->title && *self->title)
	{
		char *dup=strdup(self->title);
		if(dup)
		{
			app_ensurecleanusername(dup);
			self->linkpage = page_autoloadbytitle(basepath,dup);
			free(dup);
		}
	}
	return self->linkpage;
}











































void liqtile_titlechange(liqtile *self,char *newtitle)
{
	if(self->title){ free(self->title); self->title=NULL; }

	if((!newtitle) || (*newtitle==0))
	{
		// null or blank
		return;
	}
	self->title = strdup(newtitle);
}


void liqtile_keychange(liqtile *self,char *newkey)
{
	if(self->key){ free(self->key); self->key=NULL; }

	if((!newkey) || (*newkey==0))
	{
		// null or blank
		return;
	}
	self->key = strdup(newkey);
}

//##################################################################

void liqtile_update_posfrombound(liqtile *self)
{
	if(self->sx<=self->ex) 
							{  self->x=self->sx;  self->w=self->ex-self->sx; }
	else
							{  self->x=self->ex;  self->w=self->sx-self->ex; }

	if(self->sy<=self->ey)	
							{  self->y=self->sy;  self->h=self->ey-self->sy; }
	else
							{  self->y=self->ey;  self->h=self->sy-self->ey; }
}

//##################################################################

void liqtile_update_boundfrompos(liqtile *self)
{
	self->sx=self->x;
	self->sy=self->y;
	self->ex=self->x+self->w;
	self->ey=self->y+self->h;
}

//##################################################################

void liqtile_bound_ensurepositive(liqtile *self)
{
	if(self->sx>self->ex) {int t=self->sx;self->sx=self->ex;self->ex=t;}
	if(self->sy>self->ey) {int t=self->sy;self->sy=self->ey;self->ey=t;}
}

void liqtile_print(liqtile *self,char *reason)
{
	app_log("tile %s(%i,%i)-step(%i,%i),, B       (%i,%i)-(%i,%i)", reason,
				self->x ,self->y ,self->w ,self->h ,
				self->sx,self->sy,self->ex,self->ey);

}

void liqtile_print2(liqtile *self)
{

	char buf[1024]="\0";
	liqtile_fullyqualifiedkey(self,buf,1024);
	app_log("tile: %i,'%s': '%s' (%i,%i)",self->childcount,buf,(self->title?self->title:""),self->w,self->h);//,sa->pagefilename);
			
			
			
	liqtile *xx=self->linkchild;
	while(xx)
	{
		liqtile_print2(xx);
		xx=xx->linknext;
	}
}

//##################################################################

void liqtile_editstart(liqtile *self,int x,int y)
{
	self->sx=x;
	self->sy=y;
	self->ex=x;
	self->ey=y;
	liqtile_update_posfrombound(self);
}

//##################################################################

void liqtile_editexpand(liqtile *self,int x,int y)
{
	self->ex=x;
	self->ey=y;
	liqtile_update_posfrombound(self);
}

//##################################################################

void liqtile_editcomplete(liqtile *self)
{
	liqtile_bound_ensurepositive(self);
	liqtile_update_posfrombound(self);
}

//##################################################################

void liqtile_forceinbound(liqtile *self,int bsx,int bsy,int bex,int bey)
{
	dimension_forceinbound(&self->sx,&self->ex,bsx,bex);
	dimension_forceinbound(&self->sy,&self->ey,bsy,bey);
	liqtile_update_posfrombound(self);
}

void liqtile_forceinboundparent(liqtile *self)
{
	liqtile *par=self->linkparent;
	if(par)
	{
		//dimension_forceinbound(&self->sx,&self->ex,par->sx,par->ex);
		//dimension_forceinbound(&self->sy,&self->ey,par->sy,par->ey);
		dimension_forceinbound(&self->sx,&self->ex,0,par->w);
		dimension_forceinbound(&self->sy,&self->ey,0,par->h);
	}
	liqtile_update_posfrombound(self);	
}

//##################################################################

liqtile *liqtile_createquick(char *key,int x,int y,int w,int h)
{
	liqtile *self = liqtile_create();
	self->x=x;
	self->y=y;
	self->w=w;
	self->h=h;
	
	if(w==0 && h==0)self->visible=0;

	liqtile_update_boundfrompos(self);
	liqtile_forceinboundparent(self);

	liqtile_titlechange(self,key);	// ;)
	liqtile_keychange(self,key);

	
	
	return self;
}

int liqtile_fullyqualifiedtitle(liqtile *self,char *buffer, int bufferlen)
{
int pl=0;
char *part = self->title;
	if(!part)part="[null]";
	if(self->linkparent)
	{
		pl = liqtile_fullyqualifiedtitle(self->linkparent,buffer,bufferlen);
		if(pl<0) return -1;
		bufferlen-=pl;
		buffer+=pl;
		if(bufferlen==0) return pl;
		int a=snprintf(buffer,bufferlen,".%s",part);
		if(a<0) return -1;
		pl+=a;
		return pl;
	}
	int a=snprintf(buffer,bufferlen,"%s",part);
	if(a<0) return -1;
	return a;
}

int liqtile_fullyqualifiedkey(liqtile *self,char *buffer, int bufferlen)
{
int pl=0;
char *part = self->key;
	if(!part)part="[null]";
	if(self->linkparent)
	{
		pl = liqtile_fullyqualifiedkey(self->linkparent,buffer,bufferlen);
		if(pl<0) return -1;
		bufferlen-=pl;
		buffer+=pl;
		if(bufferlen==0) return pl;
		int a=snprintf(buffer,bufferlen,".%s",part);
		if(a<0) return -1;
		pl+=a;
		return pl;
	}
	int a=snprintf(buffer,bufferlen,"%s",part);
	if(a<0) return -1;
	return a;
}

//##################################################################

int liqtile_getsurfacearea_p2(liqtile *self)
{
	int dx=self->w; //self->ex-self->sx;
	int dy=self->h; //self->ey-self->sy;
	return dx*dx+dy*dy;
}

//##################################################################

void liqtile_autoresizecontents(liqtile *self,liqtile *selection)
{
	liqtile *c;
	c=self->linkchild;
	while(c)
	{
		if(c->visible)
		{
			if((c->overlapx) || (c->overlapy))
			{
				if(c==selection)
				{
					if((c->w+4)<canvas.pixelwidth /3) {c->x-=4;c->w+=8;}	// bigger  - not yet, we can sweep a path though
					if((c->h+4)<canvas.pixelheight/3) {c->y-=4;c->h+=8;}
					liqtile_update_boundfrompos(c);
					liqtile_forceinboundparent(c);
				}
				else
				{
					if((c->w>30) && (c->h>30))
					{
						c->x+=1;		// smaller
						c->y+=1;
						c->w-=2;
						c->h-=2;
						liqtile_update_boundfrompos(c);
						liqtile_forceinboundparent(c);
					}
				}
			}
			else
			{
				if(c==selection)
				{
					if((c->w+8)<canvas.pixelwidth /3) {c->x-=4;c->w+=8; }	// bigger
					if((c->h+8)<canvas.pixelheight/3) {c->y-=4;c->h+=8; }
					liqtile_update_boundfrompos(c);
					liqtile_forceinboundparent(c);
				}
			}
		}
		c=c->linknext;
	}
}

void liqtile_overlapcalc(liqtile *self,liqtile *selection)
{
	//if(self->visible==0) return NULL;

	liqtile *c;
	// clear overlap settings for every child
	c=self->linkchild;
	while(c)
	{
		// first clear the overlap for everything
		c->overlapx=0;
		c->overlapy=0;
		c=c->linknext;
	}

	// calculate the overlapping
	c=self->linkchild;
	while(c)
	{
		if(c->visible)
		{
			// now, we do something clever
			liqtile *d=c->linknext;
			while(d)
			{
				if(d->visible)
				{
					// we calculate the overlap between c&d
					int olw=0;
					int olh=0;
					if( dimension_overlapcalc(c->x,c->x+c->w,   d->x,d->x+d->w,   &olw) == 0
					&&	dimension_overlapcalc(c->y,c->y+c->h,   d->y,d->y+d->h,   &olh) == 0
					   )
					{
						if(olw && ABS(olw) < ABS(olh))
						{
							olh=0;
							//olh=(int)((float)olh*0.1);
						}
						if(olh && ABS(olh) < ABS(olw))
						{
							olw=0;
							//olw=(int)((float)olw*0.1);
						}
		
						// we know what the force is going to be and in which direction :)
						//app_log("c %i, d %i",c->ident,d->ident);
						olw/=2;
						olh/=2;
						c->overlapx+=olw;
						c->overlapy+=olh;
						d->overlapx-=olw;
						d->overlapy-=olh;
					}
				}
	
				d=d->linknext;
			}
			// parent boundary adjustment
			if(c->x<0)c->overlapx-=c->x;
			if(c->y<0)c->overlapy-=c->y;
			if(c->x>=self->w)c->overlapx-=c->x-self->w;
			if(c->y>=self->h)c->overlapy-=c->y-self->h;
		}
		c=c->linknext;
	}
	// now i go round and apply that overlap
	c=self->linkchild;
	while(c)
	{
		if(c->visible)
		{
			// first clear the overlap for everything
			if(c!=selection)
			{
				c->x+=c->overlapx;
				c->y+=c->overlapy;
				liqtile_update_boundfrompos(c);
	
				//liqtile_forceinbound(c,0,0,self->w-1,self->h-1);
				liqtile_forceinboundparent(c);
			}
		}
		c=c->linknext;
	}
}

int liqtile_gethit(liqtile *self,int x,int y,int *hitx,int *hity)
{
int ishit=0;
	*hitx=0;
	*hity=0;
	if(!self->visible)return 0;
		 if(x<self->sx)
			{*hitx=-2;          }
	else if(x==self->sx)
			{*hitx=-1;	ishit=1;}
	else if(x==self->ex)
			{*hitx=1;	ishit=1;}
	else if(x>self->ex)
			{*hitx=2;	        }
	else
			{*hitx=0; ishit=1;}

		 if(y<self->sy)
			{*hity=-2;          }
	else if(y==self->sy)
			{*hity=-1; ishit=1;}	
	else if(y==self->ey)
			{*hity=1; ishit=1;}		
	else if(y>self->ey)
			{*hity=2;	      }
	else
			{*hity=0; ishit=1;}	
	if(*hitx==0 && *hity==0)
		ishit=1;
	else
		ishit=0;

	//app_log("%i,%i,%i",*hitx,*hity,ishit);
	return ishit;
}


//#########################################################################



void liqtile_rendertocanvascr(liqtile *self,int ox,int oy,liqtile *selection,struct cliprect *cr)
{
	// check if inside the cliprect
	
	//cliprect_print(cr,self->title);
	if(!self->visible)return;
	if(ox+self->sx > cr->ex) return;
	if(ox+self->ex < cr->sx) return;
	
	//cliprect_print(cr,"stage1");
	   
	if(oy+self->sy > cr->ey) return;
	if(oy+self->ey < cr->sy) return;
	
	// we are at least partially inside the cliprect

	//cliprect_print(cr,"stage2");
	//canvas_drawboxcolor(ox+self->x,oy+self->y,self->w,self->h ,80,80,80);
	
	//######################################### recursive initi the first available style
//liqstyle *style=liqtile_stylelookup(self);



	struct cliprect inside;
		// this cliprect should be ADJUSTED
		cliprect_copy(&inside,cr);
		cliprect_shrink(&inside,ox+self->sx,oy+self->sy,ox+self->ex,oy+self->ey);
	

		if(inside.sx==inside.ex || inside.sy==inside.ey)
		{
			// nothing available to draw..
			return;
		}
	
	// debug boxes :)
	//cliprect_drawboxlinecolor( &inside,    ox+self->x,oy+self->y,self->w,self->h ,80,80,80);
		
		
		
		
	if(self->handlerpaint)
	{
		liqtileeventpaint evpaint;
		evpaint.surface=canvas.surface;
		evpaint.cr=&inside;
		evpaint.ox=ox;
		evpaint.oy=oy;
		//app_log("handle paint %s %i",self->key,(int)self->data);

		self->handlerpaint(self,&evpaint);
		return;
	}
	
	int x=(ox+self->x);
	int y=(oy+self->y);
	int w=(self->w);
	int h=(self->h);
	
	
		if(self->style) liqstyle_renderdefault(self->style,&inside, x,y,w,h, self);

	// draw me
	if(self->linkchild)
	{
		// for now restrict this to specific individual styles
		//if(self->style) liqstyle_renderdefault(self->style,cr, x,y,w,h, self);

		// only when diving in
		liqtile *sa=self->linkchild;
		while(sa)
		{
			liqtile_rendertocanvascr(sa,ox+self->x-self->cox,oy+self->y-self->coy,selection,&inside);
			sa=sa->linknext;
		}
		
	}
	else
	{
		
		
		
		//######################################### make use of the style
		
		
		// this can have recursive styles if it so wishes
		//if(self->style) liqstyle_renderdefault(self->style,cr, x,y,w,h, self);
		
		
		

	}
}

void liqtile_rendertocanvas(liqtile *self,int ox,int oy,liqtile *selection)
{
	// not passed a cliprect in, do we assume the whole screen is available?

struct cliprect cr;
	cliprect_copy(&cr,canvas.cr);	
	cliprect_shrink(&cr,ox+self->sx,oy+self->sy,ox+self->ex,oy+self->ey);
	liqtile_rendertocanvascr(self,ox,oy,selection,&cr);
}

void liqtile_getabsoluteoffset(liqtile *self,int *ox,int *oy)
{
	// find correct absolute offset (later we should account for the cox/y)
	*ox=0;
	*oy=0;
		liqtile *sa=self->linkparent;
		while(sa)
		{
			*ox+=sa->x-sa->cox;
			*oy+=sa->y-sa->coy;
			sa=sa->linkparent;
		}	

}





int liqtile_neatarrange_autofit_factor(liqtile *self,float factor)
{
	// layout the children in a neat grid pattern
	// find out how many children we have that are visible
	int viscount=0;
	liqtile *sa=self->linkchild;
	while(sa)
	{
		if(sa->visible)
		{
			viscount++;
		}
		sa=sa->linknext;
	}
	

	int ccols=1;
	int crows=1;
	
	while(crows*ccols < viscount)
	{
		if(ccols==crows)
		{
			ccols++;
		}
		else
		{
			crows++;
		}
	}
	
	
	//while(ccols<3 && ccols<viscount)ccols++;
	//int crows=viscount/ccols;
	//while(ccols*crows<viscount)crows++;
	
	int tilew =  self->w / ccols;
	int tileh =  self->h / crows;
	if(tilew*ccols>self->w)tilew--;
	if(tileh*crows>self->h)tileh--;
	
	
	int tileiw = ((float)tilew) * factor;
	int tileih = ((float)tileh) * factor;
	
	int x=0;
	int y=0;
	int tx=0;
	int ty=0;
	
	sa=self->linkchild;
	while(sa)
	{
		if(sa->visible)
		{
			sa->x=x + (tilew-tileiw)/2;
			sa->y=y + (tileh-tileih)/2;
			sa->w=tileiw;
			sa->h=tileih;
			liqtile_update_boundfrompos(sa);
			x+=tilew;
			tx++;
			if(tx>=ccols)
			{
				tx=0;
				x=0;
				ty++;
				y+=tileh;
			}
			viscount++;
		}
		sa=sa->linknext;
	}
	return self->h;
}
	
int liqtile_neatarrange_autofit(liqtile *self)
{
	return liqtile_neatarrange_autofit_factor(self,1.0);
}

int liqtile_neatarrange(liqtile *self)
{
	// we must arrange our items without our horizontal boundary, however items can leave by the bottom
	// return the height of the tile

	int x=0,y=0;
	int lh=0;
	liqtile *sa=self->linkchild;
	while(sa)
	{

		if(x+sa->w>self->w)
		{
			// this item does not fit on the current line
			if(x==0)
			{
				// however we are the first on the line...
				sa->x=0;
				sa->y=y;
				liqtile_update_boundfrompos(sa);
				x=0;
				y=y+lh;
				lh=0;
			}
			else
			{
				// simply start a new line
				x=0;
				y=y+lh;
				lh=sa->h;
				sa->x=x;
				sa->y=y;
				liqtile_update_boundfrompos(sa);
				x=x+sa->w;
			}
		}
		else
		{
			if(sa->h>lh) lh=sa->h;
			// this item fits on the line
			sa->x=x;
			sa->y=y;
			liqtile_update_boundfrompos(sa);
			x=x+sa->w;
		}
		//app_log("liqtile '%s' %i,%i",sa->title,sa->x,sa->y);
		sa=sa->linknext;
	}
	return y+lh+1;
}

liqtile * liqtile_findhit(liqtile *self,int x,int y)
{
	if(self->visible==0) return NULL;
	int hitx,hity;

	if(  liqtile_gethit(self,x,y,&hitx,&hity) == 0 )
	{
		// we are not hit
		// shit, i just doubled up the time
		return NULL;
	}
	
				//char titbuf[1024]="\0";
				//liqtile_fullyqualifiedtitle(self,titbuf,1024);
				//app_log("inside '%s'(%i,%i) mouse(%i,%i)  ",titbuf,self->x,self->y,x,y);//,sa->pagefilename);
	
	
	x=x-self->x;
	y=y-self->y;
	
	if(self->crw==0 && self->crh==0)
	{
		// already ok
	}
	else
	{
		x=x+self->cox;
		y=y+self->coy;
	}
	

	liqtile *sa=self->linkchild;
	while(sa)
	{
		// eugh, fly forward to get to end, should replace with doubly linked start+end store
		if(!sa->linknext)break;
		sa=sa->linknext;
	}
	while(sa)
	{
		hitx=0;
		hity=0;
		if(sa->visible)
		{
			//if(sa->crw==0 && sa->crh==0)
			{
				liqtile *res=liqtile_findhit(sa,x,y);
				if(res) return res;
			}
			//else
			//{
			//	liqtile *res=liqtile_findhit(sa,x-self->cox,y-self->coy);
			//	if(res) return res;				
			//}
			
			
		/*	if(  liqtile_gethit(sa,x,y,&hitx,&hity) != 0 )
			{
				// we hit this one..
				// does it have anything inside it?
				if(sa->linkchild && sa->crw==0 && sa->crh==0)
				{
					// stand alone item, none indented
					liqtile *inner = liqtile_findhit(sa,x-sa->x+self->cox,y-sa->y+self->coy);
					if(inner) return inner;
					// we will just ignore this for now, but of course it will be listed
					// i should list the fully qualified title..
				}
				//app_log("hit '%s'",sa->title);
	
				//char titbuf[1024]="\0";
				//liqtile_fullyqualifiedtitle(sa,titbuf,1024);
				//app_log("hit '%s' x,y=%i,%i",titbuf,x,y);//,sa->pagefilename);
	
				return sa;
			}
		*/	
			
		}
		sa=sa->linkprev;
	}
	return self;
}



int liqtile_floatprepare(liqtile *self)
{
	// examine the contents and prepare the crw/h   cvw/h  cox/y;
	//self->floatinuse=1;
	self->crw=0;
	self->crh=0;
	self->cvw=self->w;
	self->cvh=self->h;
	liqtile *sa=self->linkchild;	
	while(sa)
	{
		if(sa->x+sa->w>self->crw) self->crw=sa->x+sa->w;
		if(sa->y+sa->h>self->crh) self->crh=sa->y+sa->h;
		sa=sa->linknext;
	}
	liqtile_floatensurebounded(self);
	
	//app_log("float cr %i,%i  cv %i,%i  co %i,%i",self->crw,self->crh,  self->cvw,self->cvh,  self->cox,self->coy);
	return 0;
}
int liqtile_floatensurebounded(liqtile *self)
{
	// examine the contents and prepare the crw/h   cvw/h  cox/y;
	if(self->cox+self->cvw > self->crw) self->cox=self->crw-self->cvw;
	if(self->coy+self->cvh > self->crh) self->coy=self->crh-self->cvh;
	if(self->cox<0)self->cox=0;
	if(self->coy<0)self->coy=0;
	return 0;
}


liqstyle * liqtile_stylelookup(struct liqtile *self)
{
	//######################################### recursive init the first available style
	liqstyle *style=NULL;
	liqtile *t=self;
	while(t && (!t->style))
	{
		t=t->linkparent;
	}
	if(t && t->style) style=t->style;
	return style;
}









//##########################################################################
//##########################################################################
//##########################################################################
//########################################################################## this monster of a function feels very wrong
//##########################################################################
//##########################################################################
//##########################################################################









int liqtile_layout(struct liqtile *self,int availw,int availh)
{
	
	// i will wonder why this isnt working soon enough
	// its only used from one location however
	// it was an attempt at getting the floating areas automatically fattened up
	// but it didnt really work, the childarrange functions work better
	// and can be called without thinking ;)
	// i should replace this function with a simpler one which just calls arrange row/col on children
	// based upon their layoutmode flags
	// but as i say, its staying like this for now
	
	return 0;
	
	//######################################### layout visible contents according to style layout mode
	// get the full key for debugging purposes
	char selfkey[1024];
	liqtile_fullyqualifiedkey(self,selfkey,1024);
	
	//######################################### continue only if visible
	if(!self->visible) return 0;
	//######################################### prepare by clearing the floating buffer
	self->overlapx=self->layoutstretchw;
	self->overlapy=self->layoutstretchh;
	if(self->layoutstretchw || self->layoutstretchh)
	{
		// make sure we clear our own dimensions first
		if(self->layoutmode==0)
		{
			self->w=availw;
			self->h=availh;
		}
		else
		{
			self->w=0;
			self->h=0;
		}
	}
	//######################################### get the style and ensure its valid
	liqstyle *style=liqtile_stylelookup(self);
	if(self->layoutmode==0)
	{
		// no style or layout specified
		// leave the size exactly as specified
		//app_log("bail %s",selfkey);
		return 0;
	}
	//######################################### grab border dimensions
	
	int bw=(style ? style->borderwidth : 0);
	int bh=(style ? style->borderwidth : 0);
	
	//######################################### prepare for the looping
	int x=bw;
	int y=bh;
	
	int fmw=0;	// fixed ranges
	int fmh=0;
	int ftw=0;
	int fth=0;
	
	int smw=0;	// stretch ranges
	int smh=0;
	int stw=0;
	int sth=0;
	
	int uw=0;
	int uh=0;
	
	//######################################### loop and give the children a chance to layout themselves
	liqtile *c = self->linkchild;
	while(c)
	{
		if(c->visible)
		{
			// give each child the change to layout themselves.
			if(availw==0 && availh==0)
			{
				liqtile_layout(c,0,0);
			}
			// add the flexy components
			{
				if(c->overlapx>smw)smw=c->overlapx;
				if(c->overlapy>smh)smh=c->overlapy;
				stw+=c->overlapx;
				sth+=c->overlapy;
			}
			if(c->layoutstretchw==0 && c->layoutstretchh==0)
			{
				if(c->w>fmw)fmw=c->w;
				if(c->h>fmh)fmh=c->h;
				ftw+=c->w;
				fth+=c->h;
			}
		}
		c=c->linknext;
	}
	


	//#########################################
	if(availw && availh)
	{
		switch(self->layoutmode)
		{
			case 1:		// horizontal strip
						// ONE | TWO | THREE
				
				c = self->linkchild;
				while(c)
				{
					if(c->visible)
					{
						if(availw && availh && c->overlapx && c->overlapy)
						{
							// we know how much space we have been allocated
							// find the usable dimensions
							uw=availw-ftw+c->w;
							uh=availh;//-fmh;
							app_log("AV1: %s %s avl %i,%i  usa: %i,%i stw: %i,  smh: %i ol: %i,%i ftw: %i fmh: %i",selfkey,c->key,availw,availh,uw,uh,stw,smh,c->overlapx,c->overlapy,ftw,fmh);
							if(uw>0 && uh>0)
							{
								// there is a flexible region available
								int fw = uw * c->overlapx / stw;
								int fh = uh * c->overlapy / smh;
								//liqtile_update_boundfrompos(c);
								liqtile_layout(c,fw,fh);
								
								// now the item has had a chance to layout within the area, we account for it
								{
									if(c->w>fmw)fmw=c->w;
									if(c->h>fmh)fmh=c->h;
									ftw+=c->w;
									fth+=c->h;
								}
							}
						}
					}
					c=c->linknext;
				}
				break;
	
	
			case 2:		// vertical bar
						// ONE
						// ---
						// TWO
						// ---
						// THREE
	
				c = self->linkchild;
				while(c)
				{
					if(c->visible)
					{
						if(availw && availh && c->overlapx && c->overlapy)
						{
							// we know how much space we have been allocated
							// find the usable dimensions
							uw=availw;//-fmw;
							uh=availh-fth+c->h;
							app_log("AV2: %s %s avl %i,%i  usa: %i,%i smw: %i,  sth: %i ol: %i,%i fmw: %i fth: %i",selfkey,c->key,availw,availh,uw,uh,smw,sth,c->overlapx,c->overlapy,fmw,fth);
							if(uw>0 && uh>0)
							{
								// there is a flexible region available
								int fw = uw * c->overlapx / smw;
								int fh = uh * c->overlapy / sth;
								//liqtile_update_boundfrompos(c);
								
								// dive back in and tell the user
								liqtile_layout(c,fw,fh);
								// now the item has had a chance to layout within the area, we account for it
								{
									if(c->w>fmw)fmw=c->w;
									if(c->h>fmh)fmh=c->h;
									ftw+=c->w;
									fth+=c->h;
								}
							}
	
						}
					}
					c=c->linknext;
				}
				break;
		}
	}
	
	
	
	
	
	
	
	
	//######################################### 
	switch(self->layoutmode)
	{
		case 1:		// horizontal strip
					// ONE | TWO | THREE
			
			c = self->linkchild;
			while(c)
			{
				if(c->visible)
				{
					/*if(availw && availh && c->overlapx && c->overlapy)
					{
						// we know how much space we have been allocated
						// find the usable dimensions
						uw=availw-ftw+c->w;
						uh=availh;//-fmh;
						app_log("AV1: %s %s avl %i,%i  usa: %i,%i stw: %i,  smh: %i ol: %i,%i ftw: %i fmh: %i",selfkey,c->key,availw,availh,uw,uh,stw,smh,c->overlapx,c->overlapy,ftw,fmh);
						if(uw>0 && uh>0)
						{
							// there is a flexible region available
							int fw = uw * c->overlapx / stw;
							int fh = uh * c->overlapy / smh;
							//liqtile_update_boundfrompos(c);
							liqtile_layout(c,fw,fh);
						}
					}*/
					c->x = x;
					c->y = y;
					liqtile_update_boundfrompos(c);
					x+=c->w+bw;
				}
				c=c->linknext;
			}
			if(availw==0 && availh==0)
			{
				self->overlapx=stw;
				self->overlapy=smh;
			}
			self->w=x;
			self->h=fmh+2*bh;
			liqtile_update_boundfrompos(self);
			break;


		case 2:		// vertical bar
					// ONE
					// ---
					// TWO
					// ---
					// THREE

			c = self->linkchild;
			while(c)
			{
				if(c->visible)
				{
					/*if(availw && availh && c->overlapx && c->overlapy)
					{
						// we know how much space we have been allocated
						// find the usable dimensions
						uw=availw;//-fmw;
						uh=availh-fth+c->h;
						app_log("AV2: %s %s avl %i,%i  usa: %i,%i smw: %i,  sth: %i ol: %i,%i fmw: %i fth: %i",selfkey,c->key,availw,availh,uw,uh,smw,sth,c->overlapx,c->overlapy,fmw,fth);
						if(uw>0 && uh>0)
						{
							// there is a flexible region available
							int fw = uw * c->overlapx / smw;
							int fh = uh * c->overlapy / sth;
							//liqtile_update_boundfrompos(c);
							
							// dive back in and tell the user
							liqtile_layout(c,fw,fh);
						}
					}*/
					c->x = x;
					c->y = y;
					liqtile_update_boundfrompos(c);
					y+=c->h+bh;
				}
				c=c->linknext;
			}
			if(availw==0 && availh==0)
			{
				self->overlapx=smw;
				self->overlapy=sth;
			}
			self->w=fmw+2*bw;
			self->h=y;
			liqtile_update_boundfrompos(self);
			break;
	}

		//if(availw && availh)
		//	app_log("FIN  %s: size: %i,%i overlap: %i,%i stretch: %i,%i",selfkey,self->w,self->h,self->overlapx,self->overlapy,self->layoutstretchw,self->layoutstretchh);
		//else
		//	app_log("PREP %s: size: %i,%i overlap: %i,%i stretch: %i,%i",selfkey,self->w,self->h,self->overlapx,self->overlapy,self->layoutstretchw,self->layoutstretchh);
		return 0;
	
}


void 		liqtile_resizetofitcontent(liqtile *self)
{

	int br=0;
	int bb=0;

	//######################################### loop and give the children a chance to layout themselves
	liqtile *c = self->linkchild;
	while(c)
	{
		if(c->visible)
		{
			if(c->x+c->w>br)br=c->x+c->w;
			if(c->y+c->h>bb)bb=c->y+c->h;
		}
		c=c->linknext;
	}
	self->w=br;
	self->h=bb;
	liqtile_update_boundfrompos(self);
		
}


void 		liqtile_resizetofactor(liqtile *self,int fromfw,int fromfh,int tofw,int tofh)
{
	//######################################### loop and give the children a chance to layout themselves
	liqtile *c = self->linkchild;
	while(c)
	{
		liqtile_resizetofactor(c,fromfw,fromfh,tofw,tofh);
		c=c->linknext;
	}
	self->x=self->x*tofw/fromfw;	
	self->y=self->y*tofh/fromfh;	
	self->w=self->w*tofw/fromfw;
	self->h=self->h*tofh/fromfh;
	liqtile_update_boundfrompos(self);
}



