/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * text buffer attempt at functions required to manage a gui textbox
 *
 */




#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "liqapp.h"
#include "liqtextbuffer.h"

void tb_clear(TB *self)
{
	if(self->buffer!=NULL){  free(self->buffer); self->buffer=NULL; }
	self->bufferlen=0;
	self->cursorpos=0;
	self->cursorlen=0;
}

int tb_insertn(TB *self,char *newtext,int newlen)
{
	
	// new = buffer[0 to cursorpos] & newtext & buffer[cursorpos+sellen to bufferused]
	// to make it properly I should make use of the allocated buffer where possible
	// to make it quick i will allocate a new buffer for each append
	// inneficient but makes life simpler - it just then becomes at most 3 mem copies
	//app_log("Insert: sanity checks1");
	if(self==NULL)					// bastards passed invalid pointer
		return -1;
	//app_log("Insert: sanity checks2");
	
	if(newtext==NULL && newlen>0)	// bastards wanted us to copy bad data
		return -2;
	//app_log("Insert: sanity checks3");

	if(newlen<0)					// bastards wanted me to fail
		return -3;
	//app_log("Insert: sanity checks4");

	if(self->cursorpos<0)			// bastards have set an invalid range
		return -4;
	//app_log("Insert: sanity checks5");
	
	if(self->cursorpos+self->cursorlen>self->bufferlen)			// bastards have set an invalid range
		return -5;
	///app_log("Insert: sanity checks complete");
	
	if(self->bufferlen==0)
	{
		//app_log("Insert: no buffer yet, allocating");
		// empty string, initialize for the first time (paying due care and attention to freeing an existing buffer)
		if(self->buffer!=NULL){  free(self->buffer); self->buffer=NULL; }
		if(newlen==0)
		{
			// leave buffer at null, no point in allocating
		}
		else
		{
			//app_log("Insert: duping buffer");
			self->buffer= strdup(newtext);
			if(self->buffer==NULL) 	// bastard computer didnt give me memory
				return -6;
		}
		self->bufferlen=newlen;
		self->cursorpos=newlen;
		self->cursorlen=0;
		return 0;
	}
	//app_log("Insert: need to extend");
	int reqlen = self->cursorpos + newlen + ( self->bufferlen - ( self->cursorpos + self->cursorlen ) );
	char *req = malloc(reqlen+1);
	if(req==NULL)					// bastard computer didnt give me memory
		return -7;
		
	int pos=0;
	int siz=0;
	
	siz=self->cursorpos;
	if(siz>0)
	{
		//app_log("Insert: copying orig[0..%i]",siz);
		memcpy(&req[pos],self->buffer,siz);
		pos+=siz;
	}
	
	siz=newlen;
	if(siz>0)
	{
		//app_log("Insert: copying new[0..%i]",siz);
		memcpy(&req[pos],newtext,siz);
		pos+=siz;
	}
	
	siz=(self->bufferlen - ( self->cursorpos + self->cursorlen ) );
	if(siz>0)
	{
		//app_log("Insert: copying end[]",self->cursorpos + self->cursorlen,siz);
		memcpy(&req[pos], &self->buffer[self->cursorpos + self->cursorlen],siz);
		pos+=siz;
	}	
	//app_log("Insert: setting 0 term");
	
	req[pos]=0;
	
	if(self->buffer!=NULL){  free(self->buffer); self->buffer=NULL; }
	self->buffer=req;
	self->bufferlen=reqlen;
	self->cursorpos=self->cursorpos+newlen;
	self->cursorlen=0;
		 
	return 0;
}

int tb_insert(TB *self,char *newtext)
{
	return tb_insertn(self,newtext,strlen(newtext));
}

