/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * starlight :)
 *
 */


#include <stdlib.h>
#include <stdio.h>

#include "liqapp.h"
//#include "liqbook.h"
#include "liqcanvas.h"
//#include "liqstars.h"


#include "liqimage.h"
unsigned long tzs=0;
int startsruncount=0;
static int framecount=0;
static liqimage *imgbacon=NULL;

/*
#include <fcntl.h>
#include <linux/types.h>
#include <linux/fb.h>
void setrotate(int angle)
{
	// do not enter this domain unless you know what lies ahead..
	//return;
int	   fb_dev_fd= open("/dev/fb0", O_RDWR);
struct fb_var_screeninfo fb_vinfo; 		// variable info

	if (ioctl(fb_dev_fd, FBIOGET_VSCREENINFO, &fb_vinfo)) 
	{
		printf("VSCREENINFO Failure Reading\n");
		exit(1);
	}

	fb_vinfo.rotate = angle;

    fb_vinfo.activate = FB_ACTIVATE_NOW;

	if (ioctl(fb_dev_fd, FBIOPUT_VSCREENINFO, &fb_vinfo) != 0) 
	{
		printf("VSCREENINFO Failure Writing\n");
		exit(1);
    }

	close (fb_dev_fd); 
}
//setrotate(0);

*/

typedef struct
{
	float x;
	float y;
	float z;
} LIQPOINT;

typedef struct
{
	int id;
	int r;
	LIQPOINT p;
	LIQPOINT a;
	LIQPOINT v;
	int scrcol;
	int scrx;
	int scry;
} STAR;
#define starcount 2000
//#define starcount 10000
#define starmaxz 20
#define starmaxspeed 0.1
STAR stars[starcount];




LIQPOINT dude;

void star_init_one(STAR *sa)
{
//int scrw=(canvas.pixelwidth );
//int scrh=(canvas.pixelheight);

int cx=((canvas.pixelwidth )>>1) * starmaxz*0.8;
int cy=((canvas.pixelheight)>>1) * starmaxz*0.8;

#define RNG 880

		dude.x+=(rand() % RNG) - (RNG>>1);
		dude.y+=(rand() % RNG) - (RNG>>1);
		dude.z=starmaxz;

		if(dude.x<-cx)dude.x=-cx;
		if(dude.y<-cy)dude.y=-cy;
		if(dude.x>cx)dude.x=cx;
		if(dude.y>cy)dude.y=cy;

		sa->r  =100;
		sa->p.x=dude.x;
		sa->p.y=dude.y;
		sa->p.z=dude.z;
		sa->scrcol=0;
		sa->scrx=0;
		sa->scry=0;

}
void star_init_all()
{
	int a;
	STAR *sa;
	for(a=0;a<starcount;a++)
	{
		sa=&stars[a];
		star_init_one(sa);
		sa->p.z=(float)a * (float)starmaxz / (float)starcount;
		//sa->p.z=10;
	}
	canvas_clear(0);
}

void star_calc()
{
	int a;
	STAR *sa;
	// weigh first, this does not effect the location

	unsigned int tzn=app_GetTicks();
	unsigned int tzd=tzn-tzs;
	

//#define SPEED 0.1

	for(a=0;a<starcount;a++)
	{
		sa=&stars[a];
		// before we do ANYTHING with it
		// if it is Initialised we UNDRAW it
		if(sa->scrcol>0)
		{
			// we are on screen..
			//canvas_pset(sa->scrx,sa->scry,sa->scrcol);
			//canvas_pset(sa->scrx,sa->scry,0);
		}
		sa->p.z -= starmaxspeed;
		if(sa->p.z<=0) star_init_one(sa);
moo:
		sa->scrx = (sa->p.x / sa->p.z) + (canvas.pixelwidth >>1);
		sa->scry = (sa->p.y / sa->p.z) + (canvas.pixelheight>>1);
		sa->scrcol=255-(100 * (sa->p.z / starmaxz));
		//sa->scrcol=255;//-(50 * (sa->p.z / starmaxz));
		if(sa->scrx<0 || sa->scry<0 || sa->scrx>=canvas.pixelwidth || sa->scry>=canvas.pixelheight) 
		{
			star_init_one(sa);
			goto moo;
		}

		canvas_pset(sa->scrx,sa->scry,sa->scrcol);
		if((a % 100)==0)
		{
			if(imgbacon)
			{
				int sw=imgbacon->width / sa->p.z;
				int sh=imgbacon->height / sa->p.z;
				if(sw>0 && sh>0)
				{
					if(tzd<30000)
						cliprect_drawimageblendcolor(canvas.cr,imgbacon,sa->scrx,sa->scry,sw,sh,sa->scrcol*tzd/30000);
					//else
					//	cliprect_drawimageblendcolor(canvas.cr,imgbacon,sa->scrx,sa->scry,sw,sh,sa->scrcol);
				}
				
			}
			//
		}
		//canvas_pset(sa->scrx+1,sa->scry,sa->scrcol);
	}
}

#include <time.h>
#include <stdio.h>

void showtime()
{
  struct tm *local;
  time_t t;
  t = time(NULL);
  local = localtime(&t);
  printf("Local time and date: %s\n", asctime(local));
  local = gmtime(&t);
  printf("UTC time and date: %s\n", asctime(local));

}

int liqstar_run()
{
	app_log("Running stars");
	
	
	startsruncount++;
	
	imgbacon=NULL;
	//NCI_bacon_tiny.png
	if (startsruncount==2)
	{
		
			char buf[FILENAME_MAX+1];
			snprintf(buf,FILENAME_MAX,"%s/NCI_bacon_alpha_small.png",app.themepath);
		
		imgbacon = liqimage_createfromfilepng(buf,1);
	}


	LIQFONT fontbig;
	liqfont_openfile(&fontbig,canvas.font->name,canvas.font->size+24,0,canvas.scalew,canvas.scaleh);

	star_init_all();
int result=0;
int running=1;

    framecount=0;
	tzs=app_GetTicks();
	
unsigned long tz0=app_GetTicks();
unsigned long tz1=app_GetTicks();
LIQEVENT ev;
int mx=0,my=0,mp=0;
LIQPOINT m0,m1;
int mcnt=0;
int wantwait=0;
int dirty=1;

int refreshinprogress=0;

	while(running==1)
	{
		while(canvas_eventcount())
		{
waitevent:
			canvas_nextevent(&ev);
			if(ev.type == LIQEVENT_TYPE_KEY && (ev.state==LIQEVENT_STATE_PRESS) )
			{
				app_log("Key Pressed, stopping stars");
				running=0;
				result=-1;
				break;
			}
			else if(ev.type == LIQEVENT_TYPE_MOUSE)
			{
				mx=ev.mouse.x;
				my=ev.mouse.y;
				mp=ev.mouse.pressure;

				int cx=(canvas.pixelwidth )>>1;
				int cy=(canvas.pixelheight)>>1;

				dude.x=(mx-cx)*starmaxz;
				dude.y=(my-cy)*starmaxz;

				m1.x=m0.x;
				m1.y=m0.y;
				m0.x=mx;
				m0.y=my;
				//if(mcnt>0) canvas_line(m0.x,m0.y,m1.x,m1.y,mp % 255);
				mcnt=mcnt+1;
				if(framecount>10 && mp==0)
				{
					// tap completed
					app_log("Screen Tapped, stopping stars");
					running=0;
					result=0;
					break;
				}
				dirty=1;
			}
			else if(ev.type == LIQEVENT_TYPE_REFRESHED)
			{
				//wantwait=1;
				// ok, we have finished the refresh
				refreshinprogress=0;
				//canvas_clear(0); // ?????
				break;
			}
			else if(ev.type == LIQEVENT_TYPE_UNKNOWN)
			{
				running=0;
				break;
			}		
		}
		if(running==0) break;
		dirty=1;
		if(framecount==0 || (dirty && (refreshinprogress==0)))
		{
			
			canvas_clear(0);
			//canvas_drawrect(0,0,canvas.pixelwidth,canvas.pixelheight-canvas.font->glyphmaxh,0);	
	
			//canvas_drawrect(0,canvas.font->glyphmaxh,canvas.pixelwidth,canvas.pixelheight-canvas.font->glyphmaxh,0);
			
			
			star_calc();
	
			char buff[256];
	
			if(framecount<200)
			{
				if(startsruncount==1)
					snprintf(buff,255,"Hello %s, welcome to %s",app.username,app.title);
				else
					snprintf(buff,255,"%s",app.title);
				
					canvas_drawtextcentredon(canvas.pixelwidth/2,canvas.pixelheight*0.2,buff);	
	
				if(framecount>20)
				{
					canvas_drawtextcentredon(canvas.pixelwidth/2,canvas.pixelheight*0.5,"(C)2008 Gary Birkett.");	
					canvas_drawtextcentredon(canvas.pixelwidth/2,canvas.pixelheight*0.6,"liquid@gmail.com");	
					canvas_drawtextcentredon(canvas.pixelwidth/2,canvas.pixelheight*0.7,app.userpath);	
				}
	
			}
			


	

	
	//		if(framecount>100)
	//			canvas_drawtext(280,300,"Tap to continue");	

	unsigned int tzn=app_GetTicks();
	unsigned int tzd=tzn-tzs;


			if(imgbacon && ((tzd>30000 && tzd<40000) ) ) // || (framecount==78) || (framecount==79)) )
			{
				//if(framecount==78)
				{
						LIQFONT *oldfont = canvas.font;
						canvas.font = &fontbig;
		
						struct tm *local;
						time_t t;
						t = time(NULL);
						local = localtime(&t);
						if(framecount<80)
							snprintf(buff,255,"%s","Are you hungry?");
						else
							snprintf(buff,255,"%s","more bacon on #maemo");
						//canvas_drawtextcentredon(canvas.pixelwidth/2,canvas.pixelheight/2,buff);	
						canvas_drawtextcentredon(canvas.pixelwidth/2,canvas.pixelheight*0.85,buff);	
						canvas.font = oldfont;
		
				}
				
				int sw=imgbacon->width;// / sa->p.z;
				int sh=imgbacon->height;// / sa->p.z;
				if(sw>0 && sh>0)
					cliprect_drawimageblendcolor(canvas.cr,imgbacon,(canvas.pixelwidth-sw)/2,(canvas.pixelheight-sh)/2,sw,sh,255);
			//	

			}
			else
			{
				
				if(framecount>100)
				{
						LIQFONT *oldfont = canvas.font;
						canvas.font = &fontbig;
		
						struct tm *local;
						time_t t;
						t = time(NULL);
						local = localtime(&t);
						if(startsruncount==2)// || framecount<200)
						{
							snprintf(buff,255,"%s",asctime(local));
							canvas_drawtextcentredon(canvas.pixelwidth/2,canvas.pixelheight*0.85,buff);	
							canvas.font = oldfont;
						}
						else if(framecount>200)
						{
							snprintf(buff,255,"liqbase by Gary Birkett");
							canvas_drawtextcentredon(canvas.pixelwidth/2,canvas.pixelheight*0.85,buff);	
						}
						
						canvas.font = oldfont;
						//canvas_drawtextcentredon(canvas.pixelwidth/2,canvas.pixelheight/2,buff);	
		
				}				
				
			}


			if(framecount<100 && app.version && *app.version)
			{
						cliprect_drawtextinside(canvas.cr,canvas.font,
													0,canvas.pixelheight-canvas.font->glyphmaxh,
													canvas.pixelwidth,canvas.font->glyphmaxh,
													app.version,
													2);
			}	


	
			canvas_refreshdisplay();
			refreshinprogress=1;
			wantwait=1;
			//setrotate(90);
				tz0=tz1;
				tz1=app_GetTicks();
	
			framecount++;
		}
		
		
		if(wantwait || refreshinprogress)
		{
			wantwait=0;
			goto waitevent;
		}
	}
	
	if(imgbacon)
	{
		liqimage_free(imgbacon);
		imgbacon=NULL;
	}

	
	liqfont_close(&fontbig);
	return result;
}
