/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * module to use and manipulate frames
 *
 */



#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>

#include "liqapp.h"
#include "liqbook.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "liqdraw.h"
#include "liqdrawframe.h"

extern PAGE *page;




FRAME *frameroot=NULL;
FRAME *framecurr=NULL;
FRAME *framesel=NULL;



static void render_all()
{

	canvas_clear(0);
	//canvas_drawcolorcube(800-256,0,50);//cubegrey);
    //liqart_toolbar();

	//int a;
	FRAME *sa;
	{
		//for(a=0;a<frameused;a++)
		sa=frameroot->linkchild;
		while(sa)
		{
			//sa=&frames[a];

			frame_rendertocanvas(sa,0,0,NULL);

			sa=sa->linknext;
		}
	}
	
	
}






static FRAME *mkbutton(FRAME *self,char *title)
{
	FRAME *ch= frame_createquick(title,0,0,canvas.pixelwidth/8,canvas.pixelwidth/5);
	frame_pageautoloadbytitle_apg(ch);
	frame_append(self,ch);
	return ch;
}

static FRAME *mkrowedit(FRAME *self)
{
	// create a group of buttons in ch
	FRAME *ch= frame_createquick("editrow",0,0,0,0);
	FRAME *sa=NULL;
	
		int tw=0;
		int mh=0;
		sa=mkbutton(ch,"left");
		tw+=sa->w;
		if(sa->h>mh)mh=sa->h;

		sa=mkbutton(ch,"clear");
		tw+=sa->w;
		if(sa->h>mh)mh=sa->h;
		
		sa=mkbutton(ch,"new");
		tw+=sa->w;
		if(sa->h>mh)mh=sa->h;
		
		sa=mkbutton(ch,"edit");
		tw+=sa->w;
		if(sa->h>mh)mh=sa->h;
	
		sa=mkbutton(ch,"delete");
		tw+=sa->w;
		if(sa->h>mh)mh=sa->h;

		sa=mkbutton(ch,"right");
		tw+=sa->w;
		if(sa->h>mh)mh=sa->h;
		
		// now fix the size of ch
		ch->w=tw;
		ch->h=mh;
		frame_update_boundfrompos(ch);
		frame_neatarrange(ch);

	
	frame_append(self,ch);
	return ch;
}
/*

static int frame_childarrange_row(FRAME *self)
{
	int tw=0;								// should we start with self->layout.borderxhead ?
	int mh=0;
	FRAME *sa=self->linkchild;
	while(sa)
	{
		sa->x=tw;
		sa->y=0;							// should we check sa->layout.float?    0=top  0.5=centre 1=bottom
		frame_update_boundfrompos(sa);
		tw+=sa->w;							// should we add self->layout.borderxbetween
		if(sa->h>mh)mh=sa->h;
		sa=sa->linknext;
	}
											// should we add self->layout.borderxtail
	// now fix the size of ch
	self->w=tw;
	self->h=mh;
	frame_update_boundfrompos(self);

	return 0;
}

static int frame_childarrange_col(FRAME *self)
{
	int th=0;
	int mw=0;
	FRAME *sa=self->linkchild;
	while(sa)
	{

		sa->x=0;
		sa->y=th;
		frame_update_boundfrompos(sa);
		th+=sa->h;
		if(sa->w>mw)mw=sa->w;
		
		sa=sa->linknext;
	}
	self->w=mw;
	self->h=th;
	frame_update_boundfrompos(self);
	return 0;
}


 */

void liqscroll_run()
{

	frameroot = frame_createquick("root",0,0,canvas.pixelwidth -1,canvas.pixelheight-1);
	framecurr=NULL;
	framesel=NULL;
	
	
	//framecurr = frame_createquick("hello",10,10,100,100);
	//frame_insert(frameroot,framecurr);
	mkbutton(frameroot,"move");
	mkbutton(frameroot,"resize");
	mkbutton(frameroot,"save");
	
	mkbutton(frameroot,"new");
	mkbutton(frameroot,"edit");
	mkbutton(frameroot,"delete");
	
	
	mkbutton(frameroot,"close");
	mkbutton(frameroot,"yes");
	mkrowedit(frameroot);
	mkbutton(frameroot,"no");
	mkbutton(frameroot,"nokia");

	frame_neatarrange(frameroot);
	
	
	//frameused=0;
int fc=0;
int running=1;
//unsigned long tzs=app_GetTicks();
unsigned long tz0=app_GetTicks();
unsigned long tz1=app_GetTicks();
LIQEVENT ev;
int mx=0,my=0,mp=0;
//int mcnt=0;
int mk=0;
int mkc=0;
int dirty=1;		// ensure we are drawn at least once :)
	canvas_clear(0);
	while(running==1)
	{
		while(canvas_eventcount())
		{
waitevent:
			canvas_nextevent(&ev);
			if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) )
			{
				mk=ev.key.keycode;				
				mkc++;
				dirty=1;
				if( (ev.key.keycode==65307) )	//ESC
				{
					app_log("Escape Pressed, stopping program");
					running=0;
					break;
				}
			}
			if(ev.type == LIQEVENT_TYPE_MOUSE)
			{
				int nx,ny;
				nx=mx;		// remember old
				ny=my;
				mx=ev.mouse.x;
				my=ev.mouse.y;
				mp=ev.mouse.pressure;
				dirty=1;
				if(framesel!=NULL)
				{
					// we are already in a drag motion
					// could it be a resize?
					// what other tool options are available?

					int dx,dy;
					dx=mx-nx;
					dy=my-ny;
					//render_frame(framesel,1);
					framesel->sx+=dx;
					framesel->ex+=dx;
					framesel->sy+=dy;
					framesel->ey+=dy;
					frame_forceinboundparent(framesel);//,0,0,canvas.pixelwidth-1,canvas.pixelheight-1);
					//frame_forceinbound(framesel,0,0,canvas.pixelwidth-1,canvas.pixelheight-1);
					//render_frame(framesel,1);
					if(mp==0)
					{
						framesel=NULL;
						//render_all();
						dirty=1;
					}
				}
				else if(framecurr==NULL)
				{

					//int fh;
					FRAME *sa;
					sa = frame_findhit(frameroot,mx,my);
					if(sa)
					{
						while(sa->linkparent && sa->linkparent != frameroot)
						{
							sa=sa->linkparent;
						}
						// hey we are selecting one...
						framesel=sa;//&frames[fh];
					}
					else
					{
						// new starting
						framesel=NULL;
						framecurr = frame_create(); // &frames[frameused++];
						frame_insert(frameroot,framecurr);
						frame_editstart(framecurr,mx,my);
					}
				}
				else
				{
					// undraw it
			//		render_frame(framecurr,1);
					// new expand
					frame_editexpand(framecurr,mx,my);
					// redraw it
			//		render_frame(framecurr,1);
					if(mp==0)
					{
						// new finished
						frame_editcomplete(framecurr);
						frame_forceinboundparent(framecurr);
						framecurr=NULL;

			//			render_all();

					}
					dirty=1;
				}
				//break;
			}
			if(ev.type == LIQEVENT_TYPE_UNKNOWN)
			{
				running=0;
				break;
			}
		}
		if(running==0) break;
		//if(dirty)
		{
			FRAME *f=framecurr;
			if(framesel)f=framesel;

				frame_overlapcalc(frameroot,f);

			render_all();

			//char buff[255];
			//snprintf(buff,255,"fc %i    %1.5f,  %1.5f             ",fc,app_fps(tz0,tz1,1),app_fps(tzs,tz0,fc));
			//canvas_drawtext(0,0,buff);

			canvas_refreshdisplay();

			//xv_canvas_refresharea(0,0,canvas.pixelwidth,canvas.pixelheight/2);

			dirty=0;

			tz0=tz1;
			tz1=app_GetTicks();
			fc++;

			goto waitevent;
		}
		//else
		{
		//	goto waitevent;
		}
		}

	frame_close(frameroot);

}

