/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * book reader - original version, with autoscroll
 *
 */


#include <stdlib.h>
#include <stdio.h>

#include <X11/keysym.h>


#include "liqapp.h"
#include "liqbook.h"
#include "liqcanvas.h"



//#include "liqsketch.c"
//#include "liqstars.c"
//#include "liqart.c"


//#include "liqcell.c"



char *opt_bookname;
int   opt_colorcube;
int   opt_fpsshow;



#define ABS(x) (((x) >= 0) ? (x) : -(x))
#define SGN(x) (((x) >= 0) ? 1 : -1)

void liqprog_run()
{
	
	//opt_fpsshow=1;
	
	int running=1;
int framecount=0;
unsigned long tzs=app_GetTicks();
unsigned long tz0=app_GetTicks();
unsigned long tz1=app_GetTicks();
LIQEVENT ev;
	
int mx=0,my=0,mp=0;
unsigned int mdt=0;
	
	
int accel_ok=0;
int accel_x=0;
int accel_y=0;
unsigned int accel_dt=0;
	
int stroke_inprogress=0;
int stroke_sx=0;
int stroke_sy=0;
int stroke_dy=0;
int stroke_pagestart=0;
int font_height=canvas.font->glyphmaxh;
int book_totalheight=(book.linecount * font_height);
int page_topstart=0;
int page_lineviewcount=canvas.pixelheight/font_height;
int page_topmax=book_totalheight-canvas.pixelheight;
int dirty=1;
int refreshinprogress=0;

int autoscroll=1;

	int newtop=0;
	if(page_topmax<0)page_topmax=0;
	if(page_lineviewcount>=book.linecount) page_lineviewcount=book.linecount-1;

	while(running==1)
	{
		while(canvas_eventcount())
		{
waitevent:
			canvas_nextevent(&ev);

			if( (ev.type == LIQEVENT_TYPE_UNKNOWN))
			{
				app_log("Unknown event, stopping program");
				running=0;
				break;
			}			
			
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==XK_Escape) )
			{
				app_log("Escape Pressed, stopping program");
				running=0;
				break;
			}
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==XK_Up))
			{
				app_log("Up Pressed, Move Back");
				page_topstart = (((page_topstart - canvas.pixelheight)/ font_height)+1)*font_height;
				dirty=1;
				break;
			}
			
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==XK_Down) )
			{
				app_log("Down Pressed, Move next Page");
				page_topstart = ((page_topstart + canvas.pixelheight)/ font_height)*font_height;
				dirty=1;
				break;
			}			
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65508) )
			{
				app_log("CTRL Pressed, closing");
				running=0;
				break;
			}				
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65293) )
			{
				app_log("DPad Centre Pressed, Move next Page");
				page_topstart = ((page_topstart + canvas.pixelheight)/ font_height)*font_height;
				dirty=1;
				break;
			}
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65473) )  // menu
			{
				//feature:autoscroll stop/start with menu key
				if(autoscroll==0)
				{
					app_log("Menu Pressed, Starting autoscroll");
					autoscroll=1;
				}
				else
				{
					app_log("Menu Pressed, Stopping autoscroll");
					autoscroll=0;
				}
				dirty=1;
				break;
			}	
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS))
			{
				app_log("Undefined Key Pressed: %i",ev.key.keycode);
				break;
			}
			
			
			else if(ev.type == LIQEVENT_TYPE_MOUSE)
			{
				accel_ok=0;
				if(stroke_inprogress)
				{
					accel_ok=1;
					accel_y=my-ev.mouse.y;
					accel_x=mx-ev.mouse.x;
					accel_dt=mdt-ev.ticks;
				}
				mdt=ev.ticks;
				mx=ev.mouse.x;
				my=ev.mouse.y;
				mp=ev.mouse.pressure;
				

				if(stroke_inprogress==0)
				{
					// Starting stroke
					stroke_inprogress=1;
					stroke_sx=mx;
					stroke_sy=my;
					stroke_dy=0;
					stroke_pagestart=page_topstart;
				}
				else
				{
					// Continuing or Completing a stroke
					stroke_dy=my-stroke_sy;
					if(1==1)//stroke_sx > canvas.pixelwidth-100 || stroke_sx < 100 )
					{
						// proportional
						//newtop = ((( (float)my / (float)canvas.pixelheight )*1.2)-0.1) * (float)page_topmax;
						// actually, that doesnt work, lets slide
						newtop=stroke_pagestart - stroke_dy;
					}
					else 
						if(stroke_sy > canvas.pixelheight-100 )
					{
						// page - we should only do this ONCE per stroke
						if(stroke_pagestart==page_topstart)
						{
							if(stroke_sx > canvas.pixelwidth/2)
							{
								// next page
								newtop = ((page_topstart + canvas.pixelheight)/ font_height)*font_height;
							}
							else
							{
								// previous page
								newtop = (((page_topstart - canvas.pixelheight)/ font_height)+1)*font_height;
							}
						}
						else
						{
							newtop = page_topstart;
						}
					}
					else
					{
						// slide !shit! i wrote over the code
						newtop=stroke_pagestart - stroke_dy;
					}
					dirty= (page_topstart == newtop) ? 0 : 1;

					page_topstart = newtop;
					if(mp==0)
					{
						// Completing a stroke
						stroke_inprogress=0;
					}
					
				}
			}
			else if(ev.type == LIQEVENT_TYPE_REFRESHED)
			{
				//wantwait=1;
				// ok, we have finished the refresh
				refreshinprogress=0;
				//canvas_clear(0); // ?????
				break;
			}
			
		}
		if(autoscroll)
		{
			// autoscroll test :)
			page_topstart+=2;   dirty=1;
			//dirty=1;
		}
		
		
		if(running==0) break;
		
		
		if(opt_colorcube==0)
			if(dirty==0 && framecount>12) goto waitevent;

		if(page_topstart<0)page_topstart=0;
		if(page_topstart>page_topmax)page_topstart=page_topmax;
		
		
		//dirty=0;
		int x=0;
		int y=0;
		//int yy=0;
		int xe;
		int ye;
		
		char buff[255];
		int linenum;
		int ln;

		//canvas_drawrect(0,0,canvas.pixelwidth,canvas.pixelheight,0);
		if((dirty) && (refreshinprogress==0))
		{
			

			
			
			canvas_clear(0);
			if(opt_colorcube)
				canvas_drawcolorcube(framecount % 256,(framecount % 256)>>1,framecount % 256);
			linenum = (page_topstart / canvas.font->glyphmaxh);
			x=0;
			for(ln=0;ln <= page_lineviewcount+1;ln++)
			{
				LIQBOOKLINE *line = &book.linebuffer[ln+linenum];
				y = canvas.font->glyphmaxh * ln-(page_topstart % canvas.font->glyphmaxh);
				ye=y+canvas.font->glyphmaxh;
				if(y>=canvas.pixelheight)  break;
				if(ye>=0)
				{
					xe=canvas_drawtextn(x,y,line->filemapstart,line->length);
					if(xe<canvas.pixelwidth)
					{
					//	canvas_drawrect(xe,y,canvas.pixelwidth-xe,canvas.font->glyphmaxh,0);
					}				
					//snprintf(buff,255,"%3i  ",ln+linenum);
					//canvas_drawtext(0,y,buff);
				}
			}
			if(opt_fpsshow)
			{
				snprintf(buff,255,"fc %i    %1.5f,  %1.5f             ",framecount,app_fps(tz0,tz1,1),app_fps(tzs,tz0,framecount));
				canvas_drawtext(0,0,buff);
				//app_log(buff);
			}
			canvas_refreshdisplay();
			refreshinprogress=1;
				tz0=tz1;
				tz1=app_GetTicks();
			framecount++;
			dirty=0;
			goto waitevent;
		}
		if (refreshinprogress) goto waitevent;
		
	}
	app_log("Main loop complete:   %i frames,  average fps %f",framecount,app_fps(tzs,tz0,framecount));


	app_log("Closing Book:");
	book_close();
}







int liqreader_run()
{
int res=0;
			char buf[FILENAME_MAX+1];
			snprintf(buf,FILENAME_MAX,"%s/liqbase-example.txt",app.themepath);
	
	//app_log("Checking For Options");
	//app_log("Option [book]      : '%s'", opt_bookname = app_getopt_str(NULL,      buf)     );
	//app_log("Option -colorcube  ? %i",   opt_colorcube = app_getopt_exist("colorcube")                 );
	//app_log("Option -fpsshow    ? %i",   opt_fpsshow = app_getopt_exist("fpsshow")                 );

		opt_fpsshow=0;
		opt_bookname=buf;
		opt_colorcube=0;
	
	
	// bug#1: reporter Thesandlord
	// book specified in path will cause software to go dark, freeze and be unbreakable.  popping battery was the only solution
	// hypothosis: taking longer than overlay blanking period
	// technically being able to send a CTRL C or a killall -9 liqbase does suffice
	// but its wrong.
	// There is an infinite loop. i just let it continue and it created over 1,000,000 lines.
	// I have also made the loaded ignore multiple blank lines
	// and fixed a secondary bug for documents with only a CR (or is it LF)
	// opt_bookname="/media/mmc1/Thesandlord_files.tar/Earthbound.html";
	

	
	//################################################################

	app_log("Opening Book.");
	res=book_open(buf,canvas.pixelwidth,canvas.font->glyphwidths);
	if(res!=0) app_errorandfail(-1,"Book reading failure");
	
	app_log("Running Reader");

	liqprog_run();
	return 0;
}
