/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * editor/text viewer v2 uses kinetics
 *
 */



#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>


#include "liqapp.h"
#include "liqcanvas.h"
#include "liqimage.h"
#include "liqfont.h"
#include "liqtile.h"

#include "filebuf.h"
#include "liqdoc.h"

#include "mk_core.h"
#include "liqbase_prefs.h"

#define SGN(x) ((x)<0?-1:(x)==0?0:1)

static int runfast=0;

static liqtile *tileroot=NULL;
static liqtile *tilepageview=NULL;
static liqtile *tilebook=NULL;

static liqtile *tilefinger=NULL;
static liqtile *tilethumb=NULL;
static liqtile *tileext=NULL;

//static LIQFONT edfont;
//static int     edfontsize;



static int     flickermode=0;
static POINT * flickertrigstartpoint=NULL;		// where abouts in the hand this flicker started


static void liqtile_initboundfromPOINTstream(liqtile *self,POINT *mostrecentpoint,int maxcount,POINT *hardstopifencountered)
{
	POINT *p = mostrecentpoint;
	POINT *q=NULL;
	int tcnt=0;
	int tx=0;
	int ty=0;
	int tw=0;
	int th=0;
	while((p) && (p!=hardstopifencountered) && (maxcount>0))
	{
		tcnt++;
		tx+=p->x;
		ty+=p->y;
		if(q)
		{
			// can get bearings
			tw+=q->x-p->x;
			th+=q->y-p->y;
		}
		q=p;
		p=p->linkprev;
		maxcount--;
	}
	if(tcnt)
	{
		tx/=tcnt;
		ty/=tcnt;
		tw/=tcnt;
		th/=tcnt;
		tw+=80;
		th+=48;
		self->x=tx-tw/2;
		self->y=ty-th/2;
		self->w=tw;
		self->h=th;
		liqtile_update_boundfrompos(self);
		self->visible=1;
	}
	else
	{
		self->visible=0;
	}
}
#define samplecount 5

static int tilepageview_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	
	
			// flickermode needs smoothing before it can work correctly
			// but i believe as an input method it can work.
			// use the primary thumb as ground zero
			// then keeping the thumb pressed and stationary touch with a secondary finger
			// the cursor will jump to roughly the halfway point (depending upon pressure differential)
			// this is my chance, I know the original fixed start location
			// and I know roughly where the finger is, i know its direction, and something of its position
			// if the finger moves closer, its rough position will get closer
			// it it moves further away, then so will the rough position
			// if it rotates, i will know roughly where it is
			// i can use this rough guide to stretch or rotate objects
			
			// flickermode originally defined within liqfloatgallery, since disabled, this is the furtherment of thoughts
	
	

	// find out how far we have jumped
	
	float ml = sqrt((float)(args->mdx*args->mdx+args->mdy*args->mdy));
	
	if(flickermode)
	{
		// we are adjusting tilefinger
		// tilethumb is preinitializaed and locked
		
		
			liqtile_initboundfromPOINTstream(tilefinger ,args->hand->pointlast,           samplecount,flickertrigstartpoint);
			//liqtile_initboundfromPOINTstream(tilethumb,flickertrigstartpoint->linkprev,   4,NULL);
	}
	else
	{
		// we are adjusting tilefinger
		
		
		
		//todo: make flickermode resolution independent
		if(ml>35)//args->mdx>10 || args->mdy>10)
		{
			// bsg.hybrid.jump();
			flickermode=1;
			flickertrigstartpoint=args->hand->pointlast;
			liqtile_initboundfromPOINTstream(tilefinger ,args->hand->pointlast,           samplecount,flickertrigstartpoint);
			liqtile_initboundfromPOINTstream(tilethumb,flickertrigstartpoint->linkprev,   samplecount,NULL);
		}
		else
		{
			// normal mouse action :)
			liqtile_initboundfromPOINTstream(tilefinger ,args->hand->pointlast,           samplecount,NULL);
			liqtile_initboundfromPOINTstream(tilethumb,NULL,                              samplecount,NULL);
		}
	}
	if(flickermode)
	{
			int dx=(tilefinger->x-tilethumb->x);
			int dy=(tilefinger->y-tilethumb->y);
			tileext->x=tilethumb->x+dx*2;
			tileext->y=tilethumb->y+dy*2;
			tileext->w=tilefinger->w;
			tileext->h=tilefinger->h;
			liqtile_update_boundfrompos(tileext);
			tileext->visible=1;
	
	}
	else
	{
			tileext->visible=0;
	}


	if(args->mez==0)
	{
		flickermode=0;
		flickertrigstartpoint=0;
		tilefinger->visible=0;
		tilethumb->visible=0;
		tileext->visible=0;
	}
	return 0;

}





static int tilepageview_paint(struct liqtile *self,liqtileeventpaint *args)
{
	// ok, the gridview is about to be painted.
		
	//app_log("gridview paint KINETIC: %i,%i",self->kineticx,self->kineticy);
	if(self->kineticx || self->kineticy)
	{

		// if we have a kinetic component lets use it up
		tilepageview->cox+=self->kineticx;
		tilepageview->coy+=self->kineticy;
		
		liqtile_floatensurebounded(self);

		self->kineticx-=SGN(self->kineticx);
		self->kineticy-=SGN(self->kineticy);		
	}

	// now, render as normal
	self->handlerpaint=NULL;
	liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
	self->handlerpaint=tilepageview_paint;
	return 0;
}





int liqmutlitouchtest_run()
{
	//int err=0;
	
	runfast=1;
	
	// lets go
	if(mk_style_open() != 0)
	{
		return app_warnandcontinue(-1,"Couldnt open default styles");
	}
	
	
/*	

	//#################################################### grab correct font

	char * t=NULL;
	if((t=liqbase_pref_getvalue("book_fontsize")))
	{
		edfontsize=atoi(t);
	}
	else
	{
		edfontsize=24;
	}
	
	if(edfontsize<8)edfontsize=8;
	if(edfontsize>72)edfontsize=72;

#ifdef USE_MAEMO
	err=liqfont_openfile(&edfont,"/usr/share/fonts/nokia/nosnb.ttf",edfontsize,0,canvas.scalew,canvas.scaleh);
#else // USE_MAEMO
	err=liqfont_openfile(&edfont,"/usr/share/fonts/lucon.ttf",edfontsize,0,canvas.scalew,canvas.scaleh);
#endif
	
	
	if(err)
	{
    	{ return app_warnandcontinue(-1,"liqed_run couldnt open font"); }						
	}
	
	//#################################################### open the book
	
	struct doc doc;
	doc.renderfont=&edfont;
	doc.rendermarginright=canvas.pixelwidth;
	err=doc_initfromfilename(&doc,sourcefilename);	
	
	if(err)
	{
    	{ return app_warnandcontinue(-1,"liqed_run couldnt open doc.."); }						
	}	
	
	
	//#################################################### prep the display
	
	int docw=0;
	int doch=0;

	docw = doc.rendertotw;
	doch = doc.rendertoth;

	//#################################################### prep the display
	
	tilebook = liqtile_createquick("book",0,0,docw,doch);
	tilebook->style=styleblack;
	tilebook->handlerpaint=NULL;
	tilebook->handlermouse=NULL;

 */
	
	
	
	//#################################################### adjust location within display
/*
	if(sourcefilename)
	{
		int sfl=0;
		int sfu=0;
		if(liqbookprogress_startreading_lookupposition(sourcefilename,&sfl,&sfu))
		{
			//
			if((sfl>0) && (sfu>0) && (sfu <= sfl))
			{
				viewy = (int)((float)sfu * (float)sfl / (float)doch);
				
				app_log("viewy: %i sfu %i sfl %i doch %i",viewy,sfu,sfl,doch);
				
					if(viewy<0){viewy=0;}
					if(viewy>=viewmaxy) {viewy=viewmaxy;}

			}
			
		}
	}
	
 */


	
	
	tileroot=liqtile_createquick("ui",0,0,canvas.pixelwidth,canvas.pixelheight);
	//tileroot->handlermouse=page_drawstroke_mouse;
	//tileroot->handlerpaint=page_paint;
	//tileroot->style=stylemenuback;	
	
	
		tilepageview=liqtile_createquick("pageview", canvas.pixelwidth*0.0, canvas.pixelheight*0.0,     canvas.pixelwidth, canvas.pixelheight );
		tilepageview->style=styleblack;
		//liqtile_childappend(tilepageview,tilebook);
		
		//liqtile_floatprepare(tilepageview);
		
		tilepageview->handlermouse=tilepageview_mouse;
		//tilepage->handlerpaint=page_paint;
		liqtile_childappend(tileroot,tilepageview);
	
	
		tileext= liqtile_childappend(tilepageview,mkbutton("ext"));
		tileext->visible=0;
		tileext->style=stylebuttonsel;
		
		tilefinger= liqtile_childappend(tilepageview,mkbutton("finger"));
		tilefinger->visible=0;
		tilefinger->style=stylebuttonsel;
		tilethumb = liqtile_childappend(tilepageview,mkbutton("thumb"));
		tilethumb->visible=0;
		tilethumb->style=stylebuttonsel;
		
	
	
	liqtile_easyrun2(tileroot,&runfast);
	
	
	liqtile_close(tileroot);

	//liqfont_close(&edfont);
	
	mk_style_close();
	return 0;
}





