#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>



#include "liqapp.h"
#include "liqcanvas.h"
#include "liqdialog.h"
//#include "filebuf.h"
#include "liqdoc.h"
#include "liqtile.h"
#include "liqtextbuffer.h"


#include "mk_core.h"


int mkproject_run();


int liqmenu_askv(char *key,char *question,char *description,char *footingnotes,int defaultoption,int answercount,char ** answers)
{	
	if(answercount==0)
	{
		char **a=answers;
		while(*a++) 
		{
			if(answercount>20)break;		// for now, lets not get stuck...
			answercount++;
		}
	}
	
	if(!footingnotes)footingnotes="contact liquid@gmail.com, lcuk on #maemo";
	
	app_log("Running Dialog %s:%s with %i options",key,question,answercount);




	app_log("menu loading mk_styles");

	if(mk_style_open()!=0)
	{
		// failed
		app_log("mk_style could not open");
		return -1;
	}


	
	//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ calc basic layout
	int hhead = 0;	// Question Title BIG
	int hdesc = 0;	// Question Subtitle normal
	int hbody = 0;	// Body Area normal
	int hfoot = 0;	// Footing Notes normal
	                hhead = (styletitle->textfont ? styletitle->textfont->glyphmaxh:0);
	if(description) hdesc = canvas.font->glyphmaxh;
	if(footingnotes)hfoot = canvas.font->glyphmaxh;
                  	hbody = canvas.pixelheight-hhead-hdesc-hfoot;
	
	
	app_log("hhead %i,  hdesc %i, hbody %i,  hfoot %i",hhead,hdesc,hbody,hfoot);
	
	
	
	//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ now work out how many rows and cols we need
	
	
	int ccols=1;
	while(ccols<3 && ccols<answercount)ccols++;
	int crows=answercount/ccols;
	while(ccols*crows<answercount)crows++;
	
	int tilew =  canvas.pixelwidth / ccols;
	int tileh = (canvas.pixelheight-hhead-hdesc-hfoot) / crows;

	

	
	app_log("Tile cnt %i, rowcol(%i,%i)  size(%i,%i)   can(%i,%i)",answercount,ccols,crows, tilew,tileh,canvas.pixelwidth,canvas.pixelheight);




	//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ create handlers for the item
	int tmenu_paint(struct liqtile *self,liqtileeventpaint *args)
	{
		self->handlerpaint=NULL;
		liqtile_rendertocanvas(self,args->ox,args->oy,NULL);
		self->handlerpaint=tmenu_paint;
		return 0;
	}
	
	//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ create the main ui tiles




	app_log("menu creating ui");
	liqtile *tmenu = liqtile_createquick("menu",0,0,canvas.pixelwidth,canvas.pixelheight);
	liqtile *thead = liqtile_createquick(question,0,0,canvas.pixelwidth,hhead);
	liqtile *tdesc = liqtile_createquick(description,0,0,canvas.pixelwidth,hdesc);
	liqtile *tbody = liqtile_createquick("body",0,0,canvas.pixelwidth,hbody);
	liqtile *tfoot = liqtile_createquick(footingnotes,0,0,canvas.pixelwidth,hfoot);
	
	tmenu->style=stylemenuback;
	thead->style=styletitle;//head;
	tdesc->style=stylelabel;//desc;
	tbody->style=NULL;//stylebody;
	tfoot->style=stylelabel;//stylefoot;
	
	tmenu->handlerpaint=tmenu_paint;
	
	// bind them together
	
	liqtile_childappend(tmenu,thead);
	liqtile_childappend(tmenu,tdesc);
	liqtile_childappend(tmenu,tbody);
	liqtile_childappend(tmenu,tfoot);
	liqtile_neatarrange(tmenu);
	

int result=-1;

	//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ create handlers for the item

	liqtile *tilecurr=NULL;
	
	
	int titemedit_mouse(struct liqtile *self,liqtileeventmouse *args)
	{
		// user clicked the itemedit button :)
				if(args->mez==0)
				{
					app_log("........edit now...........");
					//int result=liqdialog_ask("Menu Item Edit","You are here too soon","Come back later",NULL,1,
					//   		"OK",
					//   		NULL);

				//	if(result==-1) {    return -1;                         } // Cancelled, Do Nothing
				
					mkproject_run();
				}
				return 0;

	}
	
	int modelayout=0;
	
	int titem_mouse(struct liqtile *self,liqtileeventmouse *args)
	{
		
		if(modelayout)
		{
			self->x-=args->mdx;
			self->y-=args->mdy;
			liqtile_update_boundfrompos(self);
			liqtile_overlapcalc(self->linkparent,self);
			tilecurr=self;
			if(args->mez==0) tilecurr=NULL;
			return 0;
		}
		
		
		tilecurr=self;
		if(args->mez==0)
		{
			result=(int)self->data;
			// mark completed
			tmenu->visible=0;
			tilecurr=NULL;
		}
		return 0;
	}


	int titem_paint(struct liqtile *self,liqtileeventpaint *args)
	{
		//cliprect_drawclear(args->cr,0,0,0);
		//canvas_clear(0);
		self->handlerpaint=NULL;
		if(self==tilecurr)
			self->style=stylemenuitemsel;
		else
		{
			if((int)self->data==defaultoption)
				self->style=stylemenuitemdefault;
			else
				self->style=stylemenuitemstd;
		}
		// if we are rendering tilecurr, then draw with different blend than if not
		liqtile_rendertocanvascr(self,args->ox,args->oy,tilecurr,args->cr);
		self->handlerpaint=titem_paint;
		return 0;
	}




	//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ create the answers now within the body area

	app_log("menu creating answers");


	int r=0;		//row
	int c=0;		//col
	int a=0;		

	for(a=0;a<answercount;a++)
	{
		int xx=c*tilew;
		int yy=r*tileh;

		//######################### grab the title and description for this answer
		char title[255] = "";
		char desc[255] = "";
		int tbrk=0;
		char *pch=strchr(answers[a],'|');
		if(pch)
		{
			tbrk = ((long)pch)-((long)answers[a]);
			if(tbrk > 255)tbrk=0;
			pch++;
		}
		if(tbrk>0)
		{	
			// we have a description
			strncpy(title,answers[a],tbrk);
			strncpy(desc ,pch       ,255);
		}
		else
		{
			strncpy(title,answers[a],255);

		}
		//######################### allocate the tile
		
		liqtile *titem=liqtile_createquick(title,xx,yy,tilew,tileh);
		titem->style=stylemenuitemstd;
		titem->handlermouse=titem_mouse;
		titem->handlerpaint=titem_paint;
		titem->data=(void *)a;		// store the index here :)
		
		
		liqtile_pageautoloadbytitle(titem,app.userpath);
		liqtile_childappend(tbody,titem);
		
			// declare the editor..
			liqtile *titemedit=liqtile_createquick("ed",tilew-tilew/10,0,tilew/10,tileh/10);
			//titemedit->visible=0;
			titemedit->style=stylebutton; //edit;
			titemedit->handlermouse=titemedit_mouse;
			titemedit->data=(void *)a;		// store the index here :)
			liqtile_childappend(titem,titemedit);
			
			
			
	

		
		c=c+1;
		if(c>=ccols){c=0;r=r+1;}
	}

	//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ RUN
	
	app_log("menu running");
	int runfast=0;
	liqtile_easyrun2(tmenu,&runfast);
	
	
	//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ shutdown
		
	app_log("menu closing tile");
	liqtile_close(tmenu);
	
	mk_style_close();
	
	app_log("menu complete");

	return result;

}



