/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * on screen keyboard
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>


#include "liqapp.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "filebuf.h"
#include "liqdoc.h"

#include "liqtile.h"
#include "liqtextbuffer.h"


#include "mk_core.h"

static int titlebuffermaxlen=0;
static TB titlebuffer={NULL,0};

//##########################################################################	
//##########################################################################	
//##########################################################################

#define ABS(x) ((x)<0?-(x):(x))
#define SGN(x) ((x)<0?-1:(x)==0?0:1)

static liqtile *liqtileroot=NULL;
static liqtile *liqtilehot=NULL;
static liqtile *liqtilesel=NULL;

static liqtile *keytext=NULL;
static liqtile *keytitle=NULL;

static liqtile *keydelete=NULL;
static liqtile *keyenter=NULL;




static int keytext_paint(struct liqtile *self,liqtileeventpaint *args)
{

	// render as normal
	self->handlerpaint=NULL;
	liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
	self->handlerpaint=keytext_paint;
	// now, paint the text and cursor
	
	//if((!self->style) || (!self->style->textfont)) return 0;
	
	
	LIQFONT *font=canvas.font;//self->style->textfont;
		int x=0;
		int y=0;
		liqtile_getabsoluteoffset(self,&x,&y);
		
		x+=self->x;
		y+=self->y;
		
		int w=self->w;
		int h=self->h;
	
	
		int tl=x;
		int tt=y;
		
	
	if(!titlebuffer.buffer)
	{
		// no buffer yet
		//cliprect_drawtextinside(args->cr,font,x,y,w,h ,"", 0);
		
	}
	else	
	{
		
		
		cliprect_drawtextinside(args->cr,font,x,y,w,h ,titlebuffer.buffer, 0);
		
		
	
		
		

	}	
		// draw the caret
		// first get its size
		int xx=liqfont_textwidthn(font, titlebuffer.buffer,                         titlebuffer.cursorpos);				
		int ww=liqfont_textwidthn(font, &titlebuffer.buffer[titlebuffer.cursorpos], titlebuffer.cursorlen);
			canvas_line(tl+xx-1, tt,   tl+xx+ww-1, tt+h-1, 255);
			canvas_line(tl+xx  , tt,   tl+xx+ww,   tt+h-1, 128);
			canvas_line(tl+xx+1, tt,   tl+xx+ww+1, tt+h-1, 255);

	
	return 0;
}






static int key_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	// user is drawing a box on page
	
	if(args->mez!=0)
	{
		//app_log("testkey !=0 start %i, %s %i",(int)self, self->key,args->mez);
		self->style=stylekeycapsel;
		//self->visible=1;
	}
	else
	{
		app_log("testkey ==0 fin   %i, %s %i",(int)self, self->key,args->mez);
		self->style=stylekeycap;
		//self->visible=0;

				if((titlebuffer.bufferlen<titlebuffermaxlen) && self->title && *self->title)
				{
					char ch[2]={0,0};
					ch[0]=self->title[0];
					tb_insert( &titlebuffer,&ch[0] );
				}

	}
	return 0;
}

static int keydelete_click(struct liqtile *self)
{
			if(titlebuffer.bufferlen>0)
			{
				// we have a buffer to delete
				if(titlebuffer.cursorlen==0)
				{
					// just delete 1 char to our left if possible
					if(titlebuffer.cursorpos>0)
					{
						titlebuffer.cursorpos--;
						titlebuffer.cursorlen=1;
						tb_insertn(&titlebuffer,"",0);
					}
				}
				else
				{
					// replace selection with ""
					tb_insertn(&titlebuffer,"",0);
				}
			}
			
	return 0;
}

static int keyenter_click(struct liqtile *self)
{
	return 1;
}


//######################################################################
//######################################################################
//######################################################################
static liqtile *mkframe(liqtile *self,char *title,int w,int h)
{
	liqtile *ch= liqtile_createquick(title,0,0,w,h);
	//liqtile_pageautoloadbytitle_apg(ch);
	liqtile_childappend(self,ch);
	return ch;
}


//######################################################################
//######################################################################
//######################################################################




//######################################################################
//######################################################################
//######################################################################
static liqtile *keyboard=NULL;
static liqtile *keyrow=NULL;
static void keyrowstart(char *title)
{
	keyrow = mkframe(keyboard,title,liqtileroot->w,liqtileroot->h/6);
	//keyrow->handlermouse=key_mouse;
	
		
}
static liqtile *keystd(int keysize,char *keycode,char *normal,char *caps)
{
	float sizes[9] = { 1.0,      1.0, 1.2, 1.4, 1.6, 1.8, 2.0, 6.0, 20.0};
	// width/15
	if(keysize<0 || keysize>7) keysize=0;
	int w=(int)   ((float)(liqtileroot->w/16) * sizes[keysize]);
	liqtile *key;
	
	if(*keycode)
	{
		key = mkframe(keyrow,keycode,w,liqtileroot->h/7);
		liqtile_titlechange(key,normal);
		key->style=NULL;
	}
	else
	{
		key = mkframe(keyrow,normal,w,liqtileroot->h/7);
		key->style=stylekeycap;
		key->handlermouse=key_mouse;
	}
	return key;
	
}
static void keyrowend()
{
	liqtile_childarrange_row(keyrow);
	liqtile_resizetofitcontent(keyrow);
	keyrow=NULL;
}


static void keysmake()
{
	
	keyboard = mkframe(liqtileroot,"keyboard",liqtileroot->w,liqtileroot->h);
	//keyrowstart("data");
	//keyrowend();


	keyrowstart("num");
//		keystd(1,"ESC","","");
		keystd(1,"",   "`" ,"");
		keystd(1,"",   "1" ,"!");
		keystd(1,"",   "2" ,"\"");
		keystd(1,"",   "3" ,"");
		keystd(1,"",   "4" ,"$");
		keystd(1,"",   "5" ,"%");
		keystd(1,"",   "6" ,"^");
		keystd(1,"",   "7" ,"&");
		keystd(1,"",   "8" ,"*");
		keystd(1,"",   "9" ,"(");
		keystd(1,"",   "0" ,")");
		keystd(1,"",   "-" ,"_");
		keystd(1,"",   "=" ,"+");
		//keystd(2,"BSP","","");
	keyrowend();
	
	keyrowstart("qwerty");	
		keystd(3,"","\t","");
		keystd(1,"",   "q" ,"Q");
		keystd(1,"",   "w" ,"W");
		keystd(1,"",   "e" ,"E");
		keystd(1,"",   "r" ,"R");
		keystd(1,"",   "t" ,"T");
		keystd(1,"",   "y" ,"Y");
		keystd(1,"",   "u" ,"U");
		keystd(1,"",   "i" ,"I");
		keystd(1,"",   "o" ,"O");
		keystd(1,"",   "p" ,"P");
		keystd(1,"",   "[" ,"{");
		keystd(1,"",   "]" ,"}");
		//keystd(2,"CR","","");
	keyrowend();
	
	keyrowstart("asdf");		
		keystd(4,"CLK","","");
		keystd(1,"",   "a" ,"A");
		keystd(1,"",   "s" ,"S");
		keystd(1,"",   "d" ,"D");
		keystd(1,"",   "f" ,"F");
		keystd(1,"",   "g" ,"G");
		keystd(1,"",   "h" ,"H");
		keystd(1,"",   "j" ,"J");
		keystd(1,"",   "k" ,"K");
		keystd(1,"",   "l" ,"L");
		keystd(1,"",   ";" ,":");
		keystd(1,"",   "'" ,"@");
		keystd(1,"",   "#" ,"~");
		//keystd(2,"CR","","");
	keyrowend();
	
	keyrowstart("zxcv");		
		keystd(5,"SHL","","");
		//keystd(1,"",   "\\","|");
		keystd(1,"",   "z" ,"Z");
		keystd(1,"",   "x" ,"X");
		keystd(1,"",   "c" ,"C");
		keystd(1,"",   "v" ,"V");
		keystd(1,"",   "b" ,"B");
		keystd(1,"",   "n" ,"N");
		keystd(1,"",   "m" ,"M");
		keystd(1,"",   "," ,"<");
		keystd(1,"",   "." ,">");
		keystd(1,"",   "/" ,"?");
		keystd(1,"",   "@" ,"@");
		//keystd(6,"SHR","","");
	keyrowend();
	
	keyrowstart("bottom");		
		keystd(3,"CTL","","");
		keystd(3,"WN1","","");
		keystd(3,"ALT","","");
		keystd(7,""," ","");
		//keystd(3,"ALG","","");
		//keystd(3,"WN2","","");
		//keystd(3,"CNT","","");
		//keystd(3,"CTR","","");
	keyrowend();
					
	
	liqtile_childarrange_col(keyboard);
	liqtile_resizetofitcontent(keyboard);
}











//handlerevent



static int tileroot_event(struct liqtile *self,LIQEVENT *ev)
{
	// grab keys here :)
	
	
		
	if( (ev->type == LIQEVENT_TYPE_KEY) && (ev->state==LIQEVENT_STATE_PRESS))
	{
		app_log("key event!!!!! %i: %s",ev->key.keycode,ev->key.keystring);

		if( (ev->key.keycode==65288) )
		{
			app_log("keyBS");
			// backspace/delete			
			return keydelete_click(self);		
		}
		else if( (ev->key.keycode==65421) )   // ENTER
		{
			app_log("keyENTER");
			// done :)
			return keyenter_click(self);
		}
		else if( (*ev->key.keystring) && (titlebuffer.bufferlen<titlebuffermaxlen) )
		{
			// extend the keybuffer item
			tb_insert( &titlebuffer,ev->key.keystring );
		}
	}
	return 0;
}








int liqkeyboard_run(char *title,char *databuf,int datamaxlength)
{
	
	titlebuffermaxlen = datamaxlength;
	
	tb_clear( &titlebuffer );
	
	
	tb_insert( &titlebuffer, databuf );
	
	
	if(mk_style_open() != 0)
	{
		return app_warnandcontinue(-1,"Couldnt open default styles");
	}
	
	

	
	
	//######################################################### create the tree
	
	liqtileroot = liqtile_createquick("root",0,0,canvas.pixelwidth ,canvas.pixelheight);
	liqtileroot->style=stylemenuback;
	liqtileroot->handlerevent = tileroot_event;
	liqtilehot=NULL;
	liqtilesel=NULL;



		keysmake();

		keytitle = mkframe(liqtileroot, title, canvas.pixelwidth,liqtileroot->h/7);
		keytitle->style = styletitle;
		//keytitle->handlerpaint = keytitle_paint;
		
		keytitle->x=(liqtileroot->w-keytitle->w)/2;
		liqtile_update_boundfrompos(keytitle);



		keytext = mkframe(liqtileroot,"",keyboard->w,liqtileroot->h/7);
		keytext->style = styletext;
		keytext->handlerpaint = keytext_paint;
		
		keytext->x=(liqtileroot->w-keytext->w)/2;
		keytext->y=keytitle->h;
		liqtile_update_boundfrompos(keytext);



		keydelete = mkframe(liqtileroot,"<",keyboard->w/5,liqtileroot->h/3);
		keydelete->style = stylekeycap;
		//keydelete->handlerpaint = keydelete_paint;
		
		
		keydelete->x=(liqtileroot->w-keydelete->w);
		keydelete->y=keytitle->h+keytext->h;
		liqtile_update_boundfrompos(keydelete);
		keydelete->handlerclick=keydelete_click;
		

		keyenter = mkframe(liqtileroot,"->",keyboard->w/5,liqtileroot->h/3);
		keyenter->style = stylekeycap;
		//keyenter->handlerpaint = keyenter_paint;
		
		keyenter->x=(liqtileroot->w-keyenter->w);
		keyenter->y=keytitle->h+keytext->h+keydelete->h+1;
		liqtile_update_boundfrompos(keyenter);
		keyenter->handlerclick=keyenter_click;

	
		liqtile_resizetofactor(keyboard,
									keyboard->w,keyboard->h,
									canvas.pixelwidth-keydelete->w,canvas.pixelheight-keytext->h-keytitle->h-1);
		
		
		keyboard->y = keytitle->h+keytext->h+1;
		liqtile_update_boundfrompos(keyboard);


		int close_click(liqtile *self)
		{
			return -1;
		}

		liqtile *cmd_close=liqtile_createquick("close",0,0,canvas.pixelwidth/10,canvas.pixelheight/8);
		cmd_close->style=stylebutton;
		cmd_close->handlerclick=close_click;
		cmd_close->x=canvas.pixelwidth-cmd_close->w;
		liqtile_update_boundfrompos(cmd_close);

		liqtile_childappend(liqtileroot,cmd_close);

	


	//liqtile_resizetofitcontent(liqtileroot);

int result=0;
int rf=0;// 1;     woglinde noticed it was running fast


	canvas_clear(0);


	result = liqtile_easyrun2(liqtileroot,&rf);
	
	app_log("keyboard result=%i",result);
	

	liqtile_close(liqtileroot);



	mk_style_close();
	
	if(result && titlebuffer.buffer && *titlebuffer.buffer)
	{
		snprintf(databuf,datamaxlength,"%s",titlebuffer.buffer);
	}
	else
	{
		*databuf=0;//snprintf(databuf,datamaxlength,"");
	}
	//tb_clear( &titlebuffer );
	
	return result;
}

