#ifndef LIQIMAGE_H
#define LIQIMAGE_H

// wget --post-file=testsketch.page -p http://liqbase.net/push_sketch.php 

typedef struct liqimage 	// you might recognise this as deriving from the XVImage structure :)
{
	int width;
	int height;
	int data_size;
	int num_planes;
	int *offsets;
	int *pitches;
	char *data;
	int dpix;
	int dpiy;
	void *XVImageSource;		// set if this image is initialized from an XVImage structure (ie uses other memory)
}
	liqimage;



liqimage *	liqimage_create();
liqimage *  liqimage_createfromfilejpeg(	char *filename);
liqimage *	liqimage_createfromfilepng(		char *filename,int allowalpha);
void 		liqimage_free(					liqimage *self);
void 		liqimage_pagereset(				liqimage *self);
void 		liqimage_pagedefine(			liqimage *self,int w,int h,int dpix,int dpiy,int hasalpha);
void 		liqimage_pagedefinefromXVImage(	liqimage *self,void *XvImagePtr,int dpix,int dpiy);
//int 		liqimage_pageloadjpeg(			liqimage *self,char * filename);
int 		liqimage_pageloadjpeg(			liqimage *self,char * filename,int maxw,int maxh);
int 		liqimage_pageloadpng(			liqimage *self,char * filename,int maxw,int maxh,int allowalpha);


int 		liqimage_pagesavepng(liqimage *self,char * filename);
#endif
