

#include <stdlib.h>
#include <stdio.h>

#include <memory.h>


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/extensions/Xv.h>
#include <X11/extensions/Xvlib.h>


#include <png.h>
#include <setjmp.h>
#include <jpeglib.h>



#include "liqapp.h"
#include "liqimage.h"



#include "liqcliprect.h"


liqimage *liqimage_createfromfilejpeg(char *filename)
{

		//app.infologgingenabled=0;
		liqimage *self=liqimage_create();
		if(liqimage_pageloadjpeg(self,filename,0,0)!=0)
		{
			// failed..
			liqimage_free(self);
			//app.infologgingenabled=1;
			return NULL;
		}

		// ok
		return self;
		//app.infologgingenabled=1;
}


liqimage *liqimage_createfromfilepng(char *filename,int allowalpha)
{

		//app.infologgingenabled=0;
		liqimage *self=liqimage_create();
		if(liqimage_pageloadpng(self,filename,0,0,allowalpha)!=0)
		{
			// failed..
			liqimage_free(self);
			//app.infologgingenabled=1;
			return NULL;
		}

		// ok
		return self;
		//app.infologgingenabled=1;
}


liqimage *liqimage_create()
{
	liqimage *self = (liqimage *)malloc(sizeof(liqimage));
	if(self==NULL) {  app_errorandfail(-1, "liqimage creation failed" ); return NULL; }
	// NULL everything
	memset((char *)self,0,sizeof(liqimage));
	return self;
}

void liqimage_free(liqimage *self)
{
	app_log("liqimage free");
	liqimage_pagereset(self);
	free(self);
}

void liqimage_pagereset(liqimage *self)
{
	app_log("liqimage pagereset");
	
	
	
	
	
	if(self->XVImageSource)
	{
		// data comes from xv
		if(self->offsets)free(self->offsets);
		if(self->pitches)free(self->pitches);
	}
	else
	{
		if(self->offsets)free(self->offsets);
		if(self->pitches)free(self->pitches);
		if(self->data)   free(self->data);		
	}
	
	
	memset((char *)self,0,sizeof(liqimage));	
}

void liqimage_pagedefine(liqimage *self,int w,int h,int dpix,int dpiy,int hasalpha)	// result plane count: 3=YUV, 4=YUVA
{
	//if(picbuff_ready) return;
	
	app_log("liqimage pagedefine(%i,%i) dpi(%i,%i) hasalpha=%i",w,h,dpix,dpiy,hasalpha);
	
	liqimage_pagereset(self);
	
int num_planes;

	if(hasalpha)
		num_planes=4;
	else
		num_planes=3;

int *picoffsets=malloc(sizeof(int)*num_planes);
	if(!picoffsets)
	{
		app_log("image: page defined could not alloc offsets");
		return;
	}

		

	picoffsets[0] = 0;
	picoffsets[1] = w * h;
	picoffsets[2] = picoffsets[1] + ((w/2) * (h/2));
	if(hasalpha)
		picoffsets[3] = picoffsets[1] + ((w/2) * (h/2)) * 2;
	
int *picpitches=malloc(sizeof(int)*num_planes);

	if(!picpitches)
	{
		app_log("image: page defined could not alloc pitches");
		return;
	}
	
	picpitches[0] = w;
	picpitches[1] = w/2;
	picpitches[2] = w/2;
	if(hasalpha)
		picpitches[3] = w;
	
	self->width      = w;
	self->height     = h;
	self->data_size  = (w * h) + ( 2 * ((w/2) * (h/2)) ) + (hasalpha ? (w * h) : 0);
	self->num_planes = num_planes;
	self->offsets    = picoffsets;
	self->pitches    = picpitches;
	self->data       = malloc(self->data_size);
	if(!self->data)
	{
		app_log("image: page defined could not alloc plane data");
		return;
	}
	
	memset((char *)self->data,0,self->data_size);

	
	self->XVImageSource = NULL;
	self->dpix = dpix;
	self->dpiy = dpiy;

	//app_log("liqimage pagedefine end");
	
	
}

void liqimage_pagedefinefromXVImage(liqimage *self,void *XvImagePtr,int dpix,int dpiy)
{
XvImage *XvImage=XvImagePtr;
	//if(picbuff_ready) return;
	
	app_log("liqimage pagedefinefromxv");
	
	liqimage_pagereset(self);
	
int w=XvImage->width;
int h=XvImage->height;
int num_planes=XvImage->num_planes;
	if(num_planes>3)num_planes=3;

int *picoffsets=malloc(sizeof(int)*num_planes);
int *picpitches=malloc(sizeof(int)*num_planes);
int i;
	for(i=0;i<num_planes;i++)
	{	
		picoffsets[i] = XvImage->offsets[i];
		picpitches[i] = XvImage->pitches[i];
	}

	self->width      = w;
	self->height     = h;
	self->data_size  = XvImage->data_size;
	self->num_planes = num_planes;
	self->offsets    = picoffsets;
	self->pitches    = picpitches;
	self->data       = XvImage->data;
	self->XVImageSource = XvImagePtr;
	self->dpix = dpix;
	self->dpiy = dpiy;
	


	app_log("liqimage pagedefinefromxv end");
	
}


/******************** JPEG DECOMPRESSION SAMPLE INTERFACE *******************/
//have a look here for example of saving: http://local.wasp.uwa.edu.au/~pbourke/libraries/jpeg.c
// and this for optimizations: http://mail.kde.org/pipermail/digikam-devel/2007-February/010596.html

//http://download.gna.org/pdbv/demo_html/demo_2.0.10/package/libjpeg62-dev_6b-9.html
//https://stage.maemo.org/svn/maemo/projects/haf/trunk/osso-af-utils/src/fb-progress.c
//http://www.koders.com/c/fid52761211B5999D23A81D29A394002B18BA57AE58.aspx
// has png inside...


struct liqimage_jpeg_error_mgr
{
	struct jpeg_error_mgr pub;
	jmp_buf setjmp_buffer;
};
typedef struct liqimage_jpeg_error_mgr * liqimage_jpeg_error_ptr;

void liqimage_jpeg_error_exit(j_common_ptr cinfo)
{
	liqimage_jpeg_error_ptr myerr = (liqimage_jpeg_error_ptr) cinfo->err;
	//(*cinfo->err->output_message) (cinfo);
	longjmp(myerr->setjmp_buffer, 1);
}




int liqimage_pageloadjpeg(liqimage *self,char * filename,int maxw,int maxh)
{
	// why did this take so much code for such a straight forward job?
	// will I have to go through similar for other image formats?
	// todo: add new image import formats as required.
struct jpeg_decompress_struct 	cinfo;
struct liqimage_jpeg_error_mgr  jerr;
FILE 							*infile;
char 							*buffer;
int 							row_stride;
	app_log("jpeg.opening '%s'",filename);
	if ((infile = fopen(filename, "rb")) == NULL)
	{
		app_log("jpeg.open failed %s", filename);
		return -1;
	}
	

	
	app_log("jpeg.init jpeglib");
	
	cinfo.err = jpeg_std_error(&jerr.pub);
	jerr.pub.error_exit = liqimage_jpeg_error_exit;
	if (setjmp(jerr.setjmp_buffer))
	{
		jpeg_destroy_decompress(&cinfo);
		fclose(infile);
		app_log("jpeg.failed '%s'", filename);
		return -1;
	}	
	 	
	jpeg_create_decompress(&cinfo);
	
	

	
	app_log("jpeg.init src");
	jpeg_stdio_src(&cinfo, infile);
	app_log("jpeg.read header");
	int JHR = jpeg_read_header(&cinfo, TRUE);
	if(JHR != JPEG_HEADER_OK )
	{
		// jpeg error
		app_log("jpeg.read header failed '%s' JHR %i", filename,JHR);
		return -1;		
	}
	
	switch (cinfo.jpeg_color_space)
	{
		case JCS_YCbCr:
			app_log("jpeg.YUV colorspace detected."); 
			break;
		case JCS_GRAYSCALE:
			app_log("jpeg.Grayscale colorspace detected."); 
			break;
		default:
			app_log("jpeg.Unsupported colorspace detected.");
			return -1;
			break;
	}
	
	// and this for optimizations: http://mail.kde.org/pipermail/digikam-devel/2007-February/010596.html
    // libjpeg supports 1/1, 1/2, 1/4, 1/8
    int scale=1;
	if(maxw && maxh)
	{
		while(scale<8 && (cinfo.image_width>maxw || cinfo.image_height>maxh)) // maximumSize*scale*2<=imgSize)
		{
			scale*=2;
		}
	}
    //if(scale>8) scale=8;
    cinfo.scale_num=1;
    cinfo.scale_denom=scale;
	
	app_log("jpeg.header original image %i,%i",cinfo.image_width,cinfo.image_height);

	
	
	app_log("jpeg.forcing decompress colorspace to yuv");
	cinfo.out_color_space  = JCS_YCbCr;
	app_log("jpeg.start decompress");
	jpeg_start_decompress(&cinfo);
	app_log("jpeg.header output image %i,%i",cinfo.output_width,cinfo.output_height);
	if (cinfo.output_components != 3 && cinfo.out_color_space == JCS_YCbCr)
	{
		app_log("jpeg.expecting 3 planes for YUV");
		return -1;
	}
	if (cinfo.output_components != 1 && cinfo.out_color_space == JCS_GRAYSCALE)
	{
		app_log("jpeg.expecting 1 plane for Greyscale");
		return -1;
	}
	/*
	if(maxw && maxh)
	{
		while(cinfo.output_width>maxw)
		{
			cinfo.output_width/=2;
			cinfo.output_height/=2;
		}
		while(cinfo.output_height>maxh)
		{
			cinfo.output_width/=2;
			cinfo.output_height/=2;
		}
	}
	*/
	liqimage_pagedefine(self, cinfo.output_width, cinfo.output_height,225,225,  0 );
	row_stride = cinfo.output_width * cinfo.output_components;
	int x=0;
	int y=0;
	buffer = malloc( row_stride * sizeof(char) );		// allocate a line block
	int i;
	for (i = 0; i < cinfo.output_components; i++)
	{
		int sh= cinfo.comp_info[i].h_samp_factor;
		int sv= cinfo.comp_info[i].v_samp_factor;
		app_log("samp factor %i h=%i v=%i",i,sh,sv);
	}
	app_log("jpeg max_v_samp_factor= %i, DCTSIZE = %i    *= %i",cinfo.max_v_samp_factor, DCTSIZE,cinfo.max_v_samp_factor * DCTSIZE);
	app_log("jpeg.reading data, at %i of %i",cinfo.output_scanline,cinfo.output_height);

	while (cinfo.output_scanline < cinfo.output_height)
	{
	    jpeg_read_scanlines(&cinfo, (JSAMPARRAY) (void *)(&buffer), 1);
		if(cinfo.output_components==1)
		{
			
			for(x=0;x<cinfo.output_width;x++)
			{
				int dstoff;
				dstoff=self->offsets[0] + (y * (self->pitches[0]) + x);
				self->data[ dstoff ] = buffer[x*cinfo.output_components];
			}
		}
		else
		{
			for(x=0;x<cinfo.output_width;x++)
			{
				int dstoff;
				dstoff=self->offsets[0] + (y * (self->pitches[0]) + x);
				self->data[ dstoff ] = buffer[x*cinfo.output_components];
				if( ((y&1)) && ((x&1)) )
				{
					// handle the color components (at half resolution in this case)
					int xx=x>>1;
					int yy=y>>1;
					dstoff=self->offsets[1] + (yy * (self->pitches[1]) + xx);
					self->data[ dstoff ] = buffer[x*cinfo.output_components+2];
					dstoff=self->offsets[2] + (yy * (self->pitches[2]) + xx);
					self->data[ dstoff ] = buffer[x*cinfo.output_components+1];
				}
			}			
		}
		y++;
		if(y>self->height)break;
	}
	app_log("jpeg.cleanup");
	free(buffer);
	jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);
	fclose(infile);
	app_log("jpeg.complete");
	return 0;
}








//#if 0




/******************** PNG DECOMPRESSION SAMPLE INTERFACE *******************/

// this does not work yet, and will require additional tinkering
//http://www.libpng.org/pub/png/libpng-manual.txt



//https://stage.maemo.org/svn/maemo/projects/haf/trunk/osso-af-utils/src/fb-progress.c


// a further example is here http://www.zarb.org/~gc/html/libpng.html


// more inside enlightenment :)
// http://trac.enlightenment.org/e/browser/trunk/PROTO/enesim/examples/image.c?rev=35582

//static image_info_t *decompress_png(const char *filename)
int liqimage_pageloadpng(liqimage *self,char * filename,int maxw,int maxh,int allowalpha)
{



	
	app_log("png.opening '%s'",filename);
	
	FILE *fp = fopen(filename, "rb");
		if (!fp)
		{
			app_log("png.open failed %s", filename);
			return -1;
		}


	char  header[8];
		fread(header, 1, 8, fp);
		int is_png = !png_sig_cmp(header, 0, 8);
		if (!is_png)
		{
			fclose(fp);
			return -2;
		}
		
	
	png_structp png_ptr = png_create_read_struct (PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
		if (!png_ptr)
		{
			app_log("png.png_ptr fail");
			fclose(fp);
			return -3;
		}
		
		
		
	png_infop info_ptr = png_create_info_struct(png_ptr);
		if (!info_ptr)
		{
			app_log("png.info_ptr fail");
			png_destroy_read_struct(&png_ptr, (png_infopp)NULL, (png_infopp)NULL);
			fclose(fp);
			return -4;
		}
		
		
	png_infop end_info = png_create_info_struct(png_ptr);
		if (!end_info)
		{
			app_log("png.end_info fail");
			png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
			fclose(fp);
			return -5;
		}
		
		
		png_init_io(png_ptr, fp);		
		png_set_sig_bytes(png_ptr, 8);
		
		
		
		
	png_uint_32 	wd=0;
	png_uint_32 	ht=0;
	int 			bit_depth=0;
	int 			color_type=0;

		png_read_info(png_ptr, info_ptr);
		png_get_IHDR(png_ptr, info_ptr, &wd, &ht, &bit_depth, &color_type, NULL, NULL, NULL);


	typedef struct image_info_t
	{
		int wd;
		int ht;
	}
		image_info_t;

	image_info_t 	image;	
		image.wd = wd;
		image.ht = ht;
	
	
	int hasalpha=0;
	int isgray=0;
		if (color_type & PNG_COLOR_MASK_ALPHA)
			hasalpha=1;
			
		// manual forced disable..
		if(!allowalpha)
			hasalpha=0;
			
		// alpha channel not supported. At least not yet...   well - we might do
		//if(hasalpha)
			//png_set_strip_alpha(png_ptr);
	
		if(color_type & PNG_COLOR_MASK_COLOR)
		{
			app_log("color............");
			
		}
		else
		{
			app_log("gray............");
			isgray=1;
		}
	
		/* transfer image to RGB if not already */
		if (color_type != PNG_COLOR_TYPE_RGB)
		{
			png_set_expand(png_ptr); 
		}

		/* we are pleased with 8 bit per pixel */
		if (bit_depth == 16) 
			png_set_strip_16(png_ptr);
			
			
		//// we want RGBA
		//png_set_filler (png_ptr, 0, PNG_FILLER_AFTER);
	
		png_read_update_info(png_ptr, info_ptr);
		
		
		
	png_uint_32 rowbytes = png_get_rowbytes(png_ptr, info_ptr);
	
	// ensure we are an even number of units wide (required for alpha reduced viewing)
	if(image.wd & 1 )image.wd--;
	if(image.ht & 1 )image.ht--;

	
	liqimage_pagedefine(self, image.wd, image.ht,225,225, hasalpha );
	
	image.wd = wd;
	image.ht = ht;

	
	
	app_log("png: rowbytes=%i",rowbytes);
	
	
	char * image_data = malloc(rowbytes * image.ht);
		if(!image_data)
		{
			app_log("png.image_data malloc fail");
			png_destroy_read_struct(&png_ptr, &info_ptr, &end_info);
			fclose(fp);
			return -6;
		}
	
	png_bytepp row_pointers = malloc(image.ht * sizeof(png_bytep));
		if(!row_pointers)
		{
			app_log("png.row_pointers malloc fail");
			free(image_data);
			png_destroy_read_struct(&png_ptr, &info_ptr, &end_info);
			return -7;
		}
	app_log("png reading data");
	int i=0;
	//int j=0;	
		for (i = 0;  i < image.ht; i++)
			row_pointers[i] = image_data + i * rowbytes;
	
		// read the whole image ?
		// is this right ?
		// ahh well it must be
			
		png_read_image(png_ptr, row_pointers);
		
		
		// now, the image_data and rot_buffers memory contains valid RGB png data.
		
		
		// quickly try and load greyscale from it :)
				
	// recurse and grab data

	//int cy00=0;			
	int x=0;
	int y=0;
	int bytesperpixel = rowbytes / image.wd;// hasalpha ? 4 : 3;
		for(y=0;y<self->height;y++)
		{
			for(x=0;x<self->width;x++)
			{
				int dstoff;
				int srcpix = (y * rowbytes) + (x * bytesperpixel);

				//dstoff=self->offsets[0] + (y * (self->pitches[0]) + x);
				//self->data[ dstoff ] = image_data[srcpix];
				//if(hasalpha)
				//{
				//	dstoff=self->offsets[3] + (y * (self->pitches[3]) + x);
				//	self->data[ dstoff ] = image_data[srcpix + 3];
				//}
				
				char ir;
				char ig;
				char ib;
				char ia;
				
				int cy;
				int cv;
				int cu;

	
				if(isgray==0)
				{
					ir = image_data[ srcpix    ];
					ig = image_data[ srcpix +1 ];
					ib = image_data[ srcpix +2 ];
					
					//http://msdn.microsoft.com/en-us/library/ms893078.aspx
					// yes, microsoft are useful :)
					
					cy = ( (  66 * ir + 129 * ig +  25 * ib + 128) >> 8) +  16;
					cv = ( ( -38 * ir -  74 * ig + 112 * ib + 128) >> 8) + 128;
					cu = ( ( 112 * ir -  94 * ig -  18 * ib + 128) >> 8) + 128;
	
	
					dstoff=self->offsets[0] + (y * (self->pitches[0]) + x);
					self->data[ dstoff ] = cy;//image_data[srcpix];
	
					dstoff=self->offsets[1] + ((y>>1) * (self->pitches[1]) + (x>>1));
					self->data[ dstoff ] = cu;//image_data[srcpix+1];
	
					dstoff=self->offsets[2] + ((y>>1) * (self->pitches[2]) + (x>>1));
					self->data[ dstoff ] = cv;//image_data[srcpix+2];
	
					if(hasalpha)
					{
						ia = image_data[ srcpix +3 ];
						dstoff=self->offsets[3] + (y * (self->pitches[3]) + x);
						self->data[ dstoff ] =ia;//(cy==cy00) ? 0 : 255; // image_data[(y * rowbytes) + ((x * bytesperpixel)+3)];
					}
	
				}
				else
				{
	
					cy = image_data[ srcpix    ];
	
	
					dstoff=self->offsets[0] + (y * (self->pitches[0]) + x);
					self->data[ dstoff ] = cy;
	
					dstoff=self->offsets[1] + ((y>>1) * (self->pitches[1]) + (x>>1));
					self->data[ dstoff ] = 128;
	
					dstoff=self->offsets[2] + ((y>>1) * (self->pitches[2]) + (x>>1));
					self->data[ dstoff ] = 128;
	
					if(hasalpha)
					{
						ia = image_data[ srcpix +1 ];
						dstoff=self->offsets[3] + (y * (self->pitches[3]) + x);
						self->data[ dstoff ] =ia;//(cy==cy00) ? 0 : 255; // image_data[(y * rowbytes) + ((x * bytesperpixel)+3)];
					}
				}
			}
		}
		

		png_destroy_read_struct(&png_ptr, &info_ptr, &end_info);
		free(row_pointers);
		free(image_data);
		fclose(fp);

		app_log("png finished");

		return 0;
}


//#endif // 0
		
/*	
	image.pixel_buffer = malloc(image.wd * image.ht *  sizeof(uint16_t));
	if (!image.pixel_buffer) {
		fprintf(stderr, "Not enought memory\n");
		free(image_data);
        png_destroy_read_struct(&png_ptr, &info_ptr, &end_info);
		return NULL;
	}
	      
	int k=0;
	for (j = 0; j < image.ht; j++) {
		uint8_t *picture = row_pointers[j];
		uint16_t red, green, blue;
		for (i = 0; i < image.wd; i++) {
			red = (*picture++ >> 3);
			green = (*picture++ >> 2);
			blue = (*picture++ >> 3);
			
			*(image.pixel_buffer + k) = red << 11 | green << 5 | blue;
			k++;
		}
	}
 */






























































int liqimage_pagesavepng(liqimage *self,char * filename)
{
	//
	app_log("png save called %i,%i: to '%s'",self->width,self->height,filename);
	FILE *outf = fopen(filename,"wb");
	if(!outf)
	{
		return app_warnandcontinue(-1,"png Couldn't open file for writing");
	}
	
	
	//####################### configure the target features
	
	app_log("png configuring dest type");
	// i have 1 to 4 planes
	// 1==greyscale
	// 2=grey+alpha
	// 3=YUV
	// 4=YUV+alpha
	
	int png_color_type=PNG_COLOR_TYPE_RGB;
    int png_depth=8;
	int png_bytesperpixel=4;

	switch(self->num_planes)
	{
		case 1:
			png_depth = 8;
			png_color_type = PNG_COLOR_TYPE_GRAY;
			png_bytesperpixel=1;
			break;
		
		
		case 2:
			png_depth = 8;
			png_color_type = PNG_COLOR_TYPE_GRAY;
			png_bytesperpixel=4;
			break;
		
		case 3:
			png_depth = 8;
			png_color_type = PNG_COLOR_TYPE_RGB;
			png_bytesperpixel=3;
			break;
		
		case 4:
			png_depth = 8;
			png_color_type = PNG_COLOR_TYPE_RGB_ALPHA;
			png_bytesperpixel=4;
			break;
	}
	
	
	

    //####################### allocate and intialise RGB buffer
	
	
	
	// ####################################### allocate buffer
	png_struct *png_ptr;
    png_info *info_ptr;
	
    png_byte **rowoffsets;
	int x,y;
	app_log("png allocating rgb buffer");
	char *rgbabuffer = malloc(png_bytesperpixel * self->width * self->height);		// alloc rgb buffer RGBA
    if (!rgbabuffer)
	{
		fclose(outf);
		return app_warnandcontinue(-1,"png Couldn't allocate rgbabuffer");
    }
	// ####################################### convert YUV image into RGB
	app_log("png converting yuv to rgb");
	unsigned char iy,iu,iv;
	cliprect icr;
	cliprect_initfromimage(&icr,self);
	for(y=0;y<self->height;y++)
	{
		for(x=0;x<self->width;x++)
		{
			// this is v slow method but is quick and dirty enough to work, will improve later
			cliprect_drawpgetcolor(&icr,x,y,&iy,&iu,&iv);
			// convert YUV -> RGB
			//http://msdn.microsoft.com/en-us/library/ms893078.aspx
			// yes, microsoft are useful :)
			inline unsigned char clip(int indat){ return (indat<0) ? 0 : ( (indat>255) ? 255 : indat) ;  }
			int           ic = iy - 16;
			int           id = iu - 128;
			int           ie = iv - 128;
			unsigned char outr = clip(( 298 * ic            + 409 * ie + 128) >> 8);
			unsigned char outg = clip(( 298 * ic - 100 * id - 208 * ie + 128) >> 8);
			unsigned char outb = clip(( 298 * ic + 516 * id            + 128) >> 8);
			int           outoff = png_bytesperpixel * (y * self->width + x);
			rgbabuffer[outoff  ] = outr;
			rgbabuffer[outoff+1] = outg;
			rgbabuffer[outoff+2] = outb;
			
			if(png_color_type == PNG_COLOR_TYPE_RGB_ALPHA)
			{
				// for now just store this, its wrong, but will have to do
				rgbabuffer[outoff+3] = 255;
			}
			
		}
	}
	// ####################################### now get on with the hard work
	app_log("png allocating row buffer");

    rowoffsets = malloc(sizeof(png_byte*) * self->height);
    if (!rowoffsets)
	{
		fclose(outf);
		return app_warnandcontinue(-1,"png Couldn't allocate rows buffer");
    }
	
	app_log("png filling row buffer");

    for (y=0; y<self->height; y++)
	{
		rowoffsets[y] = (png_byte *) &rgbabuffer[y * self->width * png_bytesperpixel];
	}

	
	app_log("png allocating write struct");
	

    png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
    if (!png_ptr)
	{
		free(rgbabuffer);
		free(rowoffsets);
		fclose(outf);
		return app_warnandcontinue(-2,"png Couldn't allocate png write struct");
    }
	
	app_log("png allocating info struct");

    info_ptr = png_create_info_struct(png_ptr);
    if (!png_ptr)
	{
		png_destroy_write_struct (&png_ptr, &info_ptr);
		free(rgbabuffer);
		free(rowoffsets);
		fclose(outf);
		return app_warnandcontinue(-2,"png Couldn't allocate png info struct");
    }
	
	app_log("png initializing jmpbuf");

    if (setjmp (png_jmpbuf (png_ptr)))
	{
		app_log("png setjmp called, must have an error");
		
		png_destroy_write_struct (&png_ptr, &info_ptr);
		free(rgbabuffer);
		free(rowoffsets);
		fclose(outf);
		return app_warnandcontinue(-2,"png setjmp was raised");
    }
	
	
	
	
	
	//####################### prepare the row_writer function
	
//	void png_rowwriter(png_structp png, png_bytep data, png_size_t size)
//	{
//		// do the writing
//		FILE *fp;
//		fp = png_get_io_ptr (png);
//		if (fwrite (data, 1, size, fp) != size)
//			png_error(png, "Write Error");
//	}
//   png_set_write_fn(png_ptr, closure, png_rowwriter, NULL);
	
	app_log("png setting phyx %i,%i",
			
				  (int)(   ((float)(self->width * self->dpix))  * (100.0 / 2.54)   ),
				  (int) (  ((float)(self->height * self->dpiy)) * (100.0 / 2.54)   )
			
			
			);
	
	
	png_set_pHYs(png_ptr, info_ptr,
				  (int)(   (self->width * self->dpix)  * (100.0 / 2.54)   ),
				  (int) (  (self->height * self->dpiy) * (100.0 / 2.54)   ),
					PNG_RESOLUTION_METER);
	
	

	
	//####################### link to io stream
	
	app_log("png linking to io stream");
	png_init_io( png_ptr, outf );

	//####################### declare the header
	
	app_log("png setting header");
    png_set_IHDR (png_ptr, info_ptr,
		  self->width,
		  self->height,
		  png_depth,
		  png_color_type,
		  PNG_INTERLACE_NONE,
		  PNG_COMPRESSION_TYPE_DEFAULT,
		  PNG_FILTER_TYPE_DEFAULT);
	
	
	
	
	
	

 	//####################### set the time
	
	
	app_log("png setting timestamp");
	png_time pt;
		png_convert_from_time_t (&pt, time (NULL));
	    png_set_tIME (png_ptr, info_ptr, &pt);

	
	//####################### create background if required
	
	
    if (png_color_type == PNG_COLOR_TYPE_RGB || png_color_type == PNG_COLOR_TYPE_RGB_ALPHA)
	{
		app_log("png organising background");
		png_color_16 backcolor;
			//backcolor.red = 0xff;		// white
			//backcolor.blue = 0xff;
			//backcolor.green = 0xff;
			
			backcolor.red = 0x00;		// black :D
			backcolor.blue = 0x00;
			backcolor.green = 0x00;

			png_set_bKGD (png_ptr, info_ptr, &backcolor);	
			png_set_bgr(png_ptr);
	}



	
    if (png_color_type == PNG_COLOR_TYPE_RGB)
	{
		app_log("png setting filler");
		png_set_filler (png_ptr, 0, PNG_FILLER_AFTER);
	}
	
	
	
	
	app_log("png setting rows");
	
	png_set_rows( png_ptr, info_ptr, rowoffsets );

	app_log("png writing png");

	png_write_png( png_ptr, info_ptr, PNG_TRANSFORM_IDENTITY, NULL );

	app_log("png cleaning up");

    //png_write_info (png_ptr, info_ptr);
    //png_write_image (png_ptr, rowoffsets);
    //png_write_end (png_ptr, info_ptr);

    png_destroy_write_struct(&png_ptr, &info_ptr);
    free(rowoffsets);
	free(rgbabuffer);
	fclose(outf);
    return 0;
}



// found this ..
//http://www.sfr-fresh.com/unix/privat/transparency-0.1.151-src.tar.gz:a/transparency-0.1.151-src/transparency.cpp
  //437         if (m_res_x > 1e-8 && m_res_y > 1e-8) {
  //438             png_set_pHYs (
  //439                 png_ptr, info_ptr,
  //440                 (int)floor(m_res_x * (100.0 / 2.54)), (int)floor (m_res_y * (100.0 / 2.54)),
  //441                 PNG_RESOLUTION_METER);
  //442         }

	
	
	
	


