
/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * mdule to play with ideas
 *
 */





#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>

#include <pthread.h>



#include "liqapp.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "filebuf.h"
#include "liqdoc.h"
#include "liqkeyboard.h"
#include "liqtile.h"
#include "liqtextbuffer.h"


#include "liqbase_prefs.h"


#include "mk_core.h"



//int liqkeyboard_run(char *title,char *databuf,int datamaxlength);

int liqart2_run_editdocument(PAGE *basepage);



int zoompercent=100;





//static liqimage *imgunknown=NULL;


//##########################################################################	
//##########################################################################	
//##########################################################################

#define ABS(x) ((x)<0?-(x):(x))
#define SGN(x) ((x)<0?-1:(x)==0?0:1)

static liqtile *liqtileroot=NULL;
static liqtile *liqtilehot=NULL;
static liqtile *liqtilesel=NULL;

static liqtile *grid=NULL;
static liqtile *tilezoom=NULL;

static liqtile *filelistroot=NULL;


/*
	liqstyle *stylefile=NULL;
	liqstyle *head=NULL;
	liqstyle *odd=NULL;
	liqstyle *even=NULL;
	liqstyle *knob=NULL;
 */


//######################################################################
//######################################################################
//######################################################################


static liqtile *addframe(liqtile *self,char *key,int w,int h)
{
	liqtile *ch= liqtile_createquick(key,0,0,w,h);
	ch->style=NULL;
	//liqtile_pageautoloadbytitle_apg(ch);
	if(key)
		liqtile_childinsertsortedbykey(self,ch,0);
	else
		liqtile_childappend(self,ch);
	return ch;
}

 
static liqtile *addbutton(liqtile *self,char *key,void *handlerclick)
{
	liqtile *ch= liqtile_createquick(key,0,0,canvas.pixelwidth/16,canvas.pixelheight/10);
	ch->handlerclick=handlerclick;
	ch->style=stylebutton;
	
		
	
	liqtile_pageautoloadbytitle(ch,app.userpath);
	
	
	liqtile_childappend(self,ch);
	return ch;
}

 

//######################################################################
//######################################################################
//######################################################################

//################################################
struct slidedata
{
	int value;
	int min;
	int max;
};

int slide_changevalue(liqtile *self,int newvalue)
{
	// adjust the value and raise the click event :)
	
	struct slidedata *inst =(struct slidedata*)self->data;
	if(!inst)return -1;
	inst->value = newvalue;
	self->tag=newvalue;
	return 0;
}

int slide_mouse(liqtile *self,liqtileeventmouse *args)
{
	// adjust the value and raise the click event :)
	
	struct slidedata *inst =(struct slidedata*)self->data;
	if(!inst)return -1;
	if(inst->max<=inst->min)return -1;
	int ax=0;
	int ay=0;
	liqtile_getabsoluteoffset(self,&ax,&ay);
	ax+=self->x;
	ay+=self->y;
	int y=args->mey-ay;
	
	int yy = y * (inst->max-inst->min) / self->h ;
	if(yy<inst->min)yy=inst->min;
	if(yy>inst->max)yy=inst->max;
	
	inst->value=yy;
	self->tag=yy;
	
	if(args->mez>0)
	{
		//
		if(self->handlerclick)
		{
			return self->handlerclick(self);
		}
	}
	
	return 0;
}
int slide_paint(liqtile *self,liqtileeventpaint *args)
{
	// draw a line at the fraction
	struct slidedata *inst =(struct slidedata*)self->data;
	if(!inst)return -1;
	if(inst->max<=inst->min)return -2;
	int ax=0;
	int ay=0;
	liqtile_getabsoluteoffset(self,&ax,&ay);
	ax+=self->x;
	ay+=self->y;
	int y=inst->value-inst->min;
	
	int yy = y * self->h / (inst->max-inst->min);
	if(yy<0)yy=0;
	if(yy>self->h)yy=self->h;
	
	//cliprect_drawcolorcube(args->cr,  args->ox+self->x,args->oy+self->y+self->h/2,    self->w,16,   128);
	cliprect_drawcolorcube(args->cr,  args->ox+self->x,args->oy+self->y,    self->w,yy,   128);
	
	return 0;
}
int slide_close(liqtile *self)
{
	// could this be a generically callable handler centrally located? - just something to automatically free the data
	if(self->data)
	{
		free(self->data);
		self->data=NULL;
	}
	return 0;
}

static liqtile *mkslide(liqtile *self,char *key,void *handlerclick,int value,int min,int max)
{
	struct slidedata *inst = (struct slidedata*)malloc(sizeof(struct slidedata));
	
	inst->value=value;
	inst->min=min;
	inst->max=max;
	
	liqtile *ch= liqtile_createquick(key,0,0,canvas.pixelwidth/16,canvas.pixelheight/5);
	ch->handlerclick=handlerclick;
	ch->data = (void *)inst;
	ch->tag = inst->value;		// prepare it
	ch->style=stylegrid;
	ch->handlerclose=slide_close;	
	ch->handlerpaint=slide_paint;
	ch->handlermouse=slide_mouse;
	//liqtile_pageautoloadbytitle_apg(ch);
	liqtile_childappend(self,ch);
	return ch;
}




//######################################################################
//######################################################################
//######################################################################
static liqtile *file_current_selection=NULL;

	
	
int filepaint_throttle=0;
	
	static int file_lazyload(struct liqtile *self)
	{
		//app_log("Event lazyload");
		//if((self->data==NULL) && (self->key))// && (filepaint_throttle<5))
		if((self->linkpage==NULL) && (self->key) && (self->visible))// && (filepaint_throttle<5))
		{
			filepaint_throttle++;
			self->visible=0;
			// we must attempt to quickly load the page..
//int 		  page_fileload(PAGE *self,char *filename);
			PAGE *pg = page_alloc();
			//app.infologgingenabled = 0;
			int pgerr=page_fileload(pg,self->key);
			//app.infologgingenabled = 1;
			if(!pgerr)
			{
				self->linkpage=pg;		// bind these together
				pg->owner=self;
				self->visible=1;
				
				//self->data=pg;


					if(!file_current_selection)
					{
						// the first one I *LOAD*, not the first one I create..
						file_current_selection=self;
					}
				
			}
			else
			{
				app_log("lazyload, invalid page: '%s'",self->key);
				self->visible=0;
				page_free(pg);
				return -1;
			}
		}
		return 0;
	}
	
	
	

	
	static int file_paint(struct liqtile *self,liqtileeventpaint *args)
	{
		if(self==file_current_selection)
		{
			cliprect_drawboxfillcolor( args->cr,  args->ox+self->x,args->oy+self->y,self->w,self->h ,0,110,110);
		}

		//if(self->data)
		if(self->linkpage)
		{
			cliprect_drawpage( args->cr,  self->linkpage,  args->ox+self->x,args->oy+self->y,self->w,self->h ,0);
		}
		else
		{
			cliprect_drawimagecolor(args->cr,imgknob,args->ox+self->x,args->oy+self->y,self->w,self->h);
		}
		if(self==file_current_selection)
		{
			cliprect_drawboxlinecolor( args->cr,  args->ox+self->x,args->oy+self->y,self->w,self->h ,30,10,10);
		}

		return 0;
	}
	
	
	static int file_click(struct liqtile *self)//,liqtileeventmouse *args)
	{
		file_current_selection=self;	// that is all :)

		return 0;
	}	
	
	
	
	


static liqtile *mkfileitem(liqtile *self,char *filename)
{

//
//int 		  pagefilename_breakapart(struct pagefilename *self,char *filename);
//char 		  *pagefilename_rebuild(struct pagefilename *self,char *bufferresultfilename,int buffermax);
	liqtile *brk=NULL;
	struct pagefilename *pf=malloc(sizeof(struct pagefilename));
	int pferr=pagefilename_breakapart(pf,filename);
	if(pferr==0)
	{
		// valid file		
		char b[255]={0};
		snprintf(b,5,"%s",pf->filedate); b[4]='\0';
		liqtile *xy=liqtile_childfindkey(self,b);
		if(!xy)
		{
			xy=addframe(self,b,(self->w),self->h/15);
			snprintf(b,5,"%s",pf->filedate); b[4]='\0';
			//brk=addframe(xy,b,(self->w),self->h/15);				// year break tile
			//brk->style=odd;								
		}
			snprintf(b,3,"%s",&pf->filedate[4]); b[2]='\0';
			liqtile *xm=liqtile_childfindkey(xy,b);
			if(!xm)
			{
				xm=addframe(xy,b,(self->w),self->h/15);
				snprintf(b,7,"%s",pf->filedate); b[6]='\0';
				//brk=addframe(xm,b,(self->w),self->h/15);			// month break tile
				//brk->style=odd;
			}
				snprintf(b,3,"%s",&pf->filedate[6]); b[2]='\0';
				liqtile *xd=liqtile_childfindkey(xm,b);
				if(!xd)
				{
					xd=addframe(xm,b,(self->w),self->h/15);
					snprintf(b,9,"%s",pf->filedate); b[8]='\0';
					brk=addframe(xd,b,(self->w),self->h/15);			// day break tile
					brk->style=stylefileseparator;
				}

					
					liqtile *xf=addframe(xd,filename,(self->w/5),self->h/4);
					//liqtile *xf=addframe(xd,filename,(self->w),self->h);
					xf->style=stylefilesketch;
					xf->handlerpaint=file_paint;
					xf->handlerclick=file_click;
					xf->handlerlazyload=file_lazyload;
					

					
					

				int h=liqtile_neatarrange(xd);
				xd->h=h;
				liqtile_update_boundfrompos(xd);


			liqtile_childarrange_col(xm);
		liqtile_childarrange_col(xy);
		free(pf);
		return xy;
				
	}
	free(pf);
}








static liqtile *mkfilelist(liqtile *self,char *path)
{
	liqtile *box= addframe(self,path,self->w,self->h);

		DIR           *dir_p;
		struct dirent *dir_entry_p;
		dir_p = opendir(path);
		
			
		if(!dir_p)
		{
			app_log("opendir failed: '%s'",path);
			return NULL;			// heh thanks kot :)
		}
			
		
		//char filename[1024]="\0";
		while( NULL != (dir_entry_p = readdir(dir_p)))
		{
			char fn[1024];
			snprintf(fn,1024,"%s/%s", path,dir_entry_p->d_name);
			mkfileitem(box,fn);
		}
		closedir(dir_p);

		liqtile_childarrange_col(box);
		
	return box;
	
	
}







int zoomfilesto(liqtile *self,int newpercentage)
{
	liqtile *c=self->linkchild;
	int found=0;
	while(c)
	{
		if(c->style==stylefilesketch)
		{
			//c->w = (grid->w/5) * 100 / newpercentage;
			//c->h = (grid->h/4) * 100 / newpercentage;

			c->w = (grid->w/5) * newpercentage / 100;
			c->h = (grid->h/4) * newpercentage / 100;


			liqtile_update_boundfrompos(c);
			found++;
		}
		zoomfilesto(c,newpercentage);
		c=c->linknext;
	}
	if(found)
	{
		int h=liqtile_neatarrange(self);
		self->h=h;
		liqtile_update_boundfrompos(self);
		liqtile *p=self->linkparent;
		while((p) && (p!=filelistroot))
		{
			liqtile_childarrange_col(p);
			p=p->linkparent;
		}
	}

	return found;
}

























int liqgraffiti_run()
{
	
	app_log("graffiti starting");
	char *pref = liqbase_pref_getvalue("graffiti_zoompercent");
	if(pref)
		zoompercent = atoi(pref);
	else
		zoompercent=100;
		
	if(zoompercent==0)zoompercent=100;
	if(zoompercent<10)zoompercent=10;
	if(zoompercent>400)zoompercent=400;	
	
	
	
	file_current_selection=NULL;
	
int arg_mode_fastrefresh=0;
int running=1;



	int zoom_click(struct liqtile *self)//,liqtileeventmouse *args)
	{
		app_log("zoom in now %i",self->tag);
		zoompercent=self->tag;
		if(zoompercent==0)zoompercent=100;
		if(zoompercent<10)zoompercent=10;
		if(zoompercent>400)zoompercent=400;
		zoomfilesto(filelistroot,zoompercent);
		liqtile_childarrange_col(filelistroot);
		liqtile_floatprepare(grid);
		return 0;
	}
	
	
	
	int btn_reset(struct liqtile *self)//,liqtileeventmouse *args)
	{		
		zoompercent=100;
		zoomfilesto(filelistroot,zoompercent);
		liqtile_childarrange_col(filelistroot);
		liqtile_floatprepare(grid);
		return 0;
	}

	int btn_plus(struct liqtile *self)//,liqtileeventmouse *args)
	{		
		
		zoompercent+=10;
		if(zoompercent>400)zoompercent=400;
		// menu.zoom
		slide_changevalue(tilezoom,zoompercent);
		zoomfilesto(filelistroot,zoompercent);
		liqtile_childarrange_col(filelistroot);
		liqtile_floatprepare(grid);
		return 0;
	}

	int btn_minus(struct liqtile *self)//,liqtileeventmouse *args)
	{
		
		zoompercent-=10;
		if(zoompercent<10)zoompercent=10;
		slide_changevalue(tilezoom,zoompercent);
		zoomfilesto(filelistroot,zoompercent);
		liqtile_childarrange_col(filelistroot);
		liqtile_floatprepare(grid);
		return 0;
	}
 
	int btn_close(struct liqtile *self)//,liqtileeventmouse *args)
	{
		app_log("Event Close");
		running=0;
		return 1;
	}
	




	



	int btn_tags(struct liqtile *self)//,liqtileeventmouse *args)
	{
		//if(args->mez) return 0;	// do nothing unless we are finishing a stroke
		app_log("Event tags");
		return 0;
	}
	
	
	
		
	int btn_new(struct liqtile *self)//,liqtileeventmouse *args)
	{
		//if(args->mez) return 0;	// do nothing unless we are finishing a stroke
		app_log("Event new");

		app_log("new fail, not ready yet, i can do it, but it will mean having to rescan");
		return -1;

		return 0;
	}
	
	
	
	
	static int root_event(struct liqtile *self,LIQEVENT *ev)
	{
		// grab keys here :)
		
		
			
	
		//app_log("event!!!!! %i",ev->key.keycode);
		
		
				if( (ev->type == LIQEVENT_TYPE_KEY) && (ev->state==LIQEVENT_STATE_PRESS) && (ev->key.keycode==65477) )	//Zoom -
				{
					app_log("event!!!!! keypress zoom- %i",ev->key.keycode);
					btn_minus(self);				
	
				}
				else if( (ev->type == LIQEVENT_TYPE_KEY) && (ev->state==LIQEVENT_STATE_PRESS) && (ev->key.keycode==65476) )	//Zoom +
				{
					app_log("event!!!!! keypress zoom+ %i",ev->key.keycode);
					btn_plus(self);
					
	
				}
				return 0;
	}
	

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	static char *filename_walkoverpath(char *filename)
	{
		if(!filename || *filename==0)
		{
			return filename;
		}
		char *fnstart = filename;
		char *fnend  = filename;
		// walk quickly to the end
		while(*fnend)
		{
			//todo:make path handling safe
			if(*fnend=='/') fnstart=fnend+1;
			fnend++;
		}
		return fnstart;
	}

	
	int btn_delete(struct liqtile *self)//,liqtileeventmouse *args)
	{
		//if(args->mez) return 0;	// do nothing unless we are finishing a stroke
		app_log("Event delete");
		if(!file_current_selection)
		{
			app_log("delete fail, nothing to delete");
			return -1;
		}
		
		//gb its fine, we can delete before its shown
		//if(!file_current_selection->linkpage)
		//{
		//	app_log("delete fail, data not ready");
		//	return -1;
		//}
		
		app_log("file delete: '%s'",file_current_selection->key);
		
		// delete the file, no confirmations etc
		
		// whoa, its too easy...
		
		//remove(file_current_selection->key);
		
		//if(0==liqdialog_showyesno("Are you sure you want to delete this file?"))
		//{
		//	app_log("delete fail, user decline..");
		//	return -1;
		//}
		
		
		
		// rename it instead, for now that will do
		char buff[1024];
		
		snprintf(buff,1024,"%s",file_current_selection->key);
		
		char *fn = filename_walkoverpath(buff);
		if(fn && *fn)*fn='.';
		
		rename(file_current_selection->key,buff);
		
		
		
		// this will break the edit chain, but so what for now..
		file_current_selection->visible=0;
		
		
		if(file_current_selection->linkpage)
		{
			file_current_selection->linkpage->owner=NULL;
			page_free(file_current_selection->linkpage);
			file_current_selection->linkpage=NULL;
		}

		return 0;
	}	
	
	int btn_edit(struct liqtile *self)//,liqtileeventmouse *args)
	{
		//if(args->mez) return 0;	// do nothing unless we are finishing a stroke
		app_log("Event edit");
		if(!file_current_selection)
		{
			app_log("edit fail, nothing to edit");
			return -1;
		}
		
		
		if(!file_current_selection->linkpage)
		{
			app_log("edit fail, data not ready");
			return -1;
		}
		
		liqart2_run_editdocument(file_current_selection->linkpage);
		
		return 0;
	}
	
	int btn_saveui(struct liqtile *self)//,liqtileeventmouse *args)
	{
		//if(args->mez) return 0;	// do nothing unless we are finishing a stroke
		app_log("Event edit");
		if(!file_current_selection)
		{
			app_log("edit fail, nothing to edit");
			return -1;
		}
		
		
		if(!file_current_selection->linkpage)
		{
			app_log("edit fail, data not ready");
			return -1;
		}
		
		
		char newtitle[32]="";
		if( liqkeyboard_run("ui replace :: gimme a name",newtitle,32)>0 )
		{
					if( (*newtitle)  )
					{	// we accepted the item
						//########### cleanse input, may need more :)
						
						app_ensurecleanusername(newtitle);
						
						app_log("ui replace accepted: '%s'",newtitle);
						
						
						char filenamefrom[1024];
						
						snprintf(filenamefrom,1024,"%s",file_current_selection->linkpage->filename);
						char *fn = filename_walkoverpath(filenamefrom);						
						char filenameto[1024];
						
						snprintf(filenameto,1024,"%s/%s.%s",app.userpath, fn , newtitle);
						
						int 	   app_file_copy (char * from, char * to, int allowoverwrite);
						
						if(app_file_copy(filenamefrom,filenameto,1))
						{
							// w00t
							app_log("ui replace saved:  '%s'",filenameto);
						}
						else
						{
							app_log("ui replace failed: '%s'",filenameto);
						}
					}
			
		}
		
		return 0;
	}
	
	
/*	
	app_log("graffiti getting fonts");
	
	LIQFONT fontbig;
	int fontbigsize = canvas.font->size+12;
	if(liqfont_openfile(&fontbig,canvas.font->name,fontbigsize,0,canvas.scalew,canvas.scaleh)!=0)
	{
		return app_warnandcontinue(-1,"Couldnt open bigfont");
	}
	
	
*/
	
/*	
	app_log("graffiti creating styles");
	//######################################################### initialize some styles

	stylefile=liqstyle_create();
	liqstyle_setbackcoloryuv(stylefile,0,128,128);			// 0,0,0 is not applicable, its green on some screens..
	liqstyle_setbordercoloryuv(stylefile,255,128,128);
	stylefile->borderwidth=1;
	stylefile->textfont=canvas.font;
	


	knob=liqstyle_create();
	liqstyle_setbackcoloryuv(knob,0,128,128);			// 0,0,0 is not applicable, its green on some screens..			
	liqstyle_setbordercoloryuv(knob,255,40,128);
	knob->borderwidth=1;
	knob->backmode=1;
	knob->textfont=canvas.font;

	head=liqstyle_create();
	liqstyle_setbackcoloryuv(head,0,128,128);			// 0,0,0 is not applicable, its green on some screens..
	liqstyle_setbordercoloryuv(head,255,128,128);
	head->borderwidth=0;
	head->backmode=1;
	//head->textfont=&fontbig;

	odd=liqstyle_create();
	liqstyle_setbackcoloryuv(odd,0,134,212);			// 0,0,0 is not applicable, its green on some screens..
	liqstyle_setbordercoloryuv(odd,255,128,128);
	odd->borderwidth=0;
	odd->backmode=1;
	odd->textfont=canvas.font;


	even=liqstyle_create();
	liqstyle_setbackcoloryuv(even,100,194,22);
	liqstyle_setbordercoloryuv(even,255,128,128);
	even->borderwidth=0;
	even->backmode=1;
	even->textfont=canvas.font;
	
	
*/
	
	app_log("graffiti creating tiletree");
	//######################################################### create the tree
	
	liqtileroot = liqtile_createquick("root",0,0,canvas.pixelwidth ,canvas.pixelheight);
	liqtileroot->handlerevent=root_event;
	liqtileroot->style=styleblack;
	liqtilehot=NULL;
	liqtilesel=NULL;

	// create a layout which fits on the visible screen.
	liqtile *pa = addbutton(liqtileroot,"menu",NULL);
		pa->style=NULL;
		addbutton(pa,"close",&btn_close);
		addbutton(pa,"ui",&btn_saveui);
		//addbutton(pa," ",NULL);
		addbutton(pa,"new",&btn_new);
		//addbutton(pa,"edit",&btn_edit);
		addbutton(pa,"",NULL);
		addbutton(pa,"delete",&btn_delete);
		addbutton(pa,"",NULL);
		
		
		//addbutton(pa,"reset",&btn_reset);
		//addbutton(pa,"+",&btn_plus);
		//addbutton(pa,"-",&btn_minus);
		
		
		tilezoom=mkslide(pa,"zoom",&zoom_click,zoompercent,10,400);
		
		//addbutton(pa,"key",&btn_key);
		//addbutton(pa,"key",&btn_key);
		//addbutton(pa,"-",NULL);
		//addbutton(pa,"tags",&btn_tags);

		liqtile_childarrange_col(pa);
		// right align...
		pa->x = liqtileroot->w-pa->w;
		liqtile_update_boundfrompos(pa);
		
	// create a grid object in a similar manner
	
	{
	
		liqtile *t;		
		if( (t=liqtile_childfindkey(liqtileroot,"menu.edit")) )
		{
			t->visible=0;
		}
		if( (t=liqtile_childfindkey(liqtileroot,"menu.new")) )
		{
			t->visible=0;
		}

		
		if( (t=liqtile_childfindkey(liqtileroot,"menu.delete")) )
		{
			//t->visible=0;
		}		
	}
	

	
		//grid = addframe(liqtileroot,"grid",liqtileroot->w-(pa->w*2),liqtileroot->h/2);
		grid = addframe(liqtileroot,"grid",liqtileroot->w-(pa->w*2),liqtileroot->h);
		grid->style=NULL;
		grid->x=pa->w;
		//grid->y+=grid->h/2;
		liqtile_update_boundfrompos(grid);
	
		grid->style=NULL;
		//mkfilelist(grid,"/home/user/MyDocs/_apg");
			

	
	liqtile *gridslide = addframe(liqtileroot,"slide",pa->w,liqtileroot->h);
	gridslide->style=NULL;
	
		liqtile *gridknob = addframe(gridslide,"knob",pa->w,liqtileroot->h/6);
		//gridknob->handlermouse=&gridknob_mouse;
		gridknob->style=styleknob;
		
		int doscaleconvert(int value,int rangefrom,int rangeto)
		{
			int yy = (int) (((float)value/(float)rangefrom)*(float)rangeto);
			return yy;
		}		
		
		
		
		int gridslide_mouse(struct liqtile *self,liqtileeventmouse *args)
		{
			// aim to adjust y between parent.sy..parent.ey-self->h
			gridknob->y=args->mey-(gridknob->h/2);
			liqtile_update_boundfrompos(gridknob);
			liqtile_forceinboundparent(gridknob);
			
			int range = gridslide->h-gridknob->h;
			if(range<0) return 0;	// too small to do anything
			
			int off=gridknob->y-gridslide->y;
			if(off<0) return 0;
			
			int yy=doscaleconvert(off,range,grid->crh-grid->cvh);			
			grid->coy=yy;
			liqtile_floatensurebounded(grid);
			
			//app_log("rng=%i off=%i mdy=%i     yy=%i  coy=%i crh=%i",range,off,args->mdy,     yy,grid->coy,grid->crh);
			return 0;
		}
		gridslide->handlermouse=&gridslide_mouse;
		
		
		int grid_mouse(struct liqtile *self,liqtileeventmouse *args)
		{
			grid->cox+=args->mdx;
			grid->coy+=args->mdy;
			liqtile_floatensurebounded(grid);
			
			
			int range = gridslide->h-gridknob->h;
			if(range<0) return 0;	// too small to do anything
			
			int off=grid->coy;
			
			int yy=doscaleconvert(off,grid->crh-grid->cvh,range);
			
			gridknob->y=yy;
			liqtile_update_boundfrompos(gridknob);
			liqtile_forceinboundparent(gridknob);
	/*		
			if(args->mez==0)
			{
				int sl=stroke_totallength(args->hand);
				if(sl<10)
				{
					// small motion, actually a click
					app_log("Grid Mouse Click: %s",self->key);
				}
			}
	*/	
			
			return 0;
		}
		
		
#define SGN(x) ((x)<0?-1:(x)==0?0:1)
	
		int grid_paint(struct liqtile *self,liqtileeventpaint *args)
		{
			if(self->kineticx || self->kineticy)
			{

				//if(arg_mode_fastrefresh)
				{
					// this was specified in the initializer
					arg_mode_fastrefresh = 1;
				}

				grid->cox+=self->kineticx;
				grid->coy+=self->kineticy;
				liqtile_floatensurebounded(grid);
				
				
				int range = gridslide->h-gridknob->h;
				if(range<0) return 0;	// too small to do anything
				
				int off=grid->coy;
				
				int yy=doscaleconvert(off,grid->crh-grid->cvh,range);
				
				gridknob->y=yy;
				liqtile_update_boundfrompos(gridknob);
				liqtile_forceinboundparent(gridknob);


				self->kineticx-=SGN(self->kineticx);
				self->kineticy-=SGN(self->kineticy);		
				
			}			
			
			
			// now, render as normal
			self->handlerpaint=NULL;
			liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
			self->handlerpaint=grid_paint;		
			return 0;
		}		
		
		
		
		
		
		
		
		
		
		
		grid->handlermouse=&grid_mouse;
		grid->handlerpaint=&grid_paint;

	
	
	filepaint_throttle=0;
	
	
	app_log("graffiti scanning files");
	
	
	//mkfilelist(grid,"/home/user/MyDocs/_apg");
	filelistroot=mkfilelist(grid,app.sketchpath);
	
	
	
	app_log("graffiti zooming data");
	

		zoomfilesto(filelistroot,zoompercent);
		liqtile_childarrange_col(filelistroot);
		


	app_log("graffiti floating");
	
	liqtile_floatprepare(grid);
	
	
	
	
	app_log("graffiti loading knob");
	
	
/*	
	
	imgunknown=liqimage_create();
	
			char buf[FILENAME_MAX+1];
			snprintf(buf,FILENAME_MAX,"%s/sun.png",app.themepath);
			
			
	liqimage_pageloadpng(imgunknown,buf,64,64,0);
	
*/	
	
	
	
	//liqimage_pageloadpng(imgunknown,"plane.png",64,64);
	

//	int liqimage_pageloadpng(liqimage *self,char * filename,int maxw,int maxh)






	
	{
		addbutton(liqtileroot,"edit",&btn_edit);
		liqtile *t;		
		if( (t=liqtile_childfindkey(liqtileroot,"edit")) )
		{
			t->style=stylebuttonsel;
			t->w=liqtileroot->w/4;
			t->x = liqtileroot->w - t->w;
			t->y = liqtileroot->h - t->h;
			liqtile_update_boundfrompos(t);
		}

	}
	


	app_log("graffiti running variant of _easyrun");




int result=0;



	liqtile *liqtile_lazyloadadvance(liqtile *self,liqtile *start)
	{
		
	more:
		if(!self) return NULL;
		if(self!=start)
		{
			if(self->handlerlazyload)
			{
				return self;
			}
		}
		
		if(self->linkchild)
		{
			self=self->linkchild;
			goto more;
		}
		else
		{
			if(self->linknext)
			{
				self=self->linknext;
				goto more;
			}
			else
			{

				liqtile *p=self->linkparent;
				while(p)
				{
					if(p->linknext)
					{
						self=p->linknext;
						goto more;
					}
					p=p->linkparent;
				}
				
			}
		}
		return NULL;
	}






liqtile *lazyloader = NULL;
int lazyloadercnt=0;



	int root_paint(struct liqtile *self,liqtileeventpaint *args)
	{
		arg_mode_fastrefresh = 0;
		
		self->handlerpaint=NULL;
		liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
		self->handlerpaint=root_paint;
		
		if(arg_mode_fastrefresh)
		{
			// the content is busy doing something
		}
		else
		{
			// not busy, so we can try to do lazy loading :)
			if(lazyloader)// && lazyloader->handlerlazyload)
			{
				lazyloader->handlerlazyload(lazyloader);
				lazyloadercnt++;
				lazyloader = liqtile_lazyloadadvance(lazyloader,lazyloader);
				arg_mode_fastrefresh=1;
			}
			if(lazyloader)// && lazyloader->handlerlazyload)
			{
				lazyloader->handlerlazyload(lazyloader);
				lazyloadercnt++;
				lazyloader = liqtile_lazyloadadvance(lazyloader,lazyloader);
				arg_mode_fastrefresh=1;
			}
			if(lazyloader)// && lazyloader->handlerlazyload)
			{
				lazyloader->handlerlazyload(lazyloader);
				lazyloadercnt++;
				lazyloader = liqtile_lazyloadadvance(lazyloader,lazyloader);
				arg_mode_fastrefresh=1;
			}
/*
			if(lazyloader)// && lazyloader->handlerlazyload)
			{
				lazyloader->handlerlazyload(lazyloader);
				lazyloadercnt++;
				lazyloader = liqtile_lazyloadadvance(lazyloader,lazyloader);
				arg_mode_fastrefresh=1;
			}
			if(lazyloader)// && lazyloader->handlerlazyload)
			{
				lazyloader->handlerlazyload(lazyloader);
				lazyloadercnt++;
				lazyloader = liqtile_lazyloadadvance(lazyloader,lazyloader);
				arg_mode_fastrefresh=1;
			}
			if(lazyloader)// && lazyloader->handlerlazyload)
			{
				lazyloader->handlerlazyload(lazyloader);
				lazyloadercnt++;
				lazyloader = liqtile_lazyloadadvance(lazyloader,lazyloader);
				arg_mode_fastrefresh=1;
			}
*/			
		}
		
		
		// now, render as normal
		return 0;
	}		
		
	liqtileroot->handlerpaint=root_paint;
	
	
	lazyloader = liqtile_lazyloadadvance(liqtileroot,NULL);
	lazyloadercnt=0;
	while(lazyloader && lazyloadercnt<10)
	{
			if(lazyloader && lazyloader->handlerlazyload)
			{
				lazyloader->handlerlazyload(lazyloader);
				//dirty=1;
			}
			lazyloader = liqtile_lazyloadadvance(lazyloader,lazyloader);
		lazyloadercnt++;
	}




		result = liqtile_easyrun2(liqtileroot,&arg_mode_fastrefresh);


	liqtile_close(liqtileroot);


	
	
	app_log("graffiti saving prefs");
	
	liqbase_pref_setvalue_printf("graffiti_zoompercent","%i",zoompercent);
	
	liqbase_prefs_save();
	
	
	app_log("graffiti completed");
	
	return result;
}

// threads aren't as nice as advertised, simplicity here works really well without :)


//https://computing.llnl.gov/tutorials/pthreads/#Pthread
//theres a nifty image
//https://computing.llnl.gov/tutorials/pthreads/images/concurrent.gif



//http://www.linuxforums.org/forum/linux-programming-scripting/50687-simple-thread-c.html

