/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * mdule to play with ideas
 *
 */






#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>


#include "liqapp.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "filebuf.h"
#include "liqdoc.h"

#include "liqdraw.h"
#include "liqdrawframe.h"



typedef struct point3d
{
	float x;
	float y;
	float z;
} POINT3D;

typedef struct star3d
{
	
	int id;
	int r;
	POINT3D p;
	POINT3D a;
	POINT3D v;
	int scrcol;
	int scrx;
	int scry;
} STAR3D;
#define starcount 100
STAR3D stars[starcount];


//##########################################################################	
//##########################################################################	
//##########################################################################

#define ABS(x) ((x)<0?-(x):(x))
#define SGN(x) ((x)<0?-1:(x)==0?0:1)

static FRAME *frameroot=NULL;
static FRAME *framecurr=NULL;
static FRAME *framesel=NULL;



static	int docw=0;
static	int doch=0;

static	int viewx=0;
static	int viewy=0;

static	int vieww=0;
static	int viewh=0;

static	int viewmaxx=0;
static	int viewmaxy=0;



//######################################################################
//######################################################################
//######################################################################

static FRAME *mkbutton(FRAME *self,char *title)
{
	FRAME *ch= frame_createquick(title,0,0,canvas.pixelwidth/16,canvas.pixelheight/10);
	frame_pageautoloadbytitle_apg(ch);
	frame_append(self,ch);
	return ch;
}


static FRAME *mkday(FRAME *self,char *title)
{
	
	FRAME *ch= frame_createquick(title,0,0,canvas.pixelwidth/8,canvas.pixelheight/5);
	frame_pageautoloadbytitle_apg(ch);
	frame_append(self,ch);

	return ch;
}




static int frame_childarrange_row(FRAME *self)
{
	int tw=0;								// should we start with self->layout.borderxhead ?
	int mh=0;
	FRAME *sa=self->linkchild;
	while(sa)
	{
		sa->x=tw;
		sa->y=0;							// should we check sa->layout.float?    0=top  0.5=centre 1=bottom
		frame_update_boundfrompos(sa);
		tw+=sa->w;							// should we add self->layout.borderxbetween
		if(sa->h>mh)mh=sa->h;
		sa=sa->linknext;
	}
											// should we add self->layout.borderxtail
	// now fix the size of ch
	self->w=tw;
	self->h=mh;
	frame_update_boundfrompos(self);

	return 0;
}
 
static int frame_childarrange_col(FRAME *self)
{
	int th=0;
	int mw=0;
	FRAME *sa=self->linkchild;
	while(sa)
	{

		sa->x=0;
		sa->y=th;
		frame_update_boundfrompos(sa);
		th+=sa->h;
		if(sa->w>mw)mw=sa->w;
		
		sa=sa->linknext;
	}
	self->w=mw;
	self->h=th+1;
	frame_update_boundfrompos(self);
	return 0;
}
 
//######################################################################
//######################################################################
//######################################################################




	
	
	
	
/*


static void game_init()
{
	int a;
	STAR3D *sa;
	for(a=0;a<starcount;a++)
	{
		sa=&stars[a];

		sa->p.x=rand() % (canvas.pixelwidth -1);
		sa->p.y=rand() % (canvas.pixelheight-1);
		sa->p.z=0;
		
		sa->v.x=0;
		sa->v.y=0;
		sa->v.z=0;
		
		sa->a.x=0;
		sa->a.y=0;
		sa->a.z=0;
	}
}
 */
void star_forceinbound(STAR3D *self,float xs,float xe,float ys,float ye)
{
	if(self->p.x<xs) { self->p.x = xs + (xs-self->p.x); self->v.x = -self->v.x; }
	if(self->p.x>xe) { self->p.x = xe - (self->p.x-xe); self->v.x = -self->v.x; }
	if(self->p.y<ys) { self->p.y = ys + (ys-self->p.y); self->v.y = -self->v.y; }
	if(self->p.y>ye) { self->p.y = ye - (self->p.y-ye); self->v.y = -self->v.y; }
}




static void stroke_render(STROKE *sa,int flagshowall)
{
	POINT *p0;
	POINT *p1;
	if (sa->pointcount<1) return;
	if(flagshowall)
	{
		p0 = sa->pointfirst;
	}
	else
	{
		// start at end-1
		p0 = sa->pointlast->linkprev;
	}
	//canvas_circle(p0->x,p0->y,5,240);
	//return;
	//for(p=ps;p<sa->pointcount;p++)
	while(p0)
	{
		//app_log("render p0:%i p0->linknext:%i showall %i",(unsigned int)p0,(unsigned int)p0->linknext,flagshowall);
		p1 = p0->linknext;
		if(!p1) break;
		// now i am using a linked list, should i draw backwards and just stop if i need to?
		// Pressure gradient:
		// 100 == MEDIC!
		// 150 == ouch
		// 200 == ahhh
		// 300 == you there
		// 450 == hello?
		int g=(450-p0->z);
		g=(g*256) / 250;
		if(g<0)g=0;
		if(g>255)g=255;			
		float f=(float)g / 256;
		float fy=sa->pen_y;
		float fu=sa->pen_u;
		float fv=sa->pen_v;
		unsigned char y=	    (char)(      f * (fy    )) ;
		unsigned char u=	    (char)(128 + f * (fu-128)) ;
		unsigned char v=	    (char)(128 + f * (fv-128)) ;
		
		//canvas_circle(p0->x,p0->y,5,128);
		//app_log("Line (%i,%i) -(%i,%i)",p0->x,p0->y,p1->x,p1->y);
		canvas_linecolor(p0->x,p0->y,p1->x,p1->y,y,u,v);//p0->x % 255,p0->y % 255);
		p0=p1;
	}
	//p0 = sa->pointlast;
	//canvas_circle(p0->x,p0->y,5,255);
}



static void page_renderall(PAGE *self)
{
	STROKE *sa=self->strokefirst;
	while(sa)
	{
		stroke_render(sa,1);
		sa=sa->linknext;
	}
}













static	void liqfloat_preplimits()
{
	docw = frameroot->w;
	doch = frameroot->h;
	
	
	// setup total size of world
	docw = canvas.pixelwidth;
	docw = canvas.pixelheight;

	// configure visible area
	vieww = canvas.pixelwidth;
	viewh = canvas.pixelheight;

	// amount of movement
	viewmaxx = docw-vieww;
	viewmaxy = doch-viewh;

	// ensure movement is valid
	if(viewmaxx<0)viewmaxx=0;
	if(viewmaxy<0)viewmaxy=0;

	app_log("xdoc   %i,%i",docw,doch);
	app_log("xview  %i,%i",vieww,viewh);
	app_log("xviewm %i,%i",viewmaxx,viewmaxy);
	
	// enforce the available space
	if(viewx<0){viewx=0;}
	if(viewy<0){viewy=0;}
	if(viewx>=viewmaxx) {viewx=viewmaxx;}
	if(viewy>=viewmaxy) {viewy=viewmaxy;}	
	
}


STROKE *mf1=NULL;
STROKE *mf2=NULL;
//int see_test();

int liqgame_run()
{


	//see_test();


//	sqlite_test();


	PAGE *pg = page_alloc();
	page_clear(pg);

	pg->dpix=canvas.dpix;
	pg->dpiy=canvas.dpiy;



	
	frameroot = frame_createquick("root",0,0,canvas.pixelwidth -1,canvas.pixelheight-1);
	framecurr=NULL;
	framesel=NULL;
	
	
	
	
	//framecurr = frame_createquick("hello",10,10,100,100);
	//frame_insert(frameroot,framecurr);
	

	
	FRAME *pa = mkbutton(frameroot,"menu");
		mkbutton(pa,"close");
		mkbutton(pa,"-");
		mkbutton(pa,"new");
		mkbutton(pa,"copy");
		mkbutton(pa,"edit");
		mkbutton(pa,"delete");
		mkbutton(pa,"-");
		mkbutton(pa,"help");
		mkbutton(pa,"rotate");
		frame_childarrange_col(pa);
		// right align...
		pa->x = frameroot->w-pa->w;
		frame_update_boundfrompos(pa);

	//frame_neatarrange(frameroot);
	
	
	//


{
	
	FRAME *pmonth = mkbutton(frameroot,"month");
	{
		FRAME *pweek = mkbutton(pmonth,"week1");
			mkday(pweek,"monday");
			mkday(pweek,"tuesday");
			mkday(pweek,"wednesday");
			mkday(pweek,"thursday");
			mkday(pweek,"friday");
			mkday(pweek,"saturday");
			mkday(pweek,"sunday");
			frame_childarrange_row(pweek);
	}
	{
		FRAME *pweek = mkbutton(pmonth,"week2");
			mkday(pweek,"monday");
			mkday(pweek,"tuesday");
			mkday(pweek,"wednesday");
			mkday(pweek,"thursday");
			mkday(pweek,"friday");
			mkday(pweek,"saturday");
			mkday(pweek,"sunday");
			frame_childarrange_row(pweek);
	}
	{
		FRAME *pweek = mkbutton(pmonth,"week3");
			mkday(pweek,"monday");
			mkday(pweek,"tuesday");
			mkday(pweek,"wednesday");
			mkday(pweek,"thursday");
			mkday(pweek,"friday");
			mkday(pweek,"saturday");
			mkday(pweek,"sunday");
			frame_childarrange_row(pweek);
	}
	{
		FRAME *pweek = mkbutton(pmonth,"week4");
			mkday(pweek,"monday");
			mkday(pweek,"tuesday");
			mkday(pweek,"wednesday");
			mkday(pweek,"thursday");
			mkday(pweek,"friday");
			mkday(pweek,"saturday");
			mkday(pweek,"sunday");
			frame_childarrange_row(pweek);
	}
	{
		FRAME *pweek = mkbutton(pmonth,"week5");
			mkday(pweek,"monday");
			mkday(pweek,"tuesday");
			mkday(pweek,"wednesday");
			mkday(pweek,"thursday");
			mkday(pweek,"friday");
			mkday(pweek,"saturday");
			mkday(pweek,"sunday");
			frame_childarrange_row(pweek);

	}
	frame_childarrange_col(pmonth);
}


	viewx=0;
	viewy=0;
	liqfloat_preplimits();


int result=0;

int running=1;
int framecount=0;
//unsigned long tzs=app_GetTicks();
unsigned long tz0=app_GetTicks();
unsigned long tz1=app_GetTicks();
LIQEVENT ev;
int mc=0;//,mx=0,my=0,mp=0;
POINT m={0,0,0,0};
//unsigned	long mt=0;
int dirty=1;		// ensure we are drawn at least once :)
int wantwait=0;

int mdx=0;
int mdy=0;
unsigned long mdt=0;
int hadmouse=0;

int refreshinprogress=0;

	canvas_clear(0);

	
	
	while(running==1)
	{
		hadmouse=0;
		while(canvas_eventcount() && (framecount>0))
		{
waitevent:
			canvas_nextevent(&ev);
			//app_log("%i",ev.key.keycode);
			if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65307) )	//ESC
			{
				app_log("Escape Pressed, Cancelling");
				running=0;
				//result=NULL;
				break;
			}
			
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65477) )	//Zoom -
			{
				//FRAME *first = frame_firstvisible();
				//if(viewscale>0.2) viewscale-=0.1;
				//liqfloat_layout(viewscale);
				liqfloat_preplimits();
				dirty=1;
				//view_goto(first);
				break;
			}
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65476) )	//Zoom +
			{
				//FRAME *first = frame_firstvisible();
				//if(viewscale<2.0) viewscale+=0.1;
				//liqfloat_layout(viewscale);
				liqfloat_preplimits();
				dirty=1;
				//view_goto(first);
				break;

			}
			else if(ev.type == LIQEVENT_TYPE_MOUSE)// && ev.mouse.pressure==0)
			{
				
				if(mc>0 && ev.mouse.pressure>0)
				{
					// we have deltas available
					mdx=(m.x-ev.mouse.x);// * 1000 / canvas.dpix;
					mdy=(m.y-ev.mouse.y);// * 1000 / canvas.dpiy;
					if( (mdx>canvas.pixelwidth/6 || mdy>canvas.pixelheight/6) )
					{
						// we have lost a stroke somewhere, we should end the previous one and start again
						// something went wrong and we did not hear about the final mouseup
						mc=0;
						mf1=NULL;
						mf2=NULL;
					}
					else
					{
						viewx+=mdx;
						viewy+=mdy;
						if(viewx<0){viewx=0;mdx=0;}
						if(viewy<0){viewy=0;mdy=0;}
						if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
						if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}
					}
				}
				
				m.x=ev.mouse.x;
				m.y=ev.mouse.y;
				m.z=ev.mouse.pressure;
				m.t=ev.ticks;
				mc++;
				if(m.z>0)
				{
					
					framesel = frame_findhit(frameroot,m.x,m.y);
					if(framesel)
					{
						char titbuf[1024]="\0";
						frame_fullyqualifiedtitle(framesel,titbuf,1024);
						app_log("hit '%s'",titbuf);
					}
					else
					{
						//app_log("miss");
					}
					// starting or continuing a stroke
					if(mc==1)
					{
						// starting...
						//app_log("stroke.start.alloc mf1");
						mf1=stroke_alloc();
						mf1->pen_y=255;
						mf1->pen_u=128;
						mf1->pen_v=128;
						stroke_start(mf1,m.x,m.y,m.z);
						mf1->pointlast->t=m.t;
						page_strokeinsert(pg,mf1);
						mf2=NULL;
					}
					else
					{
						// continuing...
						//app_log("stroke.continuing.extending mf1");
						stroke_extend(mf1,m.x,m.y,m.z);
						mf1->pointlast->t=m.t;
						page_strokeupdate(pg,mf1);
					}
				}				
				else
				{
					// finished a stroke, make sure we dont keep deletes from the last one
					app_log("stroke.finished");
					mf1=NULL;
					mc=0;
					
					framesel = NULL;
				}
				hadmouse=1;
				dirty=1;
				//break;
			}
			else if(ev.type == LIQEVENT_TYPE_REFRESHED)
			{
				//wantwait=1;
				// ok, we have finished the refresh
				refreshinprogress=0;
				//canvas_clear(0); // ?????
				break;
			}
			else if(ev.type == LIQEVENT_TYPE_UNKNOWN)
			{
				running=0;
				break;
			}
		}
		
		//app_log("%i, %i, %l",mdx,mdy,mdt);
		if(m.z==0 && (mdx || mdy) && dirty==0)// && 1==0)
		{
			// we have kinetic energy..
			framesel=NULL;

					viewx+=mdx;
					viewy+=mdy;
					if(viewx<0){viewx=0;mdx=0;}
					if(viewy<0){viewy=0;mdy=0;}
					if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
					if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}

			mdt-=SGN(mdt);
			mdx-=SGN(mdx);
			mdy-=SGN(mdy);
			dirty=1;
		}
		if(running==0) break;
		if(framecount==0 || (dirty && (refreshinprogress==0)))
		{
			//app_log("view %i,%i.    max %i,%i",viewx,viewy,viewmaxx,viewmaxy);
			//canvas_clear(0);
			canvas_clear(0);

			POINT ps={0,0};
			POINT pe={0,0};
			pe.x=canvas.pixelwidth;
			pe.y=canvas.pixelheight;
			pointrange_start(&pg->boundingbox,&ps);
			pointrange_extendrubberband(&pg->boundingbox,&pe);
			
			

			//page_rendertocanvas(pg,0,0,canvas.pixelwidth,canvas.pixelheight);
			if(mf1 && mf1->pointfirst)
			{
				POINT *p = mf1->pointfirst;
				POINT *q = NULL;
				//POINT *e = mf1->pointlast;
				
				//int rw = e->t - p->t;
				long st=p->t;
				
				int sw=(canvas.pixelwidth-1)*0.9;
				int sh=(canvas.pixelheight-1);
				//int cw=sw/2;
				int ch=sh/2;
				while(p)
				{
					if(q)
					{
						long pt=(p->t-st)/8;
						//long qt=(q->t-st)/8;
						//long dd = qt-pt;
						canvas_psetcolor(sw - pt,(q->x),255,120,120);
						canvas_psetcolor(sw - pt,(q->y),200,140,140);
						
						canvas_pset     (sw - pt,ch+(q->x-p->x),255);
						canvas_pset     (sw - pt,ch+(q->y-p->y),200);
						
					}
					q=p;
					p=p->linknext;
				}
				
			}
			
		
			frame_rendertocanvas(frameroot,0,0,framesel);

			page_renderall(pg);

			canvas_refreshdisplay();
			refreshinprogress=1;
			
			dirty=0;
			wantwait=1;
			
			tz0=tz1;
			tz1=app_GetTicks();
			framecount++;


		}

		if(wantwait || refreshinprogress || m.z==0)
		{
			wantwait=0;
			goto waitevent;
		}
	}

	frame_close(frameroot);
	
	page_clear(pg);
	page_free(pg);
	
	return result;

}



