/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Header for font glyph buffering routines
 *
 */


#ifndef LIQFONT_H
#define LIQFONT_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct 
{
	char *			name;
	int				size;
	int				rotation;			// 0/90/180/270
	//unsigned char *	glyphbuffer;		// 256*(mw*mh)
	//int   			glyphbuffersize;
	//int				glyphtilesize;		// (mw*mh)
	char           *glyphdata[256];	// allocate any used
	int				glyphmaxw;			// maximum glyphwidth 	use this for obtaining boundary
	int				glyphmaxh;			// maximum glyphheight
	int				glyphstdw;			// maximum glyphwidth
	int				glyphstdh;			// maximum glyphheight
	unsigned char  	glyphwidths[256];
	unsigned char  	glyphheights[256];
	unsigned int 	glyphsizes[256];
} LIQFONT;



LIQFONT *liqfont_alloc();
void liqfont_free(LIQFONT *self);

void liqfont_close(LIQFONT *self);
int liqfont_openblank(LIQFONT *self,char *name,int size,int rotation,float scalew,float scaleh);
int liqfont_openfile (LIQFONT *self,char *name,int size,int rotation,float scalew,float scaleh);

int liqfont_defineglyph(LIQFONT *self,int glyphindex,int width,int height,char backcolor);
int liqfont_defineglypha(LIQFONT *self,int glyphindex,int width,int height,unsigned int data0, ...);

int liqfont_textfitinside(LIQFONT *self,char *data,int availablewidth);
int liqfont_textwidth(LIQFONT *self,char *data);
int liqfont_textwidthn(LIQFONT *self,char *data,int datalen);


#ifdef __cplusplus
}
#endif

#endif
