/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * library to hold font glyphs as a custom bitmap.
 *
 */


//todo:make color, its greyscale only, could be converted to color by replacing with xvimage bitmaps for each glyph




#include <ft2build.h>
#include FT_FREETYPE_H
#include FT_GLYPH_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "liqapp.h"
#include "liqfont.h"






LIQFONT *liqfont_alloc()
{
	LIQFONT *self = (LIQFONT *)malloc(sizeof(LIQFONT));
	if(self==NULL) {  app_errorandfail(-1, "liqfont creation failed" ); return NULL; }
	// NULL everything
	memset((char *)self,0,sizeof(LIQFONT));
	return self;
}

void liqfont_free(LIQFONT *self)
{
	// only call this on memory actually allocated, otherwise close
	app_log("liqfont free closing self");
	liqfont_close(self);
	app_log("liqfont free freeing");
	free(self);
	app_log("liqfont free completed");

}




//########################################################################
//######################################################################## textfitinside - tell me how much text fits within
//########################################################################


int liqfont_textfitinside(LIQFONT *self,char *data,int availablewidth)
{
	int x=0;
	unsigned char ch;
	int w=0;
	int len=0;
	while ( (ch=*data++) )
	{
		w=self->glyphwidths[ch];
		if(x+w>=availablewidth)return len;
		x+=w;
		len++;
	}
	return len;
}

//########################################################################
//######################################################################## widthtext routines canvas font
//########################################################################

int liqfont_textwidth(LIQFONT *self,char *data)
{
	if(!data) return 0;
	int x=0;
	unsigned char ch;
	while ( (ch=*data++) )
	{
		x+=self->glyphwidths[ch];
	}
	return x;
}
	

int liqfont_textwidthn(LIQFONT *self,char *data,int datalen)
{
	if(!data) return 0;
	int x=0;
	unsigned char ch;
	if(datalen<=0)return x;
	while(datalen--)
	{
		ch=*data++;
		x+=self->glyphwidths[ch];
	}
	return x;
}




void liqfont_close(LIQFONT *self)
{
	if(self->name) free(self->name);
	self->name=NULL;
	
	//if(self->glyphbuffer) free(self->glyphbuffer);
	//self->glyphbuffer=NULL;	
	int idx;
	for(idx=0;idx<256;idx++)
	{
		self->glyphwidths[idx]=0;
		self->glyphheights[idx]=0;
		self->glyphsizes[idx]=0;
		if(self->glyphdata[idx])
		{
			free(self->glyphdata[idx]);
			self->glyphdata[idx]=0;
		}
	}
	self->glyphmaxw=0;
	self->glyphmaxh=0;
}


int liqfont_defineglyph(LIQFONT *self,int glyphindex,int width,int height,char backcolor)
{
	char *buf = NULL;
	if(((width*height)>0))// && glyphvisible)
	{
		buf = malloc(width*height);
		if(!buf) return app_errorandfail(-1, "define glyph malloc failed" );
		memset(buf,backcolor,width*height*sizeof(char));
	}
	self->glyphdata[glyphindex] = buf;
	self->glyphwidths[glyphindex]=width;
	self->glyphheights[glyphindex]=height;
	//self->glyphsizes[glyphindex]=0;
	//if(glyphvisible)
	//{
		self->glyphsizes[glyphindex]=width*height;
		if(width >self->glyphmaxw) self->glyphmaxw=width;
		if(height>self->glyphmaxh) self->glyphmaxh=height;
	//}
	return 0;
}

int liqfont_defineglypha(LIQFONT *self,int glyphindex,int width,int height,unsigned int data0, ...)
{
	// data0 and all following should be unsigned char but va_arg is limited to ints only
	va_list arg;
	va_start(arg, data0);	

	int er=liqfont_defineglyph( self,glyphindex,width,height,0);
	if(er!=0)
	{
		return app_errorandfail(-1, "define glyph alloc failed %i." );
	}
	char *buf = self->glyphdata[glyphindex];
	if(buf==NULL) return 0;
	// now fill in the data...
	buf[0] = data0;
	if(self->glyphsizes[glyphindex]==1) return 0;
	unsigned int a;
	int ac;

	for(ac=0;ac<self->glyphsizes[glyphindex];ac++)
	{
		a = va_arg (arg, unsigned int);
		buf[1+ac]=(unsigned char)a;
	}
	va_end(arg);
	return 0;	
}


int liqfont_openblank(LIQFONT *self,char *name,int size,int rotation,float scalew,float scaleh)
{
	app_log("Opening Blank Font %s, %i:",name,size);
	if(size<6)size=6;
	if(size>100)size=100;
	if(rotation==0 || rotation==90)
		rotation=rotation;
	else
		rotation=0;		// for now, quick cop out...
	self->name = strdup(name);
	self->size = size;
	self->rotation = rotation;
	memset(&self->glyphdata[0],0,256*sizeof(char *));
	memset(&self->glyphwidths[0],0,256*sizeof(char));
	memset(&self->glyphheights[0],0,256*sizeof(char));
	memset(&self->glyphsizes[0],0,256*sizeof(int));
	self->glyphmaxw=0;
	self->glyphmaxh=0;
	self->glyphstdw=0;
	self->glyphstdh=0;
	return 0;
}
int liqfont_openfile(LIQFONT *self,char *name,int size,int rotation,float scalew,float scaleh)
{

	//rotation=90;
	//rotation=0;
	app_log("Opening Font File %s, %i:",name,size);
	
	
	
	liqfont_openblank(self,name,size,rotation,scalew,scaleh);
	

	
	app_log("Opening TTF");


FT_Error    fterr;
FT_Library  ftlib;
FT_Face     ftface;

    // open up
    fterr = FT_Init_FreeType( &ftlib );
     
    if ( ( fterr ) != 0 )
    {
         return app_errorandfail(-1, "TTF Init Failed" );
    }

    fterr = FT_New_Face( ftlib, self->name, 0, &ftface );
    if ( fterr == FT_Err_Cannot_Open_Stream )
        return app_errorandfail(-1, "TTF Could not find/open font" );
	
    if ( fterr )
        return app_errorandfail(-1, "TTF Error while opening font" );

	//n810 width  90mm   3.54ins  800 pix 225.988dpi
	//n810 height 54mm   2.12ins  480 pix 226.415dpi
	// sort out DPI here :)
	
	
	
if(rotation==0)
	
	fterr = FT_Set_Char_Size( 
		ftface, 
		0, /* char_width in 1/64th of points */  
		size*64, /* char_height in 1/64th of points */  
		scalew*72.0, /* horizontal device resolution */  
		scaleh*72.0 ); /* vertical device resolution */
else
	fterr = FT_Set_Char_Size( 
		ftface, 
		0, /* char_width in 1/64th of points */  
		size*64, /* char_height in 1/64th of points */  
		scaleh*72.0, /* horizontal device resolution */  
		scalew*72.0 ); /* vertical device resolution */
		
	
	
	
    //fterr = FT_Set_Pixel_Sizes( ftface, size, size );
    if ( fterr )
        return app_errorandfail(-1, "TTF Could not set size" );


	
    //int infomaxw = ftface->size->metrics.max_advance >> 6;
    int infoheight = (ftface->size->metrics.ascender - ftface->size->metrics.descender + (2 << 6)) >> 6;
    int infoascent = ftface->size->metrics.ascender >> 6;
	
	int fw=0;
	int fh=0;
	//int mw=0;
	//int mh=0;
	//int tw=0;
	//int aw=0;
		
	int glyphmin = 32;
	int glyphmax = ftface->num_glyphs;
	if (glyphmax<glyphmin) glyphmin=glyphmax;
	if (glyphmax>255) glyphmax=255;
	if (glyphmax==glyphmin)
	{
        return app_errorandfail(-1, "TTF sanity check failure: max==min" );		
	}

	self->glyphmaxw=0;
	self->glyphmaxh=0;
	
	app_log("Loading glyphs");
	
	// now fill in the buffer	
	unsigned char ch;
	for(ch=glyphmin;ch<glyphmax;ch++)
	{

        fterr = FT_Load_Char( ftface, ch , FT_LOAD_RENDER );
        if ( fterr )
        {
            printf("Error loading glyph: %i\n", ch);
            continue;
        }

        FT_GlyphSlot 		slot 			= ftface->glyph;
        FT_Glyph_Metrics 	glyph_metrics 	= slot->metrics;
        FT_Bitmap			*source 		= &slot->bitmap;
		unsigned char		*src 			= source->buffer;
		
		int fl = glyph_metrics.horiBearingX >> 6;;
		int ft = infoascent - slot->bitmap_top;
		
		fh = infoheight;
        fw = glyph_metrics.horiAdvance >> 6;		
		
		unsigned char *buf=NULL;

		if(fl<0){fw+=-fl; fl=0; }
		if(ft<0){fh+=-ft; ft=0; }
		
		//int gw=fl+(source->width);		// glyphw glyphh
		//int gh=ft+(source->rows);
		
		//fw=gw;
		//fh=gh;
		
		
		if(fl+source->width>fw){fw=fl+source->width; }
		if(ft+source->rows>fh){fh=ft+source->rows; }
		
		//if(fw<8)fw=8;

		int x;
		int y;
		unsigned char pix;
		if(self->rotation==0)
		{
			liqfont_defineglyph(self,ch,fw,fh,0);
			buf = self->glyphdata[ch];

			for(y=0;y<source->rows;y++)
			{
				for(x=0;x<source->width;x++)
				{
					pix = src[ ((y)*source->pitch) + (x) ];					
					buf[ (ft+y) * fw + (fl+x) ] = pix;
					
					//app_log("(%i,%i) off %i,pix %i", fw,fh,  (ft+y) * fw + (fl+x) , pix);
				}
			}
			//liqfont_defineglyph(self,9,self->glyphwidths[32]*4,self->glyphheights[32],0);
		}
		else
		{
			// init rot90
			liqfont_defineglyph(self,ch,fh,fw,0);
			//liqfont_defineglyph(self,ch,fw,fh,0);
			buf = self->glyphdata[ch];
			if(buf)
			{
				//if(rx>fw)app_log("fw %i,   rx %i",fw,rx);
				//if(ry>fh)app_log("fh %i,   ry %i",fh,ry);

				for(y=0;y<source->rows;y++)
				{
					for(x=0;x<source->width;x++)
					{
						pix = src[ ((y)*source->pitch) + (x) ];					
						//buf[ (ft+y) * fw + (fl+x) ] = pix;
						
						int tx= (fh-1)-(ft+y);
						int ty= (fl+x);
						int off=tx + ty * fh;
						if(off>self->glyphsizes[ch])
							app_log("(%ix%i)=%i, siz %i,    off %i,pix %i   fl %i   ft %i", fw,fh,fw*fh,self->glyphsizes[ch],   off , pix,fl,ft);
						
						
						//buf[   ( (fl+x) ) * fh + ((fh-1)-(ft+y)) ] = pix;

						buf[ off ] = pix;
						
					}
				}			
			}
		}
				//liqfont_defineglyph(self,9,self->glyphwidths[32],self->glyphheights[32]*4,0);
				//liqfont_defineglyph(self,9,self->glyphwidths[32]*4,self->glyphheights[32],0);

	}
		if(self->rotation==0)
		{
			liqfont_defineglyph(self,9,self->glyphwidths[32]*4,self->glyphheights[32],0);
		}
		else
		{
			liqfont_defineglyph(self,9,self->glyphwidths[32],self->glyphheights[32]*4,0);
		
		}
	
	
	self->glyphstdw=(int)self->glyphwidths['x'];
	self->glyphstdh=(int)self->glyphheights['x'];
	
	app_log("Closing TTF Font");
    FT_Done_Face( ftface );
	app_log("Closing TTF Library");
    FT_Done_FreeType( ftlib );
	app_log("Open Font Completed");
	return 0;
}
