/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * graffiti floating bitmap wall
 *
 */

#include <stdlib.h>

// rotated header

//http://sse2.net/rotate/Updated_blizzard_rotation_support_v2.diff
//blizzard_read_reg

//short rotate patch
//http://fr.pastebin.ca/915469


// see here for read_reg write_reg
//http://www.ussg.iu.edu/hypermail/linux/kernel/0706.3/0769.html

/*
+
+static u8 blizzard_read_reg(u8 reg)
+{
+ u8 data;
+
+ blizzard.extif->set_bits_per_cycle(8);
+ blizzard.extif->write_command(&reg, 1);
+ blizzard.extif->read_data(&data, 1);
+
+ return data;
+}
+
+static void blizzard_write_reg(u8 reg, u8 val)
+{
+ blizzard.extif->set_bits_per_cycle(8);
+ blizzard.extif->write_command(&reg, 1);
+ blizzard.extif->write_data(&val, 1);
+}
+
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>
//#include <jpeglib.h>


#include "liqapp.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "filebuf.h"
#include "liqdoc.h"

#include "liqdraw.h"
#include "liqdrawframe.h"

#include "liqimage.h"
#include "liqcamera.h"

// todo: irc discussion
//<KotCzarny> 'dir doesn't exist, would you like to create one?'
//<KotCzarny> and use /home/user or /media/mmc2
//<KotCzarny> or mmc1
//<KotCzarny> also you should get home dir from env
//<KotCzarny> because i'm running it as root


//##########################################################################	
//##########################################################################	
//##########################################################################

#define ABS(x) ((x)<0?-(x):(x))
#define SGN(x) ((x)<0?-1:(x)==0?0:1)

static FRAME *frameroot=NULL;
static FRAME *framecurr=NULL;
static FRAME *framesel=NULL;


static	float viewscale=0.5;

// ok, make pic
// turbo version
static liqimage * picimg=NULL;

void frame_drawpic(FRAME *self,int offx,int offy)
{
	//canvas_drawboxcolor(offx+self->x,offy+self->y,self->w,self->h ,255,48,30);
	//xsurface_drawimage_color( yuv_image, &picimg,offx+self->x,offy+self->y );
/*	
	xsurface_drawzoomimage(
							&picimg,
							0,0,
							picimg.width,picimg.height,
							
							yuv_image,
							offx+self->x + self->w/2,offy+self->y + self->h/2,
							self->w/2,self->h/2
						  );
*/							



	cliprect_drawimagecolor(canvas.cr,picimg,offx+self->x,offy+self->y,self->w,self->h);

// faster (technically this should simply call down into the fast one for default)
/*

	xsurface_drawzoomimage(
							picimg,
							0,0,
							picimg->width,picimg->height,
							
							canvas.cr->surface, // yuv_image,
							offx+self->x ,offy+self->y ,
							self->w,self->h
						  );
*/

	
//fastest 25fps :)
	
//	xsurface_drawimage_color(canvas.cr->surface,picimg,offx+self->x ,offy+self->y);
	
}






static FRAME *mkbutton(FRAME *self,char *title)
{
//	FRAME *ch= frame_createquick(title,0,0,256,256);

//int w=10+(int) (canvas.pixelwidth /4 * (rand() / (RAND_MAX + 1.0)));
//int h=10+(int) (canvas.pixelheight/4 * (rand() / (RAND_MAX + 1.0)));

//int w=10+(int) (canvas.pixelwidth *2 * (rand() / (RAND_MAX + 1.0)));
//int h=10+(int) (canvas.pixelheight*2 * (rand() / (RAND_MAX + 1.0)));

//int w=(int) (canvas.pixelwidth/4)-1;// /4 * (rand() / (RAND_MAX + 1.0)));
//int h=(int) (canvas.pixelheight/4)-1;///4 * (rand() / (RAND_MAX + 1.0)));


//int w=(int) (canvas.pixelwidth-1);// /4 * (rand() / (RAND_MAX + 1.0)));
//int h=(int) (canvas.pixelheight-1);///4 * (rand() / (RAND_MAX + 1.0)));



//int w=picimg.width+rand()*200;
//int h=picimg.height+rand()*200;

int w=picimg->width;
int h=picimg->height;


	FRAME *ch= frame_createquick(title,0,0,w,h);
	frame_append(self,ch);
	return ch;
}


static	void liqfloat_layout(float viewscale)
{
	

int w=picimg->width;
int h=picimg->height;

	
	FRAME *ch;
	PAGE *pg=NULL;
	ch=frameroot->linkchild;
	while(ch)
	{
		pg=ch->page;
		if(pg)
		{
			int fmx = pg->boundingbox.xr - pg->boundingbox.xl;
			int fmy = pg->boundingbox.yb - pg->boundingbox.yt;
			ch->w= ((float)fmx*viewscale) / ((float)pg->dpix/(float)canvas.dpix);
			ch->h= ((float)fmy*viewscale) / ((float)pg->dpiy/(float)canvas.dpiy);
			frame_update_boundfrompos(ch);
		}
		else
		{
			ch->w= ((float)w*viewscale) / ((float)picimg->dpix/(float)canvas.dpix);
			ch->h= ((float)h*viewscale) / ((float)picimg->dpiy/(float)canvas.dpiy);
			frame_update_boundfrompos(ch);
		}
		ch=ch->linknext;
	}
	
	int th = frame_neatarrange(frameroot);
	frameroot->h = th;
	frame_update_boundfrompos(frameroot);
}	

static int frameroot_init()
{
	app_log("floatpic boxes creating");
	int i;
	for(i=0;i<30;i++)
	{
		mkbutton(frameroot,"");
		mkbutton(frameroot,"");
		mkbutton(frameroot,"");
		mkbutton(frameroot,"");
		mkbutton(frameroot,"");
		
		mkbutton(frameroot,"");
		mkbutton(frameroot,"");
		mkbutton(frameroot,"");
		mkbutton(frameroot,"");
		mkbutton(frameroot,"");
	}	
	app_log("floatpic boxes layout");

	liqfloat_layout(1);
	
	app_log("floatpic boxes complete");
	return 0;
}



static	int docw=0;
static	int doch=0;

static	int viewx=0;
static	int viewy=0;

static	int vieww=0;
static	int viewh=0;

static	int viewmaxx=0;
static	int viewmaxy=0;


static	void liqfloat_preplimits()
{
	docw = frameroot->w;
	doch = frameroot->h;



	vieww = canvas.pixelwidth;
	viewh = canvas.pixelheight;

	viewmaxx = docw-vieww;
	viewmaxy = doch-viewh;

	if(viewmaxx<0)viewmaxx=0;
	if(viewmaxy<0)viewmaxy=0;





	app_log("xdoc   %i,%i",docw,doch);
	app_log("xview  %i,%i",vieww,viewh);
	app_log("xviewm %i,%i",viewmaxx,viewmaxy);
	
						if(viewx<0){viewx=0;}
						if(viewy<0){viewy=0;}
						if(viewx>=viewmaxx) {viewx=viewmaxx;}
						if(viewy>=viewmaxy) {viewy=viewmaxy;}	
	
}

#include "liqcamera.h"

int liqfloatpic_run(int usecamera)
{

	//read_JPEG_file("car.jpg");
	//read_JPEG_file("catshower.jpg");
	//read_JPEG_file("Maemo.org.jpg");
	
	
	
	//read_JPEG_file("modis_wonderglobe_lrg.jpg");
	
	
	//imgunknown=liqimage_create();
	//liqimage_pageloadjpeg(imgunknown,"catshower.jpg");
	
	

//catshower.jpg
//#define CAMW 640
//#define CAMH 480
#define CAMW 320
#define CAMH 240
//#define CAMW 160
//#define CAMH 120
	//picbuff_init();
	
int wantmap=0;
	if(usecamera==2) { wantmap=1; usecamera=0; }

	if(usecamera)
	{
	
		picimg=liqimage_create();
		liqimage_pagedefine(picimg,CAMW,CAMH,canvas.dpix,canvas.dpiy,0);
			cliprect cr;
			cliprect_initfromimage(&cr,picimg);
			cliprect_drawclear(&cr,0,128,128);
			cliprect_drawtextinside(&cr,canvas.font,0,0,picimg->width,picimg->height,"Please wait",1);
		
		liqcamera_start(CAMW,CAMH,15,    picimg,NULL);
	}
	else
	{
		
		
		
		if(!wantmap)
		{
			char buf[FILENAME_MAX+1];
			snprintf(buf,FILENAME_MAX,"%s/plane.png",app.themepath);
				
			picimg=liqimage_createfromfilepng(buf,0);
		}
		else
		{
			char buf[FILENAME_MAX+1];
			snprintf(buf,FILENAME_MAX,"%s/berlin-map-metro-big.png",app.themepath);
			picimg=liqimage_createfromfilepng(buf,0);
		}
		
		
		
	}
	app_log("floatpic creating frameroot");

	viewscale=1;

	//frameroot = frame_createquick("root",0,0,2*canvas.pixelwidth -1,canvas.pixelheight-1);
	frameroot = frame_createquick("root",0,0,picimg->width*10,canvas.pixelheight-1);
//	frameroot = frame_createquick("root",0,0,4*canvas.pixelwidth-1,canvas.pixelheight-1);
	framecurr=NULL;
	framesel=NULL;
	
	
	app_log("floatpic creating boxes");

	frameroot_init();

	//int err=0;
	
	
	


	viewx=0;
	viewy=0;
	
	
	app_log("floatpic prepping limits");

	liqfloat_preplimits();


	app_log("floatpic limits prepped");

int result=0;

int running=1;
int framecount=0;
//unsigned long tzs=app_GetTicks();
unsigned long tz0=app_GetTicks();
unsigned long tz1=app_GetTicks();
LIQEVENT ev;
int mc=0,mx=0,my=0,mp=0;
unsigned	long mt=0;
int dirty=1;		// ensure we are drawn at least once :)
int wantwait=0;

int mdx=0;
int mdy=0;
unsigned long mdt=0;
int hadmouse=0;

int refreshinprogress=0;
	app_log("floatpic entering main loop");
	canvas_clear(0);

	
	
	while(running==1)
	{
		hadmouse=0;
		while(canvas_eventcount() && (framecount>0))
		{
waitevent:
			canvas_nextevent(&ev);
			//app_log("%i",ev.key.keycode);
			if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65307) )	//ESC
			{
				app_log("Escape Pressed, Cancelling");
				running=0;
				//result=NULL;
				break;
			}
			
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65477) )	//Zoom -
			{
				
				if(viewscale>0.1) viewscale-=0.1;
				liqfloat_layout(viewscale);
				liqfloat_preplimits();
				dirty=1;
				break;
			}
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65476) )	//Zoom +
			{
				
				if(viewscale<2.0) viewscale+=0.1;
				liqfloat_layout(viewscale);
				liqfloat_preplimits();
				dirty=1;
				break;

			}
			else if(ev.type == LIQEVENT_TYPE_MOUSE)// && ev.mouse.pressure==0)
			{
				if(mc>0 && ev.mouse.pressure>0)
				{
					// we have deltas available
					mdx=mx-ev.mouse.x;
					mdy=my-ev.mouse.y;
					mdt=mt-ev.ticks;
					
					
					
					//app_log("md %i,%i",mdx,mdy);
					
					
					if(mdx>canvas.pixelwidth/6 || mdy>canvas.pixelheight/6)
					{
						// we have lost a stroke somewhere, we should end the previous one and start again
						// something went wrong and we did not hear about the final mouseup
						mc=0;
					}
					else
					{
						//int amdy=ABS(mdy);
						//if(amdy>5) mdy = SGN(mdy) * ((float)amdy * ((float)amdy / 5.0));

						//float speedscale = 8.0 * ((float)ev.mouse.x / (float)canvas.pixelwidth);
						//if(speedscale<1)speedscale=1;
						//mdy = (float)mdy * speedscale;
	
	
						viewx+=mdx;
						viewy+=mdy;
						
						
						
						if(viewx<0){viewx=0;mdx=0;}
						if(viewy<0){viewy=0;mdy=0;}
						if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
						if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}
					}

				}
				mx=ev.mouse.x;
				my=ev.mouse.y;
				mp=ev.mouse.pressure;
				mt=ev.ticks;
				mc++;
				if(mp>0)
				{
					// starting or continuing a stroke
				}				

				if(mp==0)
				{
					// finished a stroke, make sure we dont keep deletes from the last one
					mc=0;
					// we are finished hopefully, lets just try to goto sleep
					//wantwait=1;
				}
				hadmouse=1;
				dirty=1;
				//break;
			}
			else if(ev.type == LIQEVENT_TYPE_REFRESHED)
			{
				//wantwait=1;
				// ok, we have finished the refresh
				refreshinprogress=0;
				//canvas_clear(0); // ?????
				break;
			}
			else if(ev.type == LIQEVENT_TYPE_UNKNOWN)
			{
				running=0;
				break;
			}
		}

		//app_log("%i, %i, %l",mdx,mdy,mdt);
		if(mp==0 && (mdx || mdy) && dirty==0)// && 1==0)
		{
			// we have kinetic energy..

					viewx+=mdx;
					viewy+=mdy;
					if(viewx<0){viewx=0;mdx=0;}
					if(viewy<0){viewy=0;mdy=0;}
					if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
					if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}

			mdt-=SGN(mdt);
			mdx-=SGN(mdx);
			mdy-=SGN(mdy);
			dirty=1;
			hadmouse=1;
			
		//	app_log("kinetic %i,%i",mdx,mdy);
			
		}
		if(refreshinprogress==0)dirty=1;
		if(running==0) break;
		if(framecount==0 || (dirty && (refreshinprogress==0)))
		{
			//app_log("floatpic render");
			//app_log("view %i,%i.    max %i,%i",viewx,viewy,viewmaxx,viewmaxy);
			//canvas_clear(0);
			//canvas_clear(0);

			//canvas_drawrectcolor(0,0,canvas.pixelwidth,canvas.pixelheight,0,128,128);

			char buff[255];
			//int x=0;
			//int y=0;
			//int qw;
			//frame_rendertocanvas(frameroot,0,0, framesel);
			FRAME *sa=frameroot->linkchild;
			while(sa)
			{
				//frame_rendertocanvas(sa,-viewx,-viewy, framesel);
				
				//canvas_drawboxcolor(sa->x-viewx,sa->y-viewy,sa->w,sa->h ,255,48,30);
				
				
				frame_drawpic(sa,-viewx,-viewy);
				sa=sa->linknext;
			}


		if(usecamera)
		{
			canvas_drawrectcolor(canvas.pixelwidth/2,0,canvas.pixelwidth,canvas.font->glyphmaxh,0,128,128);
			snprintf(buff,255,"smile and press [Fullscreen]");//,framecount,app_fps(tz0,tz1,1),app_fps(tzs,tz0,framecount));
			canvas_drawtext(canvas.pixelwidth/2,0,buff);
		}

			canvas_refreshdisplay();
			refreshinprogress=1;
			
			dirty=0;
			wantwait=1;


			tz0=tz1;
			tz1=app_GetTicks();

			framecount++;
			
			
		}

		if(wantwait || refreshinprogress || (hadmouse==0))
		{
			wantwait=0;
			goto waitevent;
		}
	}
	
	app_log("floatpic cleanup");

	frame_close(frameroot);
	
	if(usecamera)
	{
		liqcamera_stop();
	}
	
	liqimage_free(picimg);
	picimg=NULL;
	
	app_log("floatpic complete");
	
	
	
	return result;

}

