#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>
#include <math.h>


#include "liqapp.h"
#include "liqcanvas.h"
#include "liqtile.h"

//#include "liqdialog.h"
//#include "filebuf.h"
//#include "liqdoc.h"
//#include "liqtextbuffer.h"

#include "mk_core.h"

static int runfast=0;

static liqtile *liqtileroot;
static liqtile *tilecurr=NULL;
static liqtile *tilepicgrid=NULL;
static liqtile *tilecurrtitle=NULL;
//static liqtile *tilemenu=NULL;





static int floatfile_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	tilecurr=self;
	// normal mouse action :)
	self->x-=args->mdx;
	self->y-=args->mdy;
	liqtile_update_boundfrompos(self);

	if(args->mez==0)
	{
		tilecurr=NULL;
	}
	return 0;

}














static liqtile *divefolder(liqtile *self,char *path)
{
	// todo: ensure path has no trailing "/"
	
//liqtile 		*self=NULL;
//	if(self->childcount>15) return NULL;
DIR             *dir;
struct dirent 	*dp;
char 			dpfullname[255];
struct stat     statbuf;
liqtile 		*sub=NULL;
	//app_log("walk %s ",path);
	dir = opendir(path);
	
	
	if(!dir)
	{
		app_log("opendir failed: '%s'",path);
		return NULL;			// heh thanks kot :)
	}
	
	
	while ((dp = readdir(dir)) != NULL)
	{

		if( dp->d_name[0]=='.' )
			continue;

		if( strcmp(dp->d_name,".")==0 || strcmp(dp->d_name,"..")==0 )
			continue;
		// if path has a trailing "/" already
		//sprintf(dpfullname, "%s%s", path, dp->d_name);
		// if path has no trailing "/"
		sprintf(dpfullname, "%s/%s", path, dp->d_name);
		if(stat(dpfullname, &statbuf) == -1)
		{
			printf("stat failed: '%s'\n",dpfullname);
			continue;
		}
		// got the information we need
        if ( S_ISDIR(statbuf.st_mode) )
		{
			//printf(" DIR  ");
			sub=divefolder(self,dpfullname);	
        }
		else
		if ( S_ISREG(statbuf.st_mode) )
		{
            //printf(" FILE ");
			
			//if(self->childcount>20)goto fin;
			
			char *ext=strrchr(dp->d_name,'.');
			if(!ext)ext=dp->d_name;
			if(ext)
			{
				//if( strcasecmp (dp->d_name,"meta.jpg")==0 )
				
				//if(self->childcount>0)goto fin;
		/*		if(
				   strcasecmp (ext,".page")==0 ||
				   0)
				{
					sub=liqtile_createquick(dpfullname,0,0,canvas.pixelwidth/8,canvas.pixelheight/4);
					sub->handlermouse=floatfile_mouse;
					//liqtileroot->handlerpaint=graffiti_paint;
					sub->style=styleknob;
					sub->dataclass4cc=3;//mk_fourcc("fnpg");
					liqtile_childinsertsorted(self,sub);
					
				}
		
				else
		*/
		
		
		
		
		
	
				if(
				   // pictures
				   
				   
				   
				   strcasecmp (ext,".jpeg")==0 ||
				   strcasecmp (ext,".jpg")==0 ||
				   //strcasecmp (ext,".bmp")==0 ||		// todo: add more image type readers - will use gstreamer if i  get time
				   //strcasecmp (ext,".gif")==0 ||
				   //strcasecmp (ext,".png")==0 ||
				   0)
				{
					//sub=mkfile(dpfullname,&statbuf);

					//if(strcasecmp (dp->d_name,"meta.jpg")==0)
					{

					
						sub=liqtile_createquick(dpfullname,0,0,canvas.pixelwidth/8,canvas.pixelheight/4);
						sub->handlermouse=floatfile_mouse;
						//liqtileroot->handlerpaint=graffiti_paint;
						sub->style=styleknob;
						sub->dataclass4cc=1;//mk_fourcc("fnim");
						liqtile_childinsertsortedbykey(self,sub,0);
						
					}
					
				}
				
				
				
				
			
				
			
				
				else
				if(
				   // pictures
				   strcasecmp (ext,".png")==0 ||
				   0)
				{
					//sub=mkfile(dpfullname,&statbuf);

					
					sub=liqtile_createquick(dpfullname,0,0,canvas.pixelwidth/8,canvas.pixelheight/4);
					sub->handlermouse=floatfile_mouse;
					//liqtileroot->handlerpaint=graffiti_paint;
					sub->style=styleknob;
					sub->dataclass4cc=4;//mk_fourcc("fnim");
					liqtile_childinsertsortedbykey(self,sub,0);
					
					
				}
		
			}
			
        }
	}
 //fin:
	closedir(dir);
	return self;
}














//###############################################################################
//############################################################################### graffiti rendering
//###############################################################################

int createdthisframe=0;

static void graffiti_rendertocliprect(liqtile *self,liqtile *root,cliprect *crsrc,int ox,int oy)
{
	if(!self->visible)return;
/*	int x=(ox+self->x)*canvas.pixelwidth/root->w;
	int y=(oy+self->y)*canvas.pixelheight/root->h;
	int w=(self->w)*canvas.pixelwidth/root->w;
	int h=(self->h)*canvas.pixelheight/root->h;
*/	
	int x=(ox+self->x);
	int y=(oy+self->y);
	int w=(self->w);
	int h=(self->h);
	
struct cliprect crin;
struct cliprect *cr=&crin;
	cliprect_copy(cr,crsrc);	
	cliprect_shrink(cr,x,y,x+w,y+h);
	if (cr->ex-cr->sx==0 || cr->ey-cr->sy==0) return;
	
	
	if(self->dataclass4cc==1 && createdthisframe<1)//mk_fourcc("fnim"))
	{
		// we have an image filename
		// convert it to a thumbnail :)
		
		//app.infologgingenabled=0;
		liqimage *img=liqimage_create();
		if(liqimage_pageloadjpeg(img,self->key,canvas.pixelwidth,canvas.pixelheight)!=0)
		//if(liqimage_pageloadjpeg(img,self->key,canvas.pixelwidth/4,canvas.pixelheight/4)!=0)
		{
			// failed..
			self->dataclass4cc=0;
			liqimage_free(img);
		}
		else
		{
			// ok, now upgrade the item :)
			self->data = img;
			self->dataclass4cc=2;//mk_fourcc("imag");
		}
		//app.infologgingenabled=1;
		createdthisframe++;
	}
	if(self->dataclass4cc==4 && createdthisframe<1)//mk_fourcc("fnim"))
	{
		// we have an image filename
		// convert it to a thumbnail :)
		
		//app.infologgingenabled=0;
		liqimage *img=liqimage_create();
		if(liqimage_pageloadpng(img,self->key,0,0,0)!=0)
		//if(liqimage_pageloadjpeg(img,self->key,canvas.pixelwidth/4,canvas.pixelheight/4)!=0)
		{
			// failed..
			self->dataclass4cc=0;
			liqimage_free(img);
		}
		else
		{
			// ok, now upgrade the item :)
			self->data = img;
			self->dataclass4cc=2;//mk_fourcc("imag");
		}
		//app.infologgingenabled=1;
		createdthisframe++;
	}
	
	
	if(self->dataclass4cc==2 )//mk_fourcc("imag"))
	{
		// we have an image filename
		// convert it to a thumbnail :)
		liqimage *img=self->data;
		//cliprect_drawimagecolor(cr,img,x,y,w,h);
		
		char cy=255;
		char cu=128;
		char cv=128;
		if(self->style) liqstyle_getbackcoloryuv(self->style,&cy,&cu,&cv);
		cliprect_drawimageblendcolor(cr,img,x,y,w,h,cy);
		return;
	}
	
	
	
	
	if(self->dataclass4cc==3 && createdthisframe<1)//mk_fourcc("fnpg");
	{
		// we have a page filename
		// convert it to a page :)
		
		//app.infologgingenabled=0;
		
		PAGE *page=page=page_alloc();
		
		if(page_fileload(page,self->key)!=0)
		{
			page_free(page);
		}
		else
		{
			self->data = page;
			self->dataclass4cc=4;//mk_fourcc("page");			
		}
		//app.infologgingenabled=1;
		createdthisframe++;
	}
	
	
	if(self->dataclass4cc==4)//mk_fourcc("page");
	{
		// we have an image filename
		// convert it to a thumbnail :)
		PAGE *page=self->data;
		//cliprect_drawimagecolor(cr,img,x,y,w,h);		
		cliprect_drawpage(cr,page,x,y,w,h,0);
		return;
	}	
	//app_log("render '%s'",self->key);
	
	if(self->handlerpaint)
	{
		// it wants to draw itself :)
		liqtileeventpaint evpaint;
		evpaint.surface=cr->surface;
		evpaint.cr=cr;
		evpaint.ox=ox;
		evpaint.oy=oy;
		self->handlerpaint(self,&evpaint);
		return;
	}
	
	// ############################ find common style
	liqstyle *style=NULL;
	liqtile *t=self;
	while(t && (!t->style))
	{
		t=t->linkparent;
	}
	if(t && t->style) style=t->style;



	// ############################ apply style
	if(style)
	{
		if(style->textfont)
		{
			if(h*10<style->textfont->glyphmaxh*6)return;
		}
		liqstyle_renderdefault(style,cr, x,y,w,h, self);
	}
	
	// ############################ render children
	liqtile *c=self->linkchild;
	liqtile *skipsel=NULL;
	while(c)
	{
		if(c==tilecurr)
			skipsel=c;
		else
			graffiti_rendertocliprect(c,root,cr,ox+self->x,oy+self->y);
		c=c->linknext;
	}
	if(skipsel)
			graffiti_rendertocliprect(skipsel,root,cr,ox+self->x,oy+self->y);

}






static int graffiti_paint(struct liqtile *self,liqtileeventpaint *args)
{
	//app_log("Draw something");
	// event paint should tell us how long we have been running
	// what frame we are on
	// how long since the last frame
	// we might actually need some calculation first?
	// but usually to break the jobs into discrete blocks is harder and more wasteful processing wise
	//
	
	liqtile_overlapcalc(tilepicgrid,tilecurr);
	liqtile_autoresizecontents(tilepicgrid,tilecurr);
	
	
	if(tilecurr)
	{
		if(tilecurr!=tilecurrtitle->data)
		{
			liqtile_titlechange(tilecurrtitle,tilecurr->key);
			tilecurrtitle->data=tilecurr;
		}
		tilecurrtitle->visible=1;
	}
	else
	{
		tilecurrtitle->visible=0;
	}

	
	createdthisframe=0;
	
	//canvas_clear(0);
	
	cliprect_drawclear(args->cr,0,128,128);
	
	// quick hack to block recursion..
	self->handlerpaint=NULL;
	graffiti_rendertocliprect(self,liqtileroot,args->cr,args->ox,args->oy);
	
	
	//cliprect_drawcolorcube(canvas.cr,640,0,160,320,lasty);
	
	self->handlerpaint=graffiti_paint;
	
	// once we have loaded, we have no need to continue blazing away
	//if(createdthisframe==0) runfast=0;
	return 0;
}




//###############################################################################
//############################################################################### main code
//###############################################################################



static int liqtile_freecustom(liqtile *self)
{
	if(self->data)
	{
		// todo: add additional custom data removal entries here :)
		if(self->dataclass4cc==2)//mk_fourcc("imag"))
		{
			liqimage *img=self->data;
			liqimage_free(img);
			self->data=NULL;
		}
		if(self->dataclass4cc==4)//mk_fourcc("page"))
		{
			PAGE *page=self->data;;
			page_free(page);
			self->data=NULL;
		}
	}
	liqtile *sa=self->linkchild;
	while(sa)
	{
		liqtile_freecustom(sa);
		sa=sa->linknext;
	}
	return 0;
}










int liqtile_easyrun(liqtile *self);

int liqfloatgallery_run()
{
	app_log("floatgallery starting");
	
	tilecurr=NULL;
	
	// we want to runfast this time :)
	runfast=1;
	
	
	
	if(mk_style_open() != 0)
	{
		return app_warnandcontinue(-1,"Couldnt open default styles");
	}
	
	app_log("floatgallery scanning");
	
	
		liqtileroot=liqtile_createquick("ui",0,0,canvas.pixelwidth,canvas.pixelheight);
		//liqtileroot->handlermouse=graffiti_mouse;
		liqtileroot->handlerpaint=graffiti_paint;
		liqtileroot->style=stylenone;
		
		//tilepicgrid=liqtile_createquick("picgrid",canvas.pixelwidth*0.4,0,  canvas.pixelwidth*0.6,canvas.pixelheight*0.8);
		tilepicgrid=liqtile_createquick("picgrid",canvas.pixelwidth*0,0,  canvas.pixelwidth,canvas.pixelheight*1);
		//tilepicgrid->handlermouse=graffiti_mouse;
		//tilepicgrid->handlerpaint=picgrid_paint;
		tilepicgrid->style=stylenone;
		
		liqtile_childappend(liqtileroot,tilepicgrid);

	
	
		tilecurrtitle=liqtile_createquick("currtitle",canvas.pixelwidth*0.0,canvas.pixelheight*0.8,  canvas.pixelwidth*1.0,canvas.pixelheight*0.2);
		//tilecurrtitle->handlermouse=graffiti_mouse;
		//tilecurrtitle->handlerpaint=graffiti_paint;
		tilecurrtitle->style=stylelabel;
		tilecurrtitle->visible=0;
		liqtile_childappend(liqtileroot,tilecurrtitle);
				
			divefolder(tilepicgrid,app.sketchpath);
			//divefolder(tilepicgrid,app.userpath);
			//divefolder(tilepicgrid,"/home/user");
			//divefolder(tilepicgrid,"/media/mmc2");
			//divefolder(tilepicgrid,"/media/mmc1");
			
			
			
			// should grab all in sequence, then only display a few?
			{
				liqtile *sa=tilepicgrid->linkchild;
				int cnt=0;
				while((sa) && (cnt++<12))
				{
					sa->visible=1;
					sa=sa->linknext;
					//cnt++;
				}
				while(sa)
				{
					sa->visible=0;
					sa=sa->linknext;
					cnt++;
				}				
			}
			
			

		liqtile_neatarrange_autofit_factor(tilepicgrid,0.8);
		
		app_log("floatgallery easyrun %s(%i,%i)",liqtileroot->key,liqtileroot->w,liqtileroot->h);
		
		liqtile_easyrun2(liqtileroot,&runfast);
		
		app_log("floatgallery closing tile");
		
		liqtile_freecustom(liqtileroot);
		liqtile_close(liqtileroot);
	
	mk_style_close();
	
	
	app_log("floatgallery complete");
	return 0;
}


