/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * graffiti floating sketch wall
 *
 */


//<crashanddie> feature request for liqbase
//<lcuk> "make it work"
//<crashanddie> nope
//<crashanddie> I don't care about that, take your time
//<lcuk> gfi then
//<crashanddie> in graffiti
//<crashanddie> when you click on an image
//<crashanddie> and hit a button, ask if you want to delete that image
//<lcuk> from the graffiti editor, double click (single will be scrolling) will bring up a preview screen with tag lists file info, edit sessions name, edit button and notably delete button


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>

#include "liqapp.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "filebuf.h"
#include "liqdoc.h"

#include "liqdraw.h"
#include "liqdrawframe.h"

//##########################################################################	
//##########################################################################	
//##########################################################################

#define ABS(x) ((x)<0?-(x):(x))
#define SGN(x) ((x)<0?-1:(x)==0?0:1)

static FRAME *frameroot=NULL;
static FRAME *framecurr=NULL;
static FRAME *framesel=NULL;

static	float viewscale=0.5;
/*
static FRAME *mkbutton(FRAME *self,char *title)
{
	FRAME *ch= frame_createquick(title,0,0,canvas.pixelwidth/12,canvas.pixelwidth/8);
	frame_append(self,ch);
	return ch;
}
 */
static FRAME *mksketch(FRAME *self,PAGE *pg)
{
	FRAME *ch= frame_createquick("",0,0,canvas.pixelwidth/12,canvas.pixelwidth/8);
	//frame_append(self,ch);
	//ch->pagefilename = strdup(pg->filename);
	ch->page=pg;			

	frame_childinsertsorted(self,ch);

	return ch;

}

static	void liqfloat_layout(float viewscale)
{
	FRAME *ch;
	PAGE *pg=NULL;
	ch=frameroot->linkchild;
	while(ch)
	{
		pg=ch->page;			
		int fmx = pg->boundingbox.xr - pg->boundingbox.xl;
		int fmy = pg->boundingbox.yb - pg->boundingbox.yt;
		ch->w= ((float)fmx*viewscale) / ((float)pg->dpix/(float)canvas.dpix);
		ch->h= ((float)fmy*viewscale) / ((float)pg->dpiy/(float)canvas.dpiy);

		frame_update_boundfrompos(ch);

		ch=ch->linknext;
	}

	int th = frame_neatarrange(frameroot);
	frameroot->h = th;
	frame_update_boundfrompos(frameroot);
}	

static int frameroot_init()
{
	//app.infologgingenabled = 0;
	PAGE *pg=NULL;
	char *dir_name = app.sketchpath;
    DIR           *dir_p;
    struct dirent *dir_entry_p;
    dir_p = opendir(dir_name);
	if(!dir_p)
	{
		app_log("opendir failed: '%s'",dir_name);
		return -1;			// heh thanks kot :)
	}
	//int x=0;
	//int y=0;
	char filename[1024]="\0";

	while( NULL != (dir_entry_p = readdir(dir_p)))
    {

		//if(filename[0]==0 || strcmp(filename,dir_entry_p->d_name)<0)
		{
			strncpy(filename,dir_entry_p->d_name,1024);
			char fn[1024];
			snprintf(fn,1024,"%s/%s", dir_name,filename);

			int wantfile=0;

			struct pagefilename pf;	
			if(	pagefilename_breakapart(&pf,filename) == 0)
			{
				// GOOD, we have a formatted file
				if(pf.filetitle[0])
				{
					// has a title
					wantfile=1;
				}
				else
				{
					// is anonymous
					wantfile=1;
				}
			}
			else
			{
				// not in parsable format
				wantfile=0;
			}

			if(wantfile)
			{
			//	app_log("Loading '%s'",filename);
				if(!pg) pg=page_alloc();

				if(page_fileload(pg,fn)==0)
				{

					//FRAME *sa=
					mksketch(frameroot,pg);
					// ensure we continue writing with a new one..
					pg=NULL;				
				}
				else
				{
					page_free(pg);
					pg=NULL;				
				}
			}
			//else
			//	app_log("NOT Loading '%s'",filename);

			//if(frameroot->childcount>30) break;
		}

    }
    closedir(dir_p);
	if(pg)
	{
		// free if reqd
		page_free(pg);
		pg=NULL;
	}

	//int th = frame_neatarrange(frameroot);
	//frameroot->h = th;
	//frame_update_boundfrompos(frameroot);

	//frame_overlapcalc(frameroot,NULL);
	//frame_autoresizecontents(frameroot,NULL);

	liqfloat_layout(0.5);

	//app.infologgingenabled = 1;
	return 0;
}

static	int docw=0;
static	int doch=0;

static	int viewx=0;
static	int viewy=0;

static	int vieww=0;
static	int viewh=0;

static	int viewmaxx=0;
static	int viewmaxy=0;

static	void liqfloat_preplimits()
{
	docw = frameroot->w;
	doch = frameroot->h;

	vieww = canvas.pixelwidth;
	viewh = canvas.pixelheight;

	viewmaxx = docw-vieww;
	viewmaxy = doch-viewh;

	if(viewmaxx<0)viewmaxx=0;
	if(viewmaxy<0)viewmaxy=0;

	app_log("xdoc   %i,%i",docw,doch);
	app_log("xview  %i,%i",vieww,viewh);
	app_log("xviewm %i,%i",viewmaxx,viewmaxy);

						if(viewx<0){viewx=0;}
						if(viewy<0){viewy=0;}
						if(viewx>=viewmaxx) {viewx=viewmaxx;}
						if(viewy>=viewmaxy) {viewy=viewmaxy;}	

}

extern int frame_mousep;

static FRAME *frame_firstvisible()
{
			FRAME *sa=frameroot->linkchild;

			while(sa)
			{
				if(sa->y-viewy >= 0)
				{
					return sa;
				}	
				sa=sa->linknext;
			}
			return NULL;
}

static void view_goto(FRAME *sa)
{
	if(sa)
	{
		viewy=sa->y;
						if(viewx<0){viewx=0;}
						if(viewy<0){viewy=0;}
						if(viewx>=viewmaxx) {viewx=viewmaxx;}
						if(viewy>=viewmaxy) {viewy=viewmaxy;}	
	}
}

int liqfloat_run()
{

	viewscale=0.5;

	frameroot = frame_createquick("root",0,0,canvas.pixelwidth -1,canvas.pixelheight-1);
	framecurr=NULL;
	framesel=NULL;

	frameroot_init();

	//int err=0;

	viewx=0;
	viewy=0;

	liqfloat_preplimits();

int result=0;

int running=1;
int framecount=0;
//unsigned long tzs=app_GetTicks();
unsigned long tz0=app_GetTicks();
unsigned long tz1=app_GetTicks();
LIQEVENT ev;
int mc=0,mx=0,my=0,mp=0;
unsigned	long mt=0;
int mdx=0;
int mdy=0;
unsigned long mdt=0;

int dirty=1;		// ensure we are drawn at least once :)
int wantwait=0;


int hadmouse=0;

int refreshinprogress=0;

	canvas_clear(0);

	while(running==1)
	{
		hadmouse=0;
		while(canvas_eventcount() && (framecount>0))
		{
waitevent:
			canvas_nextevent(&ev);
			//app_log("%i",ev.key.keycode);
			if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65307) )	//ESC
			{
				app_log("Escape Pressed, Cancelling");
				running=0;
				//result=NULL;
				break;
			}

			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65477) )	//Zoom -
			{
				FRAME *first = frame_firstvisible();
				if(viewscale>0.2) viewscale-=0.1;
				liqfloat_layout(viewscale);
				liqfloat_preplimits();
				dirty=1;
				view_goto(first);
				break;
			}
			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65476) )	//Zoom +
			{
				FRAME *first = frame_firstvisible();
				if(viewscale<2.0) viewscale+=0.1;
				liqfloat_layout(viewscale);
				liqfloat_preplimits();
				dirty=1;
				view_goto(first);
				break;

			}
			else if(ev.type == LIQEVENT_TYPE_MOUSE)// && ev.mouse.pressure==0)
			{
				if(mc>0 && ev.mouse.pressure>0)
				{
					// we have deltas available
					mdx=mx-ev.mouse.x;
					mdy=my-ev.mouse.y;
					mdt=mt-ev.ticks;

					if(mdx>canvas.pixelwidth/6 || mdy>canvas.pixelheight/6)
					{
						// we have lost a stroke somewhere, we should end the previous one and start again
						// something went wrong and we did not hear about the final mouseup
						mc=0;
					}
					else
					{
						//int amdy=ABS(mdy);
						//if(amdy>5) mdy = SGN(mdy) * ((float)amdy * ((float)amdy / 5.0));

						//float speedscale = 8.0 * ((float)ev.mouse.x / (float)canvas.pixelwidth);
						//if(speedscale<1)speedscale=1;
						//mdy = (float)mdy * speedscale;

						viewx+=mdx;
						viewy+=mdy;

						if(viewx<0){viewx=0;mdx=0;}
						if(viewy<0){viewy=0;mdy=0;}
						if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
						if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}
					}

				}
				mx=ev.mouse.x;
				my=ev.mouse.y;
				mp=ev.mouse.pressure;
				mt=ev.ticks;
				mc++;
				if(mp>0)
				{
					// starting or continuing a stroke
					if(mc==1)
					{
						// starting...
					}
					else
					{
						// continuing...
					}

					framesel = frame_findhit(frameroot,mx+viewx,my+viewy);
				}				

				if(mp==0)
				{
					// finished a stroke, make sure we dont keep deletes from the last one
					framesel=NULL;
					mc=0;
					// we are finished hopefully, lets just try to goto sleep
					//wantwait=1;
				}
				hadmouse=1;
				dirty=1;
				
				//break;
			}
			else if(ev.type == LIQEVENT_TYPE_REFRESHED)
			{
				//wantwait=1;
				// ok, we have finished the refresh
				refreshinprogress=0;
				//canvas_clear(0); // ?????
				break;
			}
			else if(ev.type == LIQEVENT_TYPE_UNKNOWN)
			{
				running=0;
				break;
			}
		}

		//app_log("%i, %i, %l",mdx,mdy,mdt);
		if(mp==0 && (mdx || mdy) && dirty==0)// && 1==0)
		{
			
			// we have kinetic energy..
			hadmouse=1;
			framesel=NULL;

					viewx+=mdx;
					viewy+=mdy;
					if(viewx<0){viewx=0;mdx=0;}
					if(viewy<0){viewy=0;mdy=0;}
					if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
					if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}

			mdt-=SGN(mdt);
			mdx-=SGN(mdx);
			mdy-=SGN(mdy);
			dirty=1;
		}
		if(running==0) break;
		if(framecount==0 || (dirty && (refreshinprogress==0)))
		{
			//app_log("view %i,%i.    max %i,%i",viewx,viewy,viewmaxx,viewmaxy);
			//canvas_clear(0);
			canvas_clear(0);

			//canvas_drawrectcolor(0,0,canvas.pixelwidth,canvas.pixelheight,0,128,128);

			//char buff[255];
			//int x=0;
			//int y=0;
			//int qw;
			//frame_rendertocanvas(frameroot,0,0, framesel);
			FRAME *sa=frameroot->linkchild;

			//frame_mousep = mp;
			while(sa)
			{
				frame_rendertocanvas(sa,-viewx,-viewy, NULL);// framesel);
				//canvas_drawboxcolor(sa->x-viewx,sa->y-viewy,sa->w,sa->h ,255,48,30);		
				sa=sa->linknext;
			}

			canvas_refreshdisplay();
			refreshinprogress=1;

			dirty=0;
			wantwait=1;
			
			tz0=tz1;
			tz1=app_GetTicks();
			framecount++;
		}


		if(wantwait || refreshinprogress || (hadmouse==0))
		{
			wantwait=0;
			goto waitevent;
		}
	}

	frame_close(frameroot);
	return result;

}

