/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * rotated editor seedling
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>

#include "liqapp.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "filebuf.h"
#include "liqdoc.h"

//##########################################################################	
//##########################################################################	
//##########################################################################

#define SGN(x) ((x)<0?-1:(x)==0?0:1)

int liqed_run()
{
	int err=0;

	// we now assume we have a FIXED POINT font
	// this will only work if that assumption is kept
	LIQFONT edfont;
	err=liqfont_openfile(&edfont,"/usr/share/fonts/lucon.ttf",20,90,canvas.scalew,canvas.scaleh);
	//err=liqfont_openfile(&edfont,canvas.font->name,canvas.font->size+10,0,canvas.scalew,canvas.scaleh);
	if(err)
	{
    	{ return app_warnandcontinue(-1,"liqed_run couldnt open font"); }						
	}	

	// grab the file and process it :)
	struct doc doc;
	doc.renderfont=NULL;
	//doc.renderfont=&edfont;
	//doc.rendermarginright=canvas.pixelwidth;
//	doc.rendermarginbottom=99999999;

	int r90=1;

	err=doc_initfromfilename(&doc,"liqed.c");
	//err=doc_initfromfilename(&doc,"/usr/bin/liq/moteineye.txt");
	//err=doc_initfromfilename(&doc,"/usr/share/liqbase/liqreader_readme.txt");
	if(err)
	{
    	{ return app_warnandcontinue(-1,"liqed_run couldnt open doc.."); }						
	}
	struct docline *line;
	line=doc.linefirst;
	//while(line)
	{
		// do line handling now :)
	//	line=line->linknext;		
	}

	int charw=0;
	int charh=0;

	int docw=0;
	int doch=0;

	int viewx=0;
	int viewy=0;

	int vieww=0;
	int viewh=0;

	int viewminx=0;
	int viewminy=0;


	int viewmaxx=0;
	int viewmaxy=0;

	int sellines = 78;
	int sellinee = 94;
	int selcols = 4;
	int selcole = 18;
	if(r90)
	{
		charw = edfont.glyphstdh;
		charh = edfont.glyphstdw;		
	}
	else
	{
		charw = edfont.glyphstdw;
		charh = edfont.glyphstdh;
	}
	if(doc.renderfont)
	{
		if(r90)
		{
			docw=doc.rendertoth;
			doch=doc.rendertotw;			
		}
		else
		{
			docw=doc.rendertotw;
			doch=doc.rendertoth;
		}
		
	}
	else
	{
		if(r90)
		{
			docw = charw * doc.linecount;
			doch = charh * doc.linelongest;
		}
		else
		{
			docw = charw * doc.linelongest;
			doch = charh * doc.linecount;
		}
	}

	vieww = canvas.pixelwidth; // - charw*5;   //(for line numbers..)
	viewh = canvas.pixelheight;

	viewmaxx = docw-vieww;
	viewmaxy = doch-viewh;

	if(viewmaxx<0)viewmaxx=0;
	if(viewmaxy<0)viewmaxy=0;

	app_log("doc   %i cols, %i lines",doc.linelongest,doc.linecount);

	app_log("xchar  %i,%i",charw,charh);
	app_log("xdoc   %i,%i",docw,doch);
	app_log("xview  %i,%i",vieww,viewh);
	app_log("xviewm %i,%i",viewmaxx,viewmaxy);

int result=0;

int running=1;
int framecount=0;
//unsigned long tzs=app_GetTicks();
unsigned long tz0=app_GetTicks();
unsigned long tz1=app_GetTicks();
LIQEVENT ev;
int mc=0,mx=0,my=0,mp=0;
unsigned	long mt=0;
int dirty=1;		// ensure we are drawn at least once :)
int wantwait=0;

int mdx=0;
int mdy=0;
unsigned long mdt=0;
int hadmouse=0;
int refreshinprogress=0;

	canvas_clear(0);
	while(running==1)
	{
		hadmouse=0;
		while(canvas_eventcount() && (framecount>0))
		{
waitevent:
			canvas_nextevent(&ev);
			//app_log("%i",ev.key.keycode);
			if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65307) )	//ESC
			{
				app_log("Escape Pressed, Cancelling");
				running=0;
				//result=NULL;
				break;
			}
			if(ev.type == LIQEVENT_TYPE_MOUSE)// && ev.mouse.pressure==0)
			{
				if(mc>0 && ev.mouse.pressure>0)
				{
					// we have deltas available
					mdx=mx-ev.mouse.x;
					mdy=my-ev.mouse.y;
					mdt=mt-ev.ticks;

					viewx+=mdx;
					viewy+=mdy;
					if(viewx<0){viewx=0;mdx=0;}
					if(viewy<0){viewy=0;mdy=0;}
					if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
					if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}
				}
				mx=ev.mouse.x;
				my=ev.mouse.y;
				mp=ev.mouse.pressure;
				mt=ev.ticks;
				mc++;
				if(mp>0)
				{
					// starting or continuing a stroke
				}				

				if(mp==0)
				{
					// finished a stroke, make sure we dont keep deletes from the last one
					mc=0;
					// we are finished hopefully, lets just try to goto sleep
					//wantwait=1;
				}
				hadmouse=1;
				dirty=1;
				//break;
			}
			if(ev.type == LIQEVENT_TYPE_REFRESHED)
			{
				//wantwait=1;
				refreshinprogress=0;
				break;
			}
			if(ev.type == LIQEVENT_TYPE_UNKNOWN)
			{
				running=0;
				break;
			}
		}
		
					viewx-=4;
					viewy+=0;
					if(viewx<0){viewx=0;mdx=0;}
					if(viewy<0){viewy=0;mdy=0;}
					if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
					if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}
					dirty=1;
		
		//app_log("%i, %i, %l",mdx,mdy,mdt);
		if(mp==0 && (mdx || mdy) && dirty==0)
		{
			// we have kinetic energy..

					viewx+=mdx;
					viewy+=mdy;
					if(viewx<0){viewx=0;mdx=0;}
					if(viewy<0){viewy=0;mdy=0;}
					if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
					if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}

			mdt-=SGN(mdt);
			mdx-=SGN(mdx);
			mdy-=SGN(mdy);
			dirty=1;
		}
		if(running==0) break;
		if((dirty && (refreshinprogress==0)))
		{
			canvas_clear(0);
			int x=0;
			int y=0;
			int ln=0;

			ln=0;
			x=-viewx;
			y=-viewy;
			line=doc.linefirst;
			while(line)
			{
				// do line handling now :)
				if(ln>999999) break;
				if(x+charh>vieww) break;
				if(x+charh>=0 && x<vieww)
				{
					// draw this line
					int ye=canvas_font_drawtextn(&edfont,x,y,line->linedata,line->linelength);
					//if(ye<canvas.pixelheight)
					//{
					//	canvas_drawrect(x,ye,canvas.font->glyphmaxw,canvas.pixelheight-ye,0);
					//}							
				}
				x=x+charh;
				ln++;
				line=line->linknext;
			}
			canvas_refreshdisplay();
			refreshinprogress=1;
			dirty=0;
			wantwait=1;
		}

		tz0=tz1;
		tz1=app_GetTicks();
		framecount++;
		
		if(wantwait || refreshinprogress)
		{
			wantwait=0;
			goto waitevent;
		}
	}

	liqfont_close(&edfont);
	return result;

}

