/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * editor/text viewer seedling  uses kinetics
 *
 */



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>

#include "liqapp.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "filebuf.h"
#include "liqdoc.h"

#include "liqbase_prefs.h"

int liqbookprogress_startreading_lookupposition(char *bookfilename,int *storedfilelength,int *storedreadupto);
void liqbookprogress_finishedreading_storeposition(char *bookfilename,int filelength,int readupto);


int 			autoscroll_inuse=0;
int 			autoscroll_pix_per_min=3000;
unsigned long 	autoscroll_lasttick=0;

//##########################################################################	
//##########################################################################	
//##########################################################################

#define SGN(x) ((x)<0?-1:(x)==0?0:1)




static int fontsizechanged=0;

//static int edfontsize = 24;



int liqed_internal_run(char *sourcefilename)
{
	int err=0;

	// we now assume we have a FIXED POINT font
	// this will only work if that assumption is kept
	LIQFONT edfont;
	
	// nokia fixed width font does not come out fixed width
	
	
int edfontsize;
	char * t=NULL;
	if((t=liqbase_pref_getvalue("book_fontsize")))
	{
		edfontsize=atoi(t);
	}
	else
	{
		edfontsize=24;
	}
	
	if(edfontsize<8)edfontsize=8;
	if(edfontsize>72)edfontsize=72;

#ifdef USE_MAEMO
	err=liqfont_openfile(&edfont,"/usr/share/fonts/nokia/nosnb.ttf",edfontsize,0,canvas.scalew,canvas.scaleh);
#else // USE_MAEMO
	err=liqfont_openfile(&edfont,"/usr/share/fonts/lucon.ttf",edfontsize,0,canvas.scalew,canvas.scaleh);
#endif
	
	
	// for now just put one in that does
	//if(sourcefilename==NULL)
	//	err=liqfont_openfile(&edfont,"lucon.ttf",20,0,canvas.scalew,canvas.scaleh);
	//else
	//	err=liqfont_openfile(&edfont,"lucon.ttf",16,0,canvas.scalew,canvas.scaleh);
	
	
	//NcrRR4nh.ttf
	//"/usr/share/fonts/nokia/nosnb.ttf"
	
	//err=liqfont_openfile(&edfont,canvas.font->name,canvas.font->size+10,0,canvas.scalew,canvas.scaleh);
	if(err)
	{
    	{ return app_warnandcontinue(-1,"liqed_run couldnt open font"); }						
	}	

	// grab the file and process it :)
	struct doc doc;
	doc.renderfont=NULL;
	
	
	doc.renderfont=&edfont;
	doc.rendermarginright=canvas.pixelwidth;
	//doc.rendermarginbottom=99999999;

	//err=doc_initfromfilename(&doc,"liqed.c");
	if(sourcefilename==NULL)
	{
		char buf[FILENAME_MAX+1];
		snprintf(buf,FILENAME_MAX,"%s/liqbase-example.txt",app.themepath);

		err=doc_initfromfilename(&doc,buf);
	}
	else
	{
		err=doc_initfromfilename(&doc,sourcefilename);
		
	}
	
	
	
//void liqbookprogress_startreading(char *bookfilename,int *storedfilelength,int *storedreadupto)

	
	
	
	if(err)
	{
    	{ return app_warnandcontinue(-1,"liqed_run couldnt open doc.."); }						
	}
	struct docline *line;
	line=doc.linefirst;
	//while(line)
	{
		// do line handling now :)
	//	line=line->linknext;		
	}

	int charw=0;
	int charh=0;

	int docw=0;
	int doch=0;

	int viewx=0;
	int viewy=0;

	int vieww=0;
	int viewh=0;

	int viewmaxx=0;
	int viewmaxy=0;

	int sellines = 78;
	int sellinee = 94;
	int selcols = 4;
	int selcole = 18;

	charw = edfont.glyphstdw;
	charh = edfont.glyphstdh;
	if(doc.renderfont)
	{
		docw=doc.rendertotw;
		doch=doc.rendertoth;
	}
	else
	{
		docw = charw * doc.linelongest;
		doch = charh * doc.linecount;
	}

	vieww = canvas.pixelwidth; // - charw*5;   //(for line numbers..)
	viewh = canvas.pixelheight;

	viewmaxx = docw-vieww;
	viewmaxy = doch-viewh;

	if(viewmaxx<0)viewmaxx=0;
	if(viewmaxy<0)viewmaxy=0;

	app_log("doc   %i cols, %i lines",doc.linelongest,doc.linecount);

	app_log("xchar  %i,%i",charw,charh);
	app_log("xdoc   %i,%i",docw,doch);
	app_log("xview  %i,%i",vieww,viewh);
	app_log("xviewm %i,%i",viewmaxx,viewmaxy);
	
	
	if(sourcefilename)
	{
		int sfl=0;
		int sfu=0;
		if(liqbookprogress_startreading_lookupposition(sourcefilename,&sfl,&sfu))
		{
			//
			if((sfl>0) && (sfu>0) && (sfu <= sfl))
			{
				viewy = (int)((float)sfu * (float)sfl / (float)doch);
				
				app_log("viewy: %i sfu %i sfl %i doch %i",viewy,sfu,sfl,doch);
				
					if(viewy<0){viewy=0;}
					if(viewy>=viewmaxy) {viewy=viewmaxy;}

			}
			
		}
	}






int result=0;

int running=1;
int framecount=0;
unsigned long tzs=app_GetTicks();
unsigned long tz0=app_GetTicks();
unsigned long tz1=app_GetTicks();
LIQEVENT ev;
int mc=0,mx=0,my=0,mp=0;
unsigned	long mt=0;
int dirty=1;		// ensure we are drawn at least once :)
int wantwait=0;

int mdx=0;
int mdy=0;
unsigned long mdt=0;
int hadmouse=0;

int refreshinprogress=0;

	canvas_clear(0);
	while(running==1)
	{
		hadmouse=0;
		while(canvas_eventcount() && (framecount>0))
		{
waitevent:
			canvas_nextevent(&ev);
			//app_log("%i",ev.key.keycode);
			if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==65307) )	//ESC
			{
				app_log("Escape Pressed, Cancelling");
				running=0;
				//result=NULL;
				break;
			}


			else if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) )
			{
				
				
				if( (ev.key.keycode==65362 ) ) // DPAD UP
				{
					if(autoscroll_inuse)
					{
						app_log("Down Pressed, autoscroll slower");
						autoscroll_pix_per_min-=100;
						if(autoscroll_pix_per_min<1000)
							autoscroll_pix_per_min=1000;
						dirty=1;
						break;
						
					}
					else
					{
						app_log("Up Pressed, Move Back");
						viewy -= (viewh-charh); //(((viewy - canvas.pixelheight)/ font_height)+1)*font_height;
							if(viewx<0){viewx=0;mdx=0;}
							if(viewy<0){viewy=0;mdy=0;}
							if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
							if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}
						dirty=1;
						break;
					}
				}
				
				
				else if(  (ev.key.keycode==65477) )	//Zoom -
				{
					edfontsize-=1;
					fontsizechanged=1;
					running=0;
					break;
				}
				
				else if(  (ev.key.keycode==65476) )	//Zoom +
				{
					edfontsize+=1;
					fontsizechanged=1;
					running=0;
					break;
				}
				
				else if( (ev.key.keycode==65364 ) ) // DPAD DOWN
				{
					if(autoscroll_inuse)
					{
						app_log("Down Pressed, autoscroll faster");
						autoscroll_pix_per_min+=100;
						if(autoscroll_pix_per_min>10000)
							autoscroll_pix_per_min=10000;
						dirty=1;
						break;
						
					}
					else
					{
						app_log("Down Pressed, Move next Page");
						viewy += (viewh-charh);//((viewy + canvas.pixelheight)/ font_height)*font_height;
							if(viewx<0){viewx=0;mdx=0;}
							if(viewy<0){viewy=0;mdy=0;}
							if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
							if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}
						dirty=1;
						break;
					}
				}
				else if( (ev.key.keycode==65473) )  // menu
				{
					//feature:autoscroll stop/start with menu key
					if(autoscroll_inuse==0)
					{
						app_log("Menu Pressed, Starting autoscroll");
						autoscroll_lasttick=0;
						autoscroll_inuse=1;
					}
					else
					{
						app_log("Menu Pressed, Stopping autoscroll");
						autoscroll_inuse=0;
					}
					dirty=1;
					break;
				}	
				
				
			}
			
	
				
			else if(ev.type == LIQEVENT_TYPE_MOUSE)// && ev.mouse.pressure==0)
			{
				if(mc>0 && ev.mouse.pressure>0)
				{
					// we have deltas available
					mdx=mx-ev.mouse.x;
					mdy=my-ev.mouse.y;
					mdt=mt-ev.ticks;

					viewx+=mdx;
					viewy+=mdy;
					if(viewx<0){viewx=0;mdx=0;}
					if(viewy<0){viewy=0;mdy=0;}
					if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
					if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}
				}
				mx=ev.mouse.x;
				my=ev.mouse.y;
				mp=ev.mouse.pressure;
				mt=ev.ticks;
				mc++;
				if(mp>0)
				{
					// starting or continuing a stroke
				}				

				if(mp==0)
				{
					// finished a stroke, make sure we dont keep deletes from the last one
					mc=0;
					// we are finished hopefully, lets just try to goto sleep
					//wantwait=1;
				}
				hadmouse=1;
				dirty=1;
				//break;
			}

			else if(ev.type == LIQEVENT_TYPE_REFRESHED)
			{
				//wantwait=1;
				// ok, we have finished the refresh
				refreshinprogress=0;
				//canvas_clear(0); // ?????
				break;
			}
			else if(ev.type == LIQEVENT_TYPE_UNKNOWN)
			{
				running=0;
				break;
			}
		}
		//app_log("%i, %i, %l",mdx,mdy,mdt);
		if(mp==0 && (mdx || mdy) && dirty==0)
		{
			// we have kinetic energy..

					viewx+=mdx;
					viewy+=mdy;
					if(viewx<0){viewx=0;mdx=0;}
					if(viewy<0){viewy=0;mdy=0;}
					if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
					if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}
			hadmouse=1;
			mdt-=SGN(mdt);
			mdx-=SGN(mdx);
			mdy-=SGN(mdy);
			dirty=1;
		}
		
		if(autoscroll_inuse)
		{
			
			// we need to know when now is
			unsigned long now=app_GetTicks();
			unsigned long dif=now-autoscroll_lasttick;
			int adj = 0;
			
			if(autoscroll_lasttick && (dif<1000))
			{
				adj = dif * autoscroll_pix_per_min / 60 / (1000 / (canvas.scaleh));
				if(adj)
				{
					autoscroll_lasttick=now;
				}
			}
			else
			{
				autoscroll_lasttick=now;
			}
			if(adj)
			{
				viewy+=adj;
			
			
				if(viewx<0){viewx=0;mdx=0;}
				if(viewy<0){viewy=0;mdy=0;}
				if(viewx>=viewmaxx) {viewx=viewmaxx;mdx=0;}
				if(viewy>=viewmaxy) {viewy=viewmaxy;mdy=0;}
				hadmouse=1;
				dirty=1;
			}
			
		}
		
		if(running==0) break;
		if(framecount==0 || (dirty && (refreshinprogress==0)))
		{
			//app_log("view %i,%i.    max %i,%i",viewx,viewy,viewmaxx,viewmaxy);
			canvas_clear(0);

			
			int x=0;
			int y=0;
			//int qw;

			line=doc.linefirst;
			int ln=0;
			x=-viewx; // +charw*4-viewx;
			y=-viewy;
			while(line)
			{
				// do line handling now :)
				if(ln>999999) break;
				//if(y+charh>viewh) break;
				if(y>viewh) break;
				if(y+charh>=0 && y<viewh)
				{
					// draw this line
					
					
					// handle displaying the selection
					if(ln>=sellines && ln<=sellinee && (sourcefilename==NULL))
					{
						int l=selcols;
						int r=selcole;

						if(sellines==sellinee)
						{
							// all on one line
							l=selcols;
							r=selcole;
						}
						else
						if(ln==sellines)
						{
							// starting a multi line selection
							l=selcols;
							r=line->linelength;
						}
						else
						if(ln==sellinee)
						{
							// ending a multi line selection
							l=0;
							r=selcole;
						}		
						else
						{
							// in the middle of a multi line selection
							l=0;
							r=line->linelength;							
						}
						int twl = liqfont_textwidthn(&edfont,line->linedata,l);
						int twr = liqfont_textwidthn(&edfont,line->linedata,r);
						int sl=twl-viewx;
						int sr=twr-viewx;

						//int sl=l*charw-viewx;
						//int sr=r*charw-viewx;
						canvas_drawrectwash(sl,y,sr-sl,charh,80,250);

					}
					
					
					// i don't like starting from scratch every time, but its not that bad.


					canvas_font_drawtextn(&edfont,x,y,line->linedata,line->linelength);
					
					//app_log("line %i, %s",y,line->linedata);

				}

				y=y+charh;
				ln++;
				line=line->linknext;		
			}
			
			
			char buff[255];
			if(sourcefilename==NULL)
			{
				snprintf(buff,255,"fc %i    %1.5f,  %1.5f             ",framecount,app_fps(tz0,tz1,1),app_fps(tzs,tz0,framecount));
				canvas_drawtext(0,0,buff);
			}

			canvas_refreshdisplay();
			refreshinprogress=1;
			dirty=0;
			wantwait=1;
			tz0=tz1;
			tz1=app_GetTicks();

			framecount++;
		}

		if(wantwait || refreshinprogress || (hadmouse==0))
		{
			wantwait=0;
			if(autoscroll_inuse && refreshinprogress==0)
			{
				// dont jump yet
			}
			else
				goto waitevent;
		}
	}
	
	
	
	if(sourcefilename)
	{
		int sfl=0;
		int sfu=0;
		
		sfl = doch;
		sfu = viewy;
		
		liqbookprogress_finishedreading_storeposition(sourcefilename,sfl,sfu);
	}
	

	liqfont_close(&edfont);
	
	if(fontsizechanged)
	{

		liqbase_pref_setvalue_printf("book_fontsize","%i",edfontsize);
		
		liqbase_prefs_save();
		//
	}
	
	return result;

}

int liqed_run(char *sourcefilename)
{
	char *bookname=strdup(sourcefilename);
	int res=0;
	fontsizechanged=1;
	while(fontsizechanged)
	{
		app_log("book reading: %s",bookname);
		fontsizechanged=0;
		res=liqed_internal_run(bookname);
	}
	free(bookname);
	return res;
}

