/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Header for frame management
 *
 */


#ifndef LIQDRAWFRAME_H
#define LIQDRAWFRAME_H


#include "liqdraw.h"

//##################################################################
//################################################################## frame base
//##################################################################


struct framebox
{
	// to sit inside a frame
	int sx;		// BOUND actual start/end for the frame, these may be negative and indicate the actual stroke used to create the frame
	int sy;
	int ex;
	int ey;

	int x;		// POS   actual legal positions obtained from the stroke above
	int y;
	int w;
	int h;

	int overlapx;  // results of the overlap calculation, if these are none zero then the frame should adjust itself
	int overlapy;
};

struct frameborder
{
	// to sit inside a frame
	int bsx;		// border sizes
	int bsy;
	int bex;
	int bey;
	int bcx;		// gap between children
	int bcy;
	int binnerw;	// available space within the border
	int binnerh;
};

typedef struct frame
{
	//############ required for tree handling
	
	struct frame *linkparent;
	struct frame *linkprev;
	struct frame *linknext;
	struct frame *linkchild;
	int childcount;
	
	//############ Cater for the base frame
	
	int sx;		// BOUND actual start/end for the frame, these may be negative and indicate the actual stroke used to create the frame
	int sy;
	int ex;
	int ey;

	int x;		// POS   actual legal positions obtained from the stroke above
	int y;
	int w;
	int h;

	int overlapx;  // results of the overlap calculation, if these are none zero then the frame should adjust itself
	int overlapy;


	//############
	
	struct framebox box;


	char *title;
	
	PAGE *page;				// the actual icon.  shouldn't this itself hold its own filename?
	//char *pagefilename;		// icon



} FRAME;

//##################################################################

FRAME *frame_create();
//##################################################################

FRAME *frame_lastchild(FRAME *self);

//##################################################################

void frame_insert(FRAME *self,FRAME *c);

void frame_append(FRAME *self,FRAME *c);

void frame_childinsertsorted(FRAME *self,FRAME * ch);

//##################################################################

void frame_close(FRAME *self);

//int frame_pageautoloadbytitle(FRAME *self);
int frame_pageautoloadbytitle(FRAME *self,char *basepath);
int frame_pageautoloadbytitle_apg(FRAME *self);

int frame_fullyqualifiedtitle(FRAME *self,char *buffer, int bufferlen);

void frame_titlechange(FRAME *self,char *newtitle);

//##################################################################

void frame_update_posfrombound(FRAME *self);
//##################################################################

void frame_update_boundfrompos(FRAME *self);
//##################################################################

void frame_bound_ensurepositive(FRAME *self);
void frame_print(FRAME *self,char *reason);
//##################################################################

void frame_editstart(FRAME *self,int x,int y);

//##################################################################

void frame_editexpand(FRAME *self,int x,int y);
//##################################################################



void frame_editcomplete(FRAME *self);


//##################################################################

void frame_forceinbound(FRAME *self,int bsx,int bsy,int bex,int bey);
void frame_forceinboundparent(FRAME *self);
//##################################################################

FRAME *frame_createquick(char *title,int x,int y,int w,int h);

//##################################################################

int frame_getsurfacearea_p2(FRAME *self);
//##################################################################


void frame_autoresizecontents(FRAME *self,FRAME *selection);
void frame_overlapcalc(FRAME *self,FRAME *selection);

int frame_gethit(FRAME *self,int x,int y,int *hitx,int *hity);


//##################################################################
//##################################################################
//##################################################################


void 		frame_rendertocanvas(FRAME *self,int ox,int oy,FRAME *selection);
int 		frame_neatarrange(FRAME *self);
FRAME * 	frame_findhit(FRAME *self,int x,int y);


#endif
