/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * frame management
 *
 */




#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>

#include "liqapp.h"
#include "liqbook.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "liqdraw.h"

#include "liqdrawframe.h"

#define ABS(X) ((X)>=0?(X):-(X))

//##################################################################
//################################################################## dimension base
//##################################################################
// dimension isnt really a class, its just a span of Start..End and handling of it
//#####################################################################
void dimension_forceinbound(register int *s,register int *e,register int l,register int r)
{
	register int d=*e-*s;
	register int w=r-l;
	register int isneg=0;
	if(d<0  ){register int t=*s;*s=*e;*e=t;d=-d;isneg=1;}
	if(d>w  ){*e-=d-w;        }
	if(*s<l ){*e+=l-*s;*s=l;  }
	if(*e>=r){*s-=*e-(r);*e=r;  }
	if(isneg){register int t=*s;*s=*e;*e=t;d=-d;}
}

//#####################################################################
inline int dimension_overlapcalc(register int cs,register int ce,register int ds,register int de,int *overlapres)
{
	// single dimension quick calc
	if(ce < ds) return -2;		//  CCC    DDDDDD
	if(ce == ds) return -1;		//  CCCDDDDDD
	if(de < cs) return 2;		//  DDDDDD    CCC
	if(de == cs) return 1;		//  DDDDDDCCC
	if(cs <= ds)
	{
		// C starts before D starts
		if( ce <= de )	
		{
			// a partial overlap exists
			*overlapres = (ds-ce);
			return 0;
		}
		// D is smaller than us
		// we are wholey engulfing D
		// GET IT OUT OF ME!
		// we take the shortest route out.
		if( (ce-de) < (ds-cs) )
		{
			// D is closer to the right hand side of C
			*overlapres = (ds-ce);
			return 0;
		}
		else
		{
			// D is closer to the left hand side of C
			// this should be negative
			*overlapres = (cs-de);
			return 0;
		}
	}
	else
	{
		// D starts before C starts
		if( de <= ce )	
		{
			// a partial overlap exists
			*overlapres = -(cs-de);
			return 0;
		}
		// D is smaller than us
		// we are wholey engulfing D
		// GET IT OUT OF ME!
		// we take the shortest route out.
		if( (de-ce) < (cs-ds) )
		{
			// D is closer to the right hand side of C
			*overlapres = -(cs-de);
			return 0;
		}
		else
		{
			// D is closer to the left hand side of C
			// this should be negative
			*overlapres = -(ds-ce);
			return 0;
		}
	}
}

//##################################################################
//################################################################## frame base
//##################################################################

//##################################################################

FRAME *frame_create()
{
	FRAME *self = (FRAME *)malloc(sizeof(FRAME));
	if(self==NULL) {  app_errorandfail(-1, "FRAME creation failed" ); return NULL; }
	// NULL everything
	memset((char *)self,0,sizeof(FRAME));
	return self;
}
//##################################################################

FRAME *frame_lastchild(FRAME *self)
{
	if(self->linkchild==NULL)return NULL;
	FRAME *sa=self->linkchild;
	while(sa)
	{
		if(sa->linknext==NULL) return sa;
		sa=sa->linknext;
	}
	return NULL;
}

//##################################################################

void frame_insert(FRAME *self,FRAME *c)
{
	c->linkparent=self;
	c->linkprev=NULL; // we are at the start
	c->linknext=self->linkchild;
	self->linkchild = c;
	self->childcount++;
}

void frame_append(FRAME *self,FRAME *c)
{
	FRAME *sa=frame_lastchild(self);
	if(sa==NULL)
	{
		frame_insert(self,c);
		return;
	}
	c->linkparent=self;
	c->linkprev=sa;
	c->linknext=NULL;	// we are at the end
	sa->linknext=c;
	self->childcount++;
}

void frame_childinsertsorted(FRAME *self,FRAME * ch)
{
	// insert sorted
	if(!self->linkchild || !ch->page) // filename)
	{
		// first child
		frame_append(self,ch);
		return;// ch;
	}
	else
	{
		FRAME *sa=ch;
		FRAME *xx=self->linkchild;
		while(xx)
		{
			if(xx->page && xx->page->filename && strcmp(sa->page->filename,xx->page->filename)> 0)
			{
				// insert it here...
				if(xx==self->linkchild)
				{
					// first child
					self->linkchild = sa;
					sa->linkparent = self;
					sa->linkprev = xx->linkprev;
					sa->linknext = xx;
					xx->linkprev = sa;
					return;// sa;
				}
				else
				{
					// in the middle
					FRAME *yy=xx->linkprev;
					sa->linkparent = self;
					sa->linkprev = yy;
					sa->linknext = xx;
					yy->linknext = sa;
					xx->linkprev = sa;
					return;// sa;
				}
			}
			xx=xx->linknext;
		}
		frame_append(self,ch);
		return;// ch;
	}
	return;// ch;
}

//##################################################################

void frame_close(FRAME *self)
{
	// unlink from our own chain
	if(self->linkparent)
	{
		if(self == self->linkparent->linkchild)
		{
			self->linkparent->linkchild = self->linknext;
		}
		self->linkparent->childcount--;
	}
	self->linkparent=NULL;
	if(self->linkprev) self->linkprev->linknext = self->linknext;
	if(self->linknext) self->linknext->linkprev = self->linkprev;

	if(self->title){ free(self->title); self->title=NULL; }
	//if(self->pagefilename) { free(self->pagefilename); self->pagefilename=NULL; }
	if(self->page){ page_free(self->page); self->page=NULL;}

	// destroy our children
	while(self->linkchild)
	{
		FRAME *c = self->linkchild;
		FRAME *n = c->linknext;
		if(n) n->linkprev = NULL;			
		c->linkparent=NULL;
		self->linkchild = n;
		self->childcount--;
		frame_close(c);
	}

	free((char *)self);
}


int frame_pageautoloadbytitle_apg(FRAME *self)
{

	return frame_pageautoloadbytitle(self,app.sketchpath);
}

int frame_pageautoloadbytitle(FRAME *self,char *basepath)
{
	// Initialize the ->page member based upon the title
	// this should not really be used anymore
	// todo: check folder exists
	// todo: check folder contents readable

	if((!self->title) || (*self->title==0))
	{
		// null or blank, release the page if we have one
		//if(self->pagefilename) { free(self->pagefilename); self->pagefilename=NULL; }
		if(self->page){ page_free(self->page); self->page=NULL;}
		return -3; // no title to match
	}

	PAGE *pg=NULL;
	char lookfor[255];
	snprintf(lookfor,255,".page.%s",self->title);
	//char *dir_name = "/home/user/MyDocs/_apg";
	char *dir_name = basepath;
    DIR           *dir_p;
    struct dirent *dir_entry_p;
    dir_p = opendir(dir_name);
	
	if(!dir_p)
	{
		app_log("opendir failed: '%s'",dir_name);
		return -4;			// heh thanks kot :)
	}
	
	char filename[1024]="\0";
	while( NULL != (dir_entry_p = readdir(dir_p)))
    {
		// check each file and see if its our pattern
		// yes, shoot me now i need to use "*.page.title" as pattern but im not sure how in linux	
		if(instr(dir_entry_p->d_name, lookfor))
		{
			// now make sure we only select first or the latest one (filenames include datestamp as key),
			// simple to change in future to check actual dates
			if(filename[0]==0 || strcmp(filename,dir_entry_p->d_name)<0)
			{
				strncpy(filename,dir_entry_p->d_name,1024);
			}
		}
    }
    closedir(dir_p);
	//if(self->pagefilename) { free(self->pagefilename); self->pagefilename=NULL; }
	if(self->page){ page_free(self->page); self->page=NULL;}
	if(filename[0])
	{
		// we matched the suffix
		// obtain the full name including path
		char fn[1024];
		snprintf(fn,1024,"%s/%s", dir_name,filename);
		pg=page_alloc();
		if(page_fileload(pg,fn)==0)
		{
			// we have a valid page for this title
			// lets store the information and continue
			//self->pagefilename = strdup(fn);
			self->page=pg;
			return 0;
		}
		page_free(pg);
		pg=NULL;
		return -2;	// filename found, but it was invalid
	}

	return -1; // no match
}

void frame_titlechange(FRAME *self,char *newtitle)
{
	//if(self->page) { page_free(self->page); self->page=NULL; }
	if((!newtitle) || (*newtitle==0))
	{
		// null or blank
		//if(self->pagefilename) { free(self->pagefilename); self->pagefilename=NULL; }
		//if(self->page){ page_free(self->page); self->page=NULL;}
		if(self->title){ free(self->title); self->title=NULL; }
		self->title=NULL;
		return;
	}

	self->title = strdup(newtitle);
	//strncpy(self->title ,newtitle       ,20);
	
	// now, one of the most complex operations known to man
	// identify the latest PAGE from the pages file and load it in..
	// i must do a directory listing searching for the latest file "liq.*.newtitle.page"
	// note: 24jun2008: gb: removed this from here
	// decoupling frame title from page
	// they can still be initialized as required, however the automatic approach is wrong
	//frame_getpagebytitle(self);

}

//##################################################################

void frame_update_posfrombound(FRAME *self)
{
	if(self->sx<=self->ex) 
							{  self->x=self->sx;  self->w=self->ex-self->sx; }
	else
							{  self->x=self->ex;  self->w=self->sx-self->ex; }

	if(self->sy<=self->ey)	
							{  self->y=self->sy;  self->h=self->ey-self->sy; }
	else
							{  self->y=self->ey;  self->h=self->sy-self->ey; }
}

//##################################################################

void frame_update_boundfrompos(FRAME *self)
{
	self->sx=self->x;
	self->sy=self->y;
	self->ex=self->x+self->w;
	self->ey=self->y+self->h;
}

//##################################################################

void frame_bound_ensurepositive(FRAME *self)
{
	if(self->sx>self->ex) {int t=self->sx;self->sx=self->ex;self->ex=t;}
	if(self->sy>self->ey) {int t=self->sy;self->sy=self->ey;self->ey=t;}
}

void frame_print(FRAME *self,char *reason)
{
	app_log("Line(%i,%i)-step(%i,%i),, B       (%i,%i)-(%i,%i)",
				self->x ,self->y ,self->w ,self->h ,
				self->sx,self->sy,self->ex,self->ey);
}
//##################################################################

void frame_editstart(FRAME *self,int x,int y)
{
	self->sx=x;
	self->sy=y;
	self->ex=x;
	self->ey=y;
	frame_update_posfrombound(self);
}

//##################################################################

void frame_editexpand(FRAME *self,int x,int y)
{
	self->ex=x;
	self->ey=y;
	frame_update_posfrombound(self);
}

//##################################################################

void frame_editcomplete(FRAME *self)
{
	frame_bound_ensurepositive(self);
	frame_update_posfrombound(self);
}

//##################################################################

void frame_forceinbound(FRAME *self,int bsx,int bsy,int bex,int bey)
{
	dimension_forceinbound(&self->sx,&self->ex,bsx,bex);
	dimension_forceinbound(&self->sy,&self->ey,bsy,bey);
	frame_update_posfrombound(self);
}

void frame_forceinboundparent(FRAME *self)
{
	FRAME *par=self->linkparent;
	if(par)
	{
		//dimension_forceinbound(&self->sx,&self->ex,par->sx,par->ex);
		//dimension_forceinbound(&self->sy,&self->ey,par->sy,par->ey);
		dimension_forceinbound(&self->sx,&self->ex,0,par->w);
		dimension_forceinbound(&self->sy,&self->ey,0,par->h);
	}

	frame_update_posfrombound(self);
}

//##################################################################

FRAME *frame_createquick(char *title,int x,int y,int w,int h)
{
	FRAME *self = frame_create();
	self->x=x;
	self->y=y;
	self->w=w;
	self->h=h;

	frame_update_boundfrompos(self);
	frame_forceinboundparent(self);

	frame_titlechange(self,title);
	
	
	return self;
}

int frame_fullyqualifiedtitle(FRAME *self,char *buffer, int bufferlen)
{
int pl=0;
	// return actual length used
	if(self->linkparent)
	{
		pl = frame_fullyqualifiedtitle(self->linkparent,buffer,bufferlen);
		if(pl<0) return -1;
		bufferlen-=pl;
		buffer+=pl;
		if(bufferlen==0) return pl;
		int a=snprintf(buffer,bufferlen,".%s",self->title);
		if(a<0) return -1;
		pl+=a;
		return pl;
	}
	int a=snprintf(buffer,bufferlen,"%s",self->title);
	if(a<0) return -1;
	return a;
}

//##################################################################

int frame_getsurfacearea_p2(FRAME *self)
{
	int dx=self->w; //self->ex-self->sx;
	int dy=self->h; //self->ey-self->sy;
	return dx*dx+dy*dy;
}

//##################################################################

void frame_autoresizecontents(FRAME *self,FRAME *selection)
{
	FRAME *c;
	c=self->linkchild;
	while(c)
	{
		if((c->overlapx) || (c->overlapy))
		{
			if(c==selection)
			{
				if((c->w+4)<canvas.pixelwidth /3) {c->x-=4;c->w+=8;}	// bigger  - not yet, we can sweep a path though
				if((c->h+4)<canvas.pixelheight/3) {c->y-=4;c->h+=8;}
				frame_update_boundfrompos(c);
				frame_forceinboundparent(c);
			}
			else
			{
				if((c->w>30) && (c->h>30))
				{
					c->x+=1;		// smaller
					c->y+=1;
					c->w-=2;
					c->h-=2;
					frame_update_boundfrompos(c);
					frame_forceinboundparent(c);
				}
			}
		}
		else
		{
			if(c==selection)
			{
				if((c->w+8)<canvas.pixelwidth /3) {c->x-=4;c->w+=8; }	// bigger
				if((c->h+8)<canvas.pixelheight/3) {c->y-=4;c->h+=8; }
				frame_update_boundfrompos(c);
				frame_forceinboundparent(c);
			}
		}
		c=c->linknext;
	}
}

void frame_overlapcalc(FRAME *self,FRAME *selection)
{
	//if(self->visible==0) return NULL;

	FRAME *c;
	// clear overlap settings for every child
	c=self->linkchild;
	while(c)
	{
		// first clear the overlap for everything
		c->overlapx=0;
		c->overlapy=0;
		c=c->linknext;
	}

	// calculate the overlapping
	c=self->linkchild;
	while(c)
	{

		// now, we do something clever
		FRAME *d=c->linknext;
		while(d)
		{
			// we calculate the overlap between c&d
			int olw=0;
			int olh=0;
			if( dimension_overlapcalc(c->x,c->x+c->w,   d->x,d->x+d->w,   &olw) == 0
			&&	dimension_overlapcalc(c->y,c->y+c->h,   d->y,d->y+d->h,   &olh) == 0
			   )
			{
				if(olw && ABS(olw) < ABS(olh))
				{
					olh=0;
					//olh=(int)((float)olh*0.1);
				}
				if(olh && ABS(olh) < ABS(olw))
				{
					olw=0;
					//olw=(int)((float)olw*0.1);
				}

				// we know what the force is going to be and in which direction :)
				//app_log("c %i, d %i",c->ident,d->ident);
				olw/=2;
				olh/=2;
				c->overlapx+=olw;
				c->overlapy+=olh;
				d->overlapx-=olw;
				d->overlapy-=olh;
			}

			d=d->linknext;
		}
		// parent boundary adjustment
		if(c->x<0)c->overlapx-=c->x;
		if(c->y<0)c->overlapy-=c->y;
		if(c->x>=self->w)c->overlapx-=c->x-self->w;
		if(c->y>=self->h)c->overlapy-=c->y-self->h;

		c=c->linknext;
	}
	// now i go round and apply that overlap
	c=self->linkchild;
	while(c)
	{
		// first clear the overlap for everything
		if(c!=selection)
		{
			c->x+=c->overlapx;
			c->y+=c->overlapy;
			frame_update_boundfrompos(c);

			//frame_forceinbound(c,0,0,self->w-1,self->h-1);
			frame_forceinboundparent(c);
		}

		c=c->linknext;
	}
}

int frame_gethit(FRAME *self,int x,int y,int *hitx,int *hity)
{
int ishit=0;
	*hitx=0;
	*hity=0;
		 if(x<self->sx)
			{*hitx=-2;          }
	else if(x==self->sx)
			{*hitx=-1;	ishit=1;}
	else if(x==self->ex)
			{*hitx=1;	ishit=1;}
	else if(x>self->ex)
			{*hitx=2;	        }
	else
			{*hitx=0; ishit=1;}

		 if(y<self->sy)
			{*hity=-2;          }
	else if(y==self->sy)
			{*hity=-1; ishit=1;}	
	else if(y==self->ey)
			{*hity=1; ishit=1;}		
	else if(y>self->ey)
			{*hity=2;	      }
	else
			{*hity=0; ishit=1;}	
	if(*hitx==0 && *hity==0)
		ishit=1;
	else
		ishit=0;

	//app_log("%i,%i,%i",*hitx,*hity,ishit);
	return ishit;
}

//##################################################################
//##################################################################
//##################################################################

int frame_mousep=0;

void frame_rendertocanvas(FRAME *self,int ox,int oy,FRAME *selection)
{
	// draw me

	if(self->linkchild)
	{
		FRAME *sa=self->linkchild;
		while(sa)
		{
			frame_rendertocanvas(sa,ox+self->x,oy+self->y,selection);
			sa=sa->linknext;
		}
		//return;
	}
	else
	{
		if(self->page)
		{

			if(self == selection)
			{
				if(frame_mousep>600) frame_mousep=600;
				if(frame_mousep<100) frame_mousep=100;
				float fac = ((float)(600-frame_mousep))/(500.0 * 4.0);
				int ww=(self->w>>1)*fac;
				int hh=(self->h>>1)*fac;
				page_rendertocanvas(self->page,ox+self->x+ww,oy+self->y+hh,self->w-ww*2,self->h-hh*2);
			}
			else
			{
				page_rendertocanvas(self->page,ox+self->x,oy+self->y,self->w,self->h);
			}
		}		
		else
		{
		/*	if(page)
			{
				page_rendertocanvas(page,ox+self->x,oy+self->y,self->w,self->h);
			}
			else*/

			{
				//app_log("Line(%i,%i)-step(%i,%i),,B",ox+self->x,oy+self->y,self->w,self->h);
				canvas_drawrectcolor(ox+self->x,oy+self->y,self->w,self->h,200,40,220);		// inside
			}
		}
	}

	//if(self == selection)
	//	canvas_drawboxcolor(ox+self->x,oy+self->y,self->w,self->h ,255,48,30);		
	//else
	//	canvas_drawboxcolor(ox+self->x,oy+self->y,self->w,self->h ,255,128,128);

}

int frame_neatarrange(FRAME *self)
{
	// we must arrange our items without our boundary, however items can leave by the bottom

	int x=0,y=0;
	int lh=0;
	FRAME *sa=self->linkchild;
	while(sa)
	{

		if(x+sa->w>self->w)
		{
			// this item does not fit on the current line
			if(x==0)
			{
				// however we are the first on the line...
				sa->x=0;
				sa->y=y;
				frame_update_boundfrompos(sa);
				x=0;
				y=y+lh;
				lh=0;
			}
			else
			{
				// simply start a new line
				x=0;
				y=y+lh;
				lh=sa->h;
				sa->x=x;
				sa->y=y;
				frame_update_boundfrompos(sa);
				x=x+sa->w;
			}
		}
		else
		{
			if(sa->h>lh) lh=sa->h;
			// this item fits on the line
			sa->x=x;
			sa->y=y;
			frame_update_boundfrompos(sa);
			x=x+sa->w;
		}
		//app_log("frame '%s' %i,%i",sa->title,sa->x,sa->y);
		sa=sa->linknext;
	}
	return y+lh+1;
}

FRAME * frame_findhit(FRAME *self,int x,int y)
{
	int hitx,hity;
	FRAME *sa=self->linkchild;
	while(sa)
	{
		hitx=0;
		hity=0;
		if(  frame_gethit(sa,x,y,&hitx,&hity) != 0 )
		{
			// we hit this one..
			// does it have anything inside it?
			if(sa->linkchild)
			{
				FRAME *inner = frame_findhit(sa,x-sa->x,y-sa->y);
				if(inner) return inner;
				// we will just ignore this for now, but of course it will be listed
				// i should list the fully qualified title..
			}
			//app_log("hit '%s'",sa->title);

			char titbuf[1024]="\0";
			frame_fullyqualifiedtitle(sa,titbuf,1024);

			app_log("hit '%s'",titbuf);//,sa->pagefilename);

			return sa;
		}
		sa=sa->linknext;
	}
	return NULL;
}
