/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Header for basic sketch
 *
 */




#ifndef LIQDRAW_H
#define LIQDRAW_H


struct liqtile;


//##################################################################

typedef struct POINT
{
	struct POINT *linkprev;
	struct POINT *linknext;
	int           x;
	int           y;
	int           z;	
	unsigned long t;
} POINT;

POINT         *point_alloc();
void          point_new(POINT *self);
void          point_free(POINT *self);
POINT         *point_clone(POINT *s);
inline void   point_copy(POINT *self,POINT *s) ;
inline void   point_getdiff(POINT *self,POINT *s,POINT *e) ;
inline int    point_issame(POINT *self,POINT *s);

//##################################################################

typedef struct POINTRANGE
{
	int xl;
	int yt;
	int xr;
	int yb;
	int zf;
	int zb;
} POINTRANGE;
void          pointrange_start(POINTRANGE *self,POINT *p);
void          pointrange_extendrubberband(POINTRANGE *self,POINT *p);

//##################################################################
typedef struct STROKE 
{
	struct STROKE *linkprev;
	struct STROKE *linknext;
	
	struct PAGE   *linkpage;
	
	unsigned char pen_y;		// todo we can pack these nowadays ;)
	unsigned char pen_u;		// infact, we can style them :)
	unsigned char pen_v;		// hmmm..
	unsigned char pen_thick;
	
	int           strokekind;	// 0=normal stroke, 1=p2p line, 2=box, 3=areafill
	
	short 		  selected;
	short         islandnumber;
	
	char *		  mediakey;		// filename used as xref for image or subtile.  when selected the file should be moved into the project folder
	// media is the key into another page
	
	struct PAGE   *mediapage;	// this is NOT freed here, it is YOUR job to handle it
	
	// normalization involves scaling to unit
	char   		  *quadchain;	// the results of normalizing the stroke and building a quadchain list
	
	int           pointcount;
	POINT         *pointfirst;
	POINT         *pointlast;
	POINTRANGE    boundingbox;
	

} STROKE;


STROKE        *stroke_alloc();
void          stroke_new(STROKE *self);
void          stroke_clear(STROKE *self);
void          stroke_free(STROKE *self);
STROKE        *stroke_clone(STROKE *s);
void 		  stroke_appendpoint(STROKE *self,POINT *p);

void          stroke_start(STROKE *self,int px,int py, int pz);
void          stroke_extend(STROKE *self,int px,int py, int pz);
int           stroke_totallength(STROKE *self);
void          stroke_ensurepositive(STROKE *self);
int           stroke_hittest(STROKE *self,int px,int py);
char *        stroke_quadchainbuild(STROKE *self);


//##################################################################
typedef struct PAGE 
{
	
	struct liqtile *     owner;
	
	int           pixelwidth;
	int           pixelheight;

	int           dpix;
	int           dpiy;
	
	char          *title;
	char          *filename;
	int 		  islandcount;
	
	int           strokecount;
	STROKE        *strokefirst;
	STROKE        *strokelast;
	//STROKE        *strokecurrent;
	POINTRANGE    boundingbox;

} PAGE;



PAGE          *page_alloc();
void          page_new(PAGE *self);
void          page_free(PAGE *self);
void          page_titlechange(PAGE *self,char *title);

void          page_strokeinsert(PAGE *self,STROKE *s);
void          page_strokeupdate(PAGE *self,STROKE *s);
void          page_strokeremove(PAGE *self,STROKE *s);
void          page_clear(PAGE *self);

void 		  page_rendertocanvas(PAGE *self,int l,int t,int w,int h);
int 		  page_filesave(PAGE *self,char *filename);
int 		  page_fileload(PAGE *self,char *filename);

void          page_boundwholearea();

void 		  page_coordchange_scr_to_page(PAGE *self,int scrx,int scry,int scrw,int scrh, int scrdpix,int scrdpiy,int *rx,int *ry);
void 		  page_islandcalcall(PAGE *self);		// identify the islands within this page :)


struct pagefilename
{
	// From: /home/user/MyDocs/_apg/liq.lcuk.20080525_021309.page.ccm
	
	char filepath[255+1];		// /home/user/MyDocs/_apg
	//char filename[255+1];		// liq.lcuk.20080525_021309.page.ccm
	char fileuser[15+1];		// lcuk
	char filedate[15+1];		// 20080525_021309
	char fileclass[20+1];		// page
	char filetitle[20+1];		// ccm
};

int 		  pagefilename_breakapart(struct pagefilename *self,char *filename);
char 		  *pagefilename_rebuild(struct pagefilename *self,char *bufferresultfilename,int buffermax);


#endif
