/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * quick dialog and menu screens
 *
 */


#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include "liqdialog.h"
#include "liqapp.h"
#include "liqfont.h"
#include "liqcanvas.h"

#include <X11/keysym.h>



// header is fontbig.height + canvas.pixelheight*0.1


int liqdialog_showoption(char *question,int defaultanswer,int answercount, char ** answers)
{
	return liqdialog_askv(NULL,question,NULL,NULL,defaultanswer,answercount,answers);
}



int liqdialog_showyesno(char *question)
{	
	int todo=0;
	
		//
		{
			char *options[]={"Yes","No",0};
			todo=liqdialog_showoption(question,-1,2,&options[0]);
		}
		switch(todo)
		{
			case -1:
				return -1;
			case 0:
				return 0;
				break;
			case 1:
				return -1;
				break;
		}
		
	return -1;
}


//###########################################################################
//###########################################################################
//###########################################################################


//###########################################################################
//###########################################################################
//###########################################################################
int liqdialog_ask(char *key,char *question,char *description,char *footingnotes,int defaultoption,char *option1, ...)
{
	//todo: make this ask() function call showoption passing all the parameters
	//todo: once it works, expand name put it in dialog class
	//description comes from key, should be base configurable here though
	//icon comes from key
	//char *options[10];
	//int result=liqdialog_showoption(question,0,&options[0]);
	//..
	char *answerarray[20];
	int answercount=0;
	if(!option1)
	{
		// nothing to ask...
		return -1;
	}
	answerarray[0] = option1;
	answercount=1;
	va_list arg;
	va_start(arg, option1);
	
	char *a;
	for(answercount=1;answercount<19;answercount++)
	{
		a = va_arg (arg, char *);
		if(a==NULL)
		{
			// reached the end
			break;
		}
		answerarray[answercount] = a;
	}
	answerarray[answercount] = NULL;
	
	va_end(arg);
	
	return liqdialog_askv(key,question,description,footingnotes,defaultoption,0,answerarray);
}

int liqmenu_askv(char *key,char *question,char *description,char *footingnotes,int defaultoption,int answercount,char ** answers);

int liqdialog_askv(char *key,char *question,char *description,char *footingnotes,int defaultoption,int answercount,char ** answers)
{
	// gulp..	
	return liqmenu_askv(key,question,description,footingnotes,defaultoption,answercount,answers);

	
	
	if(answercount==0)
	{
		char **a=answers;
		while(*a++) 
		{
			if(answercount>20)break;		// for now, lets not get stuck...
			answercount++;
		}
	}
	
	if(!footingnotes)footingnotes="contact liquid@gmail.com, lcuk on #maemo";
	
	app_log("Running Dialog with %i options",answercount);

	LIQFONT fontbig;
	int fontbigsize = canvas.font->size+12;
	if(liqfont_openfile(&fontbig,canvas.font->name,fontbigsize,0,canvas.scalew,canvas.scaleh)!=0)
	{
		return app_warnandcontinue(-1,"Couldnt open bigfont");
	}

	LIQFONT fontsmall;
	int fontsmallsize = canvas.font->size-12;
	if(fontsmallsize<8) fontsmallsize=8;
	if(liqfont_openfile(&fontsmall,canvas.font->name,fontsmallsize,0,canvas.scalew,canvas.scaleh)!=0)
	{
		return app_warnandcontinue(-1,"Couldnt open smallfont");
	}
	
	

	
	//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ calc basic layout
	int hhead = 0;	// Question Title BIG
	int hdesc = 0;	// Question Subtitle normal
	int hbody = 0;	// Body Area
	int hfoot = 0;	// Footing Notes normal
	                hhead = fontbig.glyphmaxh;
	if(description) hdesc = canvas.font->glyphmaxh;
	if(footingnotes)hfoot = canvas.font->glyphmaxh;
                  	hbody = canvas.pixelheight-hhead-hdesc-hfoot;
	
	
	app_log("hhead %i,  hdesc %i, hbody %i,  hfoot %i",hhead,hdesc,hbody,hfoot);
	
	
	//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ now work out how many rows and cols we need
	
	
	int ccols=1;
	while(ccols<3 && ccols<answercount)ccols++;
	int crows=answercount/ccols;
	while(ccols*crows<answercount)crows++;
	
	int tilew =  canvas.pixelwidth / ccols;
	int tileh = (canvas.pixelheight-hhead-hdesc-hfoot) / crows;

	

	
	app_log("Tile cnt %i, rowcol(%i,%i)  size(%i,%i)   can(%i,%i)",answercount,ccols,crows, tilew,tileh,canvas.pixelwidth,canvas.pixelheight);
int result=-1;
int running=1;
int framecount=0;
//unsigned long tzs=app_GetTicks();
//unsigned long tz0=app_GetTicks();
//unsigned long tz1=app_GetTicks();
LIQEVENT ev;
int mx=0,my=0;
//int mp=0;
int wipestarted=0;
unsigned long wipestarttime=0;
float wipeupto=0.0;

int dirty=1;		// ensure we are drawn at least once :)

	canvas_clear(0);
	while(running==1)
	{
		while(canvas_eventcount() && (framecount>0))
		{
waitevent:
			canvas_nextevent(&ev);
		
			if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) && (ev.key.keycode==XK_Escape) )
			{
				app_log("Escape Pressed, Cancelling Dialog == -1");
				running=0;
				result=-1;
				break;
			}
			else
			if(ev.type == LIQEVENT_TYPE_MOUSE && wipestarted)
			{
				// finishing, we know who we want
			}
			else
			if(ev.type == LIQEVENT_TYPE_MOUSE)// && ev.mouse.pressure==0)
			{
				mx=ev.mouse.x;
				my=ev.mouse.y;
				
				if(my<hhead + hdesc || my >hhead+hdesc+hbody)
				{
					// hit in the header or footer
					result=-1;
					dirty=1;
				}
				else
				{
					// hit somewhere in answer block
					// find the Row/Col
					int c=mx/tilew;
					int r=(my-(hhead+hdesc))/tileh;
					
					int res =r*ccols+c;
					if(res<0 || res>=answercount)res=-1;
					
					if(res!=result)
					{

						app_log("xxx: %i, %i",res,result);
						result=res;
						dirty=1;
						if(result<0 || result>=answercount) {result=-1;break;}
						
					}
					if( ev.mouse.pressure==0 && result>=0)
					{
						dirty=1;
						app_log("Dialog Accepted: %i, %s",result,answers[result]);
						wipestarted=1;
						wipestarttime=app_GetTicks();
						//running=0;
						break;
					}

				}
			}
			else
			if(ev.type == LIQEVENT_TYPE_UNKNOWN)
			{
				running=0;
				break;
			}
		}
		unsigned long now=app_GetTicks();
		
		if(wipestarted)
		{

			// ok, we are in a transition phase
			// time to wibble ourselves
			wipeupto = (float)(now-wipestarttime) / 125;
			if( wipeupto>1.0 )
				running=0;
				
			// instant close, kot thinks its better, find a nicer way to debounce
			running=0;
			dirty=1;

			//app_log("wipe now=%i st=%i diff=%i upto=%f",(int)now,(int)wipestarttime,(int)(now-wipestarttime),wipeupto);

		}
		if(running==0) break;

		
		if(dirty)
		{

			char buff[255];
			
			//int x=0;
			int y=0;
			int qw;

			
			if(question)
			{
				y =0;
				snprintf(buff,255,"%s",question);
				//qw=liqfont_textwidth(&fontbig,buff);
				//if(qw>canvas.pixelwidth)qw=canvas.pixelwidth;
				qw=canvas.pixelwidth;
				canvas_font_drawtext(&fontbig,((canvas.pixelwidth-qw)>>1),y,buff);			
			}

			
			
			if(description)
			{
				y =hhead;
				snprintf(buff,255,"%s",description);
				//qw=liqfont_textwidth(canvas.font,buff);
				//if(qw>canvas.pixelwidth)qw=canvas.pixelwidth;
				qw=canvas.pixelwidth;
				canvas_font_drawtext(canvas.font,((canvas.pixelwidth-qw)>>1),y,buff);			
			}

			if(footingnotes)
			{
				y =hhead+hdesc+hbody;
				snprintf(buff,255,"%s",footingnotes);
				//qw=liqfont_textwidth(canvas.font,buff);
				//if(qw>canvas.pixelwidth)qw=canvas.pixelwidth;
				qw=canvas.pixelwidth;
				canvas_font_drawtext(canvas.font,((canvas.pixelwidth-qw)>>1),y,buff);			
			}
			
			int r=0;
			int c=0;
			int a=0;
			int n=0;
			
			int qh=0;
			for(a=0;a<answercount;a++)
			{
				int xx=c*tilew;
				int yy=r*tileh+hhead+hdesc;
				int bright=(a==result?100:50);
				if(a==defaultoption)bright+=20;
				
				if(wipestarted && a==result)
				{
					bright+=(int)(   (float)(255-bright)*wipeupto   );
				}
				
				
				canvas_drawrectcolor(xx,yy,tilew-3,tileh-3,bright,a==defaultoption?100:120,a==defaultoption?100:190);//rand(255),rand(255));
				
				
				char title[255] = "";
				char desc[255] = "";
				int tbrk=0;

				
				
				char *pch=strchr(answers[a],'|');
				if(pch)
				{
					tbrk = ((long)pch)-((long)answers[a]);
					if(tbrk > 255)tbrk=0;
					pch++;
				}
				if(tbrk>0)
				{	
					// we have a description
					strncpy(title,answers[a],tbrk);
					strncpy(desc ,pch       ,255);
				}
				else
				{
					strncpy(title,answers[a],255);

				}
				
				
				// get text available inside area
				n=liqfont_textfitinside(canvas.font,title,tilew);
				// find its size
				qw=liqfont_textwidthn(canvas.font,title,n);
				if(qw>tilew)qw=tilew;
				//qw=tilew;
				qh=canvas.font->glyphmaxh;
				canvas_drawtextn(xx+((tilew-qw)>>1),yy+((tileh-qh)>>1),title,n);
				
				

				// get text available inside area
				n=liqfont_textfitinside(&fontsmall,desc,tilew);
				// find its size
				qw=liqfont_textwidthn(&fontsmall,desc,n);
				if(qw>tilew)qw=tilew;
				//qw=tilew;
				qh=canvas.font->glyphmaxh;
				canvas_font_drawtextn(&fontsmall,xx+((tilew-qw)>>1),yy+((tileh-qh)>>1)+qh,desc,n);

				
				c=c+1;
				if(c>=ccols){c=0;r=r+1;}
			}
				

			
			canvas_refreshdisplay();
			dirty=0;
			
		}
			if(wipestarted==0)
				goto waitevent;
	}
	
	
	//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
	
	
	

	liqfont_close(&fontbig);
	liqfont_close(&fontsmall);
	return result;
}


