
#ifndef LIQCLIPRECT_H
#define LIQCLIPRECT_H


#include "liqfont.h"
#include "liqdraw.h"
#include "liqimage.h"

typedef struct cliprect
{
	int sx;
	int sy;
	int ex;
	int ey;
	liqimage *surface;		// thinking about this one... it may make encapsutation easier
} cliprect;


//##################################################################
//##################################################################
//##################################################################

cliprect *	cliprect_create();
void 		cliprect_free(					cliprect *self);

inline void cliprect_initfromimage(			cliprect *self,liqimage *surface);


inline void cliprect_shrink(				cliprect *self,int sx,int sy,int ex,int ey);
inline void cliprect_copy(					cliprect *self,cliprect *other);
/*
inline int cliprect_rectcheckinside(struct cliprect *self,int sx,int sy,int ex,int ey);
inline int cliprect_pointcheckinside(struct cliprect *self,int x,int y);
 */
void 		cliprect_print(					cliprect *self,char *prefix);

//##################################################################
//################################################################## drawing functions
//##################################################################

inline void cliprect_drawclear(				cliprect *self,unsigned char grey,unsigned char u,unsigned char v);
void 		cliprect_drawpsetcolor(			cliprect *self,int x, int y, unsigned char grey,unsigned char u,unsigned char v);
inline void cliprect_drawpgetcolor(      	cliprect *self,int x1, int y1, unsigned char *grey,unsigned char *u,unsigned char *v);

void 		cliprect_drawlinerowcolor(		cliprect *self,int x1, int y1, int x2, int y2, unsigned char grey,unsigned char u,unsigned char v);
void 		cliprect_drawlinecolcolor(		cliprect *self,int x1, int y1,int x2, int y2, unsigned char grey,unsigned char u,unsigned char v);
void 		cliprect_drawlinecolor(			cliprect *self,int x1, int y1, int x2, int y2, unsigned char grey,unsigned char u,unsigned char v);
void 		cliprect_drawboxlinecolor(		cliprect *self,int x,int y,int w,int h,unsigned char grey,unsigned char u,unsigned char v);
void 		cliprect_drawboxfillcolor(		cliprect *self,int x,int y,int w,int h,unsigned char grey,unsigned char u,unsigned char v);

void 		cliprect_drawcolorcube(cliprect *self,int x,int y,int w,int h,unsigned char grey);


inline void cliprect_drawglyph_grey(		cliprect *self,LIQFONT *font,int x,int y,unsigned char glyph);
int  		cliprect_drawtext(         		cliprect *self,LIQFONT *font,int xs,int ys,char *data);
int  		cliprect_drawtextn(				cliprect *self,LIQFONT *font,int xs,int ys,char *data,int datalen);
void 		cliprect_drawtextcentredon(		cliprect *self,LIQFONT *font,int cx,int cy,char *text);
void 		cliprect_drawtextcentredonlimit(cliprect *self,LIQFONT *font,int cx,int cy,char *text,int availablewidth);
void 		cliprect_drawtextinside(		cliprect *self,LIQFONT *font,int x,int y,int w,int h,char *text,int alignx);
void 		cliprect_drawpage(				cliprect *self,PAGE *page,int l,int t,int w,int h,int drawmode);	// 0=preview, 1=latest point only, 2=fully detailed



inline void cliprect_drawimagecolor(		cliprect *self,liqimage *image,int x,int y,int w,int h);
inline void cliprect_drawimageblendcolor(	cliprect *self,liqimage *image,int x,int y,int w,int h,char blend);

#endif


