

#include <stdlib.h>
#include <stdio.h>

#include <memory.h>

#include "liqcliprect.h"
#include "liq_xsurface.h"
#include "liqapp.h"
//#include "liqcanvas.h"

//##################################################################
//##################################################################
//##################################################################



cliprect *cliprect_create()
{
	app_log("cliprect create");
	cliprect *self = (cliprect *)malloc(sizeof(cliprect));
	if(self==NULL) {  app_errorandfail(-1, "cliprect creation failed" ); return NULL; }
	// NULL everything
	memset((char *)self,0,sizeof(cliprect));
	return self;
}

void cliprect_free(cliprect *self)
{
	app_log("cliprect free");
	free(self);
}


inline void cliprect_initfromimage(			cliprect *self,liqimage *surface)
{
	app_log("cliprect initfromimage");
	self->sx=0;
	self->sy=0;
	self->ex=surface->width-1;
	self->ey=surface->height-1;
	self->surface=surface;
}

inline void cliprect_shrink(cliprect *self,int sx,int sy,int ex,int ey)
{
	// given a cliprect and another rectangle, 
	if(sx > self->sx) self->sx=sx;
	if(sy > self->sy) self->sy=sy;
	if(ex < self->ex) self->ex=ex;
	if(ey < self->ey) self->ey=ey;
}
inline void cliprect_copy(cliprect *self,cliprect *other)
{
	self->sx=other->sx;
	self->sy=other->sy;
	self->ex=other->ex;
	self->ey=other->ey;
	self->surface=other->surface;
}

/*
inline int cliprect_rectcheckinside(cliprect *self,int sx,int sy,int ex,int ey)
{
	if(sx >= self->sx &&
	   sy >= self->sy &&
	   ex <= self->ex &&
	   ey <= self->ey)
		return 1;
	else
		return 0;
}

inline int cliprect_pointcheckinside(cliprect *self,int x,int y)
{
	if(x >= self->sx &&
	   y >= self->sy &&
	   x <= self->ex &&
	   y <= self->ey)
		return 1;
	else
		return 0;
}
 */

void cliprect_print(cliprect *self,char *prefix)
{
	app_log("clip %s : %i %i : %i %i",prefix,self->sx,self->ex,self->sy,self->ey);
}

//##################################################################
//################################################################## drawing functions
//##################################################################




inline void cliprect_drawclear(cliprect *self,unsigned char grey,unsigned char u,unsigned char v)
{
	// todo follow the clipregion rules tsk tsk
	if(self->sx==0 && self->sy==0 && self->ex==(self->surface->width-1) && self->ey==(self->surface->height-1))
		xsurface_drawclear_yuv(self->surface,grey,u,v);
	else
		cliprect_drawboxfillcolor(self,self->sx,self->sy,self->ex-self->sx,self->ey-self->sy,grey,u,v);
	
}



void 		cliprect_drawpsetcolor(			cliprect *self,int x, int y, unsigned char grey,unsigned char u,unsigned char v)
{
	xsurface_drawpset_yuv(self->surface,x,y,grey,u,v);
}


inline void cliprect_drawpgetcolor(      	cliprect *self,int x, int y, unsigned char *grey,unsigned char *u,unsigned char *v)
{
	xsurface_drawpget_yuv(self->surface,x,y,grey,u,v);
	
}






void cliprect_drawlinerowcolor(cliprect *self,int x1, int y1, int x2, int y2, unsigned char grey,unsigned char u,unsigned char v)
{
	// horizontal row x1..x2,y1
	if(y1<self->sy) return;
	if(y1>self->ey) return;
	if(x1>x2){int t=x1;x1=x2;x2=t;}
	if(x2<self->sx) return;
	if(x1>self->ex) return;
	if(x1<self->sx) x1=self->sx;
	if(x2>self->ex) x2=self->ex;
	// draw the line now cleanly and technically without any further bound checking - it is 100% inside the boundary
	xsurface_drawline_yuv(self->surface,x1,y1,x2,y1,grey,u,v);
}

void cliprect_drawlinecolcolor(cliprect *self,int x1, int y1,int x2, int y2, unsigned char grey,unsigned char u,unsigned char v)
{
	// horizontal row x1,y1..y2
	//grey=255;//return;
	//return;
	
	if(x1<self->sx) return;
	if(x1>self->ex) return;
	if(y1>y2){int t=y1;y1=y2;y2=t;}
	if(y2<self->sy) return;
	if(y1>self->ey) return;
	if(y1<self->sy) y1=self->sy;
	if(y2>self->ey) y2=self->ey;
	// draw the line now cleanly and technically without any further bound checking - it is 100% inside the boundary
	xsurface_drawline_yuv(self->surface,x1,y1,x1,y2,grey,u,v);
}

void cliprect_drawlinecolor(cliprect *self,int x1, int y1, int x2, int y2, unsigned char grey,unsigned char u,unsigned char v)
{
	if(x1==x2)
	{
		cliprect_drawlinecolcolor(self,x1,y1,x2,y2,grey,u,v);
		return;
	}
	if(y1==y2)
	{
		cliprect_drawlinerowcolor(self,x1,y1,x2,y2,grey,u,v);
		return;
	}
	// full line x1..x2,y1..y2
	if(x1<self->sx) return;
	if(x1>self->ex) return;
	if(y1<self->sy) return;
	if(y1>self->ey) return;
	
	if(x2<self->sx) return;
	if(x2>self->ex) return;
	if(y2<self->sy) return;
	if(y2>self->ey) return;
	// draw the line now cleanly and technically without any further bound checking - it is 100% inside the boundary
	xsurface_drawline_yuv(self->surface,x1,y1,x2,y2,grey,u,v);
}

//##################################################################
//##################################################################
//##################################################################

void cliprect_drawboxlinecolor(cliprect *self,int x,int y,int w,int h,unsigned char grey,unsigned char u,unsigned char v)
{
	// do not use yet, its not ready
int r=x+w-1;
int b=y+h-1;
		cliprect_drawlinecolor(self,x,y,  r,y,grey,u,v);
		cliprect_drawlinecolor(self,x,b,  r,b,grey,u,v);
		cliprect_drawlinecolor(self,x,y,  x,b,grey,u,v);
		cliprect_drawlinecolor(self,r,y,  r,b,grey,u,v);
}

//##################################################################
//##################################################################
//##################################################################

void cliprect_drawboxfillcolor(cliprect *self,int x,int y,int w,int h,unsigned char grey,unsigned char u,unsigned char v)
{
	//if(w<=0)return;
	//if(h<=0)return;
	if(w<0){ x+=w;w=-w;}
	if(h<0){ y+=h;h=-h;}
int r=(x+w)-1;
int b=(y+h)-1;
	if(x<self->sx)x=self->sx;
	if(y<self->sy)y=self->sy;
	if(r>self->ex)r=self->ex;
	if(b>self->ey)b=self->ey;
	if(r&1)r++;
	if(b&1)b++;
	//canvas_drawrectcolor(x,y,(r-x)+1,(b-y)+1,grey,u,v);
	
	xsurface_drawrect_yuv(self->surface,x,y,(r-x)+1,(b-y)+1,grey,u,v);
}



void cliprect_drawcolorcube(cliprect *self,int x,int y,int w,int h,unsigned char grey)
{
	//if(w<=0)return;
	//if(h<=0)return;
	if(w<0){ x+=w;w=-w;}
	if(h<0){ y+=h;h=-h;}
int r=(x+w)-1;
int b=(y+h)-1;

	if(x<self->sx)x=self->sx;
	if(y<self->sy)y=self->sy;
	if(r>self->ex)r=self->ex;
	if(b>self->ey)b=self->ey;
	if(r&1)r++;
	if(b&1)b++;
	
	int tw=(r-x)/16;
	int th=(b-y)/16;
	int u;
	int v;
	//xsurface_drawrect_yuv(self->surface,x,y,(r-x)+1,(b-y)+1,grey,u,v);
	for(v=1;v<255;v+=16)
	{
		int xx=x;
		for(u=1;u<255;u+=16)
		{
			xsurface_drawrect_yuv(self->surface,xx,y,tw,th,grey,u,v);
			xx+=tw;
		}
		y+=th;
	}
}






//##################################################################
//##################################################################
//##################################################################



inline void cliprect_drawglyph_grey(cliprect *self,LIQFONT *font,int x,int y,unsigned char glyph)
{
	if(font->glyphdata[glyph]==NULL) return;
	int gw  = font->glyphwidths[glyph];
	int gh  = font->glyphheights[glyph];
	int gtw = gw;
	int sw  = self->surface->width;
	//int sh  = self->surface->height;
	unsigned int goff = 0;
	int xu=x-self->sx;
	if(xu<0)	//x<0
	{
		if(xu<-gw) return;
		gw+=xu;
		goff-=xu;
		x=self->sx;
	}
	unsigned int gskip = gtw-gw;
	if(y+gh<self->sy)return;
	
	
	
	if(x+gw>self->ex)
	{
		if(x>=self->ex)return;
		gskip+=(x+gw)-(self->ex);
		gw=(self->ex-x);
	}
	
	if(y+gh>self->ey)
	{
		if(y>=self->ey) return;
		gh=(self->ey-y);
	}
	unsigned int poff = sw * y + x;
	unsigned int pskip = sw-gw;
//---------------------------------------
	unsigned char *pdata;
	unsigned char *gdata;
	
	int yu=y-self->sy;
	
	if(yu<0)
	{
		yu=-yu;
		goff+=gtw*yu;
		poff+=sw*yu;
		gh-=yu;
		y=self->sy;
	}
	gdata = & ((unsigned char*)font->glyphdata[glyph]) [ goff ] ;
	pdata =  ((unsigned char*)&self->surface->data[ self->surface->offsets[0] + poff ]);
	xsurface_drawstrip_or(gh,gw,gdata,pdata,gskip,pskip);
}


//########################################################################
//######################################################################## draw text as fast as possible onto xv surface :)
//########################################################################

int cliprect_drawtext(cliprect *self,LIQFONT *font,int xs,int ys,char *data)
{
	int x=xs;
	unsigned char ch;
	while ( (ch=*data++) )
	{
		cliprect_drawglyph_grey(self,font,x,ys, ch );
		x+=font->glyphwidths[ch];
	}
	return x;
}

int cliprect_drawtextn(cliprect *self,LIQFONT *font,int xs,int ys,char *data,int datalen)
{
	int x=xs;
	unsigned char ch;
	if(datalen<=0)return x;
	while(datalen--)
	{
		ch=*data++;
		cliprect_drawglyph_grey(self,font,x,ys, ch );
		x+=font->glyphwidths[ch];
	}
	return x;
}

void cliprect_drawtextcentredon(cliprect *self,LIQFONT *font,int cx,int cy,char *text)
{
	int tw=liqfont_textwidth(font,text);
	cliprect_drawtext(self,font,cx-tw/2,cy-font->glyphmaxh/2,text);		
}

void cliprect_drawtextcentredonlimit(cliprect *self,LIQFONT *font,int cx,int cy,char *text,int availablewidth)
{
	// draw some text within a boundary
	int tcnt=liqfont_textfitinside(font,text,availablewidth);
	int tw=liqfont_textwidthn(font,text,tcnt);
	cliprect_drawtextn(self,font,cx-tw/2,cy-font->glyphmaxh/2,text,tcnt);		
}


void cliprect_drawtextinside(cliprect *self,LIQFONT *font,int x,int y,int w,int h,char *text,int alignx)
{
	// tiny bit of optimising possible
	int tcnt=strlen(text);//liqfont_textfitinside(font,text,w+1);
	int tw=liqfont_textwidthn(font,text,tcnt);
	int cx=x+(w/2);
	int cy=y+(h/2);
	if(alignx==0)
	{
		cliprect_drawtextn(self,font,x,cy-font->glyphmaxh/2,text,tcnt);	
	}
	else if(alignx==1)
	{
		cliprect_drawtextn(self,font,cx-tw/2,cy-font->glyphmaxh/2,text,tcnt);	
	}
	else
	{
		cliprect_drawtextn(self,font,x+w-tw,cy-font->glyphmaxh/2,text,tcnt);	
		
	}
}



//########################################################################
//######################################################################## draw page as fast as possible onto xv surface :)
//########################################################################


int _cliprect_recursion_depth=0;

void cliprect_drawpage(cliprect *self,PAGE *page,int l,int t,int w,int h,int drawmode)	// 0=preview, 1=detailed, 2=latest point only 4=no aspect
{
	if(!page)return;
	if(l+w<self->sx || t+h<self->sy) return;
	if(l>=self->ex) return;
	if(t>=self->ey) return;
	if(w<2 || h<2) return;		// dont be silly :)
	
	// no point in displaying the entire blank frame to the user,
	// so we specify only the used rectangle within the page
	
	int fmx;
	int fmy;
	
	int fox;
	int foy;
	
	
	// From
	if(drawmode)
	{
		fmx = page->pixelwidth;
		fmy = page->pixelheight;
		if(fmx==0 || fmy==0) return;
		fox = 0;
		foy = 0;
		
	}
	else
	{
		fmx = page->boundingbox.xr - page->boundingbox.xl;
		fmy = page->boundingbox.yb - page->boundingbox.yt;
		if(fmx==0 || fmy==0) return;
		fox = page->boundingbox.xl;
		foy = page->boundingbox.yt;
		
	}
	
	
	
	
	int fmap2=fmx*fmx+fmy*fmy;
	
	
	// To
	int tmx = w-1; if(tmx<0)tmx=0;
	int tmy = h-1; if(tmy<0)tmy=0;
	if(tmy==0 || tmy==0) return;
	int tox = l;
	int toy = t;
	int tmap2 = tmx*tmx+tmy*tmy;
	
	float adx = (float)page->dpix / (float)self->surface->dpix;		// fixed to display canvas instead of being to surface
	float ady = (float)page->dpiy / (float)self->surface->dpiy;

	//================================ calc aspect ratio	
	float ax = adx * (float)tmx / (float)fmx;
	float ay = ady * (float)tmy / (float)fmy;
	float ar = (ax<=ay ? ax : ay);

	int rx = (ar * (float)fmx)/adx;
	int ry = (ar * (float)fmy)/ady;

//	int fx = ((float)tmx / rx);
//	int fy = ((float)tmy / ry);

/*	app_log("from %i,%i",fmx,fmy);
	app_log("to   %i,%i",tmx,tmy);
	app_log("ax   %f,%f,%f",ax,ay,ar);
	app_log("r    %f,%f",rx,ry);
	app_log("f    %i,%i",fx,fy);
*/	
	//================================ push altered aspect result into tmxy
	
	// this silly little reduction causes problems with live drawing..
	// but it looks better for icons etc showing used area
	if(!drawmode)
	{
		rx=(float)rx*0.9;
		ry=(float)ry*0.9;
	}

	if(!(drawmode & 4))
	{

		if(rx<tmx) tox+=(tmx-rx)/2;
		if(ry<tmy) toy+=(tmy-ry)/2;
	
		tmx = rx;
		tmy = ry;
	}
	// automatic quality reduction skip factor (high divisor==higher quality)
	//int rpt=(fmap2/tmap2)/4;// /4;
	
	
	//int rpt=(fmap2/tmap2)/8;// try this at high res, doubt it will work
	//app_log("adx*ady=%f",(adx*ady));
	
	
	//gb:18oct2008:set this too high, reverting
	//int rpt=((int)((float)(fmap2/tmap2)/(adx*ady))) >>3;// try this at high res, doubt it will work
	int rpt=(fmap2/tmap2)/8;

	
	
	
	
	
	
	// For every point I am drawing from the Page
	// I must Subtract FO From Offset
	// I must then Divide by FM From Magnitude
	// Then Multiply by TM To Magnitude
	// Then add TO To Offset
	if(drawmode)rpt=0;

	// optimize: combine t/f into a single variable up here.  reason against, it would need to be a float?
	// todo: ensure we render at correct aspect ratio, we can just adjust these parameters
	STROKE *stroke=page->strokefirst;
	while(stroke)
	{
		if(stroke->pointcount>=2)
		{
			unsigned char y=stroke->pen_y;
			unsigned char u=stroke->pen_u;
			unsigned char v=stroke->pen_v;

			// this is a good out from the dark function, but not for now..

			/*
			if(rpt>0)
			{
				y/=rpt;
				u=128+((u-128)/rpt);
				v=128+((v-128)/rpt);
			}
			*/
				//v=v-40;
				//if(v<0) v=255+v;

			POINT *p1;
			POINT *p2;
			
			int p1x;
			int p1y;
			
			int p2x;
			int p2y;
			
			int lsx;
			int lsy;
			int lex;
			int ley;
			
			
			int isselected=stroke->selected;
			
			
			


			//######################################## normal stroke
			if(stroke->strokekind==0)
			{

				if(1) // drawmode!=1)   //  =2 || drawmode==0)
				{
					p1 = stroke->pointfirst;
				}
				else
				{
					// start at end-1
					p1 = stroke->pointlast->linkprev;
					if(p1->linkprev)p1=p1->linkprev;
					if(p1->linkprev)p1=p1->linkprev;
				}
				//p1 = stroke->pointfirst;


				p1x=p1->x;	// rotate now..
				p1y=p1->y;
				
				p2 = p1->linknext;
				while(p2)
				{
					
					p2x=p2->x;   // rotate now..
					p2y=p2->y;
					
					// the heavy math part is here...
					lsx=tox+((p1x-fox)*tmx/fmx);
					lsy=toy+((p1y-foy)*tmy/fmy);
					lex=tox+((p2x-fox)*tmx/fmx);
					ley=toy+((p2y-foy)*tmy/fmy);
	
	
					// high definition color scaling :)
					int g=(450-p1->z);
					g=(g*256) / 250;
					if(g<0)g=0;
					if(g>255)g=255;			
					float f=(float)g / 256;
					float fy=y;
					float fu=u;
					float fv=v;
					unsigned char sy=	    (char)(      f * (fy    )) ;
					unsigned char su=	    (char)(128 + f * (fu-128)) ;
					unsigned char sv=	    (char)(128 + f * (fv-128)) ;
					cliprect_drawlinecolor(self,lsx,lsy,lex,ley,    sy,su,sv);
				
					if(isselected) cliprect_drawlinecolor(self,lsx+1,lsy+1,lex+1,ley+1,    sy,su,sv);
					
					
					
					
					//cliprect_drawlinecolor(self,lsx,lsy,lex,ley,    y,u,v);
					
					//canvas_line(lsx,lsy,lex,ley,    y);
	
					p1=p2;
					p2=p2->linknext;
					
					p1x=p2x;
					p1y=p2y;
	
					if(p2 && rpt)
					{	// move us on, at this point, rendering half resolution is ok :)
						//todo: make this work properly, dropoff with scale is too steep
						int cnt=rpt;
						while(p2->linknext && cnt-->0)
							p2=p2->linknext;	
						// i could do this by a factor of anything and reduce resolution as difference increases
					}
				}
			}
			//######################################## crows nest line
			else if(stroke->strokekind==1)
			{
				p1 = stroke->pointfirst;
				p1x=p1->x;	// rotate now..
				p1y=p1->y;
				
				p2 = stroke->pointlast;
				p2x=p2->x;   // rotate now..
				p2y=p2->y;
				
				// the heavy math part is here...
				lsx=tox+((p1x-fox)*tmx/fmx);
				lsy=toy+((p1y-foy)*tmy/fmy);
				lex=tox+((p2x-fox)*tmx/fmx);
				ley=toy+((p2y-foy)*tmy/fmy);
	
				cliprect_drawlinecolor(self,lsx,lsy,lex,ley,    y,u,v);
			}
			
			//######################################## simple box outline
			else if(stroke->strokekind==2)
			{
				p1 = stroke->pointfirst;
				p1x=p1->x;	// rotate now..
				p1y=p1->y;
				
				p2 = stroke->pointlast;
				p2x=p2->x;   // rotate now..
				p2y=p2->y;
				
				// the heavy math part is here...
				lsx=tox+((p1x-fox)*tmx/fmx);
				lsy=toy+((p1y-foy)*tmy/fmy);
				lex=tox+((p2x-fox)*tmx/fmx);
				ley=toy+((p2y-foy)*tmy/fmy);
	
				cliprect_drawboxlinecolor(self,lsx,lsy,lex-lsx,ley-lsy,    y,u,v);
			}
			
			//######################################## filled box
			else if(stroke->strokekind==3)
			{
				p1 = stroke->pointfirst;
				p1x=p1->x;	// rotate now..
				p1y=p1->y;
				
				p2 = stroke->pointlast;
				p2x=p2->x;   // rotate now..
				p2y=p2->y;
				
				// the heavy math part is here...
				lsx=tox+((p1x-fox)*tmx/fmx);
				lsy=toy+((p1y-foy)*tmy/fmy);
				lex=tox+((p2x-fox)*tmx/fmx);
				ley=toy+((p2y-foy)*tmy/fmy);
	
				cliprect_drawboxfillcolor(self,lsx,lsy,lex-lsx,ley-lsy,    y,u,v);
			}

			//######################################## subpage (gulp!)
			else if(stroke->strokekind==4)
			{
				//p1 = stroke->pointfirst;
				//p1x=p1->x;	// rotate now..
				//p1y=p1->y;
				
				//p2 = stroke->pointlast;
				//p2x=p2->x;   // rotate now..
				//p2y=p2->y;
				
				p1x=stroke->boundingbox.xl;
				p1y=stroke->boundingbox.yt;
				p2x=stroke->boundingbox.xr;
				p2y=stroke->boundingbox.yb;				
				
				// the heavy math part is here...
				lsx=tox+((p1x-fox)*tmx/fmx);
				lsy=toy+((p1y-foy)*tmy/fmy);
				lex=tox+((p2x-fox)*tmx/fmx);
				ley=toy+((p2y-foy)*tmy/fmy);
				
				
				//if(_cliprect_recursion_depth<4)
				if((lex-lsx)>10 &&(ley-lsy)>10)
				{
					_cliprect_recursion_depth++;
					if(stroke->mediapage)
						cliprect_drawpage(self,stroke->mediapage,lsx,lsy,lex-lsx,ley-lsy,0);
					_cliprect_recursion_depth--;
				}
				
				cliprect_drawboxlinecolor(self,lsx,lsy,lex-lsx,ley-lsy,    y,u,v);

			}

			
			// add other stroke types here :)
			





			
			
			// supposing we actually said this stroke was a BOX/Circle/Polygon/Triangle/Tile etc
			// what would we draw then?
		}
		stroke=stroke->linknext;
	}
}



//########################################################################
//######################################################################## draw image as fast as possible onto xv surface :)
//########################################################################



/*
extern void xsurface_drawzoomimage(
	
										XvImage *srcimage,
										int six,int siy,		// SrcImgPos
										int siw,int sih, 		// SrcImgSize

										XvImage *dstimage,
										int dix,int diy,		// DstImgPos
										int diw,int dih 		// DstImgSize
										
										);
 */



inline void cliprect_drawimagecolor(		cliprect *self,liqimage *image,int x,int y,int w,int h)
{
	
	if(!w || !h) return;
	if(w<0){ x+=w;w=-w;}
	if(h<0){ y+=h;h=-h;}
	
	/*
	
int r=(x+w);
int b=(y+h);
	cliprect cr;
	cliprect_copy(&cr,self);
	cliprect_shrink(&cr,x,y,r,b);
	int cw=cr.ex-cr.sx;
	int ch=cr.ey-cr.sy;
	if(!cw || !ch)return;
	
	int dw=image->width *cw/w;
	int dh=image->height*ch/h;
	int dx=image->width -dw;
	int dy=image->height-dh;
	if(!dw || !dh)return;
	
	
	//app_log("drawimg d(%i,%i)-step(%i,%i)  i(%i,%i)-step(%i,%i)  ",dx,dy,dw,dh,    cr.sx,cr.sy,cw,ch);
	
	
	// todo: make these adapt to the fluffin cliprect - wasnt aware they werent until i tried it

	xsurface_drawzoomimage( image,
								dx,dy,
								dw,dh,
								
								
							self->surface,
								cr.sx,cr.sy,
								cw,ch
						  );


	*/

	xsurface_drawzoomimage( image,
								0,0,
								image->width-1,image->height-1,
								
								
							self->surface,
								x,y,
								w,h
								);


//	xsurface_drawzoomimage( image,
//								0,0,
//								image->width-1,image->height-1,
//								
//								
//							self->surface,
//								x,y,
//								w,h
//								);

}

inline void cliprect_drawimageblendcolor(		cliprect *self,liqimage *image,int x,int y,int w,int h,char blend)
{
	if(!w || !h) return;
	if(w<0){ x+=w;w=-w;}
	if(h<0){ y+=h;h=-h;}
	
	
/*todo fix bug where it slides the UV channels at edge of screen
int r=(x+w);
int b=(y+h);
	cliprect cr;
	cliprect_copy(&cr,self);
	cliprect_shrink(&cr,x,y,r,b);
	int cw=cr.ex-cr.sx;
	int ch=cr.ey-cr.sy;
	if(!cw || !ch)return;
	
	int dw=image->width *cw/w;
	int dh=image->height*ch/h;
	int dx=image->width -dw;
	int dy=image->height-dh;
	if(!dw || !dh)return;
	
	
	//app_log("blndimg d(%i,%i)-step(%i,%i)  i(%i,%i)-step(%i,%i)  ",dx,dy,dw,dh,    cr.sx,cr.sy,cw,ch);
	//app_log("clip %i,%i -> %i,%i   img:%i,%i -> %i,%i",w,h,cw,ch,   image->width,image->height   ,image->width*cw/w,image->height*ch/h);


	xsurface_drawzoomblendimage( image,
								dx,dy,
								dw,dh,
								
								
							self->surface,
								cr.sx,cr.sy,
								cw,ch,
								blend);
*/

	xsurface_drawzoomblendimage( image,
								0,0,
								image->width-1,image->height-1,
								
								
							self->surface,
								x,y,
								w,h,

								blend);


}

