/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * x specific code
 *
 */

// double buffer discussion
//http://www.mail-archive.com/devel@xfree86.org/msg04027.html
// dont think its feasible now after a quick look, but others may find a way :)



#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/extensions/Xv.h>
#include <X11/extensions/Xvlib.h>
#include <X11/extensions/XShm.h>

#ifdef USE_MAEMO
#include <X11/extensions/Xsp.h>


#endif

#include <X11/keysym.h>
#include <X11/keysymdef.h>

//#include "liqfont.h"
#include "liqapp.h"
#include "liqcanvas.h"
#include "liqcamera.h"

#include "liqdialog.h"


#include "liqbase_hildon.h"

//#############################################################
extern int 			XShmQueryExtension(Display*);
extern int 			XShmGetEventBase(Display*);
extern XvImage  *	XvShmCreateImage(Display*, XvPortID, int, char*, int, int, XShmSegmentInfo*);

//#############################################################

#define 			GUID_YUY2_PACKED 0x32595559
#define 			GUID_UYVY_PACKED 0x59565955
#define 			GUID_IV420_PLANAR 0x30323449
#define 			GUID_YUV12_PLANAR 0x32315659	// original

//############################################################# Stylus alignment functions

/* device specific data */   // these were in the wiki, they are wrong for my device...
//#define DEV_X_DELTA 3378
//#define DEV_Y_DELTA 3080
//#define DEV_X_CORRECTION -300
//#define DEV_Y_CORRECTION -454

////////////////////////////////// todo: liquid working options (fullscreen)
////////////////////////////////// todo: these fail on windows mode, code needs transfering to an actual fn
////////////////////////////////// todo: these also fail for smaller than fullscreen

#define DEV_XS 265
#define DEV_XE 3850
#define DEV_YS 420
#define DEV_YE 3615
#define DEV_X_DELTA (DEV_XE-DEV_XS)
#define DEV_Y_DELTA (DEV_YE-DEV_YS)
#define DEV_X_CORRECTION (-DEV_XS)
#define DEV_Y_CORRECTION (-DEV_YS)

/**
   translate raw device coordinates to screen coordinates
*/
#define TRANSLATE_RAW_COORDS(x, y,xres,yres) \
{ \
  * x += DEV_X_CORRECTION;\
  * y += DEV_Y_CORRECTION;\
  * x = (xres * *x) / DEV_X_DELTA;\
  * y = yres - (yres * *y) / DEV_Y_DELTA;\
}

//############################################################# 

static void x11_set_fullscreen_state(Display *display, Window window, int action)
{
    XEvent xev;
    /* init X event structure for _NET_WM_FULLSCREEN client msg */
    xev.xclient.type 		= ClientMessage;
    xev.xclient.serial 		= 0;
    xev.xclient.send_event 	= True;
    xev.xclient.message_type= XInternAtom(display, "_NET_WM_STATE", False);
    xev.xclient.window 		= window;
    xev.xclient.format 		= 32;
    xev.xclient.data.l[0]	= action;
    xev.xclient.data.l[1]	= XInternAtom(display, "_NET_WM_STATE_FULLSCREEN", False);
    xev.xclient.data.l[2]	= 0;
    xev.xclient.data.l[3]	= 0;
    xev.xclient.data.l[4]	= 0;
    /* finally send that damn thing */
    if( !XSendEvent(display, DefaultRootWindow(display), False, SubstructureRedirectMask | SubstructureNotifyMask, &xev) )
	{
		{ app_errorandfail(-1,"canvas x11 could not set fullscreen"); }
    }
    XSync(display, False);
}

//#############################################################

Display					*dpy;
int						screen;
Window					window;



XShmSegmentInfo			yuv_shminfo;




XvImage					*yuv_image;
GC						gc;	
int						xv_port = -1;
int 					xsp_event_base=-1;
int 					xsp_error_base=-1;
int 					xsp_major=-1;
int 					xsp_minor=-1;
int 					xres,yres;


int dblbuf_flipupto=0;      // dblbuf

#ifndef USE_MAEMO
static int ispressed=0;     // is the mouse button pressed (hack..)
#endif

//#######################################################
//#######################################################

int xv_canvas_init()
{	
int						yuv_width = canvas.pixelwidth;
int						yuv_height = canvas.pixelheight;
XVisualInfo				vinfo;
XSetWindowAttributes	xswa;
int						ret;



	app_log("canvas X11 init begin");
	dpy = XOpenDisplay(NULL);
	if (dpy == NULL) 
	{
		{ return app_errorandfail(-1,"canvas cannot XOpenDisplay()"); }
	}

	screen = DefaultScreen(dpy);
    
    // why do i need 16bit, i need xv, not 16b..
	if(       
       XMatchVisualInfo(dpy, screen, 24, TrueColor    , &vinfo) ||
       XMatchVisualInfo(dpy, screen, 24, DirectColor  , &vinfo) ||
       XMatchVisualInfo(dpy, screen, 16, TrueColor    , &vinfo) ||
       XMatchVisualInfo(dpy, screen, 16, DirectColor  , &vinfo) ||
       XMatchVisualInfo(dpy, screen, 15, TrueColor    , &vinfo) ||
       XMatchVisualInfo(dpy, screen, 15, DirectColor  , &vinfo)
       )
    {
        // ok
    }
    else
	{
		{ return app_errorandfail(-1,"canvas cannot XMatchVisualInfo"); }
	}

	xres   = ScreenOfDisplay (dpy, DefaultScreen(dpy))->width;
	yres   = ScreenOfDisplay (dpy, DefaultScreen(dpy))->height;
	app_log("xyres : %i,%i",xres,yres);

	xswa.colormap =  XCreateColormap(dpy, DefaultRootWindow(dpy), vinfo.visual, AllocNone);
	xswa.event_mask = StructureNotifyMask | ExposureMask;
	xswa.background_pixel = 0;
	xswa.border_pixel = 0;

	window = XCreateWindow(dpy, DefaultRootWindow(dpy),
			 0, 0,
			 yuv_width,
			 yuv_height,
			 0, vinfo.depth,
			 InputOutput,
			 vinfo.visual,
			 CWBackPixel | CWBorderPixel | CWColormap | CWEventMask, 
			 &xswa);
#ifdef USE_MAEMO
	app_log("canvas XSP Raw Mouse init");
	XSPQueryExtension(dpy,
                    &xsp_event_base,
                    &xsp_error_base,
                    &xsp_major,
                    &xsp_minor);

	if (xsp_event_base < 0)
	{
		{ return app_errorandfail(-1,"canvas XSP raw mouse init failed"); }
	}

	XSPSetTSRawMode(dpy, True);
#endif

	XStoreName(dpy, window, app.title);
	XSetIconName(dpy, window, app.title);


	{
		XClassHint class;
		class.res_name = app.title;
		class.res_class = app.title;
		XSetClassHint(dpy, window, &class);
	}



	XSelectInput(dpy, window, StructureNotifyMask);
	

	//################################################# dangerous little loop here, if the system screws up this could be bad

	XMapWindow(dpy, window);
	// don't like infinite loops...  we may not ever get this event and would end up stuck
	// might as well just wait until we get into the normal event handler (unless i find theres a problem later)
	XEvent event;
	do 
	{
	    XNextEvent(dpy, &event);
	}
	while (event.type != MapNotify || event.xmap.event != window);




 	XSelectInput(dpy, window,
			   StructureNotifyMask  |
			   
			   
			   EnterWindowMask |
			   
			   LeaveWindowMask |
			   
			   ExposureMask |
			   
			   VisibilityChangeMask |
                 
#ifndef USE_MAEMO
			   //PointerMotionMask |
			   ButtonPressMask | 
               ButtonMotionMask |
               ButtonReleaseMask |
               
#endif //USE_MAEMO
                 
			   KeyPressMask | 
			   KeyReleaseMask | 
			   ButtonPressMask |
			   ButtonReleaseMask
			   ); 




	//################################################# GO fullscreen
	if(canvas.fullscreen)
	{		
		x11_set_fullscreen_state(dpy,window,1);
	}
	//################################################# get the graphics context

	gc = XCreateGC(dpy, window, 0, 0);		

	//#################################################
	//################################################# xv starts here
	//#################################################
	app_log("canvas Xv init begin");
	//################################################# get adapter info and find our port
int	p_num_adaptors;
XvAdaptorInfo		*ai;

	ret = XvQueryAdaptors(dpy, DefaultRootWindow(dpy), &p_num_adaptors, &ai);  
	if (ret != Success) 
	{
		{ return app_errorandfail(-1,"canvas XvQueryAdaptors failed"); }
	}

	if(p_num_adaptors==0) 
	{
		{ return app_errorandfail(-1,"canvas XvQueryAdaptors returned no adapters"); }
	}
    
    app_log("Canvas Xv p_num_adaptors=%i",p_num_adaptors);      // dblbuf test

	xv_port = ai[0].base_id;
	XvFreeAdaptorInfo(ai);
	if (xv_port == -1)
	{
		{ return app_errorandfail(-1,"canvas No XV Port on default adapter"); }	
	}

	//################################################# setup shared memory access
	app_log("canvas XShm init begin");
	if (!XShmQueryExtension(dpy))
	{
		{ return app_errorandfail(-1,"canvas XShmQueryExtension failed"); }
	}






	//YUV12 and IV420 are same but U&V are swapped
	yuv_image = XvShmCreateImage(dpy, xv_port, GUID_YUV12_PLANAR, 0, yuv_width, yuv_height, &yuv_shminfo);
	//yuv_image = XvShmCreateImage(dpy, xv_port, GUID_IV420_PLANAR, 0, yuv_width, yuv_height, &yuv_shminfo);


	yuv_shminfo.shmid = shmget(IPC_PRIVATE, yuv_image->data_size, IPC_CREAT | 0777);
	yuv_shminfo.shmaddr = yuv_image->data = shmat(yuv_shminfo.shmid, 0, 0);
	yuv_shminfo.readOnly = False;
	if (!XShmAttach(dpy, &yuv_shminfo)) 
	{
		{ return app_errorandfail(-1,"canvas XShmAttach failed"); }
	}


	app_log("hildon canvas init");

	hildon_canvas_init(window);

	//if(canvas.rotationangle!=0) setrotate(canvas.rotationangle);

	app_log("canvas init complete");
	return 0;
}

int xv_canvas_close()
{
	
	hildon_canvas_close();
	//if(canvas.rotationangle!=0) setrotate(0);
	//todo: check if i have forgotten anything
	XShmDetach(dpy,&yuv_shminfo);
	XFreeGC(dpy,gc);
	XUnmapWindow(dpy,window);
    
#ifdef USE_MAEMO
	XSPSetTSRawMode(dpy, False);
#endif
	XDestroyWindow(dpy,window);
	

	return 0;
}



//########################################################################
//######################################################################## refresh display
//########################################################################

inline int xv_canvas_refreshdisplay()
{

		int		_d, _w, _h;
		Window	_dw;
		int res=0;
		res=XGetGeometry(dpy, window, &_dw, &_d, &_d, &_w, &_h, &_d, &_d);
		if(res==0)
		{
			{ return app_errorandfail(-1,"canvas XGetGeometry failed"); }
		}
		
		res=XvShmPutImage( dpy, xv_port, window, gc, yuv_image,
		    0, 0, yuv_image->width, yuv_image->height,
		    0, 0, _w, _h, True);

		if(res!=Success)
		{
			{ return app_errorandfail(-1,"canvas XvShmPutImage failed"); }
		}
		return 0;
}

//########################################################################
//######################################################################## event count test
//########################################################################

int xv_canvas_eventcount()
{
	int evc=XEventsQueued(dpy, QueuedAfterFlush);
	//app_log("evc %i",evc);
	return evc;
}

//########################################################################
//######################################################################## event reading
//########################################################################
int xv_canvas_nextevent(LIQEVENT *ev);

static int xv_canvas_nextevent_maxtimeout = 0;

static int xv_canvas_inNotify=1;

int xv_canvas_nextevent_withtimeout(LIQEVENT *ev,int timeout)
{
int oldtimeout = xv_canvas_nextevent_maxtimeout;
	xv_canvas_nextevent_maxtimeout = timeout;
int res = xv_canvas_nextevent(ev);
	xv_canvas_nextevent_maxtimeout = oldtimeout;
	return res;
}

int xv_canvas_nextevent(LIQEVENT *ev)
{
	ev->type = 		LIQEVENT_TYPE_NONE;
	ev->ticks =     app_GetTicks();
	ev->state =     LIQEVENT_STATE_NONE;
	
	XEvent xev={0};
unsigned long ticksnow=ev->ticks;
//  goto foo;
//	canvas.keepalivealarmtime=0;
//  ok we are here.  we are not sure if there are any events
	while( (canvas.keepalivealarmtime>0 || xv_canvas_nextevent_maxtimeout>0) && xv_canvas_eventcount()==0 )
	{
		// we have been called with NO events pending.
		// we must sleep
		//app_log("Sleeping...%u,%u dif=%u  kat=%u",ev->ticks,ticksnow,ticksnow-ev->ticks,canvas.keepalivealarmtime);
		app_sleep(25);
		if(xv_canvas_eventcount()>0) break;
		ticksnow = app_GetTicks();
		if(xv_canvas_nextevent_maxtimeout && ticksnow-ev->ticks > xv_canvas_nextevent_maxtimeout)
		{
			app_log("Spent too long waiting, we timed out!...%i,%i",ev->ticks,ticksnow);
			return 0;
		}
		if(ticksnow-ev->ticks > canvas.keepalivealarmtime)// && xv_canvas_inNotify)
		{
			
			
			
			
			app_log("Waking!...%i,%i",ev->ticks,ticksnow);

			//// we exit and return 
			//ev->type = 		LIQEVENT_STATE_KEEPALIVE;
			//ev->ticks =     app_GetTicks();
			//return 0;

			// hang on, got a better idea :)
			// lets just refresh and carry on looping :)
			// ... no need for the client to do anything
			// because we are holding from this loop for the entire duration,
			// if we have waited longer than the clients' real blanking timeout
			// then we can just let it drop through and out of this loop to let it blank itself
			// (which it was already doing, just too early)

			xv_canvas_refreshdisplay();
			ev->type = 		LIQEVENT_TYPE_NONE;
			ev->ticks =     app_GetTicks();		

		}
	}
foo:
	XNextEvent(dpy,&xev);
	
	
	int keylen=0;
	//app_log("xNextEvent %i    %i,%i,%i",xev.type,KeyPress,KeyRelease,xsp_event_base);
	if(xev.type==KeyPress)
	{
		
		if(!xv_canvas_inNotify) goto foo;





		
		ev->type = LIQEVENT_TYPE_KEY;
		ev->key.state = LIQEVENT_STATE_PRESS;
		ev->key.keycode = XLookupKeysym((XKeyEvent*)&xev,0); //xev.xkey.keycode;
		ev->key.keystring[0]=0;
		
		keylen = XLookupString((XKeyEvent*)&xev,ev->key.keystring,16, (KeySym *) NULL, (XComposeStatus *) NULL);
		app_log("xNextEvent keypress %i",ev->key.keycode);


			// right in the core i can save a screen when i press the [Fullscreen] key
			if( (ev->type == LIQEVENT_TYPE_KEY) && (ev->state==LIQEVENT_STATE_PRESS) && (ev->key.keycode==65475) )	//FullScreen
			{
				char 		fmtnow[255];
	 			app_formatnow(fmtnow,255,"yyyymmdd_hhmmss");
				char buf[FILENAME_MAX+1];
				int pngerr =0;
				
				
				liqimage *imgfrom=liqcamera_getimage();
				if(!imgfrom)
				{
					// camera not on, we are doing desktop
					imgfrom = canvas.surface;
				}
				if(imgfrom)
				{
					liqimage *imgdesk=liqimage_create();
					if(imgdesk)
					{
						liqimage_pagedefine(imgdesk, imgfrom->width,imgfrom->height,imgfrom->dpix,imgfrom->dpiy,0);
						cliprect cr;
						cliprect_initfromimage(&cr,imgdesk);
						cliprect_drawimagecolor(&cr,imgfrom,0,0,imgfrom->width,imgfrom->height);
						

						
						canvas_clear(255);
						//canvas_refreshdisplay();
						
						//app_sleep(100);
						
						if(imgfrom != canvas.surface)
						{
							// save camera image
							
							snprintf(buf,FILENAME_MAX,"%s/liq.%s.%s.cam.png",app.sketchpath,fmtnow,app.username  );
							app_log("Fullscreen Pressed, saving camera  as '%s'",buf);
							pngerr=liqimage_pagesavepng(imgdesk,buf);
						}
						else
						{
							// save screenshot
							snprintf(buf,FILENAME_MAX,"%s/liq.%s.%s.scr.png",app.sketchpath,fmtnow,app.username  );
							app_log("Fullscreen Pressed, saving canvas as '%s'",buf);
							pngerr=liqimage_pagesavepng(imgdesk,buf);
						}
						
						liqimage_free(imgdesk);
						
					}
					else
					{
						// no desk
						app_log("Fullscreen Pressed, could not allocate imgdesk");
					}
				
				}
				else
				{
					// no canvas
					app_log("Fullscreen Pressed, no canvas");
				}

			}
	}
	else if(xev.type==KeyRelease)
	{
		
		if(!xv_canvas_inNotify) goto foo;
		
		ev->type = LIQEVENT_TYPE_KEY;
		ev->key.state = LIQEVENT_STATE_RELEASE;
		ev->key.keycode =XLookupKeysym((XKeyEvent*)&xev,0); //xev.xkey.keycode;
		ev->key.keystring[0]=0;
		
		
		keylen = XLookupString((XKeyEvent*)&xev,ev->key.keystring,16, (KeySym *) NULL, (XComposeStatus *) NULL);
		
		app_log("xNextEvent keyrelease %i",ev->key.keycode);

		
	}
    
    
#ifdef USE_MAEMO

	


	else if (xev.type == xsp_event_base)  // RAWMOUSE
	{
		
		if(!xv_canvas_inNotify) goto foo;
		
		
		XSPRawTouchscreenEvent xsp_event;
		memcpy(&xsp_event, &xev,sizeof(XSPRawTouchscreenEvent));

		//app_log("RawMouse %i,%i,%i",xsp_event.x,xsp_event.y,xsp_event.pressure);
		int t_x = xsp_event.x;
		int t_y = xsp_event.y;

		/* translate raw coordinates */
		TRANSLATE_RAW_COORDS(&t_x, &t_y,canvas.pixelwidth,canvas.pixelheight);
		if(t_x>=canvas.pixelwidth )t_x=canvas.pixelwidth -1;
		if(t_y>=canvas.pixelheight)t_y=canvas.pixelheight-1;
		if(t_x<0)t_x=0;
		if(t_y<0)t_y=0;

		ev->type = LIQEVENT_TYPE_MOUSE;
		ev->mouse.state = LIQEVENT_STATE_MOVE;
		ev->mouse.x = ((t_x));//*canvas.scalew);
		ev->mouse.y = ((t_y));//*canvas.scaleh);
		ev->mouse.pressure = xsp_event.pressure;

	}	
	
#else // USE_MAEMO


	else if(xev.type==ButtonPress)
	{
		
		if(!xv_canvas_inNotify) goto foo;
		
		
        ispressed=1;
        
        xev.xmotion.x= xev.xmotion.x * canvas.pixelwidth  / xres;
        xev.xmotion.y= xev.xmotion.y * canvas.pixelheight / yres;
        
        app_log("buttonpress  %i,%i",xev.xmotion.x,xev.xmotion.y);
		//app_log("ButtonPress");
		ev->type = LIQEVENT_TYPE_MOUSE;
		ev->mouse.state = LIQEVENT_STATE_PRESS;
		ev->mouse.x = ((xev.xmotion.x));
		ev->mouse.y = ((xev.xmotion.y));
        ev->mouse.pressure = 100;
	}
	else if(xev.type==MotionNotify && ispressed)
	{
		
		if(!xv_canvas_inNotify) goto foo;
		
		
        xev.xmotion.x= xev.xmotion.x * canvas.pixelwidth  / xres;
        xev.xmotion.y= xev.xmotion.y * canvas.pixelheight / yres;
 
        app_log("motion %i,%i",xev.xmotion.x,xev.xmotion.y);
		ev->type = LIQEVENT_TYPE_MOUSE;
		ev->mouse.state = LIQEVENT_STATE_MOVE;
		ev->mouse.x = ((xev.xmotion.x));// *800)/canvas.pixelwidth;
		ev->mouse.y = ((xev.xmotion.y));// *480)/canvas.pixelheight;
        ev->mouse.pressure = 200;
	}
    else if(xev.type==ButtonRelease)
	{
		
		if(!xv_canvas_inNotify) goto foo;
		
		
        ispressed=0;
        
        xev.xmotion.x= xev.xmotion.x * canvas.pixelwidth  / xres;
        xev.xmotion.y= xev.xmotion.y * canvas.pixelheight / yres;
 
        app_log("release %i,%i",xev.xmotion.x,xev.xmotion.y);

		//app_log("ButtonRelease");
		ev->type = LIQEVENT_TYPE_MOUSE;
		ev->mouse.state = LIQEVENT_STATE_RELEASE;
		ev->mouse.x = ((xev.xmotion.x));
		ev->mouse.y = ((xev.xmotion.y));
        ev->mouse.pressure = 0;
	}		

#endif // USE_MAEMO



    
    
    
	else if (xev.type == 65)  // XShmCompletionEvent
	{
		//http://www.x.org/docs/Xv/video		
		//	XvShmPutImage has a parameter:
		//   send_event - Indicates whether or not an XShmCompletionEvent should be
		//                sent.  If sent, the event's major_code and minor_code
		//                fields will indicate the Xv extension's major code and
		//                XvShmPutImage's minor code.
		//if(xv_canvas_inNotify)
		{
		
			ev->type = LIQEVENT_TYPE_REFRESHED;
		}
		//else
		//{
		//	// actually no point in telling the caller that we have finished refreshing :)
		//	// lets leave him waiting for now
		//}
		
	}
	
	//else if (xev.type == 33) // home key
	//{
	//	XRaiseWindow(dpy,window);
	//
	//}
	
	//else if (xev.type == 34) // lock key
	//{

		//XRaiseWindow(dpy,window);
	//}



	else if (xev.type == EnterNotify) // EnterNotify
	{
		app_log("event: EnterNotify");
		//XRaiseWindow(dpy,window);
		xv_canvas_inNotify = 1;


#ifdef USE_MAEMO
	XSPSetTSRawMode(dpy, True);
#endif

	}
	
	

	else if (xev.type == LeaveNotify) // LeaveNotify
	{
		app_log("event: LeaveNotify");
		//XRaiseWindow(dpy,window);
		xv_canvas_inNotify = 0;


#ifdef USE_MAEMO
	XSPSetTSRawMode(dpy, False);
#endif

	}
	
	
	
	
	
	


	else if (xev.type == VisibilityNotify) // VisibilityNotify
	{
		app_log("event: VisibilityNotify %i",xev.xvisibility.state);
		//XRaiseWindow(dpy,window);
	}
	
	
	
	
	else if (xev.type == Expose) // expose
	{
		//XRaiseWindow(dpy,window);
		//canvas_refreshdisplay();
		//if(xev.xexpose.count==0)
		{
			app_log("event: Expose");
			ev->type = LIQEVENT_TYPE_EXPOSE;
		}
		
	}
	
	else if (xev.type == MappingNotify) // mapping notify
	{
		app_log("event: MappingNotify");
		//XRaiseWindow(dpy,window);
	}
	
	else if (xev.type == MapNotify) // map notify
	{
		app_log("event: MapNotify");
		//XRaiseWindow(dpy,window);
	}
	
	else if (xev.type == UnmapNotify) // unmap notify
	{
		app_log("event: UnmapNotify");
		//XRaiseWindow(dpy,window);
	}
	else if (xev.type == ClientMessage) // client message
	{
		app_log("event: ClientMessage");
		//XRaiseWindow(dpy,window);
	}	
	
	

	
#ifndef USE_MAEMO
	else if (xev.type == 94)// random events which dont occur in maemo..
	{
	
	}
	else if (xev.type == 6)// random events which dont occur in maemo.. came at a mouse move..
	{
	
	}
    
#endif //USE_MAEMO
    
	else
	{
	//		ev->type = LIQEVENT_TYPE_UNKNOWN;
			app_log("Unknown event %i, let me know what happened at liquid@gmail.com",xev.type);
			//exit(-1);
	}

	return 0;

}

//########################################################################
//######################################################################## colorcube optimised
//########################################################################



inline void xv_canvas_drawcolorcube(int x,int y,char grey)
{
	if(x<0)return;
	if(y<0)return;
	if(x+256>yuv_image->width)return;
	if(y+266>yuv_image->height)return;
	canvas_drawrect(x,y,256,256,grey);

int i;
int j;

int uo = yuv_image->width*yuv_image->height;
int vo = uo + (uo >> 2);
int uvw = yuv_image->width>>1;

	x>>=1;
	y>>=1;

unsigned int *planeu = (unsigned int *)&yuv_image->data[ uo+(y*uvw)+x ];
unsigned int *planev = (unsigned int *)&yuv_image->data[ vo+(y*uvw)+x ];
unsigned int planeskip = (uvw>>2)-32;
unsigned int adjustu = 0x08080808;
unsigned int adjustv = 0x02020202;
unsigned int nu;// = 0x00020406;
unsigned int nv = 0x00000000;
	for(i=0;i<128;i++)
	{
		nu = 0x01030507;
		//nu = 0x00020406;
		for(j=0;j<32;j++)
		{
			// 32 longs make up a chroma cube side
			*planeu++ = nu;
			*planev++ = nv;
			nu+=adjustu;
		}
		nv+=adjustv;
		planeu+=planeskip;
		planev+=planeskip;
	}
}
