/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Header for canvas control
 *
 */



#ifndef LIQCANVAS_H
#define LIQCANVAS_H

#ifdef __cplusplus
extern "C" {
#endif


#include "liqfont.h"
#include "liqimage.h"
#include "liqcliprect.h"

typedef struct 
{
	int pixelwidth;
	int pixelheight;
	int rotationangle;
	int fullscreen;
	float scalew;
	float scaleh;
	int dpix;
	int dpiy;
	int keepalivealarmtime;
	LIQFONT *font;
	liqimage *surface;		// pre allocated for your usage pleasure :)
	cliprect *cr;
} LIQCANVAS;

//#######################################################

// optional custom event wrappers

typedef struct 
{
	unsigned int type;
	unsigned long ticks;
	unsigned int state;
	unsigned int button;
	unsigned int x;					// events are scaled to canvas pixels
	unsigned int y;
	unsigned int pressure;
} 
	LIQEVENT_MOUSE;

typedef struct 
{
	unsigned int type;
	unsigned long ticks;
	unsigned int state;
	unsigned int keycode;				// KeySym
	char keystring[16];					// not exactly sure if it will ever be needed
	//unsigned int keyascii;
} 
	LIQEVENT_KEY;

//LIQEVENT_STATE_WAKEUP
typedef union 
{
	struct							// evtype 0,3,4
	{
		unsigned int type;
		unsigned long ticks;
		unsigned int state;
	};
	LIQEVENT_MOUSE mouse;			// evtype 1
	LIQEVENT_KEY key;				// evtype 2
} 
	LIQEVENT;
	
#define LIQEVENT_TYPE_NONE    	 -1
#define LIQEVENT_TYPE_UNKNOWN    0
#define LIQEVENT_TYPE_MOUSE      1
#define LIQEVENT_TYPE_KEY        2
#define LIQEVENT_TYPE_EXPOSE     3
#define LIQEVENT_TYPE_REFRESHED  4
//#define LIQEVENT_TYPE_BUTTON     4
//#define LIQEVENT_STATE_KEEPALIVE 8

#define LIQEVENT_STATE_NONE      -1
#define LIQEVENT_STATE_UNKNOWN   0
#define LIQEVENT_STATE_PRESS     1
#define LIQEVENT_STATE_RELEASE   2
#define LIQEVENT_STATE_MOVE      4

#define HILDON_APPVIEW_HEIGHT          396
#define HILDON_APPVIEW_WIDTH           672	

//todo: make this a class instance, we might end up having multiple canvases..
extern LIQCANVAS canvas;
//#######################################################
int canvas_init(			int pixelwidth,int pixelheight,int rotationangle,int fullscreen);
int canvas_eventcount();
int canvas_nextevent(		LIQEVENT *ptrevent);
int canvas_refreshdisplay();
//int canvas_refreshdisplay_autowait();   //redacted due to errors in thinking.  it expected a single event but theres not
int canvas_close();



//####################################################### ALL these should be depreciated and replacicated within cliprect
// all these need redirecting down the
// cliprect_drawXXXX(canvas.cr,....); functions
int canvas_setfont(			char *fontfile,int pointsize);
int canvas_closefont();
void 	canvas_clear(		unsigned char grey);
void canvas_drawcolorcube(	int x,int y,unsigned char grey);
void canvas_drawrect(		int x,int y,int w,int h,unsigned char grey);
void canvas_drawrectcolor(	int x,int y,int w,int h,unsigned char grey,unsigned char u,unsigned char v);
void canvas_drawrectwash(	int x,int y,int w,int h,unsigned char u,unsigned char v);
void canvas_pset(			int x,int y,unsigned char grey);
void canvas_psetcolor(		int x,int y,unsigned char grey,unsigned char u,unsigned char v);
void canvas_line(			int x1, int y1, int x2, int y2, unsigned char grey);
void canvas_linecolor(		int x1, int y1, int x2, int y2, unsigned char grey,unsigned char u,unsigned char v);
void canvas_lineinvert(		int x1, int y1, int x2, int y2);
void canvas_circle(			int cx, int cy, int r,unsigned char grey);
int canvas_font_drawtext(	LIQFONT *font,int x,int y,char *string);
int canvas_font_drawtextn(	LIQFONT *font,int x,int y,char *string,int datalen);
int canvas_drawtext(		int x,int y,char *string);
int canvas_drawtextn(		int x,int y,char *string,int datalen);
int canvas_textwidth(		char *data);
int canvas_textwidthn(		char *data,int datalen);
void canvas_drawtextcentredon(int cx,int cy,char *text);
void canvas_drawtextcentredonlimit(int cx,int cy,char *text,int availablewidth);

inline void canvas_pgetcolor(int x1, int y1, unsigned char *grey,unsigned char *u,unsigned char *v);
void canvas_drawbox(		int x,int y,int w,int h,unsigned char grey);
void canvas_drawboxcolor(	int x,int y,int w,int h,unsigned char grey,unsigned char u,unsigned char v);
void canvas_drawboxinvert(	int x,int y,int w,int h);



#ifdef __cplusplus
}
#endif


#endif
