/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Basic Canvas control functions
 *
 */

//20080726:gb:added canvas_drawtextcentredonlimit to draw text inside a box




#include <stdlib.h>                                                                                 
#include "liqcanvas.h"
#include "liqapp.h"

#include "liqcliprect.h"
#include "liqimage.h"


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/extensions/Xv.h>
#include <X11/extensions/Xvlib.h>



//#include "liq_xsurface.h"			// include available workhorse functions
extern XvImage *yuv_image;			// this is the liqcanvass_xv base display

int xv_canvas_init();
int xv_canvas_close();
inline int xv_canvas_refreshdisplay();
int xv_canvas_eventcount();
int xv_canvas_nextevent(LIQEVENT *ev);


//todo: make this a class instance, we might end up having multiple canvases..
LIQCANVAS canvas;

int canvas_init(int pixelwidth,int pixelheight,int rotationangle,int fullscreen)
{

	canvas.keepalivealarmtime=10000;
	canvas.pixelwidth = pixelwidth;
	canvas.pixelheight = pixelheight;
	canvas.rotationangle = rotationangle;
	canvas.fullscreen = fullscreen;
	if(canvas.fullscreen==0)
	{
		canvas.scalew=(float)canvas.pixelwidth /(float)(HILDON_APPVIEW_WIDTH);		// this should depend upon the rotation
		canvas.scaleh=(float)canvas.pixelheight/(float)(HILDON_APPVIEW_HEIGHT);
		
	}
	{
		canvas.scalew=(float)canvas.pixelwidth /800.0;		// this should depend upon the rotation
		canvas.scaleh=(float)canvas.pixelheight/480.0;
	}
	canvas.dpix=(canvas.scalew * 225.0);		// this should depend upon the rotation
	canvas.dpiy=(canvas.scaleh * 225.0);
	if(xv_canvas_init()!=0)
	{
		{ return app_errorandfail(-1,"canvas xv_canvas_init failed"); }
		
	}
	app_log("Canvas.dpi %i,%i",canvas.dpix,canvas.dpiy);
	
	//################################################# setup the surface and cliprect
	canvas.surface=liqimage_create();
	if (!canvas.surface) 
	{
		{ return app_errorandfail(-1,"canvas liqimage_create failed"); }
	}
	liqimage_pagedefinefromXVImage(canvas.surface,yuv_image,canvas.dpix,canvas.dpiy);


	canvas.cr=cliprect_create();
	if (!canvas.cr) 
	{
		{ return app_errorandfail(-1,"canvas cliprect_create failed"); }
	}
	cliprect_initfromimage(canvas.cr,canvas.surface);
	
	return 0;
}


int canvas_close()
{
	app_log("canvas close");
	if(canvas.font) canvas_closefont();
	canvas.font=NULL;

	if(canvas.surface) liqimage_free(canvas.surface);
	if(canvas.cr) cliprect_free(canvas.cr);
	
	xv_canvas_close();
	app_log("canvas close end");
	return 0;
}


int canvas_closefont()
{
	if(canvas.font!=NULL) 
	{
		liqfont_close(canvas.font);
		free(canvas.font);
		canvas.font=NULL;
	}
	return 0;
}

int canvas_setfont(char *fontfile,int pointsize)
{

	if(canvas.font!=NULL) canvas_closefont();
	canvas.font = (LIQFONT *)malloc( sizeof( LIQFONT ));
	return liqfont_openfile(canvas.font,fontfile,pointsize,0,canvas.scalew,canvas.scaleh);
}


//##########################################################################

int canvas_eventcount()
{
	return xv_canvas_eventcount();
}

int canvas_nextevent(LIQEVENT *ptrevent)
{
	if(ptrevent==NULL)
	{
		return app_errorandfail(-1,"canvas_nextevent passed null event pointer");
	}
	return xv_canvas_nextevent(ptrevent);
}


int canvas_refreshdisplay()
{
	xv_canvas_refreshdisplay();
	return 0;
}

/*
int canvas_refreshdisplay_autowait()
{
	xv_canvas_refreshdisplay();
	// we are expecting an event about now
	LIQEVENT ev;
	canvas_nextevent(&ev);

	return 0;
}
*/





void canvas_clear(unsigned char grey)
{
	cliprect_drawclear(canvas.cr,grey,128,128);
}
void canvas_drawrect(int x,int y,int w,int h,unsigned char grey)
{
	cliprect_drawboxfillcolor(canvas.cr,x,y,w,h,(char)grey,128,128);
}
void canvas_drawrectcolor(int x,int y,int w,int h,unsigned char grey,unsigned char u,unsigned char v)
{
	cliprect_drawboxfillcolor(canvas.cr,x,y,w,h,grey,u,v);
}

void canvas_drawrectwash(int x,int y,int w,int h,unsigned char u,unsigned char v)
{
//	cliprect_drawrectwash_uv(canvas.cr,x,y,w,h,u,v);
	cliprect_drawboxfillcolor(canvas.cr,x,y,w,h,128,u,v);
}





//inline void xv_canvas_drawcolorcube(int x,int y,char grey);


void canvas_drawcolorcube(int x,int y,unsigned char grey)
{
	// damn, have not re-provided this functionality
	// will regain it from loading jpegs..
	// i need it now.
	//xv_canvas_drawcolorcube(x,y,grey);
}

inline void canvas_pset(int x,int y,unsigned char grey)
{
	cliprect_drawpsetcolor(canvas.cr,x,y,grey,128,128);
}

inline void canvas_psetcolor(int x,int y,unsigned char grey,unsigned char u,unsigned char v)
{
	cliprect_drawpsetcolor(canvas.cr,x,y,grey,u,v);
}



inline void canvas_pgetcolor(          int x1, int y1, unsigned char *grey,unsigned char *u,unsigned char *v)
{
	cliprect_drawpgetcolor( canvas.cr,x1,y1,grey,u,v);
}

inline void canvas_line(int x1, int y1, int x2, int y2, unsigned char grey)
{
	if(x1<0 && x2<0)return;
	if(y1<0 && y2<0)return;
	if(x1>=canvas.pixelwidth && x2>=canvas.pixelwidth)return;
	if(y1>=canvas.pixelheight && y2>=canvas.pixelheight)return;

	cliprect_drawlinecolor(canvas.cr,x1, y1, x2, y2, grey,128,128);
}
void canvas_linecolor(int x1, int y1, int x2, int y2, unsigned char grey,unsigned char u,unsigned char v)
{
	if(x1<0 && x2<0)return;
	if(y1<0 && y2<0)return;
	if(x1>=canvas.pixelwidth && x2>=canvas.pixelwidth)return;
	if(y1>=canvas.pixelheight && y2>=canvas.pixelheight)return;
	cliprect_drawlinecolor(canvas.cr,x1, y1, x2, y2, grey,u,v);
}

void canvas_lineinvert(int x1, int y1, int x2, int y2)
{
	if(x1<0 && x2<0)return;
	if(y1<0 && y2<0)return;
	if(x1>=canvas.pixelwidth && x2>=canvas.pixelwidth)return;
	if(y1>=canvas.pixelheight && y2>=canvas.pixelheight)return;

	cliprect_drawlinecolor(canvas.cr,x1, y1, x2, y2,128,128,128);
}


void canvas_circle(int cx, int cy, int r,unsigned char grey)
{
	//cliprect_drawcircle_grey(canvas.cr,cx,cy,r,grey);
}


//##################################################################

int canvas_font_drawtext(LIQFONT *font,int x,int y,char *string)
{
	//int x=xs;
	if(!string) return 0;
	unsigned char ch;
	if(font->rotation==0)
	{
		while ( (ch=*string++) )
		{
			cliprect_drawglyph_grey(canvas.cr,font,x,y, ch );
			x+=font->glyphwidths[ch];
		}
		return x;
	}
	else
	{
		while ( (ch=*string++) )
		{
			cliprect_drawglyph_grey(canvas.cr,font,x,y, ch );
			y+=font->glyphheights[ch];
		}
		return y;
	}
}

int canvas_font_drawtextn(LIQFONT *font,int x,int y,char *string,int datalen)
{
	//int x=xs;
	//bug#1 tested the function to see if it is cutting end of line.  its not.
	//this is called from many places and it displays the data correctly in each case
	//the bug is in either the parser for the books, or the calling function from liqreader
	//char buf[1024];
	//if(datalen>1023)datalen=1023;
	//snprintf(buf,datalen+1,"%s",string);
	//buf[datalen+2]=0;
	//app_log("drawn: %s",buf);
	if(!string) return 0;
	unsigned char ch;
	if(datalen<=0)return x;
	if(font->rotation==0)
	{
		while(datalen--)
		{
			ch=*string++;
			cliprect_drawglyph_grey(canvas.cr,font,x,y, ch );
			x+=font->glyphwidths[ch];
		}
		return x;
	}
	else
	{
		while(datalen--)
		{
			ch=*string++;
			cliprect_drawglyph_grey(canvas.cr,font,x,y, ch );
			y+=font->glyphheights[ch];
		}
		return y;
	}
}




int canvas_drawtext(int x,int y,char *string)
{
	return cliprect_drawtext(canvas.cr,canvas.font,x,y,string);
	//return canvas_font_drawtext(canvas.font,x,y,string);
}



int canvas_drawtextn(int x,int y,char *string,int datalen)
{
	return cliprect_drawtextn(canvas.cr,canvas.font,x,y,string,datalen);
	//return canvas_font_drawtextn(canvas.font,x,y,string,datalen);
}




void canvas_drawtextcentredon(int cx,int cy,char *text)
{
	int tw=canvas_textwidth(text);
	canvas_drawtext(cx-tw/2,cy-canvas.font->glyphmaxh/2,text);		
}

void canvas_drawtextcentredonlimit(int cx,int cy,char *text,int availablewidth)
{
	// draw some text within a boundary
	int tcnt=liqfont_textfitinside(canvas.font,text,availablewidth);
	int tw=canvas_textwidthn(text,tcnt);
	canvas_drawtextn(cx-tw/2,cy-canvas.font->glyphmaxh/2,text,tcnt);		
}

int canvas_textwidth(char *data)
{
	return liqfont_textwidth(canvas.font,data);
}

int canvas_textwidthn(char *data,int datalen)
{
	return liqfont_textwidthn(canvas.font,data,datalen);
}





void canvas_drawbox(int x,int y,int w,int h,unsigned char grey)
{
		int sx=x;
		int sy=y;
		int ex=x+w-1;
		int ey=y+h-1;
		canvas_line(sx,sy,ex,sy,grey);		// above
		canvas_line(sx,ey,ex,ey,grey);		// below
		canvas_line(sx,sy,sx,ey,grey);		// lhs
		canvas_line(ex,sy,ex,ey,grey);		// rhs
}
void canvas_drawboxcolor(int x,int y,int w,int h,unsigned char grey,unsigned char u,unsigned char v)
{
		int sx=x;
		int sy=y;
		int ex=x+w-1;
		int ey=y+h-1;
		canvas_linecolor(sx,sy,ex,sy,grey,u,v);		// above
		canvas_linecolor(sx,ey,ex,ey,grey,u,v);		// below
		canvas_linecolor(sx,sy,sx,ey,grey,u,v);		// lhs
		canvas_linecolor(ex,sy,ex,ey,grey,u,v);		// rhs
}
void canvas_drawboxinvert(int x,int y,int w,int h)
{
		int sx=x;
		int sy=y;
		int ex=x+w-1;
		int ey=y+h-1;
		canvas_lineinvert(sx,sy,ex,sy);		// above
		canvas_lineinvert(sx,ey,ex,ey);		// below
		canvas_lineinvert(sx,sy,sx,ey);		// lhs
		canvas_lineinvert(ex,sy,ex,ey);		// rhs
}




//##################################################################




