/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Header for Book Class
 *
 */




#ifndef LIQBOOK_H
#define LIQBOOK_H




//##################################################################

typedef struct 
{
//	LIQBOOK *book;
	int offset;					// where in the filemap this line begins
	int length;					// how long this line is
	char *filemapstart;			// quicklink pointer to the line start position
} LIQBOOKLINE;

typedef struct
{
	char *filename;				    // book file name
	int filelength; 			    // system defined file length
	char *filemapdata;			    // memory mapped file data
	FILE * fd;
	void * fm;
	//int lineheight;
	int linecount;				    // count of identified lines
	int linebuffersize; 		    // number of elements in linebuffer array
	int linelongest;			    // longest line
	LIQBOOKLINE *linebuffer;	// if linebuffermax=0 then this is null
} LIQBOOK;




//#######################################################

extern LIQBOOK book;


int book_close();
int book_open(char *filename,int maxlinelength,unsigned char *font_widths);


#endif
