/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Book class definition
 *
 */




#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <ctype.h>


#include "liqapp.h"
#include "liqbook.h"

LIQBOOK book;


// this code is the very first attempt at a book reader I attempted
// it has been replaced by the document code and only remains for testing purposes


//################################################################## reset and close the book

int book_close()
{

    app_log("bookclose.begin");
//FILE *file;
	if(book.filename) { free( book.filename);book.filename=NULL; }
	app_log("bookclose.len");
	book.filelength=0;
	book.filemapdata = NULL;
	book.linecount=0;
	book.linelongest=0;
	app_log("bookclose.buf");
	if(book.linebuffer) { free( (void *)book.linebuffer);book.linebuffer=NULL; }
	book.linebuffersize=0;

    app_log("bookclose.fm");
    if(book.fm) { free( (void *)book.fm);book.fm=0; }

    app_log("bookclose.fd");
	if(book.fd) { fclose( book.fd );book.fd=NULL; }
	app_log("bookclose.end");
	return 0;
}

//################################################################## extend the buffer

int book_linebufferextend()
{
    app_log("linebufferextend.start currently %i (extending by 512 lines)",book.linebuffersize);
	// extend by 512 available lines.
	int arrsize = book.linebuffersize + 512;
	LIQBOOKLINE *arr;
	arr = (LIQBOOKLINE *)malloc(arrsize * sizeof( LIQBOOKLINE));
	if(arr==NULL)
	{
		// SHIT-MA-DOODLE
		{ return app_errorandfail(-2,"linebufferextend error"); }
	}
	if(book.linebuffer)
	{
    //    app_log("linebufferextend.copying");
		// we already have a buffer, copy it
		memcpy(arr,book.linebuffer, book.linebuffersize * sizeof( LIQBOOKLINE));
		free(book.linebuffer);
	}
	book.linebuffer = arr;
	book.linebuffersize = arrsize;
	//app_log("linebufferextend.end");
	return 0;
}

//################################################################## allocate a line into the buffer

int book_linealloc(int linestart,int linelength)
{	if(book.linecount+1 > book.linebuffersize)
	{
		app_log("linealloc needs more start=%i len=%i",linestart,linelength);
		book_linebufferextend();
	}
	LIQBOOKLINE *line;
	line = &book.linebuffer[book.linecount];
	line->offset = linestart;
	line->length = linelength;
	line->filemapstart = &book.filemapdata[linestart];
	book.linecount++;
	if(linelength > book.linelongest) book.linelongest = linelength;
	return 0;
}
//################################################################## open a specific book

int book_open(char *filename,int maxlinelength,unsigned char *font_widths)
{
    app_log("bookopen.begin: %s",filename);
//FILE *file;
	//book_close();
	book.filename = strdup(filename);



	app_log("bookopen.getting file stats");
	
    //book.filelength = filelength(fileno(book.fd));
	struct stat filestatbuf;
	int fs;
	fs = stat(book.filename, &filestatbuf);
	if (fs == -1)
	{
    	{ return app_errorandfail(-1,"book stats problem"); }
	}
	// allow whole length for mapping
	book.filelength=filestatbuf.st_size;

	
	
	



    // restrict normal files to only 32mb of memory for now  extended to 32 for Oberon85, hope its enough for now

    if(book.filelength>1024*1024*32) 
	{
		{ return app_errorandfail(-1,"book length exceeds current limit (32mb)"); }
	}
	
    app_log("bookopen.allocating %i bytes",book.filelength);
    book.fm = (char*)calloc(book.filelength, sizeof(char));
	if (book.fm == NULL)
	{
    	{ return app_errorandfail(-1,"can't allocate memory"); }
	}	
	
	
	
	app_log("bookopen.opening file");
	book.fd = fopen(book.filename, "r");
	if (book.fd == NULL)
	{
    	{ return app_errorandfail(-1,"can't open file"); }
	}


	
	
    app_log("bookopen.reading");
    fread(book.fm, sizeof(char), book.filelength, (FILE*) book.fd);
    book.filemapdata = (char*)book.fm;
//#endif

    app_log("bookopen.paginating");

	int pos=0;
	char *ch;
	int linestart,linesize;
	int linewidth=0;
	linestart=0;
	linesize=0;
	ch = book.filemapdata;
	int lastlinewasblank=0;
	for(pos=0;pos<book.filelength;pos++,ch++)
	{
		switch(*ch)
		{
			//case 0:
				// doc finished early?
			//	break;
			case 10:
				// line break char
				// Linesize..pos = a whole new line!
				//if(linesize>0)
				//Bug#1 making it a bit more readable by only allowing 1 blank line in a document
				//Bug#1 should have included the CR item
				linesize++;
				linewidth+=font_widths[(int)*ch];
				if(lastlinewasblank && linesize==1)
				{
					// dont create a line
				}
				else
				{
					book_linealloc(linestart,linesize);
				}

				if(linesize==1)
					lastlinewasblank=1;
				else
					lastlinewasblank=0;

				linestart = pos;
				linesize = 0;
				linewidth=0;

				break;
			default:
				// normal character, extend the line
				linewidth += font_widths[(int)*ch];
				if(linewidth>=(maxlinelength-4) && maxlinelength>0 && linesize>0)
				//if(linesize>=maxlinelength && maxlinelength>0)
				{
					// shit! the line is going to be too long
					// lets try to walk backwards and see if we can word wrap
					if(linesize>1)
					{
						char *chwr=ch-1;
						int wr;
						int poswr=pos-1;
						for(wr=linesize-1;wr>=0;wr--)
						{
							if(isalnum(*chwr))
							{
								// ok to carry on rewinding
								chwr--;
								poswr--;
							}

							else
							{
								// no, we bail now
								break;
							}
						}
						// bug#1 checking >= 0 here
						if (wr>0 && wr<linesize)
						{
							// we found an alternative breakpoint
							ch=chwr;
							linesize = wr;
							pos=poswr;
							// now, attempt to remove the spaces from where we broke
							
							while(pos<book.filelength && isspace(*ch))
							{
								ch++;
								linesize++;
								pos++;
							}
						}
					}
					book_linealloc(linestart,linesize);
					linewidth=0;
					linestart = pos;
					linesize = 0;
				}
				linesize++;
				break;
		}
		//if(book.linecount>150) break;
	}
	//if(linesize>0) 
		book_linealloc(linestart,linesize);
	
	app_log("bookopen.pagination complete %i lines.",book.linecount);
	return 0;
}

