/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Floating resizable sketch viewer.
 *
 */




#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>

#include "liqapp.h"
#include "liqbook.h"
#include "liqcanvas.h"
#include "liqdialog.h"

#include "liqdraw.h"
#include "liqdrawframe.h"

extern PAGE *page;

static FRAME *frameroot=NULL;
static FRAME *framecurr=NULL;
static FRAME *framesel=NULL;

static FRAME *mkbutton(FRAME *self,char *title)
{
	FRAME *ch= frame_createquick(title,0,0,canvas.pixelwidth/16,canvas.pixelwidth/10);
	frame_append(self,ch);
	return ch;
}


static int frameroot_init()
{
	//app.infologgingenabled = 0;

	PAGE *pg=NULL;
	//char *dir_name = "/home/user/MyDocs/_apg";
	char *dir_name = app.sketchpath;//"/media/mmc1/_apg";
    DIR           *dir_p;
    struct dirent *dir_entry_p;
    dir_p = opendir(dir_name);
	
	
	if(!dir_p)
	{
		app_log("opendir failed: '%s'",dir_name);
		return -1;			// heh thanks kot :)
	}
	//int x=0;
	//int y=0;
	char filename[1024]="\0";

	while( NULL != (dir_entry_p = readdir(dir_p)))
    {

		//if(filename[0]==0 || strcmp(filename,dir_entry_p->d_name)<0)
		if(frameroot->childcount<60)
		{
			strncpy(filename,dir_entry_p->d_name,1024);
			char fn[1024];
			snprintf(fn,1024,"%s/%s", dir_name,filename);

			int wantfile=0;

			struct pagefilename pf;	
			if(	pagefilename_breakapart(&pf,filename) == 0)
			{
				// GOOD, we have a formatted file
				if(pf.filetitle[0])
				{
					// has a title
					wantfile=1;
				}
				else
				{
					// is anonymous
					wantfile=1;
				}
			}
			else
			{
				// not in parsable format
				wantfile=0;
			}

			if(wantfile)
			{
				if(!pg) pg=page_alloc();

				if(page_fileload(pg,fn)==0)
				{

					FRAME *sa=mkbutton(frameroot,"");
					//sa->pagefilename = strdup(fn);
					sa->page=pg;
					// ensure we continue writing with a new one..
					pg=NULL;				}
				else
				{
					page_free(pg);
					pg=NULL;				
				}
			}
		}
    }
    closedir(dir_p);
	if(pg)
	{
		// free if reqd
		page_free(pg);
		pg=NULL;
	}

	frame_neatarrange(frameroot);

	frame_overlapcalc(frameroot,NULL);
	frame_autoresizecontents(frameroot,NULL);

	//app.infologgingenabled = 1;
	return 0;
}

void liqbirds_run()
{
	
	app_log("birds opening");
	
	app_log("birds creating frameroot");

	frameroot = frame_createquick("root",0,0,canvas.pixelwidth -1,canvas.pixelheight-1);
	framecurr=NULL;
	framesel=NULL;

	app_log("birds initializing contents");
	frameroot_init();
	
	app_log("birds entering main loop");

	//frameused=0;
int fc=0;
int running=1;
//unsigned long tzs=app_GetTicks();
unsigned long tz0=app_GetTicks();
unsigned long tz1=app_GetTicks();
LIQEVENT ev;
int mx=0,my=0,mp=0;
//int mcnt=0;
int mk=0;
int mkc=0;
int dirty=1;		// ensure we are drawn at least once :)

int refreshinprogress=0;

	canvas_clear(0);
	while(running==1)
	{
		while(canvas_eventcount())
		{
//waitevent:
			canvas_nextevent(&ev);
			if( (ev.type == LIQEVENT_TYPE_KEY) && (ev.state==LIQEVENT_STATE_PRESS) )
			{
				mk=ev.key.keycode;				
				mkc++;
				dirty=1;
				if( (ev.key.keycode==65307) )	//ESC
				{
					app_log("Escape Pressed, stopping birds");
					running=0;
					break;
				}
			}
			else if(ev.type == LIQEVENT_TYPE_MOUSE)
			{
				int nx,ny;
				nx=mx;		// remember old
				ny=my;
				mx=ev.mouse.x;
				my=ev.mouse.y;
				mp=ev.mouse.pressure;
				dirty=1;
				if(framesel==NULL)
				{
					//int fh;
					FRAME *sa;
					sa = frame_findhit(frameroot,mx,my);
					if(sa)
					{
						// hey we are selecting one...
						framesel=sa;//&frames[fh];
					}

				}
				else
				{
					// we are already in a drag motion
					// could it be a resize?
					// what other tool options are available?

					int dx,dy;
					dx=mx-nx;
					dy=my-ny;
					//render_frame(framesel,1);
					framesel->sx+=dx;
					framesel->ex+=dx;
					framesel->sy+=dy;
					framesel->ey+=dy;
					frame_forceinboundparent(framesel);//,0,0,canvas.pixelwidth-1,canvas.pixelheight-1);
					//frame_forceinbound(framesel,0,0,canvas.pixelwidth-1,canvas.pixelheight-1);
					//render_frame(framesel,1);
					if(mp==0)
					{
						framesel=NULL;
						//render_all();
						dirty=1;
					}
				}

				//break;
			}
			else if(ev.type == LIQEVENT_TYPE_REFRESHED)
			{
				//wantwait=1;
				// ok, we have finished the refresh
				refreshinprogress=0;
				//canvas_clear(0); // ?????
				break;
			}

			else if(ev.type == LIQEVENT_TYPE_UNKNOWN)
			{
				running=0;
				break;
			}
		}
		if(running==0) break;
		if(dirty  && refreshinprogress==0)
		{

			frame_overlapcalc(frameroot,framesel);
			frame_autoresizecontents(frameroot,framesel);
			canvas_clear(0);
			frame_rendertocanvas(frameroot,0,0,NULL);// framesel);

			//char buff[255];
			//snprintf(buff,255,"fc %i    %1.5f,  %1.5f             ",fc,app_fps(tz0,tz1,1),app_fps(tzs,tz0,fc));
			//canvas_drawtext(0,0,buff);

			canvas_refreshdisplay();
			dirty=0;
			tz0=tz1;
			tz1=app_GetTicks();
			refreshinprogress=1;
			fc++;
			//goto waitevent;
		}
		//else
		{
		//	goto waitevent;
		}
	}
	app_log("birds Closing");
	frame_close(frameroot);
	app_log("birds Closed");

}

