
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>

#include <time.h>			// req for sleep
#include <sys/time.h>		// req for getticks
#include "liqapp.h"


#include "liqbase_prefs.h"

#include "liqtile.h"


liqtile *prefsroot=NULL;

liqtile *qpref(char *key,char *title)
{
	liqtile *self=liqtile_create();
	liqtile_keychange(self,key);
	liqtile_titlechange(self,title);
	return self;
}

int liqbase_prefs_load()
{

	// ok, now we load user preferences
	
	app_log("prefs load");
	
	if(!prefsroot)
	{
		app_log("prefs allocating root");
		prefsroot = liqtile_create();
		liqtile_keychange(prefsroot,"prefs");
	}
	
	

	// lines will be something like:
	// todo: build proper parser for prefs trees or use some other library
	
	// begin [section]
	//     [field] = [data]
	//     [field] = [data]
	//     [field] = [data]
	// end
	

	
	
		
	FILE *fn;
	
	char buf[FILENAME_MAX+1];
	snprintf(buf,FILENAME_MAX,"%s/liqbase.prefs",app.userpath);
	
	fn=fopen(buf,"r");
	if(fn)
	{
		char lineraw[512];
		int linemax=512;
		char *line=NULL;
		while(!feof(fn))
		{
			char * rc;
			rc=fgets(lineraw,linemax, (FILE*) fn);
			if(!rc)break;

			line=lineraw;
			if(*line)
			{
				while(*line==' ' || *line=='\t')line++;
				
				if(*line=='#')
				{
					// comment line
				}
				else
				{
					
					char *data=instr(line,"=");
					if(data && data>line)
					{
						
						//app_log("Test '%c'",*data);
						*data=' ';
						// rtrimming
						char *t=data;
						while(t>line && (*t==' ' || *t=='\t'))
						{
							*t-- = 0;
						}
						
						data++;
						// ltrimming to avoid the spaces
						while(*data==' ' || *data=='\t') data++;
						
						// do some rtrimming :)
						char *rtrim=data;
						while(*rtrim)rtrim++;
						if(rtrim>data && *rtrim==0)rtrim--;
					
						while(rtrim>data)
						{
							if(*rtrim=='\n' || *rtrim=='\r' || *rtrim==10 || *rtrim==13 || *rtrim==' ' || *rtrim=='\t')
								*rtrim-- = 0;
							else
								break;
						}
						
	
						liqtile_childinsertsorted( prefsroot, qpref(line,data) );
						
						
						
						
						// ok, got a key and a value pair :)
						
						//app_log("pref :: [%s]=[%s]",line,data);
						
						//if(strcmp(line,"username") == 0)
					}
				}
			}
		}
		
		fclose(fn);
		
		app_log("liqbase_prefs_load read '%s'",buf);
		//return 0;
	}
	else
	{
		app_log("liqbase_prefs_load could not open '%s'",buf);
		return -1;
	}
	
	
	//liqtile_print2(prefsroot);
	
	


	
	return 0;
	
}



char * liqbase_pref_setvalue_vprintf(char *prefkey,char *prefformat, va_list arg)
{
    char       buf[2048];
	vsnprintf(buf,2048,prefformat,arg);
	return liqbase_pref_setvalue(prefkey,buf);
}
char * liqbase_pref_setvalue_printf(char *prefkey,char *prefformat, ...)
{
	va_list arg;
	va_start(arg, prefformat);
	char *res = liqbase_pref_setvalue_vprintf(prefkey,prefformat, arg);
	va_end(arg);
	return res;
}



char * liqbase_pref_setvalue(char *prefkey,char *prefvalue)
{
	liqtile *p=liqtile_childfindorcreatekey(prefsroot,prefkey);
	if(p)
	{
		liqtile_titlechange(p,prefvalue);
		return prefvalue;
	}
	return NULL;
}
char * liqbase_pref_getvalue(char *prefkey)
{
	liqtile *p=liqtile_childfindkey(prefsroot,prefkey);
	if(p && p->title && *p->title)
	{
		return p->title;
	}
	return NULL;
}
liqtile *liqbase_pref_getitem(char *prefkey)
{
	liqtile *p=liqtile_childfindkey(prefsroot,prefkey);
	if(p)
	{
		return p;
	}
	return NULL;
}
int liqbase_pref_checkexists(char *prefkey)
{
	liqtile *p=liqtile_childfindkey(prefsroot,prefkey);
	if(p)
	{
		return 1;
	}
	return 0;
}	
	
int liqbase_prefs_save()
{
	FILE *fn;
	char buf[FILENAME_MAX+1];
	snprintf(buf,FILENAME_MAX,"%s/liqbase.prefs",app.userpath);
	
	fn=fopen(buf,"w");
	if(fn)
	{

		char 		fmtnow[255];
	 	app_formatnow(fmtnow,255,"yyyymmdd_hhmmss");

		fprintf(fn,"# liqbase preferences : %s\n",fmtnow);
		fprintf(fn,"begin prefs\n");
		liqtile *c=prefsroot->linkchild;
		while(c)
		{
			fprintf(fn,"\t%s=%s\n",c->key,c->title);		// todo ensure multiline data pushed ok, and pulled and extracted correctly
			c=c->linknext;
		}
		fprintf(fn,"end\n");
		fclose(fn);
	}
	else
	{
		app_log("liqbase_prefs_save could not open '%s'",buf);
		return -1;
	}
	
	return 0;
}

