/* liqbase
 * Copyright (C) 2008 Gary Birkett
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *
 * Main application startup and control
 *
 */



#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <X11/keysym.h>
#include <stdarg.h>
#include <unistd.h>
#include <signal.h>
#include <dirent.h>
#include <ctype.h>


#include "liqapp.h"
#include "liqcanvas.h"
#include "liqdialog.h"


#include "mk_core.h"


#include "liqbase_prefs.h"

// List of modules

int liqbookprogress_startup();
void liqbookprogress_shutdown();

int     mkfileselect_run();

int 	liqfloat_run();
int 	liqstar_run();
int 	liqart_run();
int 	liqreader_run();
int     liqfloatpic_run(int usecamera);
int     liqgame_run();
int     liqgraffiti_run();
int 	liqed_run(char *sourcefilename);
int 	liqfloatgallery_run();
int 	liquidesign_run();
void 	liqscroll_run();
int 	liqbirds_run();
char *	liqfileselect_run(char *basepath);
int 	liqart2_run();
int liqkeyboard_run(char *title,char *databuf,int datamaxlength);
int liqspeedtest_run();
extern int isinternetsketch;
int liqmutlitouchtest_run();

char * liqbookprogress_getmostrecent();

void 	menu_options();




void change_resolution(char *newresolution,int firsttime);

static char *opt_fontname=NULL;
static int   opt_fontsize=0;

#define ABS(x) (((x) >= 0) ? (x) : -(x))
#define SGN(x) (((x) >= 0) ? 1 : -1)

//	app_log("Main loop complete:   %i frames,  average fps %f",framecount,app_fps(tzs,tz0,framecount));

void closeall()
{

	app_log("Program complete");

	app_log("Closing canvas:");
	canvas_close();


	liqbookprogress_shutdown();
	
	app_log("goodbye.");
	app_close();
}

void     signalhandler(int sig)
{
	app_log("signal detected, closing");
	closeall();
	signal(SIGINT, SIG_DFL);
	kill(getpid(), SIGINT);
}

int see_test();








/*

int hellotest()
{
	
	char filename[FILENAME_MAX];
	
	
	char *envhome = getenv("HOME");
	if(!envhome)
	{
		printf("hellotest, cannot find home\n"); return -1;
	}
	
	snprintf(filename,FILENAME_MAX,"%s/MyDocs/liqbase_hellotest",envhome);
	
	
	
	printf("hellotest, opening path: %s\n",filename);
	
	FILE *fd;
	int   ri;
	fd = fopen(filename, "w");
	if(fd==NULL){ printf("hellotest, cannot open file for writing\n"); return -1; }
	ri=fputs("hello world", (FILE*) fd);
	fclose(fd);
	if(ri<0){ printf("hellotest, cannot write\n"); return -2; }
	return 0;
}

 */


int main (int argc, char* argv[])
{
int res=0;


	//hellotest();

    signal(SIGINT, signalhandler);
	signal(SIGTERM, signalhandler);
	signal(SIGHUP, signalhandler);
	// tod;:replace with actual font lookup
#ifdef USE_MAEMO
	opt_fontname = "/usr/share/fonts/nokia/nosnb.ttf";
#else // USE_MAEMO
	opt_fontname = "/usr/share/fonts/lucon.ttf";
#endif
	opt_fontsize = 28;

	if(app_init(   argc,argv ,"liqbase" )!=0)
	{
		{ return app_errorandfail(-1,"app_init failed"); }
		
	}
	
	liqbookprogress_startup();
	
	//see_test();
	//return 0;


//	app_log("Checking For Options");
	//app_log("Option [book]      : '%s'", opt_bookname = app_getopt_str(NULL,      "/usr/share/liqbase/liqreader_readme.txt")     );
//	app_log("Option -font       : '%s'", opt_fontname = app_getopt_str("font",    "/usr/share/fonts/nokia/nosnb.ttf")       );
//	app_log("Option -size       : %i",   opt_fontsize = app_getopt_int("size",    28)                 );
//	app_log("Option -colorcube  ? %i",   opt_colorcube = app_getopt_exist("colorcube")                 );
//	app_log("Option -fpsshow    ? %i",   opt_fpsshow = app_getopt_exist("fpsshow")                 );
//	app_log("Option -turbo      ? %i  defaults disabled, requires root to enable but speeds up program",   opt_turbo = app_getopt_exist("turbo")                 );

	if(opt_fontsize<8 || opt_fontsize>72)
	{
		{ closeall();  return app_errorandfail(-1,"Invalid Fontsize, must be between 8 and 72"); }
	}

	//################################################################	
	app_log("Initializing canvas:");
	
	// todo: identify real available resolutions or normal desktop res

	//res=canvas_init( HILDON_APPVIEW_WIDTH,HILDON_APPVIEW_HEIGHT, 0,0);
	//res=canvas_init( HILDON_APPVIEW_WIDTH/2,HILDON_APPVIEW_HEIGHT/2, 0,0);
	
	//res=canvas_init( 240,160, 0,1);
	//res=canvas_init( 480,320, 0,1);



	char *scr = liqbase_pref_getvalue("screen_resolution");
	if(scr)
	{
		change_resolution(scr,1);
	}
	else
	{
		// not required but if i want to pass an alternative here I can..
		change_resolution(NULL,1);
	}



#ifdef USE_MAEMO
	// first thoughts at render glitch bug.
	// going to think about starting up in alternative resolution
	//if( liqbase_pref_checkexists(""))
	//{
	//	res=canvas_init( 800,480, 0,1);
	//}
#else
	//res=canvas_init( 1024,768, 0,1);
#endif

	//res=canvas_init( 640,480, 0,1);
	//res=canvas_init( 640,480, 90,1);
	//res=canvas_init( 480,480, 0,1);
	//res=canvas_init( 400,480, 0,1);
	//res=canvas_init( 800,240, 0,1);
	//res=canvas_init( 256,256, 0,1);
	//res=canvas_init( 640,240, 0,1);
	//res=canvas_init( 400,240, 0,1);
	//res=canvas_init( 600,480, 0,1);
	//res=canvas_init( 256,224, 0,1); //pupnik prefered resolution
	//res=canvas_init( 512,448, 0,1); //pupnik prefered resolution (needs doubling to get color planes at correct res)

	//if(res!=0){ closeall();  return app_errorandfail(-1,"canvas Init"); }

	//setrotate(90);

	//canvas.keepalivealarmtime=10000;
	//################################################################

	app_log("Setting font:");
	//res=canvas_setfont( "/usr/share/fonts/lucon.ttf",20);
	//res=canvas_setfont( "/usr/share/fonts/lucon.ttf",18);
	//res=canvas_setfont( "trebuc.ttf",20);
	res=canvas_setfont( opt_fontname,opt_fontsize);

	if(res!=0){ closeall();  return app_errorandfail(-2,"Font Init"); }

	//################################################################

	app_log("Running program");
	
	
	if(!app.username || !*app.username)
	{
		// we must have had a problem loading prefs
		// lets find out who they are right away :)
		char newuser[20]="";
		if( liqkeyboard_run("new user :: enter your name",newuser,20)>0 )
		{
					if( (*newuser) && (isdigit(*newuser)==0) )
					{	// we accepted the item
						//########### cleanse input, may need more :)
						
						app_ensurecleanusername(newuser);

						
						app_log("new user request ok: %s",newuser);
						
						app.username = strdup(newuser);
						
						// now, write away the preferences?
						
						liqbase_pref_setvalue_printf("username","%s",newuser);		
						liqbase_prefs_save();
					}

					else
		
					{
						liqdialog_ask("Username is invalid","Username must begin with an alpha",NULL,NULL,1,
								"OK",
								NULL);
	
						app_errorandfail(-2,"username is required and must be none numeric");
						closeall();
						return -1;
					}
			
		}
		else
		{
			// we cannot continue

			{
				liqdialog_ask("Username required","Username must be entered to run this program",NULL,NULL,1,
						"OK",
						NULL);
			}

			
			app_errorandfail(-2,"username is required and must be none numeric");
			closeall();
			return -1;
		}
	}
	


	liqstar_run();
	
	
	
#ifdef USE_MAEMO

	//app_log("upgrading screen, close existing");
	//canvas_close();
	//res=canvas_init( 800,480, 0,1);
	//if(res!=0){ closeall();  return app_errorandfail(-1,"canvas Init"); }
	//canvas_setfont( opt_fontname,opt_fontsize);
	//canvas_clear(0);
	//canvas_refreshdisplay();


#endif

	
	
	
	app_log("liqbase loading mk_styles");

	if(mk_style_open()!=0)
	{
		// failed
		app_log("mk_style could not open");
		return -1;
	}
	int stillrunning=1;
	int todo;
	while(stillrunning)
	{
		//
		{
			char *options[]={
				"Do some Drawing",		// 0
				"Look at Stars",		// 1
				"Use the camera", //"Select a book",			// 2
				"Continue reading",		// 3
				"Physics Sym",			// 4
				"Graffiti Wall",		// 5
				"Options",				// 6
				"Recent Pictures",			// 7
				"Quit now",
				NULL};
			todo=liqdialog_showoption("liqbase :: Choose an activity",-1,0,&options[0]);
		}
		switch(todo)
		{
			case -1:
				stillrunning=0;
				break;
			case 0:
				//liqart_run();
				//liquidesign_run();
				liqart2_run();
				break;
			case 1:
				liqstar_run();
				break;
			case 2:
				liqfloatpic_run(1);
				//mkfileselect_run();
				//liqreader_run();
				break;
			case 3:
				//
				
				{
					char *mr = liqbookprogress_getmostrecent();
					if(!mr || !*mr)
					{
						mkfileselect_run();
					}
					else
					{
						
						char buf[256];
						snprintf(buf,256,"Open book : %s",app_filename_walkoverpath(mr));
						
						int result=liqdialog_ask("Continue reading book",buf,mr,NULL,0,
								"Yes",
								"Choose new book",
								"Go back",
								NULL);
								switch(result)
								{
									case -1:
										break;
									case 0:
										liqed_run(mr);
										break;
									case 1:
										mkfileselect_run();
										break;
									case 2:
										break;
								}
					}
				}
				break;
			case 4:
				//liqfloatpic_run();
				liqbirds_run();
				//liqfloatpic_run();
				break;
			case 5:

				//liqfloat_run();
				liqgraffiti_run();
				break;
			case 6:
				menu_options();
				break;
			case 7:
				//liqscroll_run();
				//liqgame_run();
				//liqgraffiti_run();
				liqfloatgallery_run();
				break;

			default:
				stillrunning=0;
				break;
		}
	};
	
	mk_style_close();

	closeall();
    return 0;
}

void menu_inprogress()
{
		{
		int result=liqdialog_ask("InProgress","This operation has not yet been built","Try again later.",NULL,1,
					   		"OK",
					   		NULL);
		if(result==-1) {                             } // Cancelled, Do Nothing
		}
}

int menu_options_cpu()
{
    char buff_orig[80]="\0";	// original governor
	int ri;
	ri=cpufreq_governor_read(buff_orig,80);
	if(ri!=0){ app_log("CPU: cannot read from governor"); return -1; }

int def=-1;
	if(strcmp("powersave",buff_orig) == 0)
	{
        def=0;
	}
	else
		if(strcmp("ondemand",buff_orig) == 0)
	{
        def=1;
	}
	else
	if(strcmp("performance",buff_orig) == 0)
	{
        def=2;
	}

	else
		def=3;

char *changeto=NULL;

	{
		char *options[]={
				"Power Save|slowest speed",
				"On Demand|variable speed",
				"Performance|fastest speed",
				"Do Not Change",
				NULL};

		char title[80];
		snprintf(title,80,"Set CPU Performance (%s)",buff_orig);

		int todo=liqdialog_showoption(title,def,0,&options[0]);
		switch(todo)
		{
			case -1:
				// cancelled
				break;
			case 3:
				// Do Not Change
				break;
			case 0:
				// powersave
				//todo: Change the cpu to PowerSave
				//app_log("CPU:PowerSave Requested");
				changeto="powersave";
				break;
			case 1:
				// on demand
				//todo: Change the cpu to OnDemand
				//app_log("CPU:On Demand Requested");
				changeto="ondemand";
				break;
			case 2:
				// Performance
				//todo: Change the cpu to Performance
				//app_log("CPU:Performance Requested");
				changeto="performance";
				break;
			default:
				// Do Not Change
				break;
		}
	}

	if(changeto)
	{
		if(strcmp(changeto,buff_orig) == 0)
		{
			// the cpu is already at this setting
			app_log("CPU: Requested '%s', no action required",changeto);
			return 0;
		}
		else
		{
			app_log("CPU: Requested '%s', currently at '%s'",changeto,buff_orig);
			ri=cpufreq_governor_write(changeto);
			if(ri!=0)
			{ 
				app_log("CPU: cannot write new setting"); 
				{
					int result=liqdialog_ask("CPU governor not changed","This operation requires Root access","Run as root to allow modification.",NULL,1,
					   		"OK",
					   		NULL);

					if(result==-1) {    return -1;                         } // Cancelled, Do Nothing
				}

				return -1; 
			}
			// everything now works
			return 0;
		}		
	}
	return -1;
}


void change_resolution(char *newresolution,int firsttime)
{
		char *options[]={


#ifdef USE_MAEMO
							"800*480",			// 0
#else
							"1024*768",			// 0
#endif
					   		"640*480",			// 1
					   		"400*480",			// 2
					   		"800*240",			// 3
					   		"640*240",			// 4
					   		"400*240",			// 5
					   		"256*224",			// 6
					   		"512*448",			// 7
					   		NULL};
	if(newresolution && *newresolution)
	{
		app_log("resolution changing to: '%s', firsttime=%i",newresolution,firsttime);
	}
	else
	{
		app_log("resolution changing to default: '%s', firsttime=%i",options[1],firsttime);		
	}
		
		int def=-1;
		char **o=options;
		int oidx=0;
		if(newresolution && *newresolution)
		{
			while(*o) 
			{
				if(strcmp(*o,newresolution) == 0)
				{
					def=oidx;
					break;
				}
				o++;
				oidx++;
			}
		}
		int result=1;
		int res=0;
		
		if(def>=0)
		{
			result=def;
		}
		else
		{
			app_log("resolution not identified, using default (%s)",options[result]);
		}
		
int OC1=0,OC2=0;

		if(!firsttime)
		{
			app_log("resolution change, closing existing screen");
			// close stuff if canvas open
			OC1=OC2=mk_style_getopencount();
			
			
			while(OC1--)mk_style_close();
			canvas_close();
		}
		
		//app_log("resolution opening new resolution: %i:'%s'",result,options[result]);
		
#ifdef USE_MAEMO
		if(result== 0) res=canvas_init( 800,480, 0,1);
#else
		if(result== 0) res=canvas_init( 1024,768, 0,1);
#endif
		if(result== 1) res=canvas_init( 640,480, 0,1);
		if(result== 2) res=canvas_init( 400,480, 0,1);
		if(result== 3) res=canvas_init( 800,240, 0,1);
		if(result== 4) res=canvas_init( 640,240, 0,1);
		if(result== 5) res=canvas_init( 400,240, 0,1);
		if(result== 6) res=canvas_init( 256,224, 0,1);
		if(result== 7) res=canvas_init( 512,448, 0,1);


		if(res!=0){  app_errorandfail(-1,"canvas Init"); closeall();    exit(-1); }

		
		
		canvas_setfont( opt_fontname,opt_fontsize);

		if(mk_style_open()!=0)
		{
			// failed
			app_log("mk_style could not open");
			closeall();
			exit(-1);
		}
		// cheat to restore the open count here
		OC2--;
		
		while((OC2--)>0) mk_style_open();

		if(!firsttime)
		{
			app_log("resolution change, finalizing change");
			// give chance to change..
			app_sleep(200);
			canvas_clear(0);
			canvas_refreshdisplay();
			app_sleep(200);
			canvas_clear(0);
			canvas_refreshdisplay();
			canvas_clear(0);
			canvas_refreshdisplay();
		}
		app_log("resolution change complete, should now be at: '%s'",options[result]);
		
		
		liqbase_pref_setvalue_printf("screen_resolution","%s",options[result]);		
		liqbase_prefs_save();		
		
		
	
}


void menu_options_resolution()
{
char curr_res[80];
	snprintf(curr_res,80,"%i*%i",canvas.pixelwidth,canvas.pixelheight);

	//{
		char *options[]={


#ifdef USE_MAEMO
							"800*480",
#else
							"1024*768",
#endif
					   		"640*480",
					   		"400*480",
					   		"800*240",
					   		"640*240",
					   		"400*240",
					   		"256*224",
					   		"512*448",
							"Do Not Change",
					   		NULL};

		// find match within option list
		int def=-1;
		char **o=options;
		int oidx=0;
		while(*o) 
		{
			if(strcmp(*o,curr_res) == 0)
			{
				def=oidx;
			}
			o++;
			oidx++;
		}

		char title[80];
		snprintf(title,80,"Set Display resolution (%i*%i)",canvas.pixelwidth,canvas.pixelheight);

		int result=liqdialog_showoption(title,def,0,&options[0]);
		if(result==-1 || result==8) {          return;                   } // Cancelled, Do Nothing
		// now, we know we are changing resolution
		//int res=0;
		
		
		change_resolution(options[result],0);
		
		
/*		
		
		// close stuff if canvas open
		mk_style_close();
		canvas_close();
		
		
#ifdef USE_MAEMO
		if(result== 0) res=canvas_init( 800,480, 0,1);
#else
		if(result== 0) res=canvas_init( 1024,768, 0,1);
#endif
		if(result== 1) res=canvas_init( 640,480, 0,1);
		if(result== 2) res=canvas_init( 400,480, 0,1);
		if(result== 3) res=canvas_init( 800,240, 0,1);
		if(result== 4) res=canvas_init( 640,240, 0,1);
		if(result== 5) res=canvas_init( 400,240, 0,1);
		if(result== 6) res=canvas_init( 256,224, 0,1);
		if(result== 7) res=canvas_init( 512,448, 0,1);
		//if(result== 8) res=canvas_init( 800,600, 0,1);
		// re-setup the font
		
		
		if(res!=0){  app_errorandfail(-1,"canvas Init"); closeall();    exit(-1); }

		
		
		canvas_setfont( opt_fontname,opt_fontsize);

		if(mk_style_open()!=0)
		{
			// failed
			app_log("mk_style could not open");
			closeall();
			exit(-1);
		}

		//LIQEVENT ptrevent;
			app_sleep(200);
			canvas_clear(0);
			canvas_refreshdisplay();
			app_sleep(200);
			canvas_clear(0);
			canvas_refreshdisplay();
			canvas_clear(0);
			canvas_refreshdisplay();
		}
		
*/
		
}



void menu_options()
{
	while (1){
		int result=liqdialog_ask("Options","Configuration area","Setup this program",NULL,-1,
					   		"Screen Resolution",
					   		"CPU Throttling",
					   		"View License",
					   		"Camera Blit test",
							"Blit test",
							"Map",
							"Back",
	//						"live sketching",
							"user config",
							"multitouch test",
					   		NULL);
		if(result==-1) {    return;                         } // Cancelled, Do Nothing
		if(result== 0) {    menu_options_resolution();             }
		if(result== 1) {    menu_options_cpu();                         }
		if(result== 2) {    liqed_run("/usr/share/liqbase/COPYING");   } //menu_inprogress();                         }
		if(result== 3) {    liqfloatpic_run(1); } // liqspeedtest_run();                         }
		if(result== 4) {    liqfloatpic_run(0); } //liqspeedtest_run();   ;                         }
		if(result== 5) {    liqfloatpic_run(2); } //liqspeedtest_run();   ;                         }
		if(result== 6) {    return;                         }
		
/*		if(result== 7) {
							// this is not to be included in packaged versions.  i will perform the upload under socket control
							// rather than this horrible hack
			
							isinternetsketch=1;
							liqart2_run();
							isinternetsketch=0;

							
							
							
							
					   } //liqspeedtest_run();   ;                         }
*/					   
		if(result== 7) {		
							char newuser[20]="";
							strncpy(newuser,app.username,20);
							char tit[255];
							snprintf(tit,255,"%s :: change name",app.username);
							
							if(liqkeyboard_run(tit,newuser,20)>0)
							{
								if(*newuser && (isdigit(*newuser)==0))
								{
									// we accepted the item
									//########### cleanse input, may need more :)
									char *nu=newuser;
									while(*nu)
									{
										if(*nu=='\\' || *nu=='/' || *nu=='\'' || *nu=='~' || *nu==' ' || *nu=='\t' || *nu=='\'' || *nu=='"' || *nu==':' || *nu=='|' ||*nu=='#' )
											*nu++ = '_';
										else
											nu++;
									}
									app_log("new user request ok: %s",newuser);
									app.username = strdup(newuser);								
									liqbase_pref_setvalue_printf("username","%s",newuser);		
									liqbase_prefs_save();
									
								}
								else
					
								{
									int result=liqdialog_ask("Username not changed","Username must begin with an alpha",NULL,NULL,1,
											"OK",
											NULL);
				
									if(result==-1) {    return;                         } // Cancelled, Do Nothing
								}
							}


					   }
					   
		if(result==8)
					   {
							liqmutlitouchtest_run();
					   }


	}

}
